//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// RC type. Used in MAV_CMD_START_RX_PAIR.
type RC_TYPE uint64

const (
	// Spektrum
	RC_TYPE_SPEKTRUM RC_TYPE = 0
	// CRSF
	RC_TYPE_CRSF RC_TYPE = 1
)

var value_to_label_RC_TYPE = map[RC_TYPE]string{
	RC_TYPE_SPEKTRUM: "RC_TYPE_SPEKTRUM",
	RC_TYPE_CRSF:     "RC_TYPE_CRSF",
}

var label_to_value_RC_TYPE = map[string]RC_TYPE{
	"RC_TYPE_SPEKTRUM": RC_TYPE_SPEKTRUM,
	"RC_TYPE_CRSF":     RC_TYPE_CRSF,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e RC_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_RC_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *RC_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_RC_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = RC_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e RC_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
