//autogenerated:yes
//nolint:revive,govet,errcheck
package ardupilotmega

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestEnum_GOPRO_COMMAND(t *testing.T) {
	t.Run("zero", func(t *testing.T) {
		var e GOPRO_COMMAND
		e.UnmarshalText([]byte{})
		e.MarshalText()
		e.String()
	})

	t.Run("first entry", func(t *testing.T) {
		enc, err := GOPRO_COMMAND_POWER.MarshalText()
		require.NoError(t, err)

		var dec GOPRO_COMMAND
		err = dec.UnmarshalText(enc)
		require.NoError(t, err)

		require.Equal(t, GOPRO_COMMAND_POWER, dec)
	})
}
