/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.util.Arrays;

public class Count<T extends Unit>
implements Comparable<Count<T>> {
    private long[] amounts;
    private T[] units;

    private Count(T[] units) {
        this.units = units;
        this.amounts = new long[units.length];
    }

    public static <T extends Unit> Count<T> newInstance(Class<T> unitClass) {
        if (!unitClass.isEnum()) {
            throw new IllegalArgumentException(unitClass + " should be enum");
        }
        return new Count((Unit[])unitClass.getEnumConstants());
    }

    public Count<T> add(long amount, T unit) {
        if (amount < 0L) {
            throw new IllegalArgumentException("amount '" + amount + "' should be >=0");
        }
        if (amount > 0L) {
            int n = unit.ordinal();
            this.amounts[n] = this.amounts[n] + amount;
            for (int i = unit.ordinal(); i < this.units.length - 1 && this.amounts[i] >= (long)this.units[i].count(); ++i) {
                int n2 = i + 1;
                this.amounts[n2] = this.amounts[n2] + this.amounts[i] / (long)this.units[i].count();
                int n3 = i;
                this.amounts[n3] = this.amounts[n3] % (long)this.units[i].count();
            }
        }
        return this;
    }

    public Count<T> add(Count<T> other) {
        for (T unit : this.units) {
            this.add(other.amounts[unit.ordinal()], unit);
        }
        return this;
    }

    public Count<T> clear() {
        Arrays.fill(this.amounts, 0L);
        return this;
    }

    public Count<T> set(long amount, T unit) {
        if (amount < 0L) {
            throw new IllegalArgumentException("amount '" + amount + "' should be >=0");
        }
        return this.clear().add(amount, unit);
    }

    public Count<T> set(Count<T> other) {
        return this.clear().add(other);
    }

    public long get(T unit) {
        return this.amounts[unit.ordinal()];
    }

    public strictfp double to(T unit) {
        long value = this.amounts[this.units.length - 1];
        for (int i = this.units.length - 2; i >= unit.ordinal(); --i) {
            value = this.amounts[i] + (long)this.units[i].count() * value;
        }
        if (unit.ordinal() > 0) {
            double before = this.amounts[0];
            for (int i = 1; i < unit.ordinal(); ++i) {
                before = before / (double)this.units[i - 1].count() + (double)this.amounts[i];
            }
            return (double)value + before / (double)this.units[unit.ordinal() - 1].count();
        }
        return value;
    }

    public int hashCode() {
        long hash = 0L;
        for (long amount : this.amounts) {
            hash = 31L * hash + amount;
        }
        return (int)(hash ^ hash >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Count) {
            Count that = (Count)obj;
            return Arrays.equals(this.units, that.units) && Arrays.equals(this.amounts, that.amounts);
        }
        return false;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (int i = this.units.length - 1; i >= 0; --i) {
            if (this.amounts[i] <= 0L) continue;
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(this.amounts[i]);
            buff.append(' ');
            buff.append(this.units[i]);
        }
        return buff.length() == 0 ? "0 " + this.units[0] : buff.toString();
    }

    @Override
    public int compareTo(Count<T> that) {
        for (int i = this.units.length - 1; i >= 0; --i) {
            if (this.amounts[i] == that.amounts[i]) continue;
            return this.amounts[i] < that.amounts[i] ? -1 : 1;
        }
        return 0;
    }

    static interface Unit {
        public int ordinal();

        public int count();

        public String toString();
    }
}

