/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractChromosome;
import io.jenetics.Gene;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import java.util.Objects;

abstract class VariableChromosome<G extends Gene<?, G>>
extends AbstractChromosome<G> {
    private static final long serialVersionUID = 1L;
    private final IntRange _lengthRange;

    protected VariableChromosome(ISeq<? extends G> genes, IntRange lengthRange) {
        super(genes);
        this._lengthRange = VariableChromosome.checkLengthRange(lengthRange, genes.size());
    }

    static IntRange checkLengthRange(IntRange lengthRange, int length) {
        Objects.requireNonNull(lengthRange);
        if (lengthRange.getMin() <= 0) {
            throw new IllegalArgumentException(String.format("Minimum length must be positive: %d", lengthRange.getMin()));
        }
        if (lengthRange.getMax() <= 0) {
            throw new IllegalArgumentException(String.format("Maximum length must be positive: %d", lengthRange.getMin()));
        }
        if (lengthRange.size() <= 0) {
            throw new IllegalArgumentException(String.format("Maximal length must be positive: %d", lengthRange.size()));
        }
        if (length < lengthRange.getMin() || length >= lengthRange.getMax()) {
            throw new IllegalArgumentException(String.format("Number of genes (%d) not within the allowed range: %s", length, lengthRange));
        }
        return lengthRange;
    }

    public IntRange lengthRange() {
        return this._lengthRange;
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).and(this._lengthRange).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(cc -> super.equals(obj) && Equality.eq(this._lengthRange, cc._lengthRange));
    }
}

