/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.DayOfMonthValueMatcher;
import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.ValueMatcher;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Predictor {
    private SchedulingPattern schedulingPattern;
    private long time;
    private TimeZone timeZone = TimeZone.getDefault();

    public Predictor(String string, long l) throws InvalidPatternException {
        this.schedulingPattern = new SchedulingPattern(string);
        this.time = l / 60000L * 1000L * 60L;
    }

    public Predictor(String string, Date date) throws InvalidPatternException {
        this(string, date.getTime());
    }

    public Predictor(String string) throws InvalidPatternException {
        this(string, System.currentTimeMillis());
    }

    public Predictor(SchedulingPattern schedulingPattern, long l) {
        this.schedulingPattern = schedulingPattern;
        this.time = l / 60000L * 1000L * 60L;
    }

    public Predictor(SchedulingPattern schedulingPattern, Date date) {
        this(schedulingPattern, date.getTime());
    }

    public Predictor(SchedulingPattern schedulingPattern) {
        this(schedulingPattern, System.currentTimeMillis());
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public synchronized long nextMatchingTime() {
        int n;
        this.time += 60000L;
        if (this.schedulingPattern.match(this.time)) {
            return this.time;
        }
        int n2 = this.schedulingPattern.matcherSize;
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(this.time);
            gregorianCalendar.setTimeZone(this.timeZone);
            n = gregorianCalendar.get(12);
            int n3 = gregorianCalendar.get(11);
            int n4 = gregorianCalendar.get(5);
            int n5 = gregorianCalendar.get(2);
            int n6 = gregorianCalendar.get(1);
            ValueMatcher valueMatcher = (ValueMatcher)this.schedulingPattern.minuteMatchers.get(i);
            ValueMatcher valueMatcher2 = (ValueMatcher)this.schedulingPattern.hourMatchers.get(i);
            ValueMatcher valueMatcher3 = (ValueMatcher)this.schedulingPattern.dayOfMonthMatchers.get(i);
            ValueMatcher valueMatcher4 = (ValueMatcher)this.schedulingPattern.dayOfWeekMatchers.get(i);
            ValueMatcher valueMatcher5 = (ValueMatcher)this.schedulingPattern.monthMatchers.get(i);
            while (true) {
                if (!valueMatcher.match(n)) {
                    if (++n <= 59) continue;
                    n = 0;
                    ++n3;
                    continue;
                }
                if (n3 > 23) {
                    n3 = 0;
                    ++n4;
                }
                if (!valueMatcher2.match(n3)) {
                    ++n3;
                    n = 0;
                    continue;
                }
                if (n4 > 31) {
                    n4 = 1;
                    ++n5;
                }
                if (n5 > 11) {
                    n5 = 0;
                    ++n6;
                }
                if (valueMatcher3 instanceof DayOfMonthValueMatcher) {
                    DayOfMonthValueMatcher dayOfMonthValueMatcher = (DayOfMonthValueMatcher)valueMatcher3;
                    if (!dayOfMonthValueMatcher.match(n4, n5 + 1, gregorianCalendar.isLeapYear(n6))) {
                        ++n4;
                        n3 = 0;
                        n = 0;
                        continue;
                    }
                } else if (!valueMatcher3.match(n4)) {
                    ++n4;
                    n3 = 0;
                    n = 0;
                    continue;
                }
                if (!valueMatcher5.match(n5 + 1)) {
                    ++n5;
                    n4 = 1;
                    n3 = 0;
                    n = 0;
                    continue;
                }
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTimeZone(this.timeZone);
                gregorianCalendar.set(12, n);
                gregorianCalendar.set(11, n3);
                gregorianCalendar.set(5, n4);
                gregorianCalendar.set(2, n5);
                gregorianCalendar.set(1, n6);
                int n7 = n4;
                int n8 = n5;
                int n9 = n6;
                n4 = gregorianCalendar.get(5);
                n5 = gregorianCalendar.get(2);
                n6 = gregorianCalendar.get(1);
                if (n5 != n8 || n4 != n7 || n6 != n9) continue;
                int n10 = gregorianCalendar.get(7);
                if (valueMatcher4.match(n10 - 1)) break;
                n3 = 0;
                n = 0;
                if (++n4 <= 31) continue;
                n4 = 1;
                if (++n5 <= 11) continue;
                n5 = 0;
                ++n6;
            }
            lArray[i] = gregorianCalendar.getTimeInMillis() / 60000L * 1000L * 60L;
        }
        long l = Long.MAX_VALUE;
        for (n = 0; n < n2; ++n) {
            if (lArray[n] >= l) continue;
            l = lArray[n];
        }
        this.time = l;
        return this.time;
    }

    public synchronized Date nextMatchingDate() {
        return new Date(this.nextMatchingTime());
    }
}

