/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.device;

import com.ubnt.ace.class;
import com.ubnt.data.Admin;
import com.ubnt.data.Device;
import com.ubnt.data.Site;
import com.ubnt.data.X;
import com.ubnt.model.L.G;
import com.ubnt.model.api.device.DeviceBleSettingsUpdateDto;
import com.ubnt.model.api.device.DeviceListDto;
import com.ubnt.model.api.device.UnifiDeviceDetailsDto;
import com.ubnt.net.security.role.A;
import com.ubnt.net.security.role.String;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.service.device.C.super;
import com.ubnt.service.device.I;
import com.ubnt.service.device.K;
import com.ubnt.service.device.interface;
import com.ubnt.service.devmgr.oOOo0;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Devices")
public class DeviceController {
    private final K \u00d400000;
    private final interface \u00d600000;
    private final A \u00d200000;
    private final oOOo0 \u00d800000;
    private final I \u00d300000;
    private final com.ubnt.service.devmgr.device.E.A class;
    private final com.ubnt.net.security.G super;

    @GetMapping(value={"/api/site/{siteName}/device"})
    @Operation(summary="List devices from all UniFi controllers", description="\"separateUnmanaged\" query param available since 7.1.46")
    public DeviceListDto listDevices(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @RequestParam(value="separateUnmanaged", defaultValue="false") boolean bl, @RequestParam(value="includeTrafficUsage", defaultValue="false") boolean bl2) {
        java.lang.String string = site.getId();
        String string2 = this.\u00d200000.\u00d300000(httpServletRequest, httpServletResponse, string);
        return this.\u00d300000.String(this.\u00d400000.O\u00f60000(string, string2, bl2), bl);
    }

    @PutMapping(value={"/api/site/{siteName}/device/{mac}/ble"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Update device BLE settings")
    public void updateBleSettings(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") java.lang.String string, @RequestBody DeviceBleSettingsUpdateDto deviceBleSettingsUpdateDto) {
        deviceBleSettingsUpdateDto.useBleSetupConfiguration().ifPresent(bl -> this.super(string, site, (Boolean)bl));
    }

    @PostMapping(value={"/api/site/{siteName}/device/{mac}/gateway/adopt-as-secondary"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Adopt gateway device as secondary one")
    public void adoptSecondaryGateway(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @PathVariable(value="mac") java.lang.String string) {
        Optional<X> optional = this.super.o00000(httpServletRequest, httpServletResponse);
        Admin admin = this.\u00d300000(optional);
        java.lang.String string2 = optional.flatMap(x2 -> x2.getOptionalString("name")).orElse("");
        this.class.o00000(site, string, admin, string2);
    }

    @GetMapping(value={"/api/site/{siteName}/device/{mac}/wireless-links"})
    public G getDeviceWirelessLinks(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") java.lang.String string) {
        return G.\u00d200000(this.\u00d600000.\u00d800000(site.getId(), string));
    }

    @GetMapping(value={"/api/site/{siteName}/device/wireless-links"})
    public List<G> getSiteDevicesWirelessLinks(@PathVariable(value="siteName") Site site) {
        return com.ubnt.ace.class.do(this.\u00d600000.\u00d300000(site.getId()), G::\u00d200000);
    }

    @AllowUCoreLocal
    @GetMapping(value={"/api/devices/{deviceMac}/details"})
    @Operation(summary="Get details for a Unifi device")
    public UnifiDeviceDetailsDto getUnifiDeviceDetails(@PathVariable(value="deviceMac") java.lang.String string) {
        return this.\u00d400000.doString(string).orElseThrow(super::new);
    }

    private Admin \u00d300000(Optional<X> optional) {
        return optional.map(x2 -> x2.getX("admin")).filter(Admin.class::isInstance).map(Admin.class::cast).orElse(new Admin());
    }

    private void super(java.lang.String string, Site site, Boolean bl) {
        this.\u00d800000.o\u00d5oO00(site.getId(), string).ifPresent(device -> {
            this.\u00d800000.\u00f8\u00d5OO00((Device)device, "use_ble_setup_configuration", bl);
            this.\u00d800000.\u00d3\u00f4OO00((Device)device);
        });
    }

    @ConstructorProperties(value={"deviceService", "deviceWirelessLinkService", "roleManager", "deviceManager", "deviceListDtoFormatter", "gatewayRedundancyAdoptionService", "loginInfoService"})
    @Generated
    public DeviceController(K k2, interface interface_, A a2, oOOo0 oOOo02, I i2, com.ubnt.service.devmgr.device.E.A a3, com.ubnt.net.security.G g2) {
        this.\u00d400000 = k2;
        this.\u00d600000 = interface_;
        this.\u00d200000 = a2;
        this.\u00d800000 = oOOo02;
        this.\u00d300000 = i2;
        this.class = a3;
        this.super = g2;
    }
}

