/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan.hotspot2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.F.return;
import com.ubnt.ace.Q;
import com.ubnt.data.X;
import com.ubnt.model.api.wlan.hotspot2.AuthParameterId;
import com.ubnt.model.api.wlan.hotspot2.ImmutableNaiRealmDto;
import com.ubnt.model.api.wlan.hotspot2.NaiRealmEapMethod;
import com.ubnt.model.api.wlan.hotspot2.NaiRealmFormatEncoding;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Nai Realm", description="Wlan Hotspot2 NAI Realm")
@Value.Immutable
@return
public interface NaiRealmDto {
    @JsonProperty(value="name")
    @Schema(name="NAI Realm Name")
    public String name();

    @JsonProperty(value="status")
    @Schema(name="NAI Realm status")
    public boolean status();

    @JsonProperty(value="encoding")
    @Schema(name="NAI Realm Encoding")
    public NaiRealmFormatEncoding encoding();

    @JsonProperty(value="eap_method")
    @Schema(name="NAI Realm EAP Method")
    public NaiRealmEapMethod eapMethod();

    @JsonProperty(value="auth_ids")
    @Schema(name="NAI Realm Auth IDs")
    public List<AuthParameterId> authIds();

    @JsonProperty(value="auth_vals")
    @Schema(name="NAI Realm Auth Values")
    public List<String> authValues();

    default public X toLegacy() {
        return new X().append("name", this.name()).append("status", this.status()).append("encoding", this.encoding().toString()).append("eap_method", this.eapMethod().toString()).append("auth_ids", this.authIds().stream().map(AuthParameterId::toString).toList()).append("auth_vals", this.authValues());
    }

    public static NaiRealmDto of(X x2) {
        return NaiRealmDto.builder().name(x2.getString("name")).status(x2.getBoolean("status")).encoding(Q.\u00d4O0000(NaiRealmFormatEncoding.class, x2.getString("encoding")).orElse(NaiRealmFormatEncoding.REALM)).eapMethod(Q.\u00d4O0000(NaiRealmEapMethod.class, x2.getString("eap_method")).orElse(NaiRealmEapMethod.EAP_TLS)).authIds(NaiRealmDto.toAuthParameterId(x2.getStringList("auth_ids"))).authValues(x2.getStringList("auth_vals").stream().filter(StringUtils::isNotBlank).toList()).build();
    }

    public static ImmutableNaiRealmDto.Builder builder() {
        return ImmutableNaiRealmDto.builder();
    }

    public static List<AuthParameterId> toAuthParameterId(List<String> list) {
        return list.stream().filter(StringUtils::isNotBlank).map(string -> Q.\u00d4O0000(AuthParameterId.class, string)).flatMap(Optional::stream).toList();
    }
}

