/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.alert.AlertDtoParameters;
import com.ubnt.model.api.alert.ImmutableAlertDeviceClientDtoParameters;
import com.ubnt.return.C;
import com.ubnt.service.alert.DeviceClientParameterDataDocumentPart;
import com.ubnt.service.alert.ParameterDataDocumentPart;
import com.ubnt.service.uidb.int;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@C
public interface AlertDeviceClientDtoParameters
extends AlertDtoParameters {
    @JsonProperty(value="model")
    @Schema(name="Model sku of the referenced entity")
    public Optional<String> model();

    @JsonProperty(value="model_name")
    @Schema(name="Model name of the referenced entity")
    public Optional<String> modelName();

    @JsonProperty(value="fingerprint_source")
    @Schema(name="Fingerprint engine ID", example="0")
    public Optional<Integer> fingerprintSource();

    @JsonProperty(value="device_fingerprint_id")
    @Schema(name="Fingerprinting device ID", example="1")
    public Optional<Integer> deviceFingerprintId();

    @JsonProperty(value="unifi_device_fingerprint_icon_filename")
    @Schema(name="Icon filename", example="b8e2127c-239b-4686-99e6-1872c5b4749a")
    public Optional<String> unifiDeviceFingerprintIconFilename();

    @JsonProperty(value="unifi_device_fingerprint_icon_resolutions")
    @Schema(name="Supported icon resolutions", example="[[257, 257], [129, 129], [101, 101], [51, 51], [25, 25]]")
    public Optional<List<List<Integer>>> unifiDeviceFingerprintIconResolutions();

    @JsonProperty(value="ip")
    @Schema(name="IP address of the referenced entity")
    public Optional<String> ip();

    @JsonProperty(value="version")
    @Schema(name="Version of the referenced entity")
    public Optional<String> version();

    @JsonProperty(value="radius_identity")
    @Schema(name="RADIUS identity of the referenced entity")
    public Optional<String> radiusIdentity();

    @JsonProperty(value="hostname")
    @Schema(name="Hostname of the referenced entity")
    public Optional<String> hostname();

    public static AlertDtoParameters mapDocumentToDto(ParameterDataDocumentPart parameterDataDocumentPart, int intVal) {
        AlertDtoParameters alertDtoParameters = AlertDtoParameters.mapDocumentToDto(parameterDataDocumentPart, intVal);
        if (parameterDataDocumentPart instanceof DeviceClientParameterDataDocumentPart) {
            DeviceClientParameterDataDocumentPart deviceClientParameterDataDocumentPart = (DeviceClientParameterDataDocumentPart)parameterDataDocumentPart;
            return AlertDeviceClientDtoParameters.builder().from(alertDtoParameters).model(Optional.ofNullable(deviceClientParameterDataDocumentPart.getModel())).modelName(intVal.\u00d5O0000(deviceClientParameterDataDocumentPart.getModel()).map(Enum::name)).fingerprintSource(deviceClientParameterDataDocumentPart.getFingerprintSource()).deviceFingerprintId(deviceClientParameterDataDocumentPart.getDeviceFingerprintId()).unifiDeviceFingerprintIconFilename(deviceClientParameterDataDocumentPart.getUnifiDeviceFingerprintIconFilename()).unifiDeviceFingerprintIconResolutions(deviceClientParameterDataDocumentPart.getUnifiDeviceFingerprintIconResolutions()).ip(Optional.ofNullable(deviceClientParameterDataDocumentPart.getIp())).version(Optional.ofNullable(deviceClientParameterDataDocumentPart.getVersion())).radiusIdentity(Optional.ofNullable(deviceClientParameterDataDocumentPart.getRadiusIdentity())).hostname(Optional.ofNullable(deviceClientParameterDataDocumentPart.getHostname())).build();
        }
        return alertDtoParameters;
    }

    public static ImmutableAlertDeviceClientDtoParameters.Builder builder() {
        return ImmutableAlertDeviceClientDtoParameters.builder();
    }
}

