/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.util.Map;
import org.bson.Document;
import org.springframework.lang.Nullable;

public interface GridFsObject<ID, CONTENT> {
    @Nullable
    public ID getFileId();

    public String getFilename();

    public CONTENT getContent();

    public Options getOptions();

    public static class Options {
        private final Document metadata;
        private final int chunkSize;

        private Options(Document metadata, int chunkSize) {
            this.metadata = metadata;
            this.chunkSize = chunkSize;
        }

        public static Options none() {
            return new Options(new Document(), -1);
        }

        public static Options typed(String contentType) {
            return new Options(new Document("_contentType", (Object)contentType), -1);
        }

        public static Options from(@Nullable GridFSFile gridFSFile) {
            return gridFSFile != null ? new Options(gridFSFile.getMetadata(), gridFSFile.getChunkSize()) : Options.none();
        }

        public Options contentType(String contentType) {
            Options target = new Options(new Document((Map)this.metadata), this.chunkSize);
            target.metadata.put("_contentType", (Object)contentType);
            return target;
        }

        public Options metadata(Document metadata) {
            return new Options(metadata, this.chunkSize);
        }

        public Options chunkSize(int chunkSize) {
            return new Options(this.metadata, chunkSize);
        }

        public Document getMetadata() {
            return this.metadata;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        @Nullable
        String getContentType() {
            return (String)this.metadata.get((Object)"_contentType");
        }
    }
}

