/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.expressions;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.FunctionUtils;
import com.google.common.base.Objects;
import com.google.firestore.v1.Function;
import com.google.firestore.v1.Value;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@BetaApi
public class FunctionExpression
extends Expression {
    private final String name;
    private final List<Expression> params;

    FunctionExpression(String name, List<? extends Expression> params) {
        this.name = name;
        this.params = Collections.unmodifiableList(params);
    }

    @Override
    @InternalApi
    Value toProto() {
        return Value.newBuilder().setFunctionValue(Function.newBuilder().setName(this.name).addAllArgs((Iterable)this.params.stream().map(FunctionUtils::exprToValue).collect(Collectors.toList()))).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpression that = (FunctionExpression)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.params});
    }
}

