/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JedisByteHashMap
implements Map<byte[], byte[]>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6971431362627219416L;
    private final Map<ByteArrayWrapper, byte[]> internalMap = new LinkedHashMap<ByteArrayWrapper, byte[]>();

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof byte[]) {
            return this.internalMap.containsKey(new ByteArrayWrapper((byte[])key));
        }
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<byte[], byte[]>> entrySet() {
        Iterator<Map.Entry<ByteArrayWrapper, byte[]>> iterator = this.internalMap.entrySet().iterator();
        LinkedHashSet<Map.Entry<byte[], byte[]>> hashSet = new LinkedHashSet<Map.Entry<byte[], byte[]>>();
        while (iterator.hasNext()) {
            Map.Entry<ByteArrayWrapper, byte[]> entry = iterator.next();
            hashSet.add(new JedisByteEntry(entry.getKey().data, entry.getValue()));
        }
        return hashSet;
    }

    @Override
    public byte[] get(Object key) {
        if (key instanceof byte[]) {
            return this.internalMap.get(new ByteArrayWrapper((byte[])key));
        }
        return this.internalMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public Set<byte[]> keySet() {
        LinkedHashSet<byte[]> keySet = new LinkedHashSet<byte[]>();
        Iterator<ByteArrayWrapper> iterator = this.internalMap.keySet().iterator();
        while (iterator.hasNext()) {
            keySet.add(iterator.next().data);
        }
        return keySet;
    }

    @Override
    public byte[] put(byte[] key, byte[] value) {
        return this.internalMap.put(new ByteArrayWrapper(key), value);
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends byte[]> m) {
        for (Map.Entry<? extends byte[], ? extends byte[]> next : m.entrySet()) {
            this.internalMap.put(new ByteArrayWrapper(next.getKey()), next.getValue());
        }
    }

    @Override
    public byte[] remove(Object key) {
        if (key instanceof byte[]) {
            return this.internalMap.remove(new ByteArrayWrapper((byte[])key));
        }
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public Collection<byte[]> values() {
        return this.internalMap.values();
    }

    private static final class JedisByteEntry
    implements Map.Entry<byte[], byte[]> {
        private byte[] value;
        private byte[] key;

        public JedisByteEntry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] setValue(byte[] value) {
            this.value = value;
            return value;
        }
    }

    private static final class ByteArrayWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] data;
        private final int hashCode;

        public ByteArrayWrapper(byte[] data) {
            if (data == null) {
                throw new NullPointerException();
            }
            this.data = data;
            this.hashCode = Arrays.hashCode(data);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.data, ((ByteArrayWrapper)other).data);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

