/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.User;

public class LdapProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapProvider.class);
    private final String url;
    private final String searchBase;
    private final String idAttribute;
    private final String nameAttribute;
    private final String mailAttribute;
    private final String searchFilter;
    private final String adminFilter;
    private final String serviceUser;
    private final String servicePassword;

    public LdapProvider(Config config) {
        String adminGroup;
        this.url = config.getString(Keys.LDAP_URL);
        this.searchBase = config.getString(Keys.LDAP_BASE);
        this.idAttribute = config.getString(Keys.LDAP_ID_ATTRIBUTE);
        this.nameAttribute = config.getString(Keys.LDAP_NAME_ATTRIBUTE);
        this.mailAttribute = config.getString(Keys.LDAP_MAIN_ATTRIBUTE);
        this.searchFilter = config.hasKey(Keys.LDAP_SEARCH_FILTER) ? config.getString(Keys.LDAP_SEARCH_FILTER) : "(" + this.idAttribute + "=:login)";
        this.adminFilter = config.hasKey(Keys.LDAP_ADMIN_FILTER) ? config.getString(Keys.LDAP_ADMIN_FILTER) : ((adminGroup = config.getString(Keys.LDAP_ADMIN_GROUP)) != null ? "(&(" + this.idAttribute + "=:login)(memberOf=" + adminGroup + "))" : null);
        this.serviceUser = config.getString(Keys.LDAP_USER);
        this.servicePassword = config.getString(Keys.LDAP_PASSWORD);
    }

    private InitialDirContext auth(String accountName, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", accountName);
        env.put("java.naming.security.credentials", password);
        return new InitialDirContext(env);
    }

    private boolean isAdmin(String accountName) {
        if (this.adminFilter != null) {
            try {
                InitialDirContext context = this.initContext();
                String searchString = this.adminFilter.replace(":login", this.encodeForLdap(accountName));
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                NamingEnumeration<SearchResult> results = context.search(this.searchBase, searchString, searchControls);
                if (results.hasMoreElements()) {
                    results.nextElement();
                    if (results.hasMoreElements()) {
                        LOGGER.warn("Matched multiple users for the accountName: " + accountName);
                        return false;
                    }
                    return true;
                }
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public InitialDirContext initContext() throws NamingException {
        return this.auth(this.serviceUser, this.servicePassword);
    }

    private SearchResult lookupUser(String accountName) throws NamingException {
        InitialDirContext context = this.initContext();
        String searchString = this.searchFilter.replace(":login", this.encodeForLdap(accountName));
        SearchControls searchControls = new SearchControls();
        String[] attributeFilter = new String[]{this.idAttribute, this.nameAttribute, this.mailAttribute};
        searchControls.setReturningAttributes(attributeFilter);
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = context.search(this.searchBase, searchString, searchControls);
        SearchResult searchResult = null;
        if (results.hasMoreElements()) {
            searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                LOGGER.warn("Matched multiple users for the accountName: " + accountName);
                return null;
            }
        }
        return searchResult;
    }

    public User getUser(String accountName) {
        User user = new User();
        try {
            SearchResult ldapUser = this.lookupUser(accountName);
            if (ldapUser != null) {
                Attribute attribute = ldapUser.getAttributes().get(this.idAttribute);
                if (attribute != null) {
                    user.setLogin((String)attribute.get());
                } else {
                    user.setLogin(accountName);
                }
                attribute = ldapUser.getAttributes().get(this.nameAttribute);
                if (attribute != null) {
                    user.setName((String)attribute.get());
                } else {
                    user.setName(accountName);
                }
                attribute = ldapUser.getAttributes().get(this.mailAttribute);
                if (attribute != null) {
                    user.setEmail((String)attribute.get());
                } else {
                    user.setEmail(accountName);
                }
            }
            user.setAdministrator(this.isAdmin(accountName));
        }
        catch (NamingException e) {
            user.setLogin(accountName);
            user.setName(accountName);
            user.setEmail(accountName);
            LOGGER.warn("User lookup error", (Throwable)e);
        }
        return user;
    }

    public boolean login(String username, String password) {
        try {
            SearchResult ldapUser = this.lookupUser(username);
            if (ldapUser != null) {
                this.auth(ldapUser.getNameInNamespace(), password).close();
                return true;
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    public String encodeForLdap(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\5c");
                    continue block10;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block10;
                }
                case '(': {
                    sb.append("\\28");
                    continue block10;
                }
                case ')': {
                    sb.append("\\29");
                    continue block10;
                }
                case '&': {
                    sb.append("\\26");
                    continue block10;
                }
                case '|': {
                    sb.append("\\7c");
                    continue block10;
                }
                case '=': {
                    sb.append("\\3d");
                    continue block10;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

