/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.util;

import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.McpUriTemplateManager;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultMcpUriTemplateManager
implements McpUriTemplateManager {
    private static final Pattern URI_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final String uriTemplate;

    public DefaultMcpUriTemplateManager(String uriTemplate) {
        Assert.hasText(uriTemplate, "URI template must not be null or empty");
        this.uriTemplate = uriTemplate;
    }

    @Override
    public List<String> getVariableNames() {
        ArrayList<String> variables = new ArrayList<String>();
        Matcher matcher = URI_VARIABLE_PATTERN.matcher(this.uriTemplate);
        while (matcher.find()) {
            String variableName = matcher.group(1);
            if (variables.contains(variableName)) {
                throw new IllegalArgumentException("Duplicate URI variable name in template: " + variableName);
            }
            variables.add(variableName);
        }
        return variables;
    }

    @Override
    public Map<String, String> extractVariableValues(String requestUri) {
        HashMap<String, String> variableValues = new HashMap<String, String>();
        List<String> uriVariables = this.getVariableNames();
        if (!Utils.hasText(requestUri) || uriVariables.isEmpty()) {
            return variableValues;
        }
        try {
            StringBuilder patternBuilder = new StringBuilder("^");
            Matcher variableMatcher = URI_VARIABLE_PATTERN.matcher(this.uriTemplate);
            int lastEnd = 0;
            while (variableMatcher.find()) {
                String textBefore = this.uriTemplate.substring(lastEnd, variableMatcher.start());
                patternBuilder.append(Pattern.quote(textBefore));
                patternBuilder.append("([^/]+)");
                lastEnd = variableMatcher.end();
            }
            if (lastEnd < this.uriTemplate.length()) {
                patternBuilder.append(Pattern.quote(this.uriTemplate.substring(lastEnd)));
            }
            patternBuilder.append("$");
            Pattern pattern = Pattern.compile(patternBuilder.toString());
            Matcher matcher = pattern.matcher(requestUri);
            if (matcher.find() && matcher.groupCount() == uriVariables.size()) {
                for (int i = 0; i < uriVariables.size(); ++i) {
                    String value = matcher.group(i + 1);
                    if (value == null || value.isEmpty()) {
                        throw new IllegalArgumentException("Empty value for URI variable '" + uriVariables.get(i) + "' in URI: " + requestUri);
                    }
                    variableValues.put(uriVariables.get(i), value);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing URI template: " + this.uriTemplate + " for URI: " + requestUri, e);
        }
        return variableValues;
    }

    @Override
    public boolean matches(String uri) {
        if (!this.isUriTemplate(this.uriTemplate)) {
            return uri.equals(this.uriTemplate);
        }
        StringBuilder patternBuilder = new StringBuilder("^");
        Matcher variableMatcher = URI_VARIABLE_PATTERN.matcher(this.uriTemplate);
        int lastEnd = 0;
        while (variableMatcher.find()) {
            String textBefore = this.uriTemplate.substring(lastEnd, variableMatcher.start());
            patternBuilder.append(Pattern.quote(textBefore));
            patternBuilder.append("([^/]+?)");
            lastEnd = variableMatcher.end();
        }
        if (lastEnd < this.uriTemplate.length()) {
            patternBuilder.append(Pattern.quote(this.uriTemplate.substring(lastEnd)));
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString()).matcher(uri).matches();
    }

    @Override
    public boolean isUriTemplate(String uri) {
        return URI_VARIABLE_PATTERN.matcher(uri).find();
    }
}

