/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

public interface ProbingPolicy {
    public Decision evaluate(ProbeContext var1);

    public static class BuiltIn {
        public static final ProbingPolicy ALL_SUCCESS = new AllSuccessPolicy();
        public static final ProbingPolicy ANY_SUCCESS = new AnySuccessPolicy();
        public static final ProbingPolicy MAJORITY_SUCCESS = new MajoritySuccessPolicy();

        private static class MajoritySuccessPolicy
        implements ProbingPolicy {
            private MajoritySuccessPolicy() {
            }

            @Override
            public Decision evaluate(ProbeContext ctx) {
                int total = ctx.getRemainingProbes() + ctx.getSuccesses() + ctx.getFails();
                int required = total / 2 + 1;
                if (ctx.getSuccesses() >= required) {
                    return Decision.SUCCESS;
                }
                int maxPossibleSuccesses = ctx.getSuccesses() + ctx.getRemainingProbes();
                if (maxPossibleSuccesses < required) {
                    return Decision.FAIL;
                }
                if (ctx.getRemainingProbes() == 0) {
                    return ctx.getSuccesses() >= required ? Decision.SUCCESS : Decision.FAIL;
                }
                return Decision.CONTINUE;
            }
        }

        private static class AnySuccessPolicy
        implements ProbingPolicy {
            private AnySuccessPolicy() {
            }

            @Override
            public Decision evaluate(ProbeContext ctx) {
                if (ctx.getSuccesses() > 0) {
                    return Decision.SUCCESS;
                }
                if (ctx.getRemainingProbes() == 0) {
                    return Decision.FAIL;
                }
                return Decision.CONTINUE;
            }
        }

        private static class AllSuccessPolicy
        implements ProbingPolicy {
            private AllSuccessPolicy() {
            }

            @Override
            public Decision evaluate(ProbeContext ctx) {
                if (ctx.getFails() > 0) {
                    return Decision.FAIL;
                }
                if (ctx.getRemainingProbes() == 0) {
                    return Decision.SUCCESS;
                }
                return Decision.CONTINUE;
            }
        }
    }

    public static interface ProbeContext {
        public int getRemainingProbes();

        public int getSuccesses();

        public int getFails();
    }

    public static enum Decision {
        CONTINUE,
        SUCCESS,
        FAIL;

    }
}

