/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.sms.SmsManager;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.SnsException;

public class SnsSmsClient
implements SmsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnsSmsClient.class);
    private final SnsClient snsClient;

    public SnsSmsClient(Config config) {
        AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)config.getString(Keys.SMS_AWS_ACCESS), (String)config.getString(Keys.SMS_AWS_SECRET));
        this.snsClient = (SnsClient)((SnsClientBuilder)((SnsClientBuilder)SnsClient.builder().region(Region.of((String)config.getString(Keys.SMS_AWS_REGION)))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).build();
    }

    @Override
    public void sendMessage(String phone, String message, boolean command) {
        HashMap<String, MessageAttributeValue> smsAttributes = new HashMap<String, MessageAttributeValue>();
        smsAttributes.put("AWS.SNS.SMS.SenderID", (MessageAttributeValue)MessageAttributeValue.builder().stringValue("SNS").dataType("String").build());
        smsAttributes.put("AWS.SNS.SMS.SMSType", (MessageAttributeValue)MessageAttributeValue.builder().stringValue("Transactional").dataType("String").build());
        PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().message(message).phoneNumber(phone).messageAttributes(smsAttributes).build();
        try {
            this.snsClient.publish(publishRequest);
        }
        catch (SnsException e) {
            LOGGER.error("SMS send failed", (Throwable)e);
        }
    }
}

