/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringEncoder;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.protocol.H02FrameDecoder;
import org.traccar.protocol.H02ProtocolDecoder;
import org.traccar.protocol.H02ProtocolEncoder;

public class H02Protocol
extends BaseProtocol {
    @Inject
    public H02Protocol(Config config) {
        this.setSupportedDataCommands("alarmArm", "alarmDisarm", "engineStop", "engineResume", "positionPeriodic");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                int messageLength = config.getInteger(Keys.PROTOCOL_MESSAGE_LENGTH.withPrefix(H02Protocol.this.getName()));
                pipeline.addLast((ChannelHandler)new H02FrameDecoder(messageLength));
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new H02ProtocolEncoder(H02Protocol.this));
                pipeline.addLast((ChannelHandler)new H02ProtocolDecoder(H02Protocol.this));
            }
        });
        this.addServer(new TrackerServer(config, this.getName(), true){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new H02ProtocolEncoder(H02Protocol.this));
                pipeline.addLast((ChannelHandler)new H02ProtocolDecoder(H02Protocol.this));
            }
        });
    }
}

