/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.walk.AbstractWalkHandler;
import com.networknt.schema.walk.WalkEvent;
import com.networknt.schema.walk.WalkListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class PropertyWalkHandler
extends AbstractWalkHandler {
    private final List<WalkListener> propertyWalkListeners;

    public PropertyWalkHandler(List<WalkListener> propertyWalkListeners) {
        this.propertyWalkListeners = propertyWalkListeners;
    }

    @Override
    public boolean preWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator) {
        WalkEvent walkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        return this.runPreWalkListeners(this.propertyWalkListeners, walkEvent);
    }

    @Override
    public void postWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator, List<Error> errors) {
        WalkEvent walkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        this.runPostWalkListeners(this.propertyWalkListeners, walkEvent, errors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<WalkListener> propertyWalkListeners = new ArrayList<WalkListener>();

        public Builder propertyWalkListener(WalkListener propertyWalkListener) {
            this.propertyWalkListeners.add(propertyWalkListener);
            return this;
        }

        public Builder propertyWalkListeners(Consumer<List<WalkListener>> propertyWalkListeners) {
            propertyWalkListeners.accept(this.propertyWalkListeners);
            return this;
        }

        public PropertyWalkHandler build() {
            return new PropertyWalkHandler(this.propertyWalkListeners);
        }
    }
}

