/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Supplier;

public class ClasspathResourceLoader
implements ResourceLoader {
    private final Supplier<ClassLoader> classLoaderSource;

    public static ClasspathResourceLoader getInstance() {
        return Holder.INSTANCE;
    }

    public ClasspathResourceLoader() {
        this(ClasspathResourceLoader::getClassLoader);
    }

    public ClasspathResourceLoader(Supplier<ClassLoader> classLoaderSource) {
        this.classLoaderSource = classLoaderSource;
    }

    @Override
    public InputStreamSource getResource(AbsoluteIri absoluteIri) {
        String iri = absoluteIri != null ? absoluteIri.toString() : "";
        String name = null;
        if (iri.startsWith("classpath:")) {
            name = iri.substring(10);
        } else if (iri.startsWith("resource:")) {
            name = iri.substring(9);
        }
        if (name != null) {
            ClassLoader classLoader = this.classLoaderSource.get();
            if (name.startsWith("//")) {
                name = name.substring(2);
            }
            String resource = name;
            return () -> {
                InputStream result = classLoader.getResourceAsStream(resource);
                if (result == null) {
                    result = classLoader.getResourceAsStream(resource.substring(1));
                }
                if (result == null) {
                    throw new FileNotFoundException(iri);
                }
                return result;
            };
        }
        return null;
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ResourceLoader.class.getClassLoader();
        }
        return classLoader;
    }

    private static class Holder {
        private static final ClasspathResourceLoader INSTANCE = new ClasspathResourceLoader();

        private Holder() {
        }
    }
}

