// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/batch/v1alpha1/job.proto

package batch

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The order that TaskGroups are scheduled relative to each other.
//
// [NotImplemented]
type Job_SchedulingPolicy int32

const (
	// Unspecified.
	Job_SCHEDULING_POLICY_UNSPECIFIED Job_SchedulingPolicy = 0
	// Run all TaskGroups as soon as possible.
	Job_AS_SOON_AS_POSSIBLE Job_SchedulingPolicy = 1
)

// Enum value maps for Job_SchedulingPolicy.
var (
	Job_SchedulingPolicy_name = map[int32]string{
		0: "SCHEDULING_POLICY_UNSPECIFIED",
		1: "AS_SOON_AS_POSSIBLE",
	}
	Job_SchedulingPolicy_value = map[string]int32{
		"SCHEDULING_POLICY_UNSPECIFIED": 0,
		"AS_SOON_AS_POSSIBLE":           1,
	}
)

func (x Job_SchedulingPolicy) Enum() *Job_SchedulingPolicy {
	p := new(Job_SchedulingPolicy)
	*p = x
	return p
}

func (x Job_SchedulingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_SchedulingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_job_proto_enumTypes[0].Descriptor()
}

func (Job_SchedulingPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_job_proto_enumTypes[0]
}

func (x Job_SchedulingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_SchedulingPolicy.Descriptor instead.
func (Job_SchedulingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{0, 0}
}

// The destination (if any) for logs.
type LogsPolicy_Destination int32

const (
	// Logs are not preserved.
	LogsPolicy_DESTINATION_UNSPECIFIED LogsPolicy_Destination = 0
	// Logs are streamed to Cloud Logging.
	LogsPolicy_CLOUD_LOGGING LogsPolicy_Destination = 1
	// Logs are saved to a path.
	LogsPolicy_PATH LogsPolicy_Destination = 2
)

// Enum value maps for LogsPolicy_Destination.
var (
	LogsPolicy_Destination_name = map[int32]string{
		0: "DESTINATION_UNSPECIFIED",
		1: "CLOUD_LOGGING",
		2: "PATH",
	}
	LogsPolicy_Destination_value = map[string]int32{
		"DESTINATION_UNSPECIFIED": 0,
		"CLOUD_LOGGING":           1,
		"PATH":                    2,
	}
)

func (x LogsPolicy_Destination) Enum() *LogsPolicy_Destination {
	p := new(LogsPolicy_Destination)
	*p = x
	return p
}

func (x LogsPolicy_Destination) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogsPolicy_Destination) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_job_proto_enumTypes[1].Descriptor()
}

func (LogsPolicy_Destination) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_job_proto_enumTypes[1]
}

func (x LogsPolicy_Destination) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogsPolicy_Destination.Descriptor instead.
func (LogsPolicy_Destination) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{1, 0}
}

// Dependency type.
type JobDependency_Type int32

const (
	// Unspecified.
	JobDependency_TYPE_UNSPECIFIED JobDependency_Type = 0
	// The dependent Job has succeeded.
	JobDependency_SUCCEEDED JobDependency_Type = 1
	// The dependent Job has failed.
	JobDependency_FAILED JobDependency_Type = 2
	// SUCCEEDED or FAILED.
	JobDependency_FINISHED JobDependency_Type = 3
)

// Enum value maps for JobDependency_Type.
var (
	JobDependency_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "FINISHED",
	}
	JobDependency_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SUCCEEDED":        1,
		"FAILED":           2,
		"FINISHED":         3,
	}
)

func (x JobDependency_Type) Enum() *JobDependency_Type {
	p := new(JobDependency_Type)
	*p = x
	return p
}

func (x JobDependency_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobDependency_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_job_proto_enumTypes[2].Descriptor()
}

func (JobDependency_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_job_proto_enumTypes[2]
}

func (x JobDependency_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobDependency_Type.Descriptor instead.
func (JobDependency_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{2, 0}
}

// Valid Job states.
type JobStatus_State int32

const (
	JobStatus_STATE_UNSPECIFIED JobStatus_State = 0
	// Job is submitted into a ResourcePool and waiting
	// for resource allocation.
	JobStatus_QUEUED JobStatus_State = 1
	// Job is scheduled to run as soon as resource allocation is ready.
	// The resource allocation may happen at a later time but with a high
	// chance to succeed.
	JobStatus_SCHEDULED JobStatus_State = 2
	// Resource allocation has been successful. At least one Task in the Job is
	// RUNNING.
	JobStatus_RUNNING JobStatus_State = 3
	// All Tasks in the Job have finished successfully.
	JobStatus_SUCCEEDED JobStatus_State = 4
	// At least one Task in the Job has failed.
	JobStatus_FAILED JobStatus_State = 5
	// The Job will be deleted, but has not been deleted yet. Typically this is
	// because resources used by the Job are still being cleaned up.
	JobStatus_DELETION_IN_PROGRESS JobStatus_State = 6
)

// Enum value maps for JobStatus_State.
var (
	JobStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "QUEUED",
		2: "SCHEDULED",
		3: "RUNNING",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "DELETION_IN_PROGRESS",
	}
	JobStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED":    0,
		"QUEUED":               1,
		"SCHEDULED":            2,
		"RUNNING":              3,
		"SUCCEEDED":            4,
		"FAILED":               5,
		"DELETION_IN_PROGRESS": 6,
	}
)

func (x JobStatus_State) Enum() *JobStatus_State {
	p := new(JobStatus_State)
	*p = x
	return p
}

func (x JobStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_job_proto_enumTypes[3].Descriptor()
}

func (JobStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_job_proto_enumTypes[3]
}

func (x JobStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobStatus_State.Descriptor instead.
func (JobStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{3, 0}
}

// Compute Engine VM instance provisioning model.
type AllocationPolicy_ProvisioningModel int32

const (
	// Unspecified.
	AllocationPolicy_PROVISIONING_MODEL_UNSPECIFIED AllocationPolicy_ProvisioningModel = 0
	// Standard VM.
	AllocationPolicy_STANDARD AllocationPolicy_ProvisioningModel = 1
	// SPOT VM.
	AllocationPolicy_SPOT AllocationPolicy_ProvisioningModel = 2
	// Preemptible VM (PVM).
	//
	// Above SPOT VM is the preferable model for preemptible VM instances: the
	// old preemptible VM model (indicated by this field) is the older model,
	// and has been migrated to use the SPOT model as the underlying technology.
	// This old model will still be supported.
	AllocationPolicy_PREEMPTIBLE AllocationPolicy_ProvisioningModel = 3
)

// Enum value maps for AllocationPolicy_ProvisioningModel.
var (
	AllocationPolicy_ProvisioningModel_name = map[int32]string{
		0: "PROVISIONING_MODEL_UNSPECIFIED",
		1: "STANDARD",
		2: "SPOT",
		3: "PREEMPTIBLE",
	}
	AllocationPolicy_ProvisioningModel_value = map[string]int32{
		"PROVISIONING_MODEL_UNSPECIFIED": 0,
		"STANDARD":                       1,
		"SPOT":                           2,
		"PREEMPTIBLE":                    3,
	}
)

func (x AllocationPolicy_ProvisioningModel) Enum() *AllocationPolicy_ProvisioningModel {
	p := new(AllocationPolicy_ProvisioningModel)
	*p = x
	return p
}

func (x AllocationPolicy_ProvisioningModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationPolicy_ProvisioningModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_job_proto_enumTypes[4].Descriptor()
}

func (AllocationPolicy_ProvisioningModel) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_job_proto_enumTypes[4]
}

func (x AllocationPolicy_ProvisioningModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationPolicy_ProvisioningModel.Descriptor instead.
func (AllocationPolicy_ProvisioningModel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{5, 0}
}

// How Tasks in the TaskGroup should be scheduled relative to each other.
type TaskGroup_SchedulingPolicy int32

const (
	// Unspecified.
	TaskGroup_SCHEDULING_POLICY_UNSPECIFIED TaskGroup_SchedulingPolicy = 0
	// Run Tasks as soon as resources are available.
	TaskGroup_AS_SOON_AS_POSSIBLE TaskGroup_SchedulingPolicy = 1
)

// Enum value maps for TaskGroup_SchedulingPolicy.
var (
	TaskGroup_SchedulingPolicy_name = map[int32]string{
		0: "SCHEDULING_POLICY_UNSPECIFIED",
		1: "AS_SOON_AS_POSSIBLE",
	}
	TaskGroup_SchedulingPolicy_value = map[string]int32{
		"SCHEDULING_POLICY_UNSPECIFIED": 0,
		"AS_SOON_AS_POSSIBLE":           1,
	}
)

func (x TaskGroup_SchedulingPolicy) Enum() *TaskGroup_SchedulingPolicy {
	p := new(TaskGroup_SchedulingPolicy)
	*p = x
	return p
}

func (x TaskGroup_SchedulingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskGroup_SchedulingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_job_proto_enumTypes[5].Descriptor()
}

func (TaskGroup_SchedulingPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_job_proto_enumTypes[5]
}

func (x TaskGroup_SchedulingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskGroup_SchedulingPolicy.Descriptor instead.
func (TaskGroup_SchedulingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{6, 0}
}

// The Cloud Batch Job description.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job name.
	// It must have the format of "projects/*/locations/*/jobs/*".
	// For example: "projects/123456/locations/us-west1/jobs/job01".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A system generated unique ID (in UUID4 format) for the Job.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Priority of the Job.
	// The valid value range is [0, 100).
	// A job with higher priority value will be scheduled to run earlier.
	Priority int64 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Required. TaskGroups in the Job. Only one TaskGroup is supported now.
	TaskGroups []*TaskGroup `protobuf:"bytes,4,rep,name=task_groups,json=taskGroups,proto3" json:"task_groups,omitempty"`
	// Scheduling policy for TaskGroups in the job.
	SchedulingPolicy Job_SchedulingPolicy `protobuf:"varint,5,opt,name=scheduling_policy,json=schedulingPolicy,proto3,enum=google.cloud.batch.v1alpha1.Job_SchedulingPolicy" json:"scheduling_policy,omitempty"`
	// At least one of the dependencies must be satisfied before the Job is
	// scheduled to run.
	// Only one JobDependency is supported now.
	// [NotImplemented]
	Dependencies []*JobDependency `protobuf:"bytes,6,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Compute resource allocation for all TaskGroups in the Job.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,7,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Labels for the Job. Labels could be user provided or system generated.
	// For example,
	// "labels": {
	//    "department": "finance",
	//    "environment": "test"
	//  }
	// You can assign up to 64 labels.  [Google Compute Engine label
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// apply.
	// Label names that start with "goog-" or "google-" are reserved.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Job status. It is read only for users.
	Status *JobStatus `protobuf:"bytes,9,opt,name=status,proto3" json:"status,omitempty"`
	// Job notification.
	Notification *JobNotification `protobuf:"bytes,10,opt,name=notification,proto3" json:"notification,omitempty"`
	// When the Job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last time the Job was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Log preservation policy for the Job.
	LogsPolicy *LogsPolicy `protobuf:"bytes,13,opt,name=logs_policy,json=logsPolicy,proto3" json:"logs_policy,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Job) GetPriority() int64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Job) GetTaskGroups() []*TaskGroup {
	if x != nil {
		return x.TaskGroups
	}
	return nil
}

func (x *Job) GetSchedulingPolicy() Job_SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return Job_SCHEDULING_POLICY_UNSPECIFIED
}

func (x *Job) GetDependencies() []*JobDependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *Job) GetAllocationPolicy() *AllocationPolicy {
	if x != nil {
		return x.AllocationPolicy
	}
	return nil
}

func (x *Job) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Job) GetStatus() *JobStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Job) GetNotification() *JobNotification {
	if x != nil {
		return x.Notification
	}
	return nil
}

func (x *Job) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Job) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Job) GetLogsPolicy() *LogsPolicy {
	if x != nil {
		return x.LogsPolicy
	}
	return nil
}

// LogsPolicy describes how outputs from a Job's Tasks (stdout/stderr) will be
// preserved.
type LogsPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Where logs should be saved.
	Destination LogsPolicy_Destination `protobuf:"varint,1,opt,name=destination,proto3,enum=google.cloud.batch.v1alpha1.LogsPolicy_Destination" json:"destination,omitempty"`
	// The path to which logs are saved when the destination = PATH. This can be a
	// local filepath on the VM, or under the mount point of a Persistent Disk or
	// Filestore, or a Cloud Storage path.
	LogsPath string `protobuf:"bytes,2,opt,name=logs_path,json=logsPath,proto3" json:"logs_path,omitempty"`
}

func (x *LogsPolicy) Reset() {
	*x = LogsPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogsPolicy) ProtoMessage() {}

func (x *LogsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogsPolicy.ProtoReflect.Descriptor instead.
func (*LogsPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{1}
}

func (x *LogsPolicy) GetDestination() LogsPolicy_Destination {
	if x != nil {
		return x.Destination
	}
	return LogsPolicy_DESTINATION_UNSPECIFIED
}

func (x *LogsPolicy) GetLogsPath() string {
	if x != nil {
		return x.LogsPath
	}
	return ""
}

// JobDependency describes the state of other Jobs that the start of this Job
// depends on.
// All dependent Jobs must have been submitted in the same region.
type JobDependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each item maps a Job name to a Type.
	// All items must be satisfied for the JobDependency to be satisfied (the AND
	// operation).
	// Once a condition for one item becomes true, it won't go back to false
	// even the dependent Job state changes again.
	Items map[string]JobDependency_Type `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.cloud.batch.v1alpha1.JobDependency_Type"`
}

func (x *JobDependency) Reset() {
	*x = JobDependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobDependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobDependency) ProtoMessage() {}

func (x *JobDependency) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobDependency.ProtoReflect.Descriptor instead.
func (*JobDependency) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{2}
}

func (x *JobDependency) GetItems() map[string]JobDependency_Type {
	if x != nil {
		return x.Items
	}
	return nil
}

// Job status.
type JobStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job state
	State JobStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.batch.v1alpha1.JobStatus_State" json:"state,omitempty"`
	// Job status events
	StatusEvents []*StatusEvent `protobuf:"bytes,2,rep,name=status_events,json=statusEvents,proto3" json:"status_events,omitempty"`
	// Aggregated task status for each TaskGroup in the Job.
	// The map key is TaskGroup ID.
	TaskGroups map[string]*JobStatus_TaskGroupStatus `protobuf:"bytes,4,rep,name=task_groups,json=taskGroups,proto3" json:"task_groups,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The duration of time the Job is in status
	// RUNNING. Once the Job completes (i.e. the Job status is either
	// SUCCEEDED/FAILED) the run duration represents the time it took the Job
	// to complete.
	RunDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=run_duration,json=runDuration,proto3" json:"run_duration,omitempty"`
}

func (x *JobStatus) Reset() {
	*x = JobStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus) ProtoMessage() {}

func (x *JobStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus.ProtoReflect.Descriptor instead.
func (*JobStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{3}
}

func (x *JobStatus) GetState() JobStatus_State {
	if x != nil {
		return x.State
	}
	return JobStatus_STATE_UNSPECIFIED
}

func (x *JobStatus) GetStatusEvents() []*StatusEvent {
	if x != nil {
		return x.StatusEvents
	}
	return nil
}

func (x *JobStatus) GetTaskGroups() map[string]*JobStatus_TaskGroupStatus {
	if x != nil {
		return x.TaskGroups
	}
	return nil
}

func (x *JobStatus) GetRunDuration() *durationpb.Duration {
	if x != nil {
		return x.RunDuration
	}
	return nil
}

// Job notification.
type JobNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Pub/Sub topic where notifications like the job state changes will
	// be published. This topic should be an existing topic in the same project
	// with the job and billings will be charged to this project.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
}

func (x *JobNotification) Reset() {
	*x = JobNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobNotification) ProtoMessage() {}

func (x *JobNotification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobNotification.ProtoReflect.Descriptor instead.
func (*JobNotification) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{4}
}

func (x *JobNotification) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

// A Job's resource allocation policy describes when, where, and how compute
// resources should be allocated for the Job.
type AllocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location where compute resources should be allocated for the Job.
	Location *AllocationPolicy_LocationPolicy `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Create only instances allowed by this policy.
	Instance *AllocationPolicy_InstancePolicy `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Create instances from the first instance template - MVP
	// Use 'gcloud compute instance-templates list` to see available templates
	// in the project If specified, it overrides the 'instance' field.
	InstanceTemplates []string `protobuf:"bytes,3,rep,name=instance_templates,json=instanceTemplates,proto3" json:"instance_templates,omitempty"`
	// Create only instances in the listed provisiong models.
	// Default to allow all.
	//
	// Currently only the first model of the provisioning_models list will be
	// considered; specifying additional models (e.g., 2nd, 3rd, etc.) is a no-op.
	ProvisioningModels []AllocationPolicy_ProvisioningModel `protobuf:"varint,4,rep,packed,name=provisioning_models,json=provisioningModels,proto3,enum=google.cloud.batch.v1alpha1.AllocationPolicy_ProvisioningModel" json:"provisioning_models,omitempty"`
	// Email of the service account that VMs will run as.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Labels applied to all VM instances and other resources
	// created by AllocationPolicy.
	// Labels could be user provided or system generated.
	// You can assign up to 64 labels. [Google Compute Engine label
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// apply.
	// Label names that start with "goog-" or "google-" are reserved.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The network policy.
	Network *AllocationPolicy_NetworkPolicy `protobuf:"bytes,7,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *AllocationPolicy) Reset() {
	*x = AllocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy) ProtoMessage() {}

func (x *AllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{5}
}

func (x *AllocationPolicy) GetLocation() *AllocationPolicy_LocationPolicy {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *AllocationPolicy) GetInstance() *AllocationPolicy_InstancePolicy {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *AllocationPolicy) GetInstanceTemplates() []string {
	if x != nil {
		return x.InstanceTemplates
	}
	return nil
}

func (x *AllocationPolicy) GetProvisioningModels() []AllocationPolicy_ProvisioningModel {
	if x != nil {
		return x.ProvisioningModels
	}
	return nil
}

func (x *AllocationPolicy) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *AllocationPolicy) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AllocationPolicy) GetNetwork() *AllocationPolicy_NetworkPolicy {
	if x != nil {
		return x.Network
	}
	return nil
}

// A TaskGroup contains one or multiple Tasks that share the same
// Runnable but with different runtime parameters.
type TaskGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. TaskGroup name.
	// The system generates this field based on parent Job name.
	// For example:
	// "projects/123456/locations/us-west1/jobs/job01/taskGroups/default-group".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Tasks in the group share the same task spec.
	TaskSpec *TaskSpec `protobuf:"bytes,3,opt,name=task_spec,json=taskSpec,proto3" json:"task_spec,omitempty"`
	// Number of Tasks in the TaskGroup.
	// default is 1
	TaskCount int64 `protobuf:"varint,4,opt,name=task_count,json=taskCount,proto3" json:"task_count,omitempty"`
	// Max number of tasks that can run in parallel.
	// Default to min(task_count, 1000).
	Parallelism int64 `protobuf:"varint,5,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// Scheduling policy for Tasks in the TaskGroup.
	SchedulingPolicy TaskGroup_SchedulingPolicy `protobuf:"varint,6,opt,name=scheduling_policy,json=schedulingPolicy,proto3,enum=google.cloud.batch.v1alpha1.TaskGroup_SchedulingPolicy" json:"scheduling_policy,omitempty"`
	// Compute resource allocation for the TaskGroup.
	// If specified, it overrides resources in Job.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,7,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Labels for the TaskGroup.
	// Labels could be user provided or system generated.
	// You can assign up to 64 labels.  [Google Compute Engine label
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// apply.
	// Label names that start with "goog-" or "google-" are reserved.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An array of environment variable mappings, which are passed to Tasks with
	// matching indices. If task_environments is used then task_count should
	// not be specified in the request (and will be ignored). Task count will be
	// the length of task_environments.
	//
	// Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
	// addition to any environment variables set in task_environments, specifying
	// the number of Tasks in the Task's parent TaskGroup, and the specific Task's
	// index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
	//
	// task_environments supports up to 200 entries.
	TaskEnvironments []*TaskGroup_Environment `protobuf:"bytes,9,rep,name=task_environments,json=taskEnvironments,proto3" json:"task_environments,omitempty"`
	// Max number of tasks that can be run on a node
	// at the same time. Default is 1.
	TaskCountPerNode int64 `protobuf:"varint,10,opt,name=task_count_per_node,json=taskCountPerNode,proto3" json:"task_count_per_node,omitempty"`
	// When true, Batch will populate a file with a list of all VMs assigned to
	// the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
	// of that file. Defaults to false.
	RequireHostsFile bool `protobuf:"varint,11,opt,name=require_hosts_file,json=requireHostsFile,proto3" json:"require_hosts_file,omitempty"`
}

func (x *TaskGroup) Reset() {
	*x = TaskGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskGroup) ProtoMessage() {}

func (x *TaskGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskGroup.ProtoReflect.Descriptor instead.
func (*TaskGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{6}
}

func (x *TaskGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TaskGroup) GetTaskSpec() *TaskSpec {
	if x != nil {
		return x.TaskSpec
	}
	return nil
}

func (x *TaskGroup) GetTaskCount() int64 {
	if x != nil {
		return x.TaskCount
	}
	return 0
}

func (x *TaskGroup) GetParallelism() int64 {
	if x != nil {
		return x.Parallelism
	}
	return 0
}

func (x *TaskGroup) GetSchedulingPolicy() TaskGroup_SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return TaskGroup_SCHEDULING_POLICY_UNSPECIFIED
}

func (x *TaskGroup) GetAllocationPolicy() *AllocationPolicy {
	if x != nil {
		return x.AllocationPolicy
	}
	return nil
}

func (x *TaskGroup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TaskGroup) GetTaskEnvironments() []*TaskGroup_Environment {
	if x != nil {
		return x.TaskEnvironments
	}
	return nil
}

func (x *TaskGroup) GetTaskCountPerNode() int64 {
	if x != nil {
		return x.TaskCountPerNode
	}
	return 0
}

func (x *TaskGroup) GetRequireHostsFile() bool {
	if x != nil {
		return x.RequireHostsFile
	}
	return false
}

// Aggregated task status for a TaskGroup.
type JobStatus_TaskGroupStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of task in each state in the TaskGroup.
	// The map key is task state name.
	Counts map[string]int64 `protobuf:"bytes,1,rep,name=counts,proto3" json:"counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *JobStatus_TaskGroupStatus) Reset() {
	*x = JobStatus_TaskGroupStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus_TaskGroupStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus_TaskGroupStatus) ProtoMessage() {}

func (x *JobStatus_TaskGroupStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus_TaskGroupStatus.ProtoReflect.Descriptor instead.
func (*JobStatus_TaskGroupStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{3, 0}
}

func (x *JobStatus_TaskGroupStatus) GetCounts() map[string]int64 {
	if x != nil {
		return x.Counts
	}
	return nil
}

// Be consistent with LocationPolicy in
// //cloud/cluster/api/mixter_instances.proto.
type AllocationPolicy_LocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of allowed location names represented by internal URLs,
	// for example, zones/us-central1-a, regions/us-west1.
	// First location in the list should be a region.
	AllowedLocations []string `protobuf:"bytes,1,rep,name=allowed_locations,json=allowedLocations,proto3" json:"allowed_locations,omitempty"`
	// A list of denied location names.
	DeniedLocations []string `protobuf:"bytes,2,rep,name=denied_locations,json=deniedLocations,proto3" json:"denied_locations,omitempty"`
}

func (x *AllocationPolicy_LocationPolicy) Reset() {
	*x = AllocationPolicy_LocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_LocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_LocationPolicy) ProtoMessage() {}

func (x *AllocationPolicy_LocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_LocationPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_LocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AllocationPolicy_LocationPolicy) GetAllowedLocations() []string {
	if x != nil {
		return x.AllowedLocations
	}
	return nil
}

func (x *AllocationPolicy_LocationPolicy) GetDeniedLocations() []string {
	if x != nil {
		return x.DeniedLocations
	}
	return nil
}

// InstancePolicy describes what instances should be created for the Job.
type AllocationPolicy_InstancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of allowed Compute Engine machine types, for example,
	// e2-standard-4. Default is empty which means allowing all.
	AllowedMachineTypes []string `protobuf:"bytes,1,rep,name=allowed_machine_types,json=allowedMachineTypes,proto3" json:"allowed_machine_types,omitempty"`
	// A list of denied Compute Engine machine types.
	// Default is empty which means denying none.
	// A machine type is allowed if it matches 'allowed_machine_types' AND
	// does not match 'denied_machine_types'.
	// For example,
	//   allowed_machine_types = "e2-standard"
	//   denied_machine_types = "e2-standard-2, e2-standard-4"
	// means using all E2 standard machine types except for 'e2-standard-2' and
	// 'e2-standard-4.
	//
	// [NotImplemented]
	DeniedMachineTypes []string `protobuf:"bytes,2,rep,name=denied_machine_types,json=deniedMachineTypes,proto3" json:"denied_machine_types,omitempty"`
	// A list of allowed CPU platforms, for example,
	// "Intel Cascade Lake", "AMD Rome".
	// Default is empty which means allowing all.
	//
	// [NotImplemented]
	AllowedCpuPlatforms []string `protobuf:"bytes,3,rep,name=allowed_cpu_platforms,json=allowedCpuPlatforms,proto3" json:"allowed_cpu_platforms,omitempty"`
	// A list of denied CPU platforms.
	// Default is empty which means denying none.
	// A CPU platform is allowed if it matches 'allowed_cpu_platforms' AND
	// does not match 'denied_cpu_platforms'.
	// If a CPU platform belongs to both lists, it will be denied.
	//
	// [NotImplemented]
	DeniedCpuPlatforms []string `protobuf:"bytes,4,rep,name=denied_cpu_platforms,json=deniedCpuPlatforms,proto3" json:"denied_cpu_platforms,omitempty"`
	// A list of allowed accelerator types (GPU models), for example,
	// "nvidia-tesla-t4". Default is empty which means allowing all.
	//
	// [NotImplemented]
	AllowedAcceleratorTypes []string `protobuf:"bytes,5,rep,name=allowed_accelerator_types,json=allowedAcceleratorTypes,proto3" json:"allowed_accelerator_types,omitempty"`
	// A list of denied accelerator types (GPU models).
	// Default is empty which means denying none.
	// A accelerator type is allowed if it matches 'allowed_accelerator_types'
	// AND does not match 'denied__accelerator_types'.
	//
	// [NotImplemented]
	DeniedAcceleratorTypes []string `protobuf:"bytes,6,rep,name=denied_accelerator_types,json=deniedAcceleratorTypes,proto3" json:"denied_accelerator_types,omitempty"`
	// The number of accelerators per VM instance.
	//
	// [NotImplemented]
	AcceleratorCount int64 `protobuf:"varint,7,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
}

func (x *AllocationPolicy_InstancePolicy) Reset() {
	*x = AllocationPolicy_InstancePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_InstancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_InstancePolicy) ProtoMessage() {}

func (x *AllocationPolicy_InstancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_InstancePolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_InstancePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{5, 1}
}

func (x *AllocationPolicy_InstancePolicy) GetAllowedMachineTypes() []string {
	if x != nil {
		return x.AllowedMachineTypes
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetDeniedMachineTypes() []string {
	if x != nil {
		return x.DeniedMachineTypes
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetAllowedCpuPlatforms() []string {
	if x != nil {
		return x.AllowedCpuPlatforms
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetDeniedCpuPlatforms() []string {
	if x != nil {
		return x.DeniedCpuPlatforms
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetAllowedAcceleratorTypes() []string {
	if x != nil {
		return x.AllowedAcceleratorTypes
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetDeniedAcceleratorTypes() []string {
	if x != nil {
		return x.DeniedAcceleratorTypes
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetAcceleratorCount() int64 {
	if x != nil {
		return x.AcceleratorCount
	}
	return 0
}

// A network interface.
type AllocationPolicy_NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of the network resource.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// The URL of the Subnetwork resource.
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Default is false (with an external IP address). Required if
	// no external public IP address is attached to the VM. If no external
	// public IP address, additional configuration is required to allow the VM
	// to access Google Services. See
	// https://cloud.google.com/vpc/docs/configure-private-google-access and
	// https://cloud.google.com/nat/docs/gce-example#create-nat for more
	// information.
	NoExternalIpAddress bool `protobuf:"varint,3,opt,name=no_external_ip_address,json=noExternalIpAddress,proto3" json:"no_external_ip_address,omitempty"`
}

func (x *AllocationPolicy_NetworkInterface) Reset() {
	*x = AllocationPolicy_NetworkInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_NetworkInterface) ProtoMessage() {}

func (x *AllocationPolicy_NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_NetworkInterface.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{5, 2}
}

func (x *AllocationPolicy_NetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *AllocationPolicy_NetworkInterface) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *AllocationPolicy_NetworkInterface) GetNoExternalIpAddress() bool {
	if x != nil {
		return x.NoExternalIpAddress
	}
	return false
}

// NetworkPolicy describes network configurations for instances created
// for the job.
type AllocationPolicy_NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network configurations.
	NetworkInterfaces []*AllocationPolicy_NetworkInterface `protobuf:"bytes,1,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
}

func (x *AllocationPolicy_NetworkPolicy) Reset() {
	*x = AllocationPolicy_NetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_NetworkPolicy) ProtoMessage() {}

func (x *AllocationPolicy_NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_NetworkPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{5, 3}
}

func (x *AllocationPolicy_NetworkPolicy) GetNetworkInterfaces() []*AllocationPolicy_NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

// TaskGroup.Environment is a workaround for proto3 not supporting
// repeated map<string, string>.
type TaskGroup_Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An map of environment variable names to values.
	// The map may contain at most 10 key/value pairs with keys length up to
	// 64 characters and values up to 4 KB.
	Variables map[string]string `protobuf:"bytes,1,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TaskGroup_Environment) Reset() {
	*x = TaskGroup_Environment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskGroup_Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskGroup_Environment) ProtoMessage() {}

func (x *TaskGroup_Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_job_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskGroup_Environment.ProtoReflect.Descriptor instead.
func (*TaskGroup_Environment) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP(), []int{6, 0}
}

func (x *TaskGroup_Environment) GetVariables() map[string]string {
	if x != nil {
		return x.Variables
	}
	return nil
}

var File_google_cloud_batch_v1alpha1_job_proto protoreflect.FileDescriptor

var file_google_cloud_batch_v1alpha1_job_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x6a, 0x6f,
	0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x74, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x08, 0x0a, 0x03, 0x4a, 0x6f,
	0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4c, 0x0a, 0x0b, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x61, 0x73, 0x6b,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4e, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x44, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x50, 0x0a,
	0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x6c, 0x6f, 0x67,
	0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x67,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4e,
	0x0a, 0x10, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x49, 0x4e, 0x47,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x53, 0x5f, 0x53, 0x4f, 0x4f, 0x4e,
	0x5f, 0x41, 0x53, 0x5f, 0x50, 0x4f, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x3a, 0x51,
	0xea, 0x41, 0x4e, 0x0a, 0x18, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62,
	0x7d, 0x22, 0xc9, 0x01, 0x0a, 0x0a, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x55, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x73, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x73,
	0x50, 0x61, 0x74, 0x68, 0x22, 0x47, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4c, 0x4f, 0x47, 0x47, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x41, 0x54, 0x48, 0x10, 0x02, 0x22, 0x8e, 0x02,
	0x0a, 0x0d, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x4b, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x69, 0x0a, 0x0a,
	0x49, 0x74, 0x65, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x45, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x03, 0x22, 0xd4,
	0x05, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x42, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x57, 0x0a, 0x0b, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54, 0x61, 0x73,
	0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x74, 0x61,
	0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x72, 0x75, 0x6e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa8, 0x01, 0x0a, 0x0f, 0x54, 0x61, 0x73, 0x6b, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5a, 0x0a, 0x06, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x75, 0x0a, 0x0f, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55, 0x45, 0x55,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x06, 0x22, 0x34, 0x0a, 0x0f, 0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0xc7, 0x0b, 0x0a, 0x10,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x58, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x70, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x51,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x55, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x68, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x6e, 0x69, 0x65,
	0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xff, 0x02, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x65, 0x6e,
	0x69, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x4d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12,
	0x30, 0x0a, 0x14, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x64,
	0x65, 0x6e, 0x69, 0x65, 0x64, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x73, 0x12, 0x3a, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x38, 0x0a,
	0x18, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x16, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x81, 0x01, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x33, 0x0a, 0x16, 0x6e, 0x6f, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x13, 0x6e, 0x6f, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49,
	0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x7e, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6d, 0x0a, 0x12, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x50,
	0x4f, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54, 0x49,
	0x42, 0x4c, 0x45, 0x10, 0x03, 0x22, 0xa5, 0x08, 0x0a, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x09,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x73,
	0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c,
	0x69, 0x73, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c,
	0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x12, 0x64, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5a, 0x0a, 0x11,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2d, 0x0a, 0x13, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72,
	0x4e, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x46, 0x69,
	0x6c, 0x65, 0x1a, 0xac, 0x01, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x1a, 0x3c, 0x0a, 0x0e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4e, 0x0a, 0x10,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x21, 0x0a, 0x1d, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x50,
	0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x53, 0x5f, 0x53, 0x4f, 0x4f, 0x4e, 0x5f, 0x41,
	0x53, 0x5f, 0x50, 0x4f, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x3a, 0x6f, 0xea, 0x41,
	0x6c, 0x0a, 0x1e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f,
	0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x7b, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x42, 0x75, 0x0a,
	0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x42, 0x08, 0x4a, 0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x62, 0x61, 0x74, 0x63, 0x68, 0xa2, 0x02,
	0x03, 0x47, 0x43, 0x42, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_batch_v1alpha1_job_proto_rawDescOnce sync.Once
	file_google_cloud_batch_v1alpha1_job_proto_rawDescData = file_google_cloud_batch_v1alpha1_job_proto_rawDesc
)

func file_google_cloud_batch_v1alpha1_job_proto_rawDescGZIP() []byte {
	file_google_cloud_batch_v1alpha1_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_batch_v1alpha1_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_batch_v1alpha1_job_proto_rawDescData)
	})
	return file_google_cloud_batch_v1alpha1_job_proto_rawDescData
}

var file_google_cloud_batch_v1alpha1_job_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_batch_v1alpha1_job_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_batch_v1alpha1_job_proto_goTypes = []interface{}{
	(Job_SchedulingPolicy)(0),               // 0: google.cloud.batch.v1alpha1.Job.SchedulingPolicy
	(LogsPolicy_Destination)(0),             // 1: google.cloud.batch.v1alpha1.LogsPolicy.Destination
	(JobDependency_Type)(0),                 // 2: google.cloud.batch.v1alpha1.JobDependency.Type
	(JobStatus_State)(0),                    // 3: google.cloud.batch.v1alpha1.JobStatus.State
	(AllocationPolicy_ProvisioningModel)(0), // 4: google.cloud.batch.v1alpha1.AllocationPolicy.ProvisioningModel
	(TaskGroup_SchedulingPolicy)(0),         // 5: google.cloud.batch.v1alpha1.TaskGroup.SchedulingPolicy
	(*Job)(nil),                             // 6: google.cloud.batch.v1alpha1.Job
	(*LogsPolicy)(nil),                      // 7: google.cloud.batch.v1alpha1.LogsPolicy
	(*JobDependency)(nil),                   // 8: google.cloud.batch.v1alpha1.JobDependency
	(*JobStatus)(nil),                       // 9: google.cloud.batch.v1alpha1.JobStatus
	(*JobNotification)(nil),                 // 10: google.cloud.batch.v1alpha1.JobNotification
	(*AllocationPolicy)(nil),                // 11: google.cloud.batch.v1alpha1.AllocationPolicy
	(*TaskGroup)(nil),                       // 12: google.cloud.batch.v1alpha1.TaskGroup
	nil,                                     // 13: google.cloud.batch.v1alpha1.Job.LabelsEntry
	nil,                                     // 14: google.cloud.batch.v1alpha1.JobDependency.ItemsEntry
	(*JobStatus_TaskGroupStatus)(nil),       // 15: google.cloud.batch.v1alpha1.JobStatus.TaskGroupStatus
	nil,                                     // 16: google.cloud.batch.v1alpha1.JobStatus.TaskGroupsEntry
	nil,                                     // 17: google.cloud.batch.v1alpha1.JobStatus.TaskGroupStatus.CountsEntry
	(*AllocationPolicy_LocationPolicy)(nil), // 18: google.cloud.batch.v1alpha1.AllocationPolicy.LocationPolicy
	(*AllocationPolicy_InstancePolicy)(nil), // 19: google.cloud.batch.v1alpha1.AllocationPolicy.InstancePolicy
	(*AllocationPolicy_NetworkInterface)(nil), // 20: google.cloud.batch.v1alpha1.AllocationPolicy.NetworkInterface
	(*AllocationPolicy_NetworkPolicy)(nil),    // 21: google.cloud.batch.v1alpha1.AllocationPolicy.NetworkPolicy
	nil,                                       // 22: google.cloud.batch.v1alpha1.AllocationPolicy.LabelsEntry
	(*TaskGroup_Environment)(nil),             // 23: google.cloud.batch.v1alpha1.TaskGroup.Environment
	nil,                                       // 24: google.cloud.batch.v1alpha1.TaskGroup.LabelsEntry
	nil,                                       // 25: google.cloud.batch.v1alpha1.TaskGroup.Environment.VariablesEntry
	(*timestamppb.Timestamp)(nil),             // 26: google.protobuf.Timestamp
	(*StatusEvent)(nil),                       // 27: google.cloud.batch.v1alpha1.StatusEvent
	(*durationpb.Duration)(nil),               // 28: google.protobuf.Duration
	(*TaskSpec)(nil),                          // 29: google.cloud.batch.v1alpha1.TaskSpec
}
var file_google_cloud_batch_v1alpha1_job_proto_depIdxs = []int32{
	12, // 0: google.cloud.batch.v1alpha1.Job.task_groups:type_name -> google.cloud.batch.v1alpha1.TaskGroup
	0,  // 1: google.cloud.batch.v1alpha1.Job.scheduling_policy:type_name -> google.cloud.batch.v1alpha1.Job.SchedulingPolicy
	8,  // 2: google.cloud.batch.v1alpha1.Job.dependencies:type_name -> google.cloud.batch.v1alpha1.JobDependency
	11, // 3: google.cloud.batch.v1alpha1.Job.allocation_policy:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy
	13, // 4: google.cloud.batch.v1alpha1.Job.labels:type_name -> google.cloud.batch.v1alpha1.Job.LabelsEntry
	9,  // 5: google.cloud.batch.v1alpha1.Job.status:type_name -> google.cloud.batch.v1alpha1.JobStatus
	10, // 6: google.cloud.batch.v1alpha1.Job.notification:type_name -> google.cloud.batch.v1alpha1.JobNotification
	26, // 7: google.cloud.batch.v1alpha1.Job.create_time:type_name -> google.protobuf.Timestamp
	26, // 8: google.cloud.batch.v1alpha1.Job.update_time:type_name -> google.protobuf.Timestamp
	7,  // 9: google.cloud.batch.v1alpha1.Job.logs_policy:type_name -> google.cloud.batch.v1alpha1.LogsPolicy
	1,  // 10: google.cloud.batch.v1alpha1.LogsPolicy.destination:type_name -> google.cloud.batch.v1alpha1.LogsPolicy.Destination
	14, // 11: google.cloud.batch.v1alpha1.JobDependency.items:type_name -> google.cloud.batch.v1alpha1.JobDependency.ItemsEntry
	3,  // 12: google.cloud.batch.v1alpha1.JobStatus.state:type_name -> google.cloud.batch.v1alpha1.JobStatus.State
	27, // 13: google.cloud.batch.v1alpha1.JobStatus.status_events:type_name -> google.cloud.batch.v1alpha1.StatusEvent
	16, // 14: google.cloud.batch.v1alpha1.JobStatus.task_groups:type_name -> google.cloud.batch.v1alpha1.JobStatus.TaskGroupsEntry
	28, // 15: google.cloud.batch.v1alpha1.JobStatus.run_duration:type_name -> google.protobuf.Duration
	18, // 16: google.cloud.batch.v1alpha1.AllocationPolicy.location:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy.LocationPolicy
	19, // 17: google.cloud.batch.v1alpha1.AllocationPolicy.instance:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy.InstancePolicy
	4,  // 18: google.cloud.batch.v1alpha1.AllocationPolicy.provisioning_models:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy.ProvisioningModel
	22, // 19: google.cloud.batch.v1alpha1.AllocationPolicy.labels:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy.LabelsEntry
	21, // 20: google.cloud.batch.v1alpha1.AllocationPolicy.network:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy.NetworkPolicy
	29, // 21: google.cloud.batch.v1alpha1.TaskGroup.task_spec:type_name -> google.cloud.batch.v1alpha1.TaskSpec
	5,  // 22: google.cloud.batch.v1alpha1.TaskGroup.scheduling_policy:type_name -> google.cloud.batch.v1alpha1.TaskGroup.SchedulingPolicy
	11, // 23: google.cloud.batch.v1alpha1.TaskGroup.allocation_policy:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy
	24, // 24: google.cloud.batch.v1alpha1.TaskGroup.labels:type_name -> google.cloud.batch.v1alpha1.TaskGroup.LabelsEntry
	23, // 25: google.cloud.batch.v1alpha1.TaskGroup.task_environments:type_name -> google.cloud.batch.v1alpha1.TaskGroup.Environment
	2,  // 26: google.cloud.batch.v1alpha1.JobDependency.ItemsEntry.value:type_name -> google.cloud.batch.v1alpha1.JobDependency.Type
	17, // 27: google.cloud.batch.v1alpha1.JobStatus.TaskGroupStatus.counts:type_name -> google.cloud.batch.v1alpha1.JobStatus.TaskGroupStatus.CountsEntry
	15, // 28: google.cloud.batch.v1alpha1.JobStatus.TaskGroupsEntry.value:type_name -> google.cloud.batch.v1alpha1.JobStatus.TaskGroupStatus
	20, // 29: google.cloud.batch.v1alpha1.AllocationPolicy.NetworkPolicy.network_interfaces:type_name -> google.cloud.batch.v1alpha1.AllocationPolicy.NetworkInterface
	25, // 30: google.cloud.batch.v1alpha1.TaskGroup.Environment.variables:type_name -> google.cloud.batch.v1alpha1.TaskGroup.Environment.VariablesEntry
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_cloud_batch_v1alpha1_job_proto_init() }
func file_google_cloud_batch_v1alpha1_job_proto_init() {
	if File_google_cloud_batch_v1alpha1_job_proto != nil {
		return
	}
	file_google_cloud_batch_v1alpha1_task_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogsPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobDependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobNotification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatus_TaskGroupStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_LocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_InstancePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_NetworkInterface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_NetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_job_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskGroup_Environment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_batch_v1alpha1_job_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_batch_v1alpha1_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_batch_v1alpha1_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_batch_v1alpha1_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_batch_v1alpha1_job_proto_msgTypes,
	}.Build()
	File_google_cloud_batch_v1alpha1_job_proto = out.File
	file_google_cloud_batch_v1alpha1_job_proto_rawDesc = nil
	file_google_cloud_batch_v1alpha1_job_proto_goTypes = nil
	file_google_cloud_batch_v1alpha1_job_proto_depIdxs = nil
}
