// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package realtimebidding provides access to the Real-time Bidding API.
//
// For product documentation, see: https://developers.google.com/authorized-buyers/apis/realtimebidding/reference/rest/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/realtimebidding/v1"
//	...
//	ctx := context.Background()
//	realtimebiddingService, err := realtimebidding.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	realtimebiddingService, err := realtimebidding.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	realtimebiddingService, err := realtimebidding.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package realtimebidding // import "google.golang.org/api/realtimebidding/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "realtimebidding:v1"
const apiName = "realtimebidding"
const apiVersion = "v1"
const basePath = "https://realtimebidding.googleapis.com/"
const basePathTemplate = "https://realtimebidding.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://realtimebidding.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, create, edit, and delete your Authorized Buyers and Open Bidding
	// account entities
	RealtimeBiddingScope = "https://www.googleapis.com/auth/realtime-bidding"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/realtime-bidding",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Bidders = NewBiddersService(s)
	s.Buyers = NewBuyersService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Bidders *BiddersService

	Buyers *BuyersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBiddersService(s *Service) *BiddersService {
	rs := &BiddersService{s: s}
	rs.Creatives = NewBiddersCreativesService(s)
	rs.Endpoints = NewBiddersEndpointsService(s)
	rs.PretargetingConfigs = NewBiddersPretargetingConfigsService(s)
	rs.PublisherConnections = NewBiddersPublisherConnectionsService(s)
	return rs
}

type BiddersService struct {
	s *Service

	Creatives *BiddersCreativesService

	Endpoints *BiddersEndpointsService

	PretargetingConfigs *BiddersPretargetingConfigsService

	PublisherConnections *BiddersPublisherConnectionsService
}

func NewBiddersCreativesService(s *Service) *BiddersCreativesService {
	rs := &BiddersCreativesService{s: s}
	return rs
}

type BiddersCreativesService struct {
	s *Service
}

func NewBiddersEndpointsService(s *Service) *BiddersEndpointsService {
	rs := &BiddersEndpointsService{s: s}
	return rs
}

type BiddersEndpointsService struct {
	s *Service
}

func NewBiddersPretargetingConfigsService(s *Service) *BiddersPretargetingConfigsService {
	rs := &BiddersPretargetingConfigsService{s: s}
	return rs
}

type BiddersPretargetingConfigsService struct {
	s *Service
}

func NewBiddersPublisherConnectionsService(s *Service) *BiddersPublisherConnectionsService {
	rs := &BiddersPublisherConnectionsService{s: s}
	return rs
}

type BiddersPublisherConnectionsService struct {
	s *Service
}

func NewBuyersService(s *Service) *BuyersService {
	rs := &BuyersService{s: s}
	rs.Creatives = NewBuyersCreativesService(s)
	rs.UserLists = NewBuyersUserListsService(s)
	return rs
}

type BuyersService struct {
	s *Service

	Creatives *BuyersCreativesService

	UserLists *BuyersUserListsService
}

func NewBuyersCreativesService(s *Service) *BuyersCreativesService {
	rs := &BuyersCreativesService{s: s}
	return rs
}

type BuyersCreativesService struct {
	s *Service
}

func NewBuyersUserListsService(s *Service) *BuyersUserListsService {
	rs := &BuyersUserListsService{s: s}
	return rs
}

type BuyersUserListsService struct {
	s *Service
}

// ActivatePretargetingConfigRequest: A request to activate a pretargeting
// configuration. Sets the configuration's state to ACTIVE.
type ActivatePretargetingConfigRequest struct {
}

// AdTechnologyProviders: The list of detected Ad Technology Providers for this
// creative. Bids placed for inventory that will serve to EEA or UK users are
// expected to comply with GDPR requirements. You must ensure that the
// creatives used in such bids should contain only user consented ad technology
// providers as indicated in the bid request. Google reserves the right to
// filter non-compliant bids. User consented ad technology providers can be
// found in the Google Protocol
// (https://developers.google.com/authorized-buyers/rtb/downloads/realtime-bidding-proto)
// with the `BidRequest.adslot.consented_providers_settings` field, and can be
// found as an OpenRTB extension
// (https://developers.google.com/authorized-buyers/rtb/downloads/openrtb-adx-proto)
// with the `BidRequest.user.ext.consented_providers_settings` and
// `BidRequest.user.ext.consent` fields. See
// https://support.google.com/authorizedbuyers/answer/9789378 for additional
// information about the Google TCF v2 integration.
type AdTechnologyProviders struct {
	// DetectedGvlIds: The detected IAB Global Vendor List (GVL) IDs for this
	// creative. See the IAB Global Vendor List at
	// https://vendor-list.consensu.org/v2/vendor-list.json for details about the
	// vendors.
	DetectedGvlIds googleapi.Int64s `json:"detectedGvlIds,omitempty"`
	// DetectedProviderIds: The detected Google Ad Tech Providers (ATP)
	// (https://support.google.com/admanager/answer/9012903) for this creative. See
	// https://storage.googleapis.com/adx-rtb-dictionaries/providers.csv for
	// mapping of provider ID to provided name, a privacy policy URL, and a list of
	// domains which can be attributed to the provider.
	DetectedProviderIds googleapi.Int64s `json:"detectedProviderIds,omitempty"`
	// UnidentifiedProviderDomains: Domains of detected unidentified ad technology
	// providers (if any). You must ensure that the creatives used in bids placed
	// for inventory that will serve to EEA or UK users does not contain
	// unidentified ad technology providers. Google reserves the right to filter
	// non-compliant bids.
	UnidentifiedProviderDomains []string `json:"unidentifiedProviderDomains,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedGvlIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedGvlIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdTechnologyProviders) MarshalJSON() ([]byte, error) {
	type NoMethod AdTechnologyProviders
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddTargetedAppsRequest: A request to start targeting the provided app IDs in
// a specific pretargeting configuration. The pretargeting configuration itself
// specifies how these apps are targeted. in
// PretargetingConfig.appTargeting.mobileAppTargeting.
type AddTargetedAppsRequest struct {
	// AppIds: A list of app IDs to target in the pretargeting configuration. These
	// values will be added to the list of targeted app IDs in
	// PretargetingConfig.appTargeting.mobileAppTargeting.values.
	AppIds []string `json:"appIds,omitempty"`
	// TargetingMode: Required. The targeting mode that should be applied to the
	// list of app IDs. If there are existing targeted app IDs, must be equal to
	// the existing
	// PretargetingConfig.appTargeting.mobileAppTargeting.targetingMode or a 400
	// bad request error will be returned.
	//
	// Possible values:
	//   "TARGETING_MODE_UNSPECIFIED" - Placeholder for undefined targeting mode.
	//   "INCLUSIVE" - The inclusive list type. Inventory must match an item in
	// this list to be targeted.
	//   "EXCLUSIVE" - The exclusive list type. Inventory must not match any item
	// in this list to be targeted.
	TargetingMode string `json:"targetingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppIds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddTargetedAppsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddTargetedAppsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddTargetedPublishersRequest: A request to start targeting the provided
// publishers in a specific pretargeting configuration. The pretargeting
// configuration itself specifies how these publishers are targeted in
// PretargetingConfig.publisherTargeting.
type AddTargetedPublishersRequest struct {
	// PublisherIds: A list of publisher IDs to target in the pretargeting
	// configuration. These values will be added to the list of targeted publisher
	// IDs in PretargetingConfig.publisherTargeting.values. Publishers are
	// identified by their publisher ID from ads.txt / app-ads.txt. See
	// https://iabtechlab.com/ads-txt/ and https://iabtechlab.com/app-ads-txt/ for
	// more details.
	PublisherIds []string `json:"publisherIds,omitempty"`
	// TargetingMode: Required. The targeting mode that should be applied to the
	// list of publisher IDs. If are existing publisher IDs, must be equal to the
	// existing PretargetingConfig.publisherTargeting.targetingMode or a 400 bad
	// request error will be returned.
	//
	// Possible values:
	//   "TARGETING_MODE_UNSPECIFIED" - Placeholder for undefined targeting mode.
	//   "INCLUSIVE" - The inclusive list type. Inventory must match an item in
	// this list to be targeted.
	//   "EXCLUSIVE" - The exclusive list type. Inventory must not match any item
	// in this list to be targeted.
	TargetingMode string `json:"targetingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublisherIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublisherIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddTargetedPublishersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddTargetedPublishersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddTargetedSitesRequest: A request to start targeting the provided sites in
// a specific pretargeting configuration. The pretargeting configuration itself
// specifies how these sites are targeted in PretargetingConfig.webTargeting.
type AddTargetedSitesRequest struct {
	// Sites: A list of site URLs to target in the pretargeting configuration.
	// These values will be added to the list of targeted URLs in
	// PretargetingConfig.webTargeting.values.
	Sites []string `json:"sites,omitempty"`
	// TargetingMode: Required. The targeting mode that should be applied to the
	// list of site URLs. If there are existing targeted sites, must be equal to
	// the existing PretargetingConfig.webTargeting.targetingMode or a 400 bad
	// request error will be returned.
	//
	// Possible values:
	//   "TARGETING_MODE_UNSPECIFIED" - Placeholder for undefined targeting mode.
	//   "INCLUSIVE" - The inclusive list type. Inventory must match an item in
	// this list to be targeted.
	//   "EXCLUSIVE" - The exclusive list type. Inventory must not match any item
	// in this list to be targeted.
	TargetingMode string `json:"targetingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sites") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddTargetedSitesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddTargetedSitesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdvertiserAndBrand: Detected advertiser and brand information.
type AdvertiserAndBrand struct {
	// AdvertiserId: See
	// https://storage.googleapis.com/adx-rtb-dictionaries/advertisers.txt for the
	// list of possible values. Can be used to filter the response of the
	// creatives.list method.
	AdvertiserId int64 `json:"advertiserId,omitempty,string"`
	// AdvertiserName: Advertiser name. Can be used to filter the response of the
	// creatives.list method.
	AdvertiserName string `json:"advertiserName,omitempty"`
	// BrandId: Detected brand ID or zero if no brand has been detected. See
	// https://storage.googleapis.com/adx-rtb-dictionaries/brands.txt for the list
	// of possible values. Can be used to filter the response of the creatives.list
	// method.
	BrandId int64 `json:"brandId,omitempty,string"`
	// BrandName: Brand name. Can be used to filter the response of the
	// creatives.list method.
	BrandName string `json:"brandName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvertiserId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvertiserId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdvertiserAndBrand) MarshalJSON() ([]byte, error) {
	type NoMethod AdvertiserAndBrand
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppTargeting: A subset of app inventory to target. Bid requests that match
// criteria in at least one of the specified dimensions will be sent.
type AppTargeting struct {
	// MobileAppCategoryTargeting: Lists of included and excluded mobile app
	// categories as defined in
	// https://developers.google.com/adwords/api/docs/appendix/mobileappcategories.csv.
	MobileAppCategoryTargeting *NumericTargetingDimension `json:"mobileAppCategoryTargeting,omitempty"`
	// MobileAppTargeting: Targeted app IDs. App IDs can refer to those found in an
	// app store or ones that are not published in an app store. A maximum of
	// 30,000 app IDs can be targeted.
	MobileAppTargeting *StringTargetingDimension `json:"mobileAppTargeting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MobileAppCategoryTargeting")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MobileAppCategoryTargeting") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod AppTargeting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchApprovePublisherConnectionsRequest: A request to approve a batch of
// publisher connections.
type BatchApprovePublisherConnectionsRequest struct {
	// Names: Required. The names of the publishers with which connections will be
	// approved. In the pattern `bidders/{bidder}/publisherConnections/{publisher}`
	// where `{bidder}` is the account ID of the bidder, and `{publisher}` is the
	// ads.txt/app-ads.txt publisher ID.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchApprovePublisherConnectionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchApprovePublisherConnectionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchApprovePublisherConnectionsResponse: A response for the request to
// approve a batch of publisher connections.
type BatchApprovePublisherConnectionsResponse struct {
	// PublisherConnections: The publisher connections that have been approved.
	PublisherConnections []*PublisherConnection `json:"publisherConnections,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PublisherConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublisherConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchApprovePublisherConnectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchApprovePublisherConnectionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchRejectPublisherConnectionsRequest: A request to reject a batch of
// publisher connections.
type BatchRejectPublisherConnectionsRequest struct {
	// Names: Required. The names of the publishers with whom connection will be
	// rejected. In the pattern `bidders/{bidder}/publisherConnections/{publisher}`
	// where `{bidder}` is the account ID of the bidder, and `{publisher}` is the
	// ads.txt/app-ads.txt publisher ID.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchRejectPublisherConnectionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchRejectPublisherConnectionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchRejectPublisherConnectionsResponse: A response for the request to
// reject a batch of publisher connections.
type BatchRejectPublisherConnectionsResponse struct {
	// PublisherConnections: The publisher connections that have been rejected.
	PublisherConnections []*PublisherConnection `json:"publisherConnections,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PublisherConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublisherConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchRejectPublisherConnectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchRejectPublisherConnectionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Bidder: Bidder settings.
type Bidder struct {
	// BypassNonguaranteedDealsPretargeting: Output only. An option to bypass
	// pretargeting for private auctions and preferred deals. When true, bid
	// requests from these nonguaranteed deals will always be sent. When false, bid
	// requests will be subject to regular pretargeting configurations.
	// Programmatic Guaranteed deals will always be sent to the bidder, regardless
	// of the value for this option. Auction packages are not impacted by this
	// value and are subject to the regular pretargeting configurations.
	BypassNonguaranteedDealsPretargeting bool `json:"bypassNonguaranteedDealsPretargeting,omitempty"`
	// CookieMatchingNetworkId: Output only. The buyer's network ID used for cookie
	// matching. This ID corresponds to the `google_nid` parameter in the URL used
	// in cookie match requests. Refer to
	// https://developers.google.com/authorized-buyers/rtb/cookie-guide for further
	// information.
	CookieMatchingNetworkId string `json:"cookieMatchingNetworkId,omitempty"`
	// CookieMatchingUrl: Output only. The base URL used in cookie match requests.
	// Refer to https://developers.google.com/authorized-buyers/rtb/cookie-guide
	// for further information.
	CookieMatchingUrl string `json:"cookieMatchingUrl,omitempty"`
	// DealsBillingId: Output only. The billing ID for the deals pretargeting
	// config. This billing ID is sent on the bid request for guaranteed and
	// nonguaranteed deals matched in pretargeting.
	DealsBillingId string `json:"dealsBillingId,omitempty"`
	// Name: Output only. Name of the bidder resource that must follow the pattern
	// `bidders/{bidderAccountId}`, where `{bidderAccountId}` is the account ID of
	// the bidder whose information is to be received. One can get their account ID
	// on the Authorized Buyers or Open Bidding UI, or by contacting their Google
	// account manager.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "BypassNonguaranteedDealsPretargeting") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "BypassNonguaranteedDealsPretargeting") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s Bidder) MarshalJSON() ([]byte, error) {
	type NoMethod Bidder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Buyer: RTB Buyer account information.
type Buyer struct {
	// ActiveCreativeCount: Output only. The number of creatives that this buyer
	// submitted through the API or bid with in the last 30 days. This is counted
	// against the maximum number of active creatives.
	ActiveCreativeCount int64 `json:"activeCreativeCount,omitempty,string"`
	// Bidder: Output only. The name of the bidder resource that is responsible for
	// receiving bidding traffic for this account. The bidder name must follow the
	// pattern `bidders/{bidderAccountId}`, where `{bidderAccountId}` is the
	// account ID of the bidder receiving traffic for this buyer.
	Bidder string `json:"bidder,omitempty"`
	// BillingIds: Output only. A list of billing IDs associated with this account.
	// These IDs appear on: 1. A bid request, to signal which buyers are eligible
	// to bid on a given opportunity, and which pretargeting configurations were
	// matched for each eligible buyer. 2. The bid response, to attribute a winning
	// impression to a specific account for billing, reporting, policy and
	// publisher block enforcement.
	BillingIds []string `json:"billingIds,omitempty"`
	// DisplayName: Output only. The diplay name associated with this buyer
	// account, as visible to sellers.
	DisplayName string `json:"displayName,omitempty"`
	// MaximumActiveCreativeCount: Output only. The maximum number of active
	// creatives that this buyer can have.
	MaximumActiveCreativeCount int64 `json:"maximumActiveCreativeCount,omitempty,string"`
	// Name: Output only. Name of the buyer resource that must follow the pattern
	// `buyers/{buyerAccountId}`, where `{buyerAccountId}` is the account ID of the
	// buyer account whose information is to be received. One can get their account
	// ID on the Authorized Buyers or Open Bidding UI, or by contacting their
	// Google account manager.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveCreativeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveCreativeCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Buyer) MarshalJSON() ([]byte, error) {
	type NoMethod Buyer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloseUserListRequest: A request to close a specified user list.
type CloseUserListRequest struct {
}

// Creative: A creative and its classification data.
type Creative struct {
	// AccountId: Output only. ID of the buyer account that this creative is owned
	// by. Can be used to filter the response of the creatives.list method with
	// equality and inequality check.
	AccountId int64 `json:"accountId,omitempty,string"`
	// AdChoicesDestinationUrl: The link to AdChoices destination page. This is
	// only supported for native ads.
	AdChoicesDestinationUrl string `json:"adChoicesDestinationUrl,omitempty"`
	// AdvertiserName: The name of the company being advertised in the creative.
	// Can be used to filter the response of the creatives.list method.
	AdvertiserName string `json:"advertiserName,omitempty"`
	// AgencyId: The agency ID for this creative.
	AgencyId int64 `json:"agencyId,omitempty,string"`
	// ApiUpdateTime: Output only. The last update timestamp of the creative
	// through the API.
	ApiUpdateTime string `json:"apiUpdateTime,omitempty"`
	// CreativeFormat: Output only. The format of this creative. Can be used to
	// filter the response of the creatives.list method.
	//
	// Possible values:
	//   "CREATIVE_FORMAT_UNSPECIFIED" - The format is unknown.
	//   "HTML" - HTML creative.
	//   "VIDEO" - Video creative.
	//   "NATIVE" - Native creative.
	CreativeFormat string `json:"creativeFormat,omitempty"`
	// CreativeId: Buyer-specific creative ID that references this creative in bid
	// responses. This field is Ignored in update operations. Can be used to filter
	// the response of the creatives.list method. The maximum length of the
	// creative ID is 128 bytes.
	CreativeId string `json:"creativeId,omitempty"`
	// CreativeServingDecision: Output only. Top level status and detected
	// attributes of a creative (for example domain, language, advertiser, product
	// category, etc.) that affect whether (status) and where (context) a creative
	// will be allowed to serve.
	CreativeServingDecision *CreativeServingDecision `json:"creativeServingDecision,omitempty"`
	// DealIds: Output only. IDs of all of the deals with which this creative has
	// been used in bidding. Can be used to filter the response of the
	// creatives.list method.
	DealIds []string `json:"dealIds,omitempty"`
	// DeclaredAttributes: All declared attributes for the ads that may be shown
	// from this creative. Can be used to filter the response of the creatives.list
	// method. If the `excluded_attribute` field of a bid request
	// (https://developers.google.com/authorized-buyers/rtb/downloads/realtime-bidding-proto")
	// contains one of the attributes that were declared or detected for a given
	// creative, and a bid is submitted with that creative, the bid will be
	// filtered before the auction.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Do not use. This is a placeholder value only.
	//   "IMAGE_RICH_MEDIA" - The creative is of type image/rich media. For
	// pretargeting.
	//   "ADOBE_FLASH_FLV" - The creative is of video type Adobe Flash FLV. For
	// pretargeting.
	//   "IS_TAGGED" - The creative is tagged.
	//   "IS_COOKIE_TARGETED" - The creative is cookie targeted.
	//   "IS_USER_INTEREST_TARGETED" - The creative is user interest targeted.
	//   "EXPANDING_DIRECTION_NONE" - The creative does not expand.
	//   "EXPANDING_DIRECTION_UP" - The creative expands up.
	//   "EXPANDING_DIRECTION_DOWN" - The creative expands down.
	//   "EXPANDING_DIRECTION_LEFT" - The creative expands left.
	//   "EXPANDING_DIRECTION_RIGHT" - The creative expands right.
	//   "EXPANDING_DIRECTION_UP_LEFT" - The creative expands up and left.
	//   "EXPANDING_DIRECTION_UP_RIGHT" - The creative expands up and right.
	//   "EXPANDING_DIRECTION_DOWN_LEFT" - The creative expands down and left.
	//   "EXPANDING_DIRECTION_DOWN_RIGHT" - The creative expands down and right.
	//   "CREATIVE_TYPE_HTML" - The creative type is HTML.
	//   "CREATIVE_TYPE_VAST_VIDEO" - The creative type is VAST video.
	//   "EXPANDING_DIRECTION_UP_OR_DOWN" - The creative expands up or down.
	//   "EXPANDING_DIRECTION_LEFT_OR_RIGHT" - The creative expands left or right.
	//   "EXPANDING_DIRECTION_ANY_DIAGONAL" - The creative expands on any diagonal.
	//   "EXPANDING_ACTION_ROLLOVER_TO_EXPAND" - The creative expands when rolled
	// over.
	//   "INSTREAM_VAST_VIDEO_TYPE_VPAID_FLASH" - The instream vast video type is
	// vpaid flash.
	//   "RICH_MEDIA_CAPABILITY_TYPE_MRAID" - The creative is MRAID.
	//   "RICH_MEDIA_CAPABILITY_TYPE_FLASH" - The creative is Flash.
	//   "RICH_MEDIA_CAPABILITY_TYPE_HTML5" - The creative is HTML5.
	//   "SKIPPABLE_INSTREAM_VIDEO" - The creative has an instream VAST video type
	// of skippable instream video. For pretargeting.
	//   "RICH_MEDIA_CAPABILITY_TYPE_SSL" - The creative is SSL.
	//   "RICH_MEDIA_CAPABILITY_TYPE_NON_SSL" - The creative is non-SSL.
	//   "RICH_MEDIA_CAPABILITY_TYPE_INTERSTITIAL" - The creative is an
	// interstitial.
	//   "NON_SKIPPABLE_INSTREAM_VIDEO" - The creative has an instream VAST video
	// type of non-skippable instream video. For pretargeting.
	//   "NATIVE_ELIGIBILITY_ELIGIBLE" - The creative is eligible for native.
	//   "NON_VPAID" - The creative has an instream VAST video type of non-VPAID.
	// For pretargeting.
	//   "NATIVE_ELIGIBILITY_NOT_ELIGIBLE" - The creative is not eligible for
	// native.
	//   "ANY_INTERSTITIAL" - The creative has an interstitial size of any
	// interstitial. For pretargeting.
	//   "NON_INTERSTITIAL" - The creative has an interstitial size of non
	// interstitial. For pretargeting.
	//   "IN_BANNER_VIDEO" - The video type is in-banner video.
	//   "RENDERING_SIZELESS_ADX" - The creative can dynamically resize to fill a
	// variety of slot sizes.
	//   "OMSDK_1_0" - The open measurement SDK is supported.
	//   "RENDERING_PLAYABLE" - The creative is considered a playable display
	// creative.
	DeclaredAttributes []string `json:"declaredAttributes,omitempty"`
	// DeclaredClickThroughUrls: The set of declared destination URLs for the
	// creative. Can be used to filter the response of the creatives.list method.
	DeclaredClickThroughUrls []string `json:"declaredClickThroughUrls,omitempty"`
	// DeclaredRestrictedCategories: All declared restricted categories for the ads
	// that may be shown from this creative. Can be used to filter the response of
	// the creatives.list method.
	//
	// Possible values:
	//   "RESTRICTED_CATEGORY_UNSPECIFIED" - Default value that should never be
	// used.
	//   "ALCOHOL" - The alcohol restricted category.
	DeclaredRestrictedCategories []string `json:"declaredRestrictedCategories,omitempty"`
	// DeclaredVendorIds: IDs for the declared ad technology vendors that may be
	// used by this creative. See
	// https://storage.googleapis.com/adx-rtb-dictionaries/vendors.txt for possible
	// values. Can be used to filter the response of the creatives.list method.
	DeclaredVendorIds []int64 `json:"declaredVendorIds,omitempty"`
	// Html: An HTML creative.
	Html *HtmlContent `json:"html,omitempty"`
	// ImpressionTrackingUrls: The set of URLs to be called to record an
	// impression.
	ImpressionTrackingUrls []string `json:"impressionTrackingUrls,omitempty"`
	// Name: Output only. Name of the creative. Follows the pattern
	// `buyers/{buyer}/creatives/{creative}`, where `{buyer}` represents the
	// account ID of the buyer who owns the creative, and `{creative}` is the
	// buyer-specific creative ID that references this creative in the bid
	// response.
	Name string `json:"name,omitempty"`
	// Native: A native creative.
	Native *NativeContent `json:"native,omitempty"`
	// RenderUrl: Experimental field that can be used during the FLEDGE Origin
	// Trial (/authorized-buyers/rtb/fledge-origin-trial). The URL to fetch an
	// interest group ad used in TURTLEDOVE on-device auction
	// (https://github.com/WICG/turtledove/blob/main/FLEDGE.md#1-browsers-record-interest-groups").
	// This should be unique among all creatives for a given `accountId`. This URL
	// should be the same as the URL returned by generateBid()
	// (https://github.com/WICG/turtledove/blob/main/FLEDGE.md#32-on-device-bidding).
	RenderUrl string `json:"renderUrl,omitempty"`
	// RestrictedCategories: All restricted categories for the ads that may be
	// shown from this creative.
	//
	// Possible values:
	//   "RESTRICTED_CATEGORY_UNSPECIFIED" - Default value that should never be
	// used.
	//   "ALCOHOL" - The alcohol restricted category.
	RestrictedCategories []string `json:"restrictedCategories,omitempty"`
	// Version: Output only. The version of the creative. Version for a new
	// creative is 1 and it increments during subsequent creative updates.
	Version int64 `json:"version,omitempty"`
	// Video: A video creative.
	Video *VideoContent `json:"video,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Creative) MarshalJSON() ([]byte, error) {
	type NoMethod Creative
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreativeDimensions: The dimensions of a creative. This applies to only HTML
// and Native creatives.
type CreativeDimensions struct {
	// Height: The height of the creative in pixels.
	Height int64 `json:"height,omitempty,string"`
	// Width: The width of the creative in pixels.
	Width int64 `json:"width,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreativeDimensions) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeDimensions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreativeServingDecision: Top level status and detected attributes of a
// creative.
type CreativeServingDecision struct {
	// AdTechnologyProviders: The detected ad technology providers.
	AdTechnologyProviders *AdTechnologyProviders `json:"adTechnologyProviders,omitempty"`
	// ChinaPolicyCompliance: The policy compliance of this creative in China. When
	// approved or disapproved, this applies to both deals and open auction in
	// China. When pending review, this creative is allowed to serve for deals but
	// not for open auction.
	ChinaPolicyCompliance *PolicyCompliance `json:"chinaPolicyCompliance,omitempty"`
	// DealsPolicyCompliance: Policy compliance of this creative when bidding on
	// Programmatic Guaranteed and Preferred Deals (outside of Russia and China).
	DealsPolicyCompliance *PolicyCompliance `json:"dealsPolicyCompliance,omitempty"`
	// DetectedAdvertisers: Detected advertisers and brands.
	DetectedAdvertisers []*AdvertiserAndBrand `json:"detectedAdvertisers,omitempty"`
	// DetectedAttributes: Publisher-excludable attributes that were detected for
	// this creative. Can be used to filter the response of the creatives.list
	// method. If the `excluded_attribute` field of a bid request
	// (https://developers.google.com/authorized-buyers/rtb/downloads/realtime-bidding-proto)
	// contains one of the attributes that were declared or detected for a given
	// creative, and a bid is submitted with that creative, the bid will be
	// filtered before the auction.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Do not use. This is a placeholder value only.
	//   "IMAGE_RICH_MEDIA" - The creative is of type image/rich media. For
	// pretargeting.
	//   "ADOBE_FLASH_FLV" - The creative is of video type Adobe Flash FLV. For
	// pretargeting.
	//   "IS_TAGGED" - The creative is tagged.
	//   "IS_COOKIE_TARGETED" - The creative is cookie targeted.
	//   "IS_USER_INTEREST_TARGETED" - The creative is user interest targeted.
	//   "EXPANDING_DIRECTION_NONE" - The creative does not expand.
	//   "EXPANDING_DIRECTION_UP" - The creative expands up.
	//   "EXPANDING_DIRECTION_DOWN" - The creative expands down.
	//   "EXPANDING_DIRECTION_LEFT" - The creative expands left.
	//   "EXPANDING_DIRECTION_RIGHT" - The creative expands right.
	//   "EXPANDING_DIRECTION_UP_LEFT" - The creative expands up and left.
	//   "EXPANDING_DIRECTION_UP_RIGHT" - The creative expands up and right.
	//   "EXPANDING_DIRECTION_DOWN_LEFT" - The creative expands down and left.
	//   "EXPANDING_DIRECTION_DOWN_RIGHT" - The creative expands down and right.
	//   "CREATIVE_TYPE_HTML" - The creative type is HTML.
	//   "CREATIVE_TYPE_VAST_VIDEO" - The creative type is VAST video.
	//   "EXPANDING_DIRECTION_UP_OR_DOWN" - The creative expands up or down.
	//   "EXPANDING_DIRECTION_LEFT_OR_RIGHT" - The creative expands left or right.
	//   "EXPANDING_DIRECTION_ANY_DIAGONAL" - The creative expands on any diagonal.
	//   "EXPANDING_ACTION_ROLLOVER_TO_EXPAND" - The creative expands when rolled
	// over.
	//   "INSTREAM_VAST_VIDEO_TYPE_VPAID_FLASH" - The instream vast video type is
	// vpaid flash.
	//   "RICH_MEDIA_CAPABILITY_TYPE_MRAID" - The creative is MRAID.
	//   "RICH_MEDIA_CAPABILITY_TYPE_FLASH" - The creative is Flash.
	//   "RICH_MEDIA_CAPABILITY_TYPE_HTML5" - The creative is HTML5.
	//   "SKIPPABLE_INSTREAM_VIDEO" - The creative has an instream VAST video type
	// of skippable instream video. For pretargeting.
	//   "RICH_MEDIA_CAPABILITY_TYPE_SSL" - The creative is SSL.
	//   "RICH_MEDIA_CAPABILITY_TYPE_NON_SSL" - The creative is non-SSL.
	//   "RICH_MEDIA_CAPABILITY_TYPE_INTERSTITIAL" - The creative is an
	// interstitial.
	//   "NON_SKIPPABLE_INSTREAM_VIDEO" - The creative has an instream VAST video
	// type of non-skippable instream video. For pretargeting.
	//   "NATIVE_ELIGIBILITY_ELIGIBLE" - The creative is eligible for native.
	//   "NON_VPAID" - The creative has an instream VAST video type of non-VPAID.
	// For pretargeting.
	//   "NATIVE_ELIGIBILITY_NOT_ELIGIBLE" - The creative is not eligible for
	// native.
	//   "ANY_INTERSTITIAL" - The creative has an interstitial size of any
	// interstitial. For pretargeting.
	//   "NON_INTERSTITIAL" - The creative has an interstitial size of non
	// interstitial. For pretargeting.
	//   "IN_BANNER_VIDEO" - The video type is in-banner video.
	//   "RENDERING_SIZELESS_ADX" - The creative can dynamically resize to fill a
	// variety of slot sizes.
	//   "OMSDK_1_0" - The open measurement SDK is supported.
	//   "RENDERING_PLAYABLE" - The creative is considered a playable display
	// creative.
	DetectedAttributes []string `json:"detectedAttributes,omitempty"`
	// DetectedCategories: Output only. IDs of the detected categories. The
	// taxonomy in which the categories are expressed is specified by the
	// detected_categories_taxonomy field. Use this in conjunction with
	// BidRequest.bcat to avoid bidding on impressions where a given ad category is
	// blocked, or to troubleshoot filtered bids. Can be used to filter the
	// response of the creatives.list method.
	DetectedCategories []string `json:"detectedCategories,omitempty"`
	// DetectedCategoriesTaxonomy: Output only. The taxonomy in which the
	// detected_categories field is expressed.
	//
	// Possible values:
	//   "AD_CATEGORY_TAXONOMY_UNSPECIFIED" - Default value that should never be
	// used.
	//   "GOOGLE_AD_CATEGORY_TAXONOMY" - Google ad categories taxonomy, including
	// product categories and sensitive categories. Find the category lists at
	// https://developers.google.com/authorized-buyers/rtb/data#reference-data
	//   "IAB_CONTENT_1_0" - IAB Content Taxonomy 1.0. See
	// https://github.com/InteractiveAdvertisingBureau/Taxonomies/blob/main/Content%20Taxonomies/Content%20Taxonomy%201.0.tsv
	// for more details.
	DetectedCategoriesTaxonomy string `json:"detectedCategoriesTaxonomy,omitempty"`
	// DetectedClickThroughUrls: The set of detected destination URLs for the
	// creative. Can be used to filter the response of the creatives.list method.
	DetectedClickThroughUrls []string `json:"detectedClickThroughUrls,omitempty"`
	// DetectedDomains: The detected domains for this creative.
	DetectedDomains []string `json:"detectedDomains,omitempty"`
	// DetectedLanguages: The detected languages for this creative. The order is
	// arbitrary. The codes are 2 or 5 characters and are documented at
	// https://developers.google.com/adwords/api/docs/appendix/languagecodes. Can
	// be used to filter the response of the creatives.list method.
	DetectedLanguages []string `json:"detectedLanguages,omitempty"`
	// DetectedProductCategories: Detected product categories, if any. See the
	// ad-product-categories.txt file in the technical documentation for a list of
	// IDs. Can be used to filter the response of the creatives.list method.
	DetectedProductCategories []int64 `json:"detectedProductCategories,omitempty"`
	// DetectedSensitiveCategories: Detected sensitive categories, if any. Can be
	// used to filter the response of the creatives.list method. See the
	// ad-sensitive-categories.txt file in the technical documentation for a list
	// of IDs. You should use these IDs along with the excluded-sensitive-category
	// field in the bid request to filter your bids.
	DetectedSensitiveCategories []int64 `json:"detectedSensitiveCategories,omitempty"`
	// DetectedVendorIds: IDs of the ad technology vendors that were detected to be
	// used by this creative. See
	// https://storage.googleapis.com/adx-rtb-dictionaries/vendors.txt for possible
	// values. Can be used to filter the response of the creatives.list method. If
	// the `allowed_vendor_type` field of a bid request
	// (https://developers.google.com/authorized-buyers/rtb/downloads/realtime-bidding-proto)
	// does not contain one of the vendor type IDs that were declared or detected
	// for a given creative, and a bid is submitted with that creative, the bid
	// will be filtered before the auction.
	DetectedVendorIds []int64 `json:"detectedVendorIds,omitempty"`
	// LastStatusUpdate: The last time the creative status was updated. Can be used
	// to filter the response of the creatives.list method.
	LastStatusUpdate string `json:"lastStatusUpdate,omitempty"`
	// NetworkPolicyCompliance: Policy compliance of this creative when bidding in
	// open auction, private auction, or auction packages (outside of Russia and
	// China).
	NetworkPolicyCompliance *PolicyCompliance `json:"networkPolicyCompliance,omitempty"`
	// PlatformPolicyCompliance: Policy compliance of this creative when bidding in
	// Open Bidding (outside of Russia and China). For the list of platform
	// policies, see: https://support.google.com/platformspolicy/answer/3013851.
	PlatformPolicyCompliance *PolicyCompliance `json:"platformPolicyCompliance,omitempty"`
	// RussiaPolicyCompliance: The policy compliance of this creative in Russia.
	// When approved or disapproved, this applies to both deals and open auction in
	// Russia. When pending review, this creative is allowed to serve for deals but
	// not for open auction.
	RussiaPolicyCompliance *PolicyCompliance `json:"russiaPolicyCompliance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdTechnologyProviders") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdTechnologyProviders") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreativeServingDecision) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeServingDecision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DestinationNotCrawlableEvidence: Evidence that the creative's destination
// URL was not crawlable by Google.
type DestinationNotCrawlableEvidence struct {
	// CrawlTime: Approximate time of the crawl.
	CrawlTime string `json:"crawlTime,omitempty"`
	// CrawledUrl: Destination URL that was attempted to be crawled.
	CrawledUrl string `json:"crawledUrl,omitempty"`
	// Reason: Reason of destination not crawlable.
	//
	// Possible values:
	//   "REASON_UNSPECIFIED" - Default value that should never be used.
	//   "UNREACHABLE_ROBOTS" - Site's robots exclusion file (for example,
	// robots.txt) was unreachable.
	//   "TIMEOUT_ROBOTS" - Timed out reading site's robots exclusion file (for
	// example, robots.txt).
	//   "ROBOTED_DENIED" - Crawler was disallowed by the site's robots exclusion
	// file (for example, robots.txt).
	//   "UNKNOWN" - Unknown reason.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrawlTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrawlTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationNotCrawlableEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationNotCrawlableEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DestinationNotWorkingEvidence: Evidence of the creative's destination URL
// not functioning properly or having been incorrectly set up.
type DestinationNotWorkingEvidence struct {
	// DnsError: DNS lookup errors.
	//
	// Possible values:
	//   "DNS_ERROR_UNSPECIFIED" - Default value that should never be used.
	//   "ERROR_DNS" - DNS name was not found.
	//   "GOOGLE_CRAWLER_DNS_ISSUE" - An internal issue occurred when Google's
	// crawler tried to resolve the DNS entry. This is a Google-internal issue and
	// may not be the result of an issue with the landing page.
	DnsError string `json:"dnsError,omitempty"`
	// ExpandedUrl: The full non-working URL.
	ExpandedUrl string `json:"expandedUrl,omitempty"`
	// HttpError: HTTP error code (for example, 404 or 5xx)
	HttpError int64 `json:"httpError,omitempty"`
	// InvalidPage: Page was crawled successfully, but was detected as either a
	// page with no content or an error page.
	//
	// Possible values:
	//   "INVALID_PAGE_UNSPECIFIED" - Default value that should never be used.
	//   "EMPTY_OR_ERROR_PAGE" - Page was empty or had an error.
	InvalidPage string `json:"invalidPage,omitempty"`
	// LastCheckTime: Approximate time when the ad destination was last checked.
	LastCheckTime string `json:"lastCheckTime,omitempty"`
	// Platform: Platform of the non-working URL.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default value that should never be used.
	//   "PERSONAL_COMPUTER" - The personal computer platform.
	//   "ANDROID" - The Android platform.
	//   "IOS" - The iOS platform.
	Platform string `json:"platform,omitempty"`
	// RedirectionError: HTTP redirect chain error.
	//
	// Possible values:
	//   "REDIRECTION_ERROR_UNSPECIFIED" - Default value that should never be used.
	//   "TOO_MANY_REDIRECTS" - Too many redirect hops.
	//   "INVALID_REDIRECT" - Got a redirect but it was invalid.
	//   "EMPTY_REDIRECT" - Got a redirect but it was empty.
	//   "REDIRECT_ERROR_UNKNOWN" - Unknown redirect error.
	RedirectionError string `json:"redirectionError,omitempty"`
	// UrlRejected: Rejected because of malformed URLs or invalid requests.
	//
	// Possible values:
	//   "URL_REJECTED_UNSPECIFIED" - Default value that should never be used.
	//   "BAD_REQUEST" - URL rejected because of a malformed request.
	//   "MALFORMED_URL" - URL rejected because of a malformed URL.
	//   "URL_REJECTED_UNKNOWN" - URL rejected because of unknown reason.
	UrlRejected string `json:"urlRejected,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DnsError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DnsError") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationNotWorkingEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationNotWorkingEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DestinationUrlEvidence: The full landing page URL of the destination.
type DestinationUrlEvidence struct {
	// DestinationUrl: The full landing page URL of the destination.
	DestinationUrl string `json:"destinationUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationUrl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationUrlEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationUrlEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainCallEvidence: Number of HTTP calls made by a creative, broken down by
// domain.
type DomainCallEvidence struct {
	// TopHttpCallDomains: Breakdown of the most frequent domains called through
	// HTTP by the creative.
	TopHttpCallDomains []*DomainCalls `json:"topHttpCallDomains,omitempty"`
	// TotalHttpCallCount: The total number of HTTP calls made by the creative,
	// including but not limited to the number of calls in the
	// top_http_call_domains.
	TotalHttpCallCount int64 `json:"totalHttpCallCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TopHttpCallDomains") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TopHttpCallDomains") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainCallEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod DomainCallEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainCalls: The number of HTTP calls made to the given domain.
type DomainCalls struct {
	// Domain: The domain name.
	Domain string `json:"domain,omitempty"`
	// HttpCallCount: Number of HTTP calls made to the domain.
	HttpCallCount int64 `json:"httpCallCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainCalls) MarshalJSON() ([]byte, error) {
	type NoMethod DomainCalls
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DownloadSizeEvidence: Total download size and URL-level download size
// breakdown for resources in a creative.
type DownloadSizeEvidence struct {
	// TopUrlDownloadSizeBreakdowns: Download size broken down by URLs with the top
	// download size.
	TopUrlDownloadSizeBreakdowns []*UrlDownloadSize `json:"topUrlDownloadSizeBreakdowns,omitempty"`
	// TotalDownloadSizeKb: Total download size (in kilobytes) for all the
	// resources in the creative.
	TotalDownloadSizeKb int64 `json:"totalDownloadSizeKb,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "TopUrlDownloadSizeBreakdowns") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TopUrlDownloadSizeBreakdowns") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DownloadSizeEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod DownloadSizeEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Endpoint: Bidder endpoint that receives bid requests.
type Endpoint struct {
	// BidProtocol: The protocol that the bidder endpoint is using.
	//
	// Possible values:
	//   "BID_PROTOCOL_UNSPECIFIED" - Placeholder for undefined bid protocol. This
	// value should not be used.
	//   "GOOGLE_RTB" - Google RTB protocol / Protobuf encoding.
	//   "OPENRTB_JSON" - OpenRTB / JSON encoding (unversioned/latest).
	//   "OPENRTB_PROTOBUF" - OpenRTB / Protobuf encoding (unversioned/latest).
	BidProtocol string `json:"bidProtocol,omitempty"`
	// MaximumQps: The maximum number of queries per second allowed to be sent to
	// this server.
	MaximumQps int64 `json:"maximumQps,omitempty,string"`
	// Name: Output only. Name of the endpoint resource that must follow the
	// pattern `bidders/{bidderAccountId}/endpoints/{endpointId}`, where
	// {bidderAccountId} is the account ID of the bidder who operates this
	// endpoint, and {endpointId} is a unique ID assigned by the server.
	Name string `json:"name,omitempty"`
	// TradingLocation: The trading location that bid requests should be sent from.
	// See
	// https://developers.google.com/authorized-buyers/rtb/peer-guide#trading-locations
	// for further information.
	//
	// Possible values:
	//   "TRADING_LOCATION_UNSPECIFIED" - A placeholder for an undefined trading
	// region. This value should not be used.
	//   "US_WEST" - The Western US trading location.
	//   "US_EAST" - The Eastern US trading location.
	//   "EUROPE" - The European trading location.
	//   "ASIA" - The Asia trading location.
	TradingLocation string `json:"tradingLocation,omitempty"`
	// Url: Output only. The URL that bid requests should be sent to.
	Url string `json:"url,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BidProtocol") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BidProtocol") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod Endpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetRemarketingTagResponse: This has been sunset as of October 2023, and will
// return an error response if called. For more information, see the release
// notes:
// https://developers.google.com/authorized-buyers/apis/relnotes#real-time-bidding-api
// Response for a request to get remarketing tag.
type GetRemarketingTagResponse struct {
	// Snippet: An HTML tag that can be placed on the advertiser's page to add
	// users to a user list. For more information and code samples on using
	// snippets on your website, refer to Tag your site for remarketing
	// (https://support.google.com/google-ads/answer/2476688).
	Snippet string `json:"snippet,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetRemarketingTagResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetRemarketingTagResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HtmlContent: HTML content for a creative.
type HtmlContent struct {
	// Height: The height of the HTML snippet in pixels. Can be used to filter the
	// response of the creatives.list method.
	Height int64 `json:"height,omitempty"`
	// Snippet: The HTML snippet that displays the ad when inserted in the web
	// page.
	Snippet string `json:"snippet,omitempty"`
	// Width: The width of the HTML snippet in pixels. Can be used to filter the
	// response of the creatives.list method.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HtmlContent) MarshalJSON() ([]byte, error) {
	type NoMethod HtmlContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpCallEvidence: HTTP calls made by a creative that resulted in policy
// violations.
type HttpCallEvidence struct {
	// Urls: URLs of HTTP calls made by the creative.
	Urls []string `json:"urls,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Urls") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Urls") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpCallEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod HttpCallEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpCookieEvidence: Evidence for HTTP cookie-related policy violations.
type HttpCookieEvidence struct {
	// CookieNames: Names of cookies that violate Google policies. For
	// TOO_MANY_COOKIES policy, this will be the cookie names of top domains with
	// the largest number of cookies. For other policies, this will be all the
	// cookie names that violate the policy.
	CookieNames []string `json:"cookieNames,omitempty"`
	// MaxCookieCount: The largest number of cookies set by a creative. If this
	// field is set, cookie_names above will be set to the cookie names of top
	// domains with the largest number of cookies. This field will only be set for
	// TOO_MANY_COOKIES policy.
	MaxCookieCount int64 `json:"maxCookieCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CookieNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CookieNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpCookieEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod HttpCookieEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Image: An image resource. You may provide a larger image than was requested,
// so long as the aspect ratio is preserved.
type Image struct {
	// Height: Image height in pixels.
	Height int64 `json:"height,omitempty"`
	// Url: The URL of the image.
	Url string `json:"url,omitempty"`
	// Width: Image width in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBiddersResponse: A response containing bidders.
type ListBiddersResponse struct {
	// Bidders: List of bidders.
	Bidders []*Bidder `json:"bidders,omitempty"`
	// NextPageToken: A token which can be passed to a subsequent call to the
	// `ListBidders` method to retrieve the next page of results in
	// ListBiddersRequest.pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bidders") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bidders") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBiddersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBiddersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBuyersResponse: A response containing buyer account information.
type ListBuyersResponse struct {
	// Buyers: List of buyers.
	Buyers []*Buyer `json:"buyers,omitempty"`
	// NextPageToken: A token which can be passed to a subsequent call to the
	// `ListBuyers` method to retrieve the next page of results in
	// ListBuyersRequest.pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Buyers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buyers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBuyersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBuyersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCreativesResponse: A response for listing creatives.
type ListCreativesResponse struct {
	// Creatives: The list of creatives.
	Creatives []*Creative `json:"creatives,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass this value
	// in the ListCreativesRequest.pageToken field in the subsequent call to the
	// `ListCreatives` method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Creatives") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Creatives") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCreativesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCreativesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEndpointsResponse: A response containing bidder endpoints.
type ListEndpointsResponse struct {
	// Endpoints: List of bidder endpoints.
	Endpoints []*Endpoint `json:"endpoints,omitempty"`
	// NextPageToken: A token which can be passed to a subsequent call to the
	// `ListEndpoints` method to retrieve the next page of results in
	// ListEndpointsRequest.pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Endpoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Endpoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEndpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEndpointsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPretargetingConfigsResponse: A response containing pretargeting
// configurations.
type ListPretargetingConfigsResponse struct {
	// NextPageToken: A token which can be passed to a subsequent call to the
	// `ListPretargetingConfigs` method to retrieve the next page of results in
	// ListPretargetingConfigsRequest.pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PretargetingConfigs: List of pretargeting configurations.
	PretargetingConfigs []*PretargetingConfig `json:"pretargetingConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPretargetingConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPretargetingConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPublisherConnectionsResponse: A response to a request for listing
// publisher connections.
type ListPublisherConnectionsResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass this value
	// in the ListPublisherConnectionsRequest.pageToken field in the subsequent
	// call to the `ListPublisherConnections` method to retrieve the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PublisherConnections: The list of publisher connections.
	PublisherConnections []*PublisherConnection `json:"publisherConnections,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPublisherConnectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPublisherConnectionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUserListsResponse: The list user list response.
type ListUserListsResponse struct {
	// NextPageToken: The continuation page token to send back to the server in a
	// subsequent request. Due to a currently known issue, it is recommended that
	// the caller keep invoking the list method until the time a next page token is
	// not returned, even if the result set is empty.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UserLists: List of user lists from the search.
	UserLists []*UserList `json:"userLists,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUserListsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUserListsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MediaFile: Information about each media file in the VAST.
type MediaFile struct {
	// Bitrate: Bitrate of the video file, in Kbps. Can be used to filter the
	// response of the creatives.list method.
	Bitrate int64 `json:"bitrate,omitempty,string"`
	// MimeType: The MIME type of this media file. Can be used to filter the
	// response of the creatives.list method.
	//
	// Possible values:
	//   "VIDEO_MIME_TYPE_UNSPECIFIED" - Default value that should never be used.
	//   "MIME_VIDEO_XFLV" - Flash container.
	//   "MIME_VIDEO_WEBM" - WebM container assuming VP9 codec.
	//   "MIME_VIDEO_MP4" - MPEG-4 container typically with H.264 codec.
	//   "MIME_VIDEO_OGG" - Ogg container assuming Theora codec.
	//   "MIME_VIDEO_YT_HOSTED" - Video files hosted on YouTube.
	//   "MIME_VIDEO_X_MS_WMV" - Windows Media Video Codec.
	//   "MIME_VIDEO_3GPP" - 3GPP container format used on 3G phones.
	//   "MIME_VIDEO_MOV" - Quicktime container format.
	//   "MIME_APPLICATION_SWF" - Shockwave Flash (used for VPAID ads).
	//   "MIME_APPLICATION_SURVEY" - Properties of VAST served by consumer survey.
	//   "MIME_APPLICATION_JAVASCRIPT" - JavaScript (used for VPAID ads).
	//   "MIME_APPLICATION_SILVERLIGHT" - Silverlight (used for VPAID ads).
	//   "MIME_APPLICATION_MPEGURL" - HLS/M3U8.
	//   "MIME_APPLICATION_MPEGDASH" - DASH.
	//   "MIME_AUDIO_MP4A" - MPEG-4 audio format.
	//   "MIME_AUDIO_MP3" - MPEG-3 audio format.
	//   "MIME_AUDIO_OGG" - Ogg audio format
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bitrate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bitrate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MediaFile) MarshalJSON() ([]byte, error) {
	type NoMethod MediaFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NativeContent: Native content for a creative.
type NativeContent struct {
	// AdvertiserName: The name of the advertiser or sponsor, to be displayed in
	// the ad creative.
	AdvertiserName string `json:"advertiserName,omitempty"`
	// AppIcon: The app icon, for app download ads.
	AppIcon *Image `json:"appIcon,omitempty"`
	// Body: A long description of the ad.
	Body string `json:"body,omitempty"`
	// CallToAction: A label for the button that the user is supposed to click.
	CallToAction string `json:"callToAction,omitempty"`
	// ClickLinkUrl: The URL that the browser/SDK will load when the user clicks
	// the ad.
	ClickLinkUrl string `json:"clickLinkUrl,omitempty"`
	// ClickTrackingUrl: The URL to use for click tracking.
	ClickTrackingUrl string `json:"clickTrackingUrl,omitempty"`
	// Headline: A short title for the ad.
	Headline string `json:"headline,omitempty"`
	// Image: A large image.
	Image *Image `json:"image,omitempty"`
	// Logo: A smaller image, for the advertiser's logo.
	Logo *Image `json:"logo,omitempty"`
	// PriceDisplayText: The price of the promoted app including currency info.
	PriceDisplayText string `json:"priceDisplayText,omitempty"`
	// StarRating: The app rating in the app store. Must be in the range [0-5].
	StarRating float64 `json:"starRating,omitempty"`
	// VideoUrl: The URL to fetch a native video ad.
	VideoUrl string `json:"videoUrl,omitempty"`
	// VideoVastXml: The contents of a VAST document for a native video ad.
	VideoVastXml string `json:"videoVastXml,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvertiserName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvertiserName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NativeContent) MarshalJSON() ([]byte, error) {
	type NoMethod NativeContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *NativeContent) UnmarshalJSON(data []byte) error {
	type NoMethod NativeContent
	var s1 struct {
		StarRating gensupport.JSONFloat64 `json:"starRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.StarRating = float64(s1.StarRating)
	return nil
}

// NumericTargetingDimension: Generic targeting used for targeting dimensions
// that contain a list of included and excluded numeric IDs used in app, user
// list, geo, and vertical id targeting.
type NumericTargetingDimension struct {
	// ExcludedIds: The IDs excluded in a configuration.
	ExcludedIds googleapi.Int64s `json:"excludedIds,omitempty"`
	// IncludedIds: The IDs included in a configuration.
	IncludedIds googleapi.Int64s `json:"includedIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NumericTargetingDimension) MarshalJSON() ([]byte, error) {
	type NoMethod NumericTargetingDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpenUserListRequest: A request to open a specified user list.
type OpenUserListRequest struct {
}

// PolicyCompliance: Policy compliance of the creative for a transaction type
// or a region.
type PolicyCompliance struct {
	// Status: Serving status for the given transaction type (for example, open
	// auction, deals) or region (for example, China, Russia). Can be used to
	// filter the response of the creatives.list method.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Default value that should never be used.
	//   "PENDING_REVIEW" - Creative is pending review.
	//   "DISAPPROVED" - Creative cannot serve.
	//   "APPROVED" - Creative is approved.
	//   "CERTIFICATE_REQUIRED" - Certificates are required for the creative to be
	// served in some regions. For more information about creative certification,
	// refer to: https://support.google.com/authorizedbuyers/answer/7450776
	Status string `json:"status,omitempty"`
	// Topics: Topics related to the policy compliance for this transaction type
	// (for example, open auction, deals) or region (for example, China, Russia).
	// Topics may be present only if status is DISAPPROVED.
	Topics []*PolicyTopicEntry `json:"topics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyCompliance) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyCompliance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyTopicEntry: Each policy topic entry will represent a violation of a
// policy topic for a creative, with the policy topic information and optional
// evidence for the policy violation.
type PolicyTopicEntry struct {
	// Evidences: Pieces of evidence associated with this policy topic entry.
	Evidences []*PolicyTopicEvidence `json:"evidences,omitempty"`
	// HelpCenterUrl: URL of the help center article describing this policy topic.
	HelpCenterUrl string `json:"helpCenterUrl,omitempty"`
	// MissingCertificate: Whether or not the policy topic is missing a
	// certificate. Some policy topics require a certificate to unblock serving in
	// some regions. For more information about creative certification, refer to:
	// https://support.google.com/authorizedbuyers/answer/7450776
	MissingCertificate bool `json:"missingCertificate,omitempty"`
	// PolicyTopic: Policy topic this entry refers to. For example, "ALCOHOL",
	// "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
	// policy topics is not fixed for a particular API version and may change at
	// any time. Can be used to filter the response of the creatives.list method
	PolicyTopic string `json:"policyTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evidences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evidences") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyTopicEntry) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyTopicEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyTopicEvidence: Evidence associated with a policy topic entry.
type PolicyTopicEvidence struct {
	// DestinationNotCrawlable: The creative's destination URL was not crawlable by
	// Google.
	DestinationNotCrawlable *DestinationNotCrawlableEvidence `json:"destinationNotCrawlable,omitempty"`
	// DestinationNotWorking: The creative's destination URL did not function
	// properly or was incorrectly set up.
	DestinationNotWorking *DestinationNotWorkingEvidence `json:"destinationNotWorking,omitempty"`
	// DestinationUrl: URL of the actual landing page.
	DestinationUrl *DestinationUrlEvidence `json:"destinationUrl,omitempty"`
	// DomainCall: Number of HTTP calls made by the creative, broken down by
	// domain.
	DomainCall *DomainCallEvidence `json:"domainCall,omitempty"`
	// DownloadSize: Total download size and URL-level download size breakdown for
	// resources in a creative.
	DownloadSize *DownloadSizeEvidence `json:"downloadSize,omitempty"`
	// HttpCall: HTTP calls made by the creative that resulted in policy
	// violations.
	HttpCall *HttpCallEvidence `json:"httpCall,omitempty"`
	// HttpCookie: Evidence for HTTP cookie-related policy violations.
	HttpCookie *HttpCookieEvidence `json:"httpCookie,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationNotCrawlable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationNotCrawlable") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyTopicEvidence) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyTopicEvidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PretargetingConfig: Pretargeting configuration: a set of targeting
// dimensions applied at the pretargeting stage of the RTB funnel. These
// control which inventory a bidder will receive bid requests for.
type PretargetingConfig struct {
	// AllowedUserTargetingModes: Targeting modes included by this configuration. A
	// bid request must allow all the specified targeting modes. An unset value
	// allows all bid requests to be sent, regardless of which targeting modes they
	// allow.
	//
	// Possible values:
	//   "USER_TARGETING_MODE_UNSPECIFIED" - Placeholder for undefined user
	// targeting mode.
	//   "REMARKETING_ADS" - Remarketing ads are allowed to serve.
	//   "INTEREST_BASED_TARGETING" - Ads based on user interest category targeting
	// are allowed to serve.
	AllowedUserTargetingModes []string `json:"allowedUserTargetingModes,omitempty"`
	// AppTargeting: Targeting on a subset of app inventory. If APP is listed in
	// targeted_environments, the specified targeting is applied. A maximum of
	// 30,000 app IDs can be targeted. An unset value for targeting allows all
	// app-based bid requests to be sent. Apps can either be targeting positively
	// (bid requests will be sent only if the destination app is listed in the
	// targeting dimension) or negatively (bid requests will be sent only if the
	// destination app is not listed in the targeting dimension).
	AppTargeting *AppTargeting `json:"appTargeting,omitempty"`
	// BillingId: Output only. The identifier that corresponds to this pretargeting
	// configuration that helps buyers track and attribute their spend across their
	// own arbitrary divisions. If a bid request matches more than one
	// configuration, the buyer chooses which billing_id to attribute each of their
	// bids.
	BillingId int64 `json:"billingId,omitempty,string"`
	// DisplayName: The diplay name associated with this configuration. This name
	// must be unique among all the pretargeting configurations a bidder has.
	DisplayName string `json:"displayName,omitempty"`
	// ExcludedContentLabelIds: The sensitive content category label IDs excluded
	// in this configuration. Bid requests for inventory with any of the specified
	// content label IDs will not be sent. Refer to this file
	// https://storage.googleapis.com/adx-rtb-dictionaries/content-labels.txt for
	// category IDs.
	ExcludedContentLabelIds googleapi.Int64s `json:"excludedContentLabelIds,omitempty"`
	// GeoTargeting: The geos included or excluded in this configuration defined in
	// https://storage.googleapis.com/adx-rtb-dictionaries/geo-table.csv
	GeoTargeting *NumericTargetingDimension `json:"geoTargeting,omitempty"`
	// IncludedCreativeDimensions: Creative dimensions included by this
	// configuration. Only bid requests eligible for at least one of the specified
	// creative dimensions will be sent. An unset value allows all bid requests to
	// be sent, regardless of creative dimension.
	IncludedCreativeDimensions []*CreativeDimensions `json:"includedCreativeDimensions,omitempty"`
	// IncludedEnvironments: Environments that are being included. Bid requests
	// will not be sent for a given environment if it is not included. Further
	// restrictions can be applied to included environments to target only a subset
	// of its inventory. An unset value includes all environments.
	//
	// Possible values:
	//   "ENVIRONMENT_UNSPECIFIED" - Placeholder for unspecified environment. This
	// value should not be used.
	//   "APP" - App environment.
	//   "WEB" - Web environment.
	IncludedEnvironments []string `json:"includedEnvironments,omitempty"`
	// IncludedFormats: Creative formats included by this configuration. Only bid
	// requests eligible for at least one of the specified creative formats will be
	// sent. An unset value will allow all bid requests to be sent, regardless of
	// format.
	//
	// Possible values:
	//   "CREATIVE_FORMAT_UNSPECIFIED" - Placeholder for undefined creative format.
	// This value should not be used.
	//   "HTML" - HTML and AMPHTML creatives.
	//   "VAST" - VAST video or audio creative.
	//   "NATIVE" - Native creative, including standard and video native ads.
	IncludedFormats []string `json:"includedFormats,omitempty"`
	// IncludedLanguages: The languages included in this configuration, represented
	// by their language code. See
	// https://developers.google.com/adwords/api/docs/appendix/languagecodes.
	IncludedLanguages []string `json:"includedLanguages,omitempty"`
	// IncludedMobileOperatingSystemIds: The mobile operating systems included in
	// this configuration as defined in
	// https://storage.googleapis.com/adx-rtb-dictionaries/mobile-os.csv
	IncludedMobileOperatingSystemIds googleapi.Int64s `json:"includedMobileOperatingSystemIds,omitempty"`
	// IncludedPlatforms: The platforms included by this configration. Bid requests
	// for devices with the specified platform types will be sent. An unset value
	// allows all bid requests to be sent, regardless of platform.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Placeholder for an undefined platform. This value
	// should not be used.
	//   "PERSONAL_COMPUTER" - The personal computer platform.
	//   "PHONE" - The mobile platform.
	//   "TABLET" - The tablet platform.
	//   "CONNECTED_TV" - The connected TV platform.
	IncludedPlatforms []string `json:"includedPlatforms,omitempty"`
	// IncludedUserIdTypes: User identifier types included in this configuration.
	// At least one of the user identifier types specified in this list must be
	// available for the bid request to be sent.
	//
	// Possible values:
	//   "USER_ID_TYPE_UNSPECIFIED" - Placeholder for unspecified user identifier.
	//   "HOSTED_MATCH_DATA" - Hosted match data, referring to hosted_match_data in
	// the bid request.
	//   "GOOGLE_COOKIE" - Google cookie, referring to google_user_id in the bid
	// request.
	//   "DEVICE_ID" - Mobile device advertising ID.
	//   "PUBLISHER_PROVIDED_ID" - The request has a publisher-provided ID
	// available to the bidder.
	//   "PUBLISHER_FIRST_PARTY_ID" - Publisher first party ID, scoped to a single
	// site, app or vendor needs to be present on the bid request.
	IncludedUserIdTypes []string `json:"includedUserIdTypes,omitempty"`
	// InterstitialTargeting: The interstitial targeting specified for this
	// configuration. The unset value will allow bid requests to be sent regardless
	// of whether they are for interstitials or not.
	//
	// Possible values:
	//   "INTERSTITIAL_TARGETING_UNSPECIFIED" - Unspecified interstitial targeting.
	// Represents an interstitial-agnostic selection.
	//   "ONLY_INTERSTITIAL_REQUESTS" - Only bid requests for interstitial
	// inventory should be sent.
	//   "ONLY_NON_INTERSTITIAL_REQUESTS" - Only bid requests for non-interstitial
	// inventory should be sent.
	InterstitialTargeting string `json:"interstitialTargeting,omitempty"`
	// InvalidGeoIds: Output only. Existing included or excluded geos that are
	// invalid. Previously targeted geos may become invalid due to privacy
	// restrictions.
	InvalidGeoIds googleapi.Int64s `json:"invalidGeoIds,omitempty"`
	// MaximumQps: The maximum QPS threshold for this configuration. The bidder
	// should receive no more than this number of bid requests matching this
	// configuration per second across all their bidding endpoints among all
	// trading locations. Further information available at
	// https://developers.google.com/authorized-buyers/rtb/peer-guide
	MaximumQps int64 `json:"maximumQps,omitempty,string"`
	// MinimumViewabilityDecile: The targeted minimum viewability decile, ranging
	// in values [0, 10]. A value of 5 means that the configuration will only match
	// adslots for which we predict at least 50% viewability. Values > 10 will be
	// rounded down to 10. An unset value or a value of 0 indicates that bid
	// requests will be sent regardless of viewability.
	MinimumViewabilityDecile int64 `json:"minimumViewabilityDecile,omitempty"`
	// Name: Output only. Name of the pretargeting configuration that must follow
	// the pattern `bidders/{bidder_account_id}/pretargetingConfigs/{config_id}`
	Name string `json:"name,omitempty"`
	// PublisherTargeting: Targeting on a subset of publisher inventory. Publishers
	// can either be targeted positively (bid requests will be sent only if the
	// publisher is listed in the targeting dimension) or negatively (bid requests
	// will be sent only if the publisher is not listed in the targeting
	// dimension). A maximum of 10,000 publisher IDs can be targeted. Publisher IDs
	// are found in ads.txt (https://iabtechlab.com/ads-txt/) / app-ads.txt
	// (https://iabtechlab.com/app-ads-txt/) and in bid requests in the
	// `BidRequest.publisher_id` field on the Google RTB protocol
	// (https://developers.google.com/authorized-buyers/rtb/downloads/realtime-bidding-proto)
	// or the `BidRequest.site.publisher.id` / `BidRequest.app.publisher.id` field
	// on the OpenRTB protocol
	// (https://developers.google.com/authorized-buyers/rtb/downloads/openrtb-adx-proto).
	// Publisher IDs will be returned in the order that they were entered.
	PublisherTargeting *StringTargetingDimension `json:"publisherTargeting,omitempty"`
	// State: Output only. The state of this pretargeting configuration.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Placeholder for undefined state.
	//   "ACTIVE" - This pretargeting configuration is actively being used to
	// filter bid requests.
	//   "SUSPENDED" - This pretargeting configuration is suspended and not used in
	// serving.
	State string `json:"state,omitempty"`
	// UserListTargeting: The remarketing lists included or excluded in this
	// configuration as defined in UserList.
	UserListTargeting *NumericTargetingDimension `json:"userListTargeting,omitempty"`
	// VerticalTargeting: The verticals included or excluded in this configuration
	// as defined in
	// https://developers.google.com/authorized-buyers/rtb/downloads/publisher-verticals
	VerticalTargeting *NumericTargetingDimension `json:"verticalTargeting,omitempty"`
	// WebTargeting: Targeting on a subset of site inventory. If WEB is listed in
	// included_environments, the specified targeting is applied. A maximum of
	// 50,000 site URLs can be targeted. An unset value for targeting allows all
	// web-based bid requests to be sent. Sites can either be targeting positively
	// (bid requests will be sent only if the destination site is listed in the
	// targeting dimension) or negatively (bid requests will be sent only if the
	// destination site is not listed in the pretargeting configuration).
	WebTargeting *StringTargetingDimension `json:"webTargeting,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowedUserTargetingModes")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedUserTargetingModes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PretargetingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PretargetingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PublisherConnection: An Open Bidding exchange's connection to a publisher.
// This is initiated by the publisher for the bidder to review. If approved by
// the bidder, this means that the bidder agrees to receive bid requests from
// the publisher.
type PublisherConnection struct {
	// BiddingState: Whether the publisher has been approved by the bidder.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - An unspecified bidding status.
	//   "PENDING" - Indicates a request for connection from the publisher that the
	// bidder needs to review.
	//   "REJECTED" - Indicates that the publisher was rejected.
	//   "APPROVED" - Indicates that the publisher was approved.
	BiddingState string `json:"biddingState,omitempty"`
	// CreateTime: Output only. The time at which the publisher initiated a
	// connection with the bidder (irrespective of if or when the bidder approves
	// it). This is subsequently updated if the publisher revokes and re-initiates
	// the connection.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Output only. Publisher display name.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Name of the publisher connection. This follows the
	// pattern `bidders/{bidder}/publisherConnections/{publisher}`, where
	// `{bidder}` represents the account ID of the bidder, and `{publisher}` is the
	// ads.txt/app-ads.txt publisher ID.
	Name string `json:"name,omitempty"`
	// PublisherPlatform: Output only. Whether the publisher is an Ad Manager or
	// AdMob publisher.
	//
	// Possible values:
	//   "PUBLISHER_PLATFORM_UNSPECIFIED" - An unspecified publisher platform.
	//   "GOOGLE_AD_MANAGER" - A Google Ad Manager publisher.
	//   "ADMOB" - An AdMob publisher.
	PublisherPlatform string `json:"publisherPlatform,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BiddingState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BiddingState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PublisherConnection) MarshalJSON() ([]byte, error) {
	type NoMethod PublisherConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveTargetedAppsRequest: A request to stop targeting the provided apps in
// a specific pretargeting configuration. The pretargeting configuration itself
// specifies how these apps are targeted. in
// PretargetingConfig.appTargeting.mobileAppTargeting.
type RemoveTargetedAppsRequest struct {
	// AppIds: A list of app IDs to stop targeting in the pretargeting
	// configuration. These values will be removed from the list of targeted app
	// IDs in PretargetingConfig.appTargeting.mobileAppTargeting.values.
	AppIds []string `json:"appIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppIds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveTargetedAppsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveTargetedAppsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveTargetedPublishersRequest: A request to stop targeting publishers in a
// specific configuration. The pretargeting configuration itself specifies how
// these publishers are targeted in PretargetingConfig.publisherTargeting.
type RemoveTargetedPublishersRequest struct {
	// PublisherIds: A list of publisher IDs to stop targeting in the pretargeting
	// configuration. These values will be removed from the list of targeted
	// publisher IDs in PretargetingConfig.publisherTargeting.values. Publishers
	// are identified by their publisher ID from ads.txt / app-ads.txt. See
	// https://iabtechlab.com/ads-txt/ and https://iabtechlab.com/app-ads-txt/ for
	// more details.
	PublisherIds []string `json:"publisherIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublisherIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublisherIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveTargetedPublishersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveTargetedPublishersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveTargetedSitesRequest: A request to stop targeting sites in a specific
// pretargeting configuration. The pretargeting configuration itself specifies
// how these sites are targeted in PretargetingConfig.webTargeting.
type RemoveTargetedSitesRequest struct {
	// Sites: A list of site URLs to stop targeting in the pretargeting
	// configuration. These values will be removed from the list of targeted URLs
	// in PretargetingConfig.webTargeting.values.
	Sites []string `json:"sites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sites") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveTargetedSitesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveTargetedSitesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StringTargetingDimension: Generic targeting with string values used in app,
// website and publisher targeting.
type StringTargetingDimension struct {
	// TargetingMode: How the items in this list should be targeted.
	//
	// Possible values:
	//   "TARGETING_MODE_UNSPECIFIED" - Placeholder for undefined targeting mode.
	//   "INCLUSIVE" - The inclusive list type. Inventory must match an item in
	// this list to be targeted.
	//   "EXCLUSIVE" - The exclusive list type. Inventory must not match any item
	// in this list to be targeted.
	TargetingMode string `json:"targetingMode,omitempty"`
	// Values: The values specified.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetingMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetingMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StringTargetingDimension) MarshalJSON() ([]byte, error) {
	type NoMethod StringTargetingDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuspendPretargetingConfigRequest: A request to suspend a pretargeting
// configuration. Sets the configuration's state to SUSPENDED.
type SuspendPretargetingConfigRequest struct {
}

// UrlDownloadSize: The URL-level breakdown for the download size.
type UrlDownloadSize struct {
	// DownloadSizeKb: Download size of the URL in kilobytes.
	DownloadSizeKb int64 `json:"downloadSizeKb,omitempty"`
	// NormalizedUrl: The normalized URL with query parameters and fragment
	// removed.
	NormalizedUrl string `json:"normalizedUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DownloadSizeKb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DownloadSizeKb") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UrlDownloadSize) MarshalJSON() ([]byte, error) {
	type NoMethod UrlDownloadSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UrlRestriction: Deprecated. This will be removed in October 2023. For more
// information, see the release notes:
// https://developers.google.com/authorized-buyers/apis/relnotes#real-time-bidding-api
// Represents the URL restriction (for the URL captured by the pixel callback)
// for a user list.
type UrlRestriction struct {
	// EndDate: End date (if specified) of the URL restriction. End date should be
	// later than the start date for the date range to be valid.
	EndDate *Date `json:"endDate,omitempty"`
	// RestrictionType: The restriction type for the specified URL.
	//
	// Possible values:
	//   "RESTRICTION_TYPE_UNSPECIFIED" - Default value that should never be used.
	//   "CONTAINS" - The tag URL (as recorded by the pixel callback) contains the
	// specified URL.
	//   "EQUALS" - The tag URL (as recorded by the pixel callback) exactly matches
	// the specified URL.
	//   "STARTS_WITH" - The tag URL (as recorded by the pixel callback) starts
	// with the specified URL.
	//   "ENDS_WITH" - The tag URL (as recorded by the pixel callback) ends with
	// the specified URL.
	//   "DOES_NOT_EQUAL" - The tag URL (as recorded by the pixel callback) does
	// not equal the specified URL.
	//   "DOES_NOT_CONTAIN" - The tag URL (as recorded by the pixel callback) does
	// not contain the specified URL.
	//   "DOES_NOT_START_WITH" - The tag URL (as recorded by the pixel callback)
	// does not start with the specified URL.
	//   "DOES_NOT_END_WITH" - The tag URL (as recorded by the pixel callback) does
	// not end with the specified URL.
	RestrictionType string `json:"restrictionType,omitempty"`
	// StartDate: Start date (if specified) of the URL restriction.
	StartDate *Date `json:"startDate,omitempty"`
	// Url: Required. The URL to use for applying the restriction on the user list.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UrlRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod UrlRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserList: Represents an Authorized Buyers user list. Authorized Buyers can
// create/update/list user lists. Once a user list is created in the system,
// Authorized Buyers can add users to the user list using the bulk uploader
// API. Alternatively, users can be added by hosting a tag on the advertiser's
// page.
type UserList struct {
	// Description: The description for the user list.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the user list. This must be unique
	// across all user lists for a given account.
	DisplayName string `json:"displayName,omitempty"`
	// MembershipDurationDays: Required. The number of days a user's cookie stays
	// on the user list. The field must be between 0 and 540 inclusive.
	MembershipDurationDays int64 `json:"membershipDurationDays,omitempty,string"`
	// Name: Output only. Name of the user list that must follow the pattern
	// `buyers/{buyer}/userLists/{user_list}`, where `{buyer}` represents the
	// account ID of the buyer who owns the user list. For a bidder accessing user
	// lists on behalf of a child seat buyer, `{buyer}` represents the account ID
	// of the child seat buyer. `{user_list}` is an int64 identifier assigned by
	// Google to uniquely identify a user list.
	Name string `json:"name,omitempty"`
	// Status: Output only. The status of the user list. A new user list starts out
	// as open.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Default value that should never be used.
	//   "OPEN" - New users can be added to the user list.
	//   "CLOSED" - New users cannot be added to the user list.
	Status string `json:"status,omitempty"`
	// UrlRestriction: Required. Deprecated. This will be removed in October 2023.
	// For more information, see the release notes:
	// https://developers.google.com/authorized-buyers/apis/relnotes#real-time-bidding-api
	// The URL restriction for the user list.
	UrlRestriction *UrlRestriction `json:"urlRestriction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserList) MarshalJSON() ([]byte, error) {
	type NoMethod UserList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VideoContent: Video content for a creative.
type VideoContent struct {
	// VideoMetadata: Output only. Video metadata.
	VideoMetadata *VideoMetadata `json:"videoMetadata,omitempty"`
	// VideoUrl: The URL to fetch a video ad. The URL should return an XML response
	// that conforms to the VAST 2.0, 3.0 or 4.x standard.
	VideoUrl string `json:"videoUrl,omitempty"`
	// VideoVastXml: The contents of a VAST document for a video ad. This document
	// should conform to the VAST 2.0, 3.0, or 4.x standard.
	VideoVastXml string `json:"videoVastXml,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VideoMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VideoMetadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VideoContent) MarshalJSON() ([]byte, error) {
	type NoMethod VideoContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VideoMetadata: Video metadata for a creative.
type VideoMetadata struct {
	// Duration: The duration of the ad. Can be used to filter the response of the
	// creatives.list method.
	Duration string `json:"duration,omitempty"`
	// IsValidVast: Is this a valid VAST ad? Can be used to filter the response of
	// the creatives.list method.
	IsValidVast bool `json:"isValidVast,omitempty"`
	// IsVpaid: Is this a VPAID ad? Can be used to filter the response of the
	// creatives.list method.
	IsVpaid bool `json:"isVpaid,omitempty"`
	// MediaFiles: The list of all media files declared in the VAST. If there are
	// multiple VASTs in a wrapper chain, this includes the media files from the
	// deepest one in the chain.
	MediaFiles []*MediaFile `json:"mediaFiles,omitempty"`
	// SkipOffset: The minimum duration that the user has to watch before being
	// able to skip this ad. If the field is not set, the ad is not skippable. If
	// the field is set, the ad is skippable. Can be used to filter the response of
	// the creatives.list method.
	SkipOffset string `json:"skipOffset,omitempty"`
	// VastVersion: The maximum VAST version across all wrapped VAST documents. Can
	// be used to filter the response of the creatives.list method.
	//
	// Possible values:
	//   "VAST_VERSION_UNSPECIFIED" - Default value that should never be used.
	//   "VAST_VERSION_1_0" - VAST 1.0
	//   "VAST_VERSION_2_0" - VAST 2.0
	//   "VAST_VERSION_3_0" - VAST 3.0
	//   "VAST_VERSION_4_0" - VAST 4.0
	VastVersion string `json:"vastVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Duration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VideoMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod VideoMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WatchCreativesRequest: A request to receive push notifications when any of
// the creatives belonging to the bidder changes status.
type WatchCreativesRequest struct {
}

// WatchCreativesResponse: A response for the request to receive push
// notification when a bidder's creatives change status.
type WatchCreativesResponse struct {
	// Subscription: The Pub/Sub subscription that can be used to pull creative
	// status notifications. This would be of the format
	// `projects/{project_id}/subscriptions/{subscription_id}`. Subscription is
	// created with pull delivery. All service accounts belonging to the bidder
	// will have read access to this subscription. Subscriptions that are inactive
	// for more than 90 days will be disabled. Use watchCreatives to re-enable the
	// subscription.
	Subscription string `json:"subscription,omitempty"`
	// Topic: The Pub/Sub topic that will be used to publish creative serving
	// status notifications. This would be of the format
	// `projects/{project_id}/topics/{topic_id}`.
	Topic string `json:"topic,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Subscription") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WatchCreativesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod WatchCreativesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BiddersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a bidder account by its name.
//
// - name: Name of the bidder to get. Format: `bidders/{bidderAccountId}`.
func (r *BiddersService) Get(name string) *BiddersGetCall {
	c := &BiddersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersGetCall) Fields(s ...googleapi.Field) *BiddersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersGetCall) IfNoneMatch(entityTag string) *BiddersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersGetCall) Context(ctx context.Context) *BiddersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Bidder.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BiddersGetCall) Do(opts ...googleapi.CallOption) (*Bidder, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Bidder{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the bidder accounts that belong to the caller.
func (r *BiddersService) List() *BiddersListCall {
	c := &BiddersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// bidders to return. If unspecified, at most 100 bidders will be returned. The
// maximum value is 500; values above 500 will be coerced to 500.
func (c *BiddersListCall) PageSize(pageSize int64) *BiddersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. This value is received from a
// previous `ListBidders` call in ListBiddersResponse.nextPageToken.
func (c *BiddersListCall) PageToken(pageToken string) *BiddersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersListCall) Fields(s ...googleapi.Field) *BiddersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersListCall) IfNoneMatch(entityTag string) *BiddersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersListCall) Context(ctx context.Context) *BiddersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/bidders")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBiddersResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersListCall) Do(opts ...googleapi.CallOption) (*ListBiddersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBiddersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersListCall) Pages(ctx context.Context, f func(*ListBiddersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BiddersCreativesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists creatives as they are at the time of the initial request. This
// call may take multiple hours to complete. For large, paginated requests,
// this method returns a snapshot of creatives at the time of request for the
// first page. `lastStatusUpdate` and `creativeServingDecision` may be outdated
// for creatives on sequential pages. We recommend Google Cloud Pub/Sub
// (//cloud.google.com/pubsub/docs/overview) to view the latest status.
//
//   - parent: Name of the parent buyer that owns the creatives. The pattern for
//     this resource is either `buyers/{buyerAccountId}` or
//     `bidders/{bidderAccountId}`. For `buyers/{buyerAccountId}`, the
//     `buyerAccountId` can be one of the following: 1. The ID of the buyer that
//     is accessing their own creatives. 2. The ID of the child seat buyer under
//     a bidder account. So for listing creatives pertaining to the child seat
//     buyer (`456`) under bidder account (`123`), you would use the pattern:
//     `buyers/456`. 3. The ID of the bidder itself. So for listing creatives
//     pertaining to bidder (`123`), you would use `buyers/123`. If you want to
//     access all creatives pertaining to both the bidder and all of its child
//     seat accounts, you would use `bidders/{bidderAccountId}`, for example, for
//     all creatives pertaining to bidder (`123`), use `bidders/123`.
func (r *BiddersCreativesService) List(parent string) *BiddersCreativesListCall {
	c := &BiddersCreativesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// creatives. If no filter is specified, all active creatives will be returned.
// Example: 'accountId=12345 AND (dealsStatus:DISAPPROVED AND
// disapprovalReason:UNACCEPTABLE_CONTENT) OR
// declaredAttributes:IS_COOKIE_TARGETED'
func (c *BiddersCreativesListCall) Filter(filter string) *BiddersCreativesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer creatives than requested (due to timeout constraint)
// even if more are available through another call. If unspecified, server will
// pick an appropriate default. Acceptable values are 1 to 1000, inclusive.
func (c *BiddersCreativesListCall) PageSize(pageSize int64) *BiddersCreativesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListCreativesResponse.nextPageToken returned from the previous call to the
// 'ListCreatives' method. Page tokens for continued pages are valid for up to
// five hours, counting from the call to 'ListCreatives' for the first page.
func (c *BiddersCreativesListCall) PageToken(pageToken string) *BiddersCreativesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Controls the amount of information
// included in the response. By default only creativeServingDecision is
// included. To retrieve the entire creative resource (including the declared
// fields and the creative content) specify the view as "FULL".
//
// Possible values:
//
//	"CREATIVE_VIEW_UNSPECIFIED" - Not specified, equivalent to
//
// SERVING_DECISION_ONLY.
//
//	"SERVING_DECISION_ONLY" - Only creativeServingDecision is included in the
//
// response.
//
//	"FULL" - The entire creative resource (including the declared fields and
//
// the creative content) is included in the response.
func (c *BiddersCreativesListCall) View(view string) *BiddersCreativesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersCreativesListCall) Fields(s ...googleapi.Field) *BiddersCreativesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersCreativesListCall) IfNoneMatch(entityTag string) *BiddersCreativesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersCreativesListCall) Context(ctx context.Context) *BiddersCreativesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersCreativesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersCreativesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/creatives")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.creatives.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.creatives.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCreativesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersCreativesListCall) Do(opts ...googleapi.CallOption) (*ListCreativesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCreativesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.creatives.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersCreativesListCall) Pages(ctx context.Context, f func(*ListCreativesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BiddersCreativesWatchCall struct {
	s                     *Service
	parent                string
	watchcreativesrequest *WatchCreativesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Watch: Watches all creatives pertaining to a bidder. It is sufficient to
// invoke this endpoint once per bidder. A Pub/Sub topic will be created and
// notifications will be pushed to the topic when any of the bidder's creatives
// change status. All of the bidder's service accounts will have access to read
// from the topic. Subsequent invocations of this method will return the
// existing Pub/Sub configuration.
//
//   - parent: To watch all creatives pertaining to the bidder and all its child
//     seat accounts, the bidder must follow the pattern
//     `bidders/{bidderAccountId}`.
func (r *BiddersCreativesService) Watch(parent string, watchcreativesrequest *WatchCreativesRequest) *BiddersCreativesWatchCall {
	c := &BiddersCreativesWatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.watchcreativesrequest = watchcreativesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersCreativesWatchCall) Fields(s ...googleapi.Field) *BiddersCreativesWatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersCreativesWatchCall) Context(ctx context.Context) *BiddersCreativesWatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersCreativesWatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersCreativesWatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.watchcreativesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/creatives:watch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.creatives.watch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.creatives.watch" call.
// Any non-2xx status code is an error. Response headers are in either
// *WatchCreativesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersCreativesWatchCall) Do(opts ...googleapi.CallOption) (*WatchCreativesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WatchCreativesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.creatives.watch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersEndpointsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a bidder endpoint by its name.
//
//   - name: Name of the bidder endpoint to get. Format:
//     `bidders/{bidderAccountId}/endpoints/{endpointId}`.
func (r *BiddersEndpointsService) Get(name string) *BiddersEndpointsGetCall {
	c := &BiddersEndpointsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersEndpointsGetCall) Fields(s ...googleapi.Field) *BiddersEndpointsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersEndpointsGetCall) IfNoneMatch(entityTag string) *BiddersEndpointsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersEndpointsGetCall) Context(ctx context.Context) *BiddersEndpointsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersEndpointsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersEndpointsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.endpoints.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.endpoints.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Endpoint.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BiddersEndpointsGetCall) Do(opts ...googleapi.CallOption) (*Endpoint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Endpoint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.endpoints.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersEndpointsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the bidder's endpoints.
//
//   - parent: Name of the bidder whose endpoints will be listed. Format:
//     `bidders/{bidderAccountId}`.
func (r *BiddersEndpointsService) List(parent string) *BiddersEndpointsListCall {
	c := &BiddersEndpointsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// endpoints to return. If unspecified, at most 100 endpoints will be returned.
// The maximum value is 500; values above 500 will be coerced to 500.
func (c *BiddersEndpointsListCall) PageSize(pageSize int64) *BiddersEndpointsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. This value is received from a
// previous `ListEndpoints` call in ListEndpointsResponse.nextPageToken.
func (c *BiddersEndpointsListCall) PageToken(pageToken string) *BiddersEndpointsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersEndpointsListCall) Fields(s ...googleapi.Field) *BiddersEndpointsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersEndpointsListCall) IfNoneMatch(entityTag string) *BiddersEndpointsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersEndpointsListCall) Context(ctx context.Context) *BiddersEndpointsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersEndpointsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersEndpointsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/endpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.endpoints.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.endpoints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEndpointsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersEndpointsListCall) Do(opts ...googleapi.CallOption) (*ListEndpointsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEndpointsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.endpoints.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersEndpointsListCall) Pages(ctx context.Context, f func(*ListEndpointsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BiddersEndpointsPatchCall struct {
	s          *Service
	name       string
	endpoint   *Endpoint
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a bidder's endpoint.
//
//   - name: Output only. Name of the endpoint resource that must follow the
//     pattern `bidders/{bidderAccountId}/endpoints/{endpointId}`, where
//     {bidderAccountId} is the account ID of the bidder who operates this
//     endpoint, and {endpointId} is a unique ID assigned by the server.
func (r *BiddersEndpointsService) Patch(name string, endpoint *Endpoint) *BiddersEndpointsPatchCall {
	c := &BiddersEndpointsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.endpoint = endpoint
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask to use for
// partial in-place updates.
func (c *BiddersEndpointsPatchCall) UpdateMask(updateMask string) *BiddersEndpointsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersEndpointsPatchCall) Fields(s ...googleapi.Field) *BiddersEndpointsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersEndpointsPatchCall) Context(ctx context.Context) *BiddersEndpointsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersEndpointsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersEndpointsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.endpoint)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.endpoints.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.endpoints.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Endpoint.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BiddersEndpointsPatchCall) Do(opts ...googleapi.CallOption) (*Endpoint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Endpoint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.endpoints.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsActivateCall struct {
	s                                 *Service
	name                              string
	activatepretargetingconfigrequest *ActivatePretargetingConfigRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Activate: Activates a pretargeting configuration.
//
//   - name: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) Activate(name string, activatepretargetingconfigrequest *ActivatePretargetingConfigRequest) *BiddersPretargetingConfigsActivateCall {
	c := &BiddersPretargetingConfigsActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activatepretargetingconfigrequest = activatepretargetingconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsActivateCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsActivateCall) Context(ctx context.Context) *BiddersPretargetingConfigsActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.activatepretargetingconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.activate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.activate" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsActivateCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.activate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsAddTargetedAppsCall struct {
	s                      *Service
	pretargetingConfig     string
	addtargetedappsrequest *AddTargetedAppsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// AddTargetedApps: Adds targeted apps to the pretargeting configuration.
//
//   - pretargetingConfig: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) AddTargetedApps(pretargetingConfig string, addtargetedappsrequest *AddTargetedAppsRequest) *BiddersPretargetingConfigsAddTargetedAppsCall {
	c := &BiddersPretargetingConfigsAddTargetedAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.pretargetingConfig = pretargetingConfig
	c.addtargetedappsrequest = addtargetedappsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsAddTargetedAppsCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsAddTargetedAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsAddTargetedAppsCall) Context(ctx context.Context) *BiddersPretargetingConfigsAddTargetedAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsAddTargetedAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsAddTargetedAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addtargetedappsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+pretargetingConfig}:addTargetedApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"pretargetingConfig": c.pretargetingConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.addTargetedApps", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.addTargetedApps" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsAddTargetedAppsCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.addTargetedApps", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsAddTargetedPublishersCall struct {
	s                            *Service
	pretargetingConfig           string
	addtargetedpublishersrequest *AddTargetedPublishersRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// AddTargetedPublishers: Adds targeted publishers to the pretargeting config.
//
//   - pretargetingConfig: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) AddTargetedPublishers(pretargetingConfig string, addtargetedpublishersrequest *AddTargetedPublishersRequest) *BiddersPretargetingConfigsAddTargetedPublishersCall {
	c := &BiddersPretargetingConfigsAddTargetedPublishersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.pretargetingConfig = pretargetingConfig
	c.addtargetedpublishersrequest = addtargetedpublishersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsAddTargetedPublishersCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsAddTargetedPublishersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsAddTargetedPublishersCall) Context(ctx context.Context) *BiddersPretargetingConfigsAddTargetedPublishersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsAddTargetedPublishersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsAddTargetedPublishersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addtargetedpublishersrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+pretargetingConfig}:addTargetedPublishers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"pretargetingConfig": c.pretargetingConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.addTargetedPublishers", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.addTargetedPublishers" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsAddTargetedPublishersCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.addTargetedPublishers", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsAddTargetedSitesCall struct {
	s                       *Service
	pretargetingConfig      string
	addtargetedsitesrequest *AddTargetedSitesRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// AddTargetedSites: Adds targeted sites to the pretargeting configuration.
//
//   - pretargetingConfig: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) AddTargetedSites(pretargetingConfig string, addtargetedsitesrequest *AddTargetedSitesRequest) *BiddersPretargetingConfigsAddTargetedSitesCall {
	c := &BiddersPretargetingConfigsAddTargetedSitesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.pretargetingConfig = pretargetingConfig
	c.addtargetedsitesrequest = addtargetedsitesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsAddTargetedSitesCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsAddTargetedSitesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsAddTargetedSitesCall) Context(ctx context.Context) *BiddersPretargetingConfigsAddTargetedSitesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsAddTargetedSitesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsAddTargetedSitesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addtargetedsitesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+pretargetingConfig}:addTargetedSites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"pretargetingConfig": c.pretargetingConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.addTargetedSites", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.addTargetedSites" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsAddTargetedSitesCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.addTargetedSites", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsCreateCall struct {
	s                  *Service
	parent             string
	pretargetingconfig *PretargetingConfig
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a pretargeting configuration. A pretargeting configuration's
// state (PretargetingConfig.state) is active upon creation, and it will start
// to affect traffic shortly after. A bidder may create a maximum of 10
// pretargeting configurations. Attempts to exceed this maximum results in a
// 400 bad request error.
//
//   - parent: Name of the bidder to create the pretargeting configuration for.
//     Format: bidders/{bidderAccountId}.
func (r *BiddersPretargetingConfigsService) Create(parent string, pretargetingconfig *PretargetingConfig) *BiddersPretargetingConfigsCreateCall {
	c := &BiddersPretargetingConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.pretargetingconfig = pretargetingconfig
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsCreateCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsCreateCall) Context(ctx context.Context) *BiddersPretargetingConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.pretargetingconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/pretargetingConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsCreateCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a pretargeting configuration.
//
//   - name: The name of the pretargeting configuration to delete. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) Delete(name string) *BiddersPretargetingConfigsDeleteCall {
	c := &BiddersPretargetingConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsDeleteCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsDeleteCall) Context(ctx context.Context) *BiddersPretargetingConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BiddersPretargetingConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a pretargeting configuration.
//
//   - name: Name of the pretargeting configuration to get. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) Get(name string) *BiddersPretargetingConfigsGetCall {
	c := &BiddersPretargetingConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsGetCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersPretargetingConfigsGetCall) IfNoneMatch(entityTag string) *BiddersPretargetingConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsGetCall) Context(ctx context.Context) *BiddersPretargetingConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsGetCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all pretargeting configurations for a single bidder.
//
//   - parent: Name of the bidder whose pretargeting configurations will be
//     listed. Format: bidders/{bidderAccountId}.
func (r *BiddersPretargetingConfigsService) List(parent string) *BiddersPretargetingConfigsListCall {
	c := &BiddersPretargetingConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// pretargeting configurations to return. If unspecified, at most 10
// pretargeting configurations will be returned. The maximum value is 100;
// values above 100 will be coerced to 100.
func (c *BiddersPretargetingConfigsListCall) PageSize(pageSize int64) *BiddersPretargetingConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. This value is received from a
// previous `ListPretargetingConfigs` call in
// ListPretargetingConfigsResponse.nextPageToken.
func (c *BiddersPretargetingConfigsListCall) PageToken(pageToken string) *BiddersPretargetingConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsListCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersPretargetingConfigsListCall) IfNoneMatch(entityTag string) *BiddersPretargetingConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsListCall) Context(ctx context.Context) *BiddersPretargetingConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/pretargetingConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPretargetingConfigsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BiddersPretargetingConfigsListCall) Do(opts ...googleapi.CallOption) (*ListPretargetingConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPretargetingConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersPretargetingConfigsListCall) Pages(ctx context.Context, f func(*ListPretargetingConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BiddersPretargetingConfigsPatchCall struct {
	s                  *Service
	name               string
	pretargetingconfig *PretargetingConfig
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates a pretargeting configuration.
//
//   - name: Output only. Name of the pretargeting configuration that must follow
//     the pattern `bidders/{bidder_account_id}/pretargetingConfigs/{config_id}`.
func (r *BiddersPretargetingConfigsService) Patch(name string, pretargetingconfig *PretargetingConfig) *BiddersPretargetingConfigsPatchCall {
	c := &BiddersPretargetingConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.pretargetingconfig = pretargetingconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask to use for
// partial in-place updates.
func (c *BiddersPretargetingConfigsPatchCall) UpdateMask(updateMask string) *BiddersPretargetingConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsPatchCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsPatchCall) Context(ctx context.Context) *BiddersPretargetingConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.pretargetingconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsPatchCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsRemoveTargetedAppsCall struct {
	s                         *Service
	pretargetingConfig        string
	removetargetedappsrequest *RemoveTargetedAppsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// RemoveTargetedApps: Removes targeted apps from the pretargeting
// configuration.
//
//   - pretargetingConfig: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) RemoveTargetedApps(pretargetingConfig string, removetargetedappsrequest *RemoveTargetedAppsRequest) *BiddersPretargetingConfigsRemoveTargetedAppsCall {
	c := &BiddersPretargetingConfigsRemoveTargetedAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.pretargetingConfig = pretargetingConfig
	c.removetargetedappsrequest = removetargetedappsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsRemoveTargetedAppsCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsRemoveTargetedAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsRemoveTargetedAppsCall) Context(ctx context.Context) *BiddersPretargetingConfigsRemoveTargetedAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsRemoveTargetedAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsRemoveTargetedAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removetargetedappsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+pretargetingConfig}:removeTargetedApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"pretargetingConfig": c.pretargetingConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.removeTargetedApps", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.removeTargetedApps" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsRemoveTargetedAppsCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.removeTargetedApps", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsRemoveTargetedPublishersCall struct {
	s                               *Service
	pretargetingConfig              string
	removetargetedpublishersrequest *RemoveTargetedPublishersRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// RemoveTargetedPublishers: Removes targeted publishers from the pretargeting
// config.
//
//   - pretargetingConfig: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) RemoveTargetedPublishers(pretargetingConfig string, removetargetedpublishersrequest *RemoveTargetedPublishersRequest) *BiddersPretargetingConfigsRemoveTargetedPublishersCall {
	c := &BiddersPretargetingConfigsRemoveTargetedPublishersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.pretargetingConfig = pretargetingConfig
	c.removetargetedpublishersrequest = removetargetedpublishersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsRemoveTargetedPublishersCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsRemoveTargetedPublishersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsRemoveTargetedPublishersCall) Context(ctx context.Context) *BiddersPretargetingConfigsRemoveTargetedPublishersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsRemoveTargetedPublishersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsRemoveTargetedPublishersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removetargetedpublishersrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+pretargetingConfig}:removeTargetedPublishers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"pretargetingConfig": c.pretargetingConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.removeTargetedPublishers", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.removeTargetedPublishers" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsRemoveTargetedPublishersCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.removeTargetedPublishers", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsRemoveTargetedSitesCall struct {
	s                          *Service
	pretargetingConfig         string
	removetargetedsitesrequest *RemoveTargetedSitesRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// RemoveTargetedSites: Removes targeted sites from the pretargeting
// configuration.
//
//   - pretargetingConfig: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) RemoveTargetedSites(pretargetingConfig string, removetargetedsitesrequest *RemoveTargetedSitesRequest) *BiddersPretargetingConfigsRemoveTargetedSitesCall {
	c := &BiddersPretargetingConfigsRemoveTargetedSitesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.pretargetingConfig = pretargetingConfig
	c.removetargetedsitesrequest = removetargetedsitesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsRemoveTargetedSitesCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsRemoveTargetedSitesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsRemoveTargetedSitesCall) Context(ctx context.Context) *BiddersPretargetingConfigsRemoveTargetedSitesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsRemoveTargetedSitesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsRemoveTargetedSitesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removetargetedsitesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+pretargetingConfig}:removeTargetedSites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"pretargetingConfig": c.pretargetingConfig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.removeTargetedSites", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.removeTargetedSites" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsRemoveTargetedSitesCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.removeTargetedSites", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPretargetingConfigsSuspendCall struct {
	s                                *Service
	name                             string
	suspendpretargetingconfigrequest *SuspendPretargetingConfigRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Suspend: Suspends a pretargeting configuration.
//
//   - name: The name of the pretargeting configuration. Format:
//     bidders/{bidderAccountId}/pretargetingConfig/{configId}.
func (r *BiddersPretargetingConfigsService) Suspend(name string, suspendpretargetingconfigrequest *SuspendPretargetingConfigRequest) *BiddersPretargetingConfigsSuspendCall {
	c := &BiddersPretargetingConfigsSuspendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.suspendpretargetingconfigrequest = suspendpretargetingconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPretargetingConfigsSuspendCall) Fields(s ...googleapi.Field) *BiddersPretargetingConfigsSuspendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPretargetingConfigsSuspendCall) Context(ctx context.Context) *BiddersPretargetingConfigsSuspendCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPretargetingConfigsSuspendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPretargetingConfigsSuspendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.suspendpretargetingconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:suspend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.suspend", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.pretargetingConfigs.suspend" call.
// Any non-2xx status code is an error. Response headers are in either
// *PretargetingConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPretargetingConfigsSuspendCall) Do(opts ...googleapi.CallOption) (*PretargetingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PretargetingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.pretargetingConfigs.suspend", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPublisherConnectionsBatchApproveCall struct {
	s                                       *Service
	parent                                  string
	batchapprovepublisherconnectionsrequest *BatchApprovePublisherConnectionsRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// BatchApprove: Batch approves multiple publisher connections.
//
//   - parent: The bidder for whom publisher connections will be approved.
//     Format: `bidders/{bidder}` where `{bidder}` is the account ID of the
//     bidder.
func (r *BiddersPublisherConnectionsService) BatchApprove(parent string, batchapprovepublisherconnectionsrequest *BatchApprovePublisherConnectionsRequest) *BiddersPublisherConnectionsBatchApproveCall {
	c := &BiddersPublisherConnectionsBatchApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchapprovepublisherconnectionsrequest = batchapprovepublisherconnectionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPublisherConnectionsBatchApproveCall) Fields(s ...googleapi.Field) *BiddersPublisherConnectionsBatchApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPublisherConnectionsBatchApproveCall) Context(ctx context.Context) *BiddersPublisherConnectionsBatchApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPublisherConnectionsBatchApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPublisherConnectionsBatchApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchapprovepublisherconnectionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/publisherConnections:batchApprove")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.batchApprove", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.publisherConnections.batchApprove" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchApprovePublisherConnectionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BiddersPublisherConnectionsBatchApproveCall) Do(opts ...googleapi.CallOption) (*BatchApprovePublisherConnectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchApprovePublisherConnectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.batchApprove", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPublisherConnectionsBatchRejectCall struct {
	s                                      *Service
	parent                                 string
	batchrejectpublisherconnectionsrequest *BatchRejectPublisherConnectionsRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// BatchReject: Batch rejects multiple publisher connections.
//
//   - parent: The bidder for whom publisher connections will be rejected.
//     Format: `bidders/{bidder}` where `{bidder}` is the account ID of the
//     bidder.
func (r *BiddersPublisherConnectionsService) BatchReject(parent string, batchrejectpublisherconnectionsrequest *BatchRejectPublisherConnectionsRequest) *BiddersPublisherConnectionsBatchRejectCall {
	c := &BiddersPublisherConnectionsBatchRejectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchrejectpublisherconnectionsrequest = batchrejectpublisherconnectionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPublisherConnectionsBatchRejectCall) Fields(s ...googleapi.Field) *BiddersPublisherConnectionsBatchRejectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPublisherConnectionsBatchRejectCall) Context(ctx context.Context) *BiddersPublisherConnectionsBatchRejectCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPublisherConnectionsBatchRejectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPublisherConnectionsBatchRejectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchrejectpublisherconnectionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/publisherConnections:batchReject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.batchReject", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.publisherConnections.batchReject" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchRejectPublisherConnectionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BiddersPublisherConnectionsBatchRejectCall) Do(opts ...googleapi.CallOption) (*BatchRejectPublisherConnectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchRejectPublisherConnectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.batchReject", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPublisherConnectionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a publisher connection.
//
//   - name: Name of the publisher whose connection information is to be
//     retrieved. In the pattern
//     `bidders/{bidder}/publisherConnections/{publisher}` where `{bidder}` is
//     the account ID of the bidder, and `{publisher}` is the ads.txt/app-ads.txt
//     publisher ID. See publisherConnection.name.
func (r *BiddersPublisherConnectionsService) Get(name string) *BiddersPublisherConnectionsGetCall {
	c := &BiddersPublisherConnectionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPublisherConnectionsGetCall) Fields(s ...googleapi.Field) *BiddersPublisherConnectionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersPublisherConnectionsGetCall) IfNoneMatch(entityTag string) *BiddersPublisherConnectionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPublisherConnectionsGetCall) Context(ctx context.Context) *BiddersPublisherConnectionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPublisherConnectionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPublisherConnectionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.publisherConnections.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PublisherConnection.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BiddersPublisherConnectionsGetCall) Do(opts ...googleapi.CallOption) (*PublisherConnection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PublisherConnection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BiddersPublisherConnectionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists publisher connections for a given bidder.
//
//   - parent: Name of the bidder for which publishers have initiated
//     connections. The pattern for this resource is `bidders/{bidder}` where
//     `{bidder}` represents the account ID of the bidder.
func (r *BiddersPublisherConnectionsService) List(parent string) *BiddersPublisherConnectionsListCall {
	c := &BiddersPublisherConnectionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// publisher connections. Connections can be filtered by `displayName`,
// `publisherPlatform`, and `biddingState`. If no filter is specified, all
// publisher connections will be returned. Example: 'displayName="Great
// Publisher*" AND publisherPlatform=ADMOB AND biddingState != PENDING' See
// https://google.aip.dev/160 for more information about filtering syntax.
func (c *BiddersPublisherConnectionsListCall) Filter(filter string) *BiddersPublisherConnectionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order specification by which
// results should be sorted. If no sort order is specified, the results will be
// returned in alphabetic order based on the publisher's publisher code.
// Results can be sorted by `createTime`. Example: 'createTime DESC'.
func (c *BiddersPublisherConnectionsListCall) OrderBy(orderBy string) *BiddersPublisherConnectionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested (due to timeout constraint)
// even if more are available through another call. If unspecified, the server
// will pick an appropriate default. Acceptable values are 1 to 5000,
// inclusive.
func (c *BiddersPublisherConnectionsListCall) PageSize(pageSize int64) *BiddersPublisherConnectionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListPublisherConnectionsResponse.nextPageToken returned from the previous
// call to the 'ListPublisherConnections' method.
func (c *BiddersPublisherConnectionsListCall) PageToken(pageToken string) *BiddersPublisherConnectionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersPublisherConnectionsListCall) Fields(s ...googleapi.Field) *BiddersPublisherConnectionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersPublisherConnectionsListCall) IfNoneMatch(entityTag string) *BiddersPublisherConnectionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersPublisherConnectionsListCall) Context(ctx context.Context) *BiddersPublisherConnectionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersPublisherConnectionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersPublisherConnectionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/publisherConnections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.bidders.publisherConnections.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPublisherConnectionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BiddersPublisherConnectionsListCall) Do(opts ...googleapi.CallOption) (*ListPublisherConnectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPublisherConnectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.bidders.publisherConnections.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersPublisherConnectionsListCall) Pages(ctx context.Context, f func(*ListPublisherConnectionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a buyer account by its name.
//
// - name: Name of the buyer to get. Format: `buyers/{buyerId}`.
func (r *BuyersService) Get(name string) *BuyersGetCall {
	c := &BuyersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersGetCall) Fields(s ...googleapi.Field) *BuyersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersGetCall) IfNoneMatch(entityTag string) *BuyersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersGetCall) Context(ctx context.Context) *BuyersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Buyer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersGetCall) Do(opts ...googleapi.CallOption) (*Buyer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Buyer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersGetRemarketingTagCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetRemarketingTag: This has been sunset as of October 2023, and will return
// an error response if called. For more information, see the release notes:
// https://developers.google.com/authorized-buyers/apis/relnotes#real-time-bidding-api
// Gets remarketing tag for a buyer. A remarketing tag is a piece of JavaScript
// code that can be placed on a web page. When a user visits a page containing
// a remarketing tag, Google adds the user to a user list.
//
//   - name: To fetch the remarketing tag for an account, the name must follow
//     the pattern `buyers/{accountId}`, where `{accountId}` represents the ID of
//     the buyer that owns the remarketing tag. For a bidder accessing the
//     remarketing tag on behalf of a child seat buyer, `{accountId}` should
//     represent the ID of the child seat buyer. To fetch the remarketing tag for
//     a specific user list, the name must follow the pattern
//     `buyers/{accountId}/userLists/{userListId}`. See UserList.name.
func (r *BuyersService) GetRemarketingTag(name string) *BuyersGetRemarketingTagCall {
	c := &BuyersGetRemarketingTagCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersGetRemarketingTagCall) Fields(s ...googleapi.Field) *BuyersGetRemarketingTagCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersGetRemarketingTagCall) IfNoneMatch(entityTag string) *BuyersGetRemarketingTagCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersGetRemarketingTagCall) Context(ctx context.Context) *BuyersGetRemarketingTagCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersGetRemarketingTagCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersGetRemarketingTagCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getRemarketingTag")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.getRemarketingTag", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.getRemarketingTag" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetRemarketingTagResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersGetRemarketingTagCall) Do(opts ...googleapi.CallOption) (*GetRemarketingTagResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetRemarketingTagResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.getRemarketingTag", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all buyer account information the calling buyer user or service
// account is permissioned to manage.
func (r *BuyersService) List() *BuyersListCall {
	c := &BuyersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// buyers to return. If unspecified, at most 100 buyers will be returned. The
// maximum value is 500; values above 500 will be coerced to 500.
func (c *BuyersListCall) PageSize(pageSize int64) *BuyersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. This value is received from a
// previous `ListBuyers` call in ListBuyersResponse.nextPageToken.
func (c *BuyersListCall) PageToken(pageToken string) *BuyersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersListCall) Fields(s ...googleapi.Field) *BuyersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersListCall) IfNoneMatch(entityTag string) *BuyersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersListCall) Context(ctx context.Context) *BuyersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/buyers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBuyersResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersListCall) Do(opts ...googleapi.CallOption) (*ListBuyersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBuyersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersListCall) Pages(ctx context.Context, f func(*ListBuyersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersCreativesCreateCall struct {
	s          *Service
	parent     string
	creative   *Creative
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a creative.
//
//   - parent: The name of the parent buyer that the new creative belongs to that
//     must follow the pattern `buyers/{buyerAccountId}`, where
//     `{buyerAccountId}` represents the account ID of the buyer who owns a
//     creative. For a bidder accessing creatives on behalf of a child seat
//     buyer, `{buyerAccountId}` should represent the account ID of the child
//     seat buyer.
func (r *BuyersCreativesService) Create(parent string, creative *Creative) *BuyersCreativesCreateCall {
	c := &BuyersCreativesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.creative = creative
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersCreativesCreateCall) Fields(s ...googleapi.Field) *BuyersCreativesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersCreativesCreateCall) Context(ctx context.Context) *BuyersCreativesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersCreativesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersCreativesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.creative)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/creatives")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.creatives.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Creative.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersCreativesCreateCall) Do(opts ...googleapi.CallOption) (*Creative, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Creative{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersCreativesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a creative.
//
// - name: Name of the creative to retrieve. See creative.name.
func (r *BuyersCreativesService) Get(name string) *BuyersCreativesGetCall {
	c := &BuyersCreativesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Controls the amount of information
// included in the response. By default only creativeServingDecision is
// included. To retrieve the entire creative resource (including the declared
// fields and the creative content) specify the view as "FULL".
//
// Possible values:
//
//	"CREATIVE_VIEW_UNSPECIFIED" - Not specified, equivalent to
//
// SERVING_DECISION_ONLY.
//
//	"SERVING_DECISION_ONLY" - Only creativeServingDecision is included in the
//
// response.
//
//	"FULL" - The entire creative resource (including the declared fields and
//
// the creative content) is included in the response.
func (c *BuyersCreativesGetCall) View(view string) *BuyersCreativesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersCreativesGetCall) Fields(s ...googleapi.Field) *BuyersCreativesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersCreativesGetCall) IfNoneMatch(entityTag string) *BuyersCreativesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersCreativesGetCall) Context(ctx context.Context) *BuyersCreativesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersCreativesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersCreativesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.creatives.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Creative.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersCreativesGetCall) Do(opts ...googleapi.CallOption) (*Creative, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Creative{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersCreativesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists creatives as they are at the time of the initial request. This
// call may take multiple hours to complete. For large, paginated requests,
// this method returns a snapshot of creatives at the time of request for the
// first page. `lastStatusUpdate` and `creativeServingDecision` may be outdated
// for creatives on sequential pages. We recommend Google Cloud Pub/Sub
// (//cloud.google.com/pubsub/docs/overview) to view the latest status.
//
//   - parent: Name of the parent buyer that owns the creatives. The pattern for
//     this resource is either `buyers/{buyerAccountId}` or
//     `bidders/{bidderAccountId}`. For `buyers/{buyerAccountId}`, the
//     `buyerAccountId` can be one of the following: 1. The ID of the buyer that
//     is accessing their own creatives. 2. The ID of the child seat buyer under
//     a bidder account. So for listing creatives pertaining to the child seat
//     buyer (`456`) under bidder account (`123`), you would use the pattern:
//     `buyers/456`. 3. The ID of the bidder itself. So for listing creatives
//     pertaining to bidder (`123`), you would use `buyers/123`. If you want to
//     access all creatives pertaining to both the bidder and all of its child
//     seat accounts, you would use `bidders/{bidderAccountId}`, for example, for
//     all creatives pertaining to bidder (`123`), use `bidders/123`.
func (r *BuyersCreativesService) List(parent string) *BuyersCreativesListCall {
	c := &BuyersCreativesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// creatives. If no filter is specified, all active creatives will be returned.
// Example: 'accountId=12345 AND (dealsStatus:DISAPPROVED AND
// disapprovalReason:UNACCEPTABLE_CONTENT) OR
// declaredAttributes:IS_COOKIE_TARGETED'
func (c *BuyersCreativesListCall) Filter(filter string) *BuyersCreativesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer creatives than requested (due to timeout constraint)
// even if more are available through another call. If unspecified, server will
// pick an appropriate default. Acceptable values are 1 to 1000, inclusive.
func (c *BuyersCreativesListCall) PageSize(pageSize int64) *BuyersCreativesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListCreativesResponse.nextPageToken returned from the previous call to the
// 'ListCreatives' method. Page tokens for continued pages are valid for up to
// five hours, counting from the call to 'ListCreatives' for the first page.
func (c *BuyersCreativesListCall) PageToken(pageToken string) *BuyersCreativesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Controls the amount of information
// included in the response. By default only creativeServingDecision is
// included. To retrieve the entire creative resource (including the declared
// fields and the creative content) specify the view as "FULL".
//
// Possible values:
//
//	"CREATIVE_VIEW_UNSPECIFIED" - Not specified, equivalent to
//
// SERVING_DECISION_ONLY.
//
//	"SERVING_DECISION_ONLY" - Only creativeServingDecision is included in the
//
// response.
//
//	"FULL" - The entire creative resource (including the declared fields and
//
// the creative content) is included in the response.
func (c *BuyersCreativesListCall) View(view string) *BuyersCreativesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersCreativesListCall) Fields(s ...googleapi.Field) *BuyersCreativesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersCreativesListCall) IfNoneMatch(entityTag string) *BuyersCreativesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersCreativesListCall) Context(ctx context.Context) *BuyersCreativesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersCreativesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersCreativesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/creatives")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.creatives.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCreativesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersCreativesListCall) Do(opts ...googleapi.CallOption) (*ListCreativesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCreativesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersCreativesListCall) Pages(ctx context.Context, f func(*ListCreativesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersCreativesPatchCall struct {
	s          *Service
	name       string
	creative   *Creative
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a creative.
//
//   - name: Output only. Name of the creative. Follows the pattern
//     `buyers/{buyer}/creatives/{creative}`, where `{buyer}` represents the
//     account ID of the buyer who owns the creative, and `{creative}` is the
//     buyer-specific creative ID that references this creative in the bid
//     response.
func (r *BuyersCreativesService) Patch(name string, creative *Creative) *BuyersCreativesPatchCall {
	c := &BuyersCreativesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.creative = creative
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask to use for
// partial in-place updates.
func (c *BuyersCreativesPatchCall) UpdateMask(updateMask string) *BuyersCreativesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersCreativesPatchCall) Fields(s ...googleapi.Field) *BuyersCreativesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersCreativesPatchCall) Context(ctx context.Context) *BuyersCreativesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersCreativesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersCreativesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.creative)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.creatives.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Creative.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersCreativesPatchCall) Do(opts ...googleapi.CallOption) (*Creative, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Creative{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.creatives.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersUserListsCloseCall struct {
	s                    *Service
	name                 string
	closeuserlistrequest *CloseUserListRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Close: Changes the status of a user list to CLOSED. This prevents new users
// from being added to the user list.
//
// - name: The name of the user list to close. See UserList.name.
func (r *BuyersUserListsService) Close(name string, closeuserlistrequest *CloseUserListRequest) *BuyersUserListsCloseCall {
	c := &BuyersUserListsCloseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.closeuserlistrequest = closeuserlistrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsCloseCall) Fields(s ...googleapi.Field) *BuyersUserListsCloseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsCloseCall) Context(ctx context.Context) *BuyersUserListsCloseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsCloseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsCloseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.closeuserlistrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:close")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.close", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.close" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersUserListsCloseCall) Do(opts ...googleapi.CallOption) (*UserList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.close", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersUserListsCreateCall struct {
	s          *Service
	parent     string
	userlist   *UserList
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new user list.
//
//   - parent: The name of the parent buyer of the user list to be retrieved,
//     which must follow the pattern `buyers/{buyerAccountId}`, where
//     `{buyerAccountId}` represents the account ID of the buyer who owns the
//     user list. For a bidder accessing user lists on behalf of a child seat
//     buyer, `{buyerAccountId}` should represent the account ID of the child
//     seat buyer.
func (r *BuyersUserListsService) Create(parent string, userlist *UserList) *BuyersUserListsCreateCall {
	c := &BuyersUserListsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.userlist = userlist
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsCreateCall) Fields(s ...googleapi.Field) *BuyersUserListsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsCreateCall) Context(ctx context.Context) *BuyersUserListsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.userlist)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/userLists")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersUserListsCreateCall) Do(opts ...googleapi.CallOption) (*UserList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersUserListsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a user list by its name.
//
// - name: The name of the user list to be retrieved. See UserList.name.
func (r *BuyersUserListsService) Get(name string) *BuyersUserListsGetCall {
	c := &BuyersUserListsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsGetCall) Fields(s ...googleapi.Field) *BuyersUserListsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersUserListsGetCall) IfNoneMatch(entityTag string) *BuyersUserListsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsGetCall) Context(ctx context.Context) *BuyersUserListsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersUserListsGetCall) Do(opts ...googleapi.CallOption) (*UserList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersUserListsGetRemarketingTagCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetRemarketingTag: This has been sunset as of October 2023, and will return
// an error response if called. For more information, see the release notes:
// https://developers.google.com/authorized-buyers/apis/relnotes#real-time-bidding-api
// Gets remarketing tag for a buyer. A remarketing tag is a piece of JavaScript
// code that can be placed on a web page. When a user visits a page containing
// a remarketing tag, Google adds the user to a user list.
//
//   - name: To fetch the remarketing tag for an account, the name must follow
//     the pattern `buyers/{accountId}`, where `{accountId}` represents the ID of
//     the buyer that owns the remarketing tag. For a bidder accessing the
//     remarketing tag on behalf of a child seat buyer, `{accountId}` should
//     represent the ID of the child seat buyer. To fetch the remarketing tag for
//     a specific user list, the name must follow the pattern
//     `buyers/{accountId}/userLists/{userListId}`. See UserList.name.
func (r *BuyersUserListsService) GetRemarketingTag(name string) *BuyersUserListsGetRemarketingTagCall {
	c := &BuyersUserListsGetRemarketingTagCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsGetRemarketingTagCall) Fields(s ...googleapi.Field) *BuyersUserListsGetRemarketingTagCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersUserListsGetRemarketingTagCall) IfNoneMatch(entityTag string) *BuyersUserListsGetRemarketingTagCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsGetRemarketingTagCall) Context(ctx context.Context) *BuyersUserListsGetRemarketingTagCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsGetRemarketingTagCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsGetRemarketingTagCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getRemarketingTag")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.getRemarketingTag", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.getRemarketingTag" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetRemarketingTagResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersUserListsGetRemarketingTagCall) Do(opts ...googleapi.CallOption) (*GetRemarketingTagResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetRemarketingTagResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.getRemarketingTag", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersUserListsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the user lists visible to the current user.
//
//   - parent: The name of the parent buyer for the user lists to be returned
//     that must follow the pattern `buyers/{buyerAccountId}`, where
//     `{buyerAccountId}` represents the account ID of the buyer who owns user
//     lists. For a bidder accessing user lists on behalf of a child seat buyer ,
//     `{buyerAccountId}` should represent the account ID of the child seat
//     buyer.
func (r *BuyersUserListsService) List(parent string) *BuyersUserListsListCall {
	c := &BuyersUserListsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The number of results to
// return per page.
func (c *BuyersUserListsListCall) PageSize(pageSize int64) *BuyersUserListsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Continuation page token
// as received from a previous response.
func (c *BuyersUserListsListCall) PageToken(pageToken string) *BuyersUserListsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsListCall) Fields(s ...googleapi.Field) *BuyersUserListsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersUserListsListCall) IfNoneMatch(entityTag string) *BuyersUserListsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsListCall) Context(ctx context.Context) *BuyersUserListsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/userLists")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUserListsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersUserListsListCall) Do(opts ...googleapi.CallOption) (*ListUserListsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUserListsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersUserListsListCall) Pages(ctx context.Context, f func(*ListUserListsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersUserListsOpenCall struct {
	s                   *Service
	name                string
	openuserlistrequest *OpenUserListRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Open: Changes the status of a user list to OPEN. This allows new users to be
// added to the user list.
//
// - name: The name of the user list to open. See UserList.name.
func (r *BuyersUserListsService) Open(name string, openuserlistrequest *OpenUserListRequest) *BuyersUserListsOpenCall {
	c := &BuyersUserListsOpenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.openuserlistrequest = openuserlistrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsOpenCall) Fields(s ...googleapi.Field) *BuyersUserListsOpenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsOpenCall) Context(ctx context.Context) *BuyersUserListsOpenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsOpenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsOpenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.openuserlistrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:open")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.open", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.open" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersUserListsOpenCall) Do(opts ...googleapi.CallOption) (*UserList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.open", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BuyersUserListsUpdateCall struct {
	s          *Service
	nameid     string
	userlist   *UserList
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the given user list. Only user lists with URLRestrictions
// can be updated.
//
//   - name: Output only. Name of the user list that must follow the pattern
//     `buyers/{buyer}/userLists/{user_list}`, where `{buyer}` represents the
//     account ID of the buyer who owns the user list. For a bidder accessing
//     user lists on behalf of a child seat buyer, `{buyer}` represents the
//     account ID of the child seat buyer. `{user_list}` is an int64 identifier
//     assigned by Google to uniquely identify a user list.
func (r *BuyersUserListsService) Update(nameid string, userlist *UserList) *BuyersUserListsUpdateCall {
	c := &BuyersUserListsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.userlist = userlist
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersUserListsUpdateCall) Fields(s ...googleapi.Field) *BuyersUserListsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersUserListsUpdateCall) Context(ctx context.Context) *BuyersUserListsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersUserListsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersUserListsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.userlist)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "realtimebidding.buyers.userLists.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersUserListsUpdateCall) Do(opts ...googleapi.CallOption) (*UserList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "realtimebidding.buyers.userLists.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
