// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package civicinfo provides access to the Google Civic Information API.
//
// For product documentation, see: https://developers.google.com/civic-information/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/civicinfo/v2"
//	...
//	ctx := context.Background()
//	civicinfoService, err := civicinfo.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	civicinfoService, err := civicinfo.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	civicinfoService, err := civicinfo.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package civicinfo // import "google.golang.org/api/civicinfo/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "civicinfo:v2"
const apiName = "civicinfo"
const apiVersion = "v2"
const basePath = "https://civicinfo.googleapis.com/"
const basePathTemplate = "https://civicinfo.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://civicinfo.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Divisions = NewDivisionsService(s)
	s.Elections = NewElectionsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Divisions *DivisionsService

	Elections *ElectionsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewDivisionsService(s *Service) *DivisionsService {
	rs := &DivisionsService{s: s}
	return rs
}

type DivisionsService struct {
	s *Service
}

func NewElectionsService(s *Service) *ElectionsService {
	rs := &ElectionsService{s: s}
	return rs
}

type ElectionsService struct {
	s *Service
}

type CivicinfoApiprotosV2DivisionByAddressResponse struct {
	Divisions map[string]CivicinfoSchemaV2GeographicDivision `json:"divisions,omitempty"`
	// NormalizedInput: The normalized version of the requested address.
	NormalizedInput *CivicinfoSchemaV2SimpleAddressType `json:"normalizedInput,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Divisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Divisions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoApiprotosV2DivisionByAddressResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoApiprotosV2DivisionByAddressResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoApiprotosV2DivisionSearchResponse: The result of a division search
// query.
type CivicinfoApiprotosV2DivisionSearchResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "civicinfo#divisionSearchResponse".
	Kind    string                                      `json:"kind,omitempty"`
	Results []*CivicinfoApiprotosV2DivisionSearchResult `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoApiprotosV2DivisionSearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoApiprotosV2DivisionSearchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoApiprotosV2DivisionSearchResult: Represents a political geographic
// division that matches the requested query.
type CivicinfoApiprotosV2DivisionSearchResult struct {
	// Aliases: Other Open Civic Data identifiers that refer to the same division
	// -- for example, those that refer to other political divisions whose
	// boundaries are defined to be coterminous with this one. For example,
	// ocd-division/country:us/state:wy will include an alias of
	// ocd-division/country:us/state:wy/cd:1, since Wyoming has only one
	// Congressional district.
	Aliases []string `json:"aliases,omitempty"`
	// Name: The name of the division.
	Name string `json:"name,omitempty"`
	// OcdId: The unique Open Civic Data identifier for this division
	OcdId string `json:"ocdId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Aliases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aliases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoApiprotosV2DivisionSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoApiprotosV2DivisionSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoApiprotosV2ElectionsQueryResponse: The list of elections available
// for this version of the API.
type CivicinfoApiprotosV2ElectionsQueryResponse struct {
	// Elections: A list of available elections
	Elections []*CivicinfoSchemaV2Election `json:"elections,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "civicinfo#electionsQueryResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Elections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Elections") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoApiprotosV2ElectionsQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoApiprotosV2ElectionsQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoApiprotosV2VoterInfoResponse: The result of a voter info lookup
// query.
type CivicinfoApiprotosV2VoterInfoResponse struct {
	// Contests: Contests that will appear on the voter's ballot.
	Contests []*CivicinfoSchemaV2Contest `json:"contests,omitempty"`
	// DropOffLocations: Locations where a voter is eligible to drop off a
	// completed ballot. The voter must have received and completed a ballot prior
	// to arriving at the location. The location may not have ballots available on
	// the premises. These locations could be open on or before election day as
	// indicated in the pollingHours field.
	DropOffLocations []*CivicinfoSchemaV2PollingLocation `json:"dropOffLocations,omitempty"`
	// EarlyVoteSites: Locations where the voter is eligible to vote early, prior
	// to election day.
	EarlyVoteSites []*CivicinfoSchemaV2PollingLocation `json:"earlyVoteSites,omitempty"`
	// Election: The election that was queried.
	Election *CivicinfoSchemaV2Election `json:"election,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "civicinfo#voterInfoResponse".
	Kind string `json:"kind,omitempty"`
	// MailOnly: Specifies whether voters in the precinct vote only by mailing
	// their ballots (with the possible option of dropping off their ballots as
	// well).
	MailOnly bool `json:"mailOnly,omitempty"`
	// NormalizedInput: The normalized version of the requested address
	NormalizedInput *CivicinfoSchemaV2SimpleAddressType `json:"normalizedInput,omitempty"`
	// OtherElections: When there are multiple elections for a voter address, the
	// otherElections field is populated in the API response and there are two
	// possibilities: 1. If the earliest election is not the intended election,
	// specify the election ID of the desired election in a second API request
	// using the electionId field. 2. If these elections occur on the same day, the
	// API doesn?t return any polling location, contest, or election official
	// information to ensure that an additional query is made. For user-facing
	// applications, we recommend displaying these elections to the user to
	// disambiguate. A second API request using the electionId field should be made
	// for the election that is relevant to the user.
	OtherElections []*CivicinfoSchemaV2Election `json:"otherElections,omitempty"`
	// PollingLocations: Locations where the voter is eligible to vote on election
	// day.
	PollingLocations []*CivicinfoSchemaV2PollingLocation `json:"pollingLocations,omitempty"`
	PrecinctId       string                              `json:"precinctId,omitempty"`
	// Precincts: The precincts that match this voter's address. Will only be
	// returned for project IDs which have been allowlisted as "partner projects".
	Precincts []*CivicinfoSchemaV2Precinct `json:"precincts,omitempty"`
	// State: Local Election Information for the state that the voter votes in. For
	// the US, there will only be one element in this array.
	State []*CivicinfoSchemaV2AdministrationRegion `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoApiprotosV2VoterInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoApiprotosV2VoterInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2AdministrationRegion: Describes information about a
// regional election administrative area.
type CivicinfoSchemaV2AdministrationRegion struct {
	// ElectionAdministrationBody: The election administration body for this area.
	ElectionAdministrationBody *CivicinfoSchemaV2AdministrativeBody `json:"electionAdministrationBody,omitempty"`
	// LocalJurisdiction: The city or county that provides election information for
	// this voter. This object can have the same elements as state.
	LocalJurisdiction *CivicinfoSchemaV2AdministrationRegion `json:"local_jurisdiction,omitempty"`
	// Name: The name of the jurisdiction.
	Name string `json:"name,omitempty"`
	// Sources: A list of sources for this area. If multiple sources are listed the
	// data has been aggregated from those sources.
	Sources []*CivicinfoSchemaV2Source `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ElectionAdministrationBody")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ElectionAdministrationBody") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2AdministrationRegion) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2AdministrationRegion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2AdministrativeBody: Information about an election
// administrative body (e.g. County Board of Elections).
type CivicinfoSchemaV2AdministrativeBody struct {
	// AbsenteeVotingInfoUrl: A URL provided by this administrative body for
	// information on absentee voting.
	AbsenteeVotingInfoUrl string `json:"absenteeVotingInfoUrl,omitempty"`
	// BallotInfoUrl: A URL provided by this administrative body to give contest
	// information to the voter.
	BallotInfoUrl string `json:"ballotInfoUrl,omitempty"`
	// CorrespondenceAddress: The mailing address of this administrative body.
	CorrespondenceAddress *CivicinfoSchemaV2SimpleAddressType `json:"correspondenceAddress,omitempty"`
	// ElectionInfoUrl: A URL provided by this administrative body for looking up
	// general election information.
	ElectionInfoUrl string `json:"electionInfoUrl,omitempty"`
	// ElectionNoticeText: A last minute or emergency notification text provided by
	// this administrative body.
	ElectionNoticeText string `json:"electionNoticeText,omitempty"`
	// ElectionNoticeUrl: A URL provided by this administrative body for additional
	// information related to the last minute or emergency notification.
	ElectionNoticeUrl string `json:"electionNoticeUrl,omitempty"`
	// ElectionOfficials: The election officials for this election administrative
	// body.
	ElectionOfficials []*CivicinfoSchemaV2ElectionOfficial `json:"electionOfficials,omitempty"`
	// ElectionRegistrationConfirmationUrl: A URL provided by this administrative
	// body for confirming that the voter is registered to vote.
	ElectionRegistrationConfirmationUrl string `json:"electionRegistrationConfirmationUrl,omitempty"`
	// ElectionRegistrationUrl: A URL provided by this administrative body for
	// looking up how to register to vote.
	ElectionRegistrationUrl string `json:"electionRegistrationUrl,omitempty"`
	// ElectionRulesUrl: A URL provided by this administrative body describing
	// election rules to the voter.
	ElectionRulesUrl string `json:"electionRulesUrl,omitempty"`
	// HoursOfOperation: A description of the hours of operation for this
	// administrative body.
	HoursOfOperation string `json:"hoursOfOperation,omitempty"`
	// Name: The name of this election administrative body.
	Name string `json:"name,omitempty"`
	// PhysicalAddress: The physical address of this administrative body.
	PhysicalAddress *CivicinfoSchemaV2SimpleAddressType `json:"physicalAddress,omitempty"`
	// VoterServices: A description of the services this administrative body may
	// provide.
	VoterServices []string `json:"voter_services,omitempty"`
	// VotingLocationFinderUrl: A URL provided by this administrative body for
	// looking up where to vote.
	VotingLocationFinderUrl string `json:"votingLocationFinderUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AbsenteeVotingInfoUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AbsenteeVotingInfoUrl") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2AdministrativeBody) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2AdministrativeBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2Candidate: Information about a candidate running for
// elected office.
type CivicinfoSchemaV2Candidate struct {
	// CandidateUrl: The URL for the candidate's campaign web site.
	CandidateUrl string `json:"candidateUrl,omitempty"`
	// Channels: A list of known (social) media channels for this candidate.
	Channels []*CivicinfoSchemaV2Channel `json:"channels,omitempty"`
	// Email: The email address for the candidate's campaign.
	Email string `json:"email,omitempty"`
	// Name: The candidate's name. If this is a joint ticket it will indicate the
	// name of the candidate at the top of a ticket followed by a / and that name
	// of candidate at the bottom of the ticket. e.g. "Mitt Romney / Paul Ryan"
	Name string `json:"name,omitempty"`
	// OrderOnBallot: The order the candidate appears on the ballot for this
	// contest.
	OrderOnBallot int64 `json:"orderOnBallot,omitempty,string"`
	// Party: The full name of the party the candidate is a member of.
	Party string `json:"party,omitempty"`
	// Phone: The voice phone number for the candidate's campaign office.
	Phone string `json:"phone,omitempty"`
	// PhotoUrl: A URL for a photo of the candidate.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2Candidate) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2Candidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2Channel: A social media or web channel for a candidate.
type CivicinfoSchemaV2Channel struct {
	// Id: The unique public identifier for the candidate's channel.
	Id string `json:"id,omitempty"`
	// Type: The type of channel. The following is a list of types of channels, but
	// is not exhaustive. More channel types may be added at a later time. One of:
	// GooglePlus, YouTube, Facebook, Twitter
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2Channel) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2Channel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2Contest: Information about a contest that appears on a
// voter's ballot.
type CivicinfoSchemaV2Contest struct {
	// BallotPlacement: A number specifying the position of this contest on the
	// voter's ballot.
	BallotPlacement int64 `json:"ballotPlacement,omitempty,string"`
	// BallotTitle: The official title on the ballot for this contest, only where
	// available.
	BallotTitle string `json:"ballotTitle,omitempty"`
	// Candidates: The candidate choices for this contest.
	Candidates []*CivicinfoSchemaV2Candidate `json:"candidates,omitempty"`
	// District: Information about the electoral district that this contest is in.
	District *CivicinfoSchemaV2ElectoralDistrict `json:"district,omitempty"`
	// ElectorateSpecifications: A description of any additional eligibility
	// requirements for voting in this contest.
	ElectorateSpecifications string `json:"electorateSpecifications,omitempty"`
	// Level: The levels of government of the office for this contest. There may be
	// more than one in cases where a jurisdiction effectively acts at two
	// different levels of government; for example, the mayor of the District of
	// Columbia acts at "locality" level, but also effectively at both
	// "administrative-area-2" and "administrative-area-1".
	//
	// Possible values:
	//   "international"
	//   "country"
	//   "administrativeArea1"
	//   "regional"
	//   "administrativeArea2"
	//   "locality"
	//   "subLocality1"
	//   "subLocality2"
	//   "special"
	Level []string `json:"level,omitempty"`
	// NumberElected: The number of candidates that will be elected to office in
	// this contest.
	NumberElected int64 `json:"numberElected,omitempty,string"`
	// NumberVotingFor: The number of candidates that a voter may vote for in this
	// contest.
	NumberVotingFor int64 `json:"numberVotingFor,omitempty,string"`
	// Office: The name of the office for this contest.
	Office string `json:"office,omitempty"`
	// PrimaryParties: If this is a partisan election, the name of the
	// party/parties it is for.
	PrimaryParties []string `json:"primaryParties,omitempty"`
	// ReferendumBallotResponses: The set of ballot responses for the referendum. A
	// ballot response represents a line on the ballot. Common examples might
	// include "yes" or "no" for referenda. This field is only populated for
	// contests of type 'Referendum'.
	ReferendumBallotResponses []string `json:"referendumBallotResponses,omitempty"`
	// ReferendumBrief: Specifies a short summary of the referendum that is
	// typically on the ballot below the title but above the text. This field is
	// only populated for contests of type 'Referendum'.
	ReferendumBrief string `json:"referendumBrief,omitempty"`
	// ReferendumConStatement: A statement in opposition to the referendum. It does
	// not necessarily appear on the ballot. This field is only populated for
	// contests of type 'Referendum'.
	ReferendumConStatement string `json:"referendumConStatement,omitempty"`
	// ReferendumEffectOfAbstain: Specifies what effect abstaining (not voting) on
	// the proposition will have (i.e. whether abstaining is considered a vote
	// against it). This field is only populated for contests of type 'Referendum'.
	ReferendumEffectOfAbstain string `json:"referendumEffectOfAbstain,omitempty"`
	// ReferendumPassageThreshold: The threshold of votes that the referendum needs
	// in order to pass, e.g. "two-thirds". This field is only populated for
	// contests of type 'Referendum'.
	ReferendumPassageThreshold string `json:"referendumPassageThreshold,omitempty"`
	// ReferendumProStatement: A statement in favor of the referendum. It does not
	// necessarily appear on the ballot. This field is only populated for contests
	// of type 'Referendum'.
	ReferendumProStatement string `json:"referendumProStatement,omitempty"`
	// ReferendumSubtitle: A brief description of the referendum. This field is
	// only populated for contests of type 'Referendum'.
	ReferendumSubtitle string `json:"referendumSubtitle,omitempty"`
	// ReferendumText: The full text of the referendum. This field is only
	// populated for contests of type 'Referendum'.
	ReferendumText string `json:"referendumText,omitempty"`
	// ReferendumTitle: The title of the referendum (e.g. 'Proposition 42'). This
	// field is only populated for contests of type 'Referendum'.
	ReferendumTitle string `json:"referendumTitle,omitempty"`
	// ReferendumUrl: A link to the referendum. This field is only populated for
	// contests of type 'Referendum'.
	ReferendumUrl string `json:"referendumUrl,omitempty"`
	// Roles: The roles which this office fulfills.
	//
	// Possible values:
	//   "headOfState"
	//   "headOfGovernment"
	//   "deputyHeadOfGovernment"
	//   "governmentOfficer"
	//   "executiveCouncil"
	//   "legislatorUpperBody"
	//   "legislatorLowerBody"
	//   "highestCourtJudge"
	//   "judge"
	//   "schoolBoard"
	//   "specialPurposeOfficer"
	//   "otherRole"
	Roles []string `json:"roles,omitempty"`
	// Sources: A list of sources for this contest. If multiple sources are listed,
	// the data has been aggregated from those sources.
	Sources []*CivicinfoSchemaV2Source `json:"sources,omitempty"`
	// Special: "Yes" or "No" depending on whether this a contest being held
	// outside the normal election cycle.
	Special string `json:"special,omitempty"`
	// Type: The type of contest. Usually this will be 'General', 'Primary', or
	// 'Run-off' for contests with candidates. For referenda this will be
	// 'Referendum'. For Retention contests this will typically be 'Retention'.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BallotPlacement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BallotPlacement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2Contest) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2Contest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2Election: Information about the election that was queried.
type CivicinfoSchemaV2Election struct {
	// ElectionDay: Day of the election in YYYY-MM-DD format.
	ElectionDay string `json:"electionDay,omitempty"`
	// Id: The unique ID of this election.
	Id int64 `json:"id,omitempty,string"`
	// Name: A displayable name for the election.
	Name string `json:"name,omitempty"`
	// OcdDivisionId: The political division of the election. Represented as an OCD
	// Division ID. Voters within these political jurisdictions are covered by this
	// election. This is typically a state such as ocd-division/country:us/state:ca
	// or for the midterms or general election the entire US (i.e.
	// ocd-division/country:us).
	OcdDivisionId string `json:"ocdDivisionId,omitempty"`
	// Possible values:
	//   "shapeLookupDefault"
	//   "shapeLookupDisabled"
	//   "shapeLookupEnabled"
	ShapeLookupBehavior string `json:"shapeLookupBehavior,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ElectionDay") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ElectionDay") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2Election) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2Election
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2ElectionOfficial: Information about individual election
// officials.
type CivicinfoSchemaV2ElectionOfficial struct {
	// EmailAddress: The email address of the election official.
	EmailAddress string `json:"emailAddress,omitempty"`
	// FaxNumber: The fax number of the election official.
	FaxNumber string `json:"faxNumber,omitempty"`
	// Name: The full name of the election official.
	Name string `json:"name,omitempty"`
	// OfficePhoneNumber: The office phone number of the election official.
	OfficePhoneNumber string `json:"officePhoneNumber,omitempty"`
	// Title: The title of the election official.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2ElectionOfficial) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2ElectionOfficial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2ElectoralDistrict: Describes the geographic scope of a
// contest.
type CivicinfoSchemaV2ElectoralDistrict struct {
	// Id: An identifier for this district, relative to its scope. For example, the
	// 34th State Senate district would have id "34" and a scope of stateUpper.
	Id string `json:"id,omitempty"`
	// Name: The name of the district.
	Name string `json:"name,omitempty"`
	// Scope: The geographic scope of this district. If unspecified the district's
	// geography is not known. One of: national, statewide, congressional,
	// stateUpper, stateLower, countywide, judicial, schoolBoard, cityWide,
	// township, countyCouncil, cityCouncil, ward, special
	//
	// Possible values:
	//   "statewide"
	//   "congressional"
	//   "stateUpper"
	//   "stateLower"
	//   "countywide"
	//   "judicial"
	//   "schoolBoard"
	//   "citywide"
	//   "special"
	//   "countyCouncil"
	//   "township"
	//   "ward"
	//   "cityCouncil"
	//   "national"
	Scope string `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2ElectoralDistrict) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2ElectoralDistrict
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2GeographicDivision: Describes a political geography.
type CivicinfoSchemaV2GeographicDivision struct {
	// AlsoKnownAs: Any other valid OCD IDs that refer to the same
	// division.\n\nBecause OCD IDs are meant to be human-readable and at least
	// somewhat predictable, there are occasionally several identifiers for a
	// single division. These identifiers are defined to be equivalent to one
	// another, and one is always indicated as the primary identifier. The primary
	// identifier will be returned in ocd_id above, and any other equivalent valid
	// identifiers will be returned in this list.\n\nFor example, if this
	// division's OCD ID is ocd-division/country:us/district:dc, this will contain
	// ocd-division/country:us/state:dc.
	AlsoKnownAs []string `json:"alsoKnownAs,omitempty"`
	// Name: The name of the division.
	Name string `json:"name,omitempty"`
	// OfficeIndices: List of indices in the offices array, one for each office
	// elected from this division. Will only be present if includeOffices was true
	// (or absent) in the request.
	OfficeIndices []int64 `json:"officeIndices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlsoKnownAs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlsoKnownAs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2GeographicDivision) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2GeographicDivision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2PollingLocation: A location where a voter can vote. This
// may be an early vote site, an election day voting location, or a drop off
// location for a completed ballot.
type CivicinfoSchemaV2PollingLocation struct {
	// Address: The address of the location.
	Address *CivicinfoSchemaV2SimpleAddressType `json:"address,omitempty"`
	// EndDate: The last date that this early vote site or drop off location may be
	// used. This field is not populated for polling locations.
	EndDate string `json:"endDate,omitempty"`
	// Latitude: Latitude of the location, in degrees north of the equator. Note
	// this field may not be available for some locations.
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: Longitude of the location, in degrees east of the Prime Meridian.
	// Note this field may not be available for some locations.
	Longitude float64 `json:"longitude,omitempty"`
	// Name: The name of the early vote site or drop off location. This field is
	// not populated for polling locations.
	Name string `json:"name,omitempty"`
	// Notes: Notes about this location (e.g. accessibility ramp or entrance to
	// use).
	Notes string `json:"notes,omitempty"`
	// PollingHours: A description of when this location is open.
	PollingHours string `json:"pollingHours,omitempty"`
	// Sources: A list of sources for this location. If multiple sources are listed
	// the data has been aggregated from those sources.
	Sources []*CivicinfoSchemaV2Source `json:"sources,omitempty"`
	// StartDate: The first date that this early vote site or drop off location may
	// be used. This field is not populated for polling locations.
	StartDate string `json:"startDate,omitempty"`
	// VoterServices: The services provided by this early vote site or drop off
	// location. This field is not populated for polling locations.
	VoterServices string `json:"voterServices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2PollingLocation) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2PollingLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CivicinfoSchemaV2PollingLocation) UnmarshalJSON(data []byte) error {
	type NoMethod CivicinfoSchemaV2PollingLocation
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

type CivicinfoSchemaV2Precinct struct {
	// AdministrationRegionId: ID of the AdministrationRegion message for this
	// precinct. Corresponds to LocalityId xml tag.
	AdministrationRegionId string `json:"administrationRegionId,omitempty"`
	// ContestId: ID(s) of the Contest message(s) for this precinct.
	ContestId []string `json:"contestId,omitempty"`
	// DatasetId: Required. Dataset ID. What datasets our Precincts come from.
	DatasetId int64 `json:"datasetId,omitempty,string"`
	// EarlyVoteSiteId: ID(s) of the PollingLocation message(s) for this precinct.
	EarlyVoteSiteId []string `json:"earlyVoteSiteId,omitempty"`
	// ElectoralDistrictId: ID(s) of the ElectoralDistrict message(s) for this
	// precinct.
	ElectoralDistrictId []string `json:"electoralDistrictId,omitempty"`
	// Id: Required. A unique identifier for this precinct.
	Id string `json:"id,omitempty"`
	// MailOnly: Specifies if the precinct runs mail-only elections.
	MailOnly bool `json:"mailOnly,omitempty"`
	// Name: Required. The name of the precinct.
	Name string `json:"name,omitempty"`
	// Number: The number of the precinct.
	Number string `json:"number,omitempty"`
	// OcdId: Encouraged. The OCD ID of the precinct
	OcdId []string `json:"ocdId,omitempty"`
	// PollingLocationId: ID(s) of the PollingLocation message(s) for this
	// precinct.
	PollingLocationId []string `json:"pollingLocationId,omitempty"`
	// SpatialBoundaryId: ID(s) of the SpatialBoundary message(s) for this
	// precinct. Used to specify a geometrical boundary of the precinct.
	SpatialBoundaryId []string `json:"spatialBoundaryId,omitempty"`
	// SplitName: If present, this proto corresponds to one portion of split
	// precinct. Other portions of this precinct are guaranteed to have the same
	// `name`. If not present, this proto represents a full precicnt.
	SplitName string `json:"splitName,omitempty"`
	// Ward: Specifies the ward the precinct is contained within.
	Ward string `json:"ward,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdministrationRegionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdministrationRegionId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2Precinct) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2Precinct
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2SimpleAddressType: A simple representation of an address.
type CivicinfoSchemaV2SimpleAddressType struct {
	AddressLine []string `json:"addressLine,omitempty"`
	// City: The city or town for the address.
	City string `json:"city,omitempty"`
	// Line1: The street name and number of this address.
	Line1 string `json:"line1,omitempty"`
	// Line2: The second line the address, if needed.
	Line2 string `json:"line2,omitempty"`
	// Line3: The third line of the address, if needed.
	Line3 string `json:"line3,omitempty"`
	// LocationName: The name of the location.
	LocationName string `json:"locationName,omitempty"`
	// State: The US two letter state abbreviation of the address.
	State string `json:"state,omitempty"`
	// Zip: The US Postal Zip Code of the address.
	Zip string `json:"zip,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressLine") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressLine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2SimpleAddressType) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2SimpleAddressType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CivicinfoSchemaV2Source: Contains information about the data source for the
// element containing it.
type CivicinfoSchemaV2Source struct {
	// Name: The name of the data source.
	Name string `json:"name,omitempty"`
	// Official: Whether this data comes from an official government source.
	Official bool `json:"official,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CivicinfoSchemaV2Source) MarshalJSON() ([]byte, error) {
	type NoMethod CivicinfoSchemaV2Source
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DivisionsQueryDivisionByAddressCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// QueryDivisionByAddress: Lookup OCDIDs and names for divisions related to an
// address.
func (r *DivisionsService) QueryDivisionByAddress() *DivisionsQueryDivisionByAddressCall {
	c := &DivisionsQueryDivisionByAddressCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Address sets the optional parameter "address":
func (c *DivisionsQueryDivisionByAddressCall) Address(address string) *DivisionsQueryDivisionByAddressCall {
	c.urlParams_.Set("address", address)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DivisionsQueryDivisionByAddressCall) Fields(s ...googleapi.Field) *DivisionsQueryDivisionByAddressCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DivisionsQueryDivisionByAddressCall) IfNoneMatch(entityTag string) *DivisionsQueryDivisionByAddressCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DivisionsQueryDivisionByAddressCall) Context(ctx context.Context) *DivisionsQueryDivisionByAddressCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DivisionsQueryDivisionByAddressCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DivisionsQueryDivisionByAddressCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "civicinfo/v2/divisionsByAddress")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "civicinfo.divisions.queryDivisionByAddress", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "civicinfo.divisions.queryDivisionByAddress" call.
// Any non-2xx status code is an error. Response headers are in either
// *CivicinfoApiprotosV2DivisionByAddressResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DivisionsQueryDivisionByAddressCall) Do(opts ...googleapi.CallOption) (*CivicinfoApiprotosV2DivisionByAddressResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CivicinfoApiprotosV2DivisionByAddressResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "civicinfo.divisions.queryDivisionByAddress", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DivisionsSearchCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches for political divisions by their natural name or OCD ID.
func (r *DivisionsService) Search() *DivisionsSearchCall {
	c := &DivisionsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Query sets the optional parameter "query": The search query. Queries can
// cover any parts of a OCD ID or a human readable division name. All words
// given in the query are treated as required patterns. In addition to that,
// most query operators of the Apache Lucene library are supported. See
// http://lucene.apache.org/core/2_9_4/queryparsersyntax.html
func (c *DivisionsSearchCall) Query(query string) *DivisionsSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DivisionsSearchCall) Fields(s ...googleapi.Field) *DivisionsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DivisionsSearchCall) IfNoneMatch(entityTag string) *DivisionsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DivisionsSearchCall) Context(ctx context.Context) *DivisionsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DivisionsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DivisionsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "civicinfo/v2/divisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "civicinfo.divisions.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "civicinfo.divisions.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *CivicinfoApiprotosV2DivisionSearchResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DivisionsSearchCall) Do(opts ...googleapi.CallOption) (*CivicinfoApiprotosV2DivisionSearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CivicinfoApiprotosV2DivisionSearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "civicinfo.divisions.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ElectionsElectionQueryCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ElectionQuery: List of available elections to query.
func (r *ElectionsService) ElectionQuery() *ElectionsElectionQueryCall {
	c := &ElectionsElectionQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ProductionDataOnly sets the optional parameter "productionDataOnly": Whether
// to include data that has not been allowlisted yet
func (c *ElectionsElectionQueryCall) ProductionDataOnly(productionDataOnly bool) *ElectionsElectionQueryCall {
	c.urlParams_.Set("productionDataOnly", fmt.Sprint(productionDataOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ElectionsElectionQueryCall) Fields(s ...googleapi.Field) *ElectionsElectionQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ElectionsElectionQueryCall) IfNoneMatch(entityTag string) *ElectionsElectionQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ElectionsElectionQueryCall) Context(ctx context.Context) *ElectionsElectionQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ElectionsElectionQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ElectionsElectionQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "civicinfo/v2/elections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "civicinfo.elections.electionQuery", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "civicinfo.elections.electionQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *CivicinfoApiprotosV2ElectionsQueryResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ElectionsElectionQueryCall) Do(opts ...googleapi.CallOption) (*CivicinfoApiprotosV2ElectionsQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CivicinfoApiprotosV2ElectionsQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "civicinfo.elections.electionQuery", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ElectionsVoterInfoQueryCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// VoterInfoQuery: Looks up information relevant to a voter based on the
// voter's registered address.
func (r *ElectionsService) VoterInfoQuery() *ElectionsVoterInfoQueryCall {
	c := &ElectionsVoterInfoQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Address sets the optional parameter "address": The registered address of the
// voter to look up.
func (c *ElectionsVoterInfoQueryCall) Address(address string) *ElectionsVoterInfoQueryCall {
	c.urlParams_.Set("address", address)
	return c
}

// ElectionId sets the optional parameter "electionId": The unique ID of the
// election to look up. A list of election IDs can be obtained at
// https://www.googleapis.com/civicinfo/{version}/elections. If no election ID
// is specified in the query and there is more than one election with data for
// the given voter, the additional elections are provided in the otherElections
// response field.
func (c *ElectionsVoterInfoQueryCall) ElectionId(electionId int64) *ElectionsVoterInfoQueryCall {
	c.urlParams_.Set("electionId", fmt.Sprint(electionId))
	return c
}

// OfficialOnly sets the optional parameter "officialOnly": If set to true,
// only data from official state sources will be returned.
func (c *ElectionsVoterInfoQueryCall) OfficialOnly(officialOnly bool) *ElectionsVoterInfoQueryCall {
	c.urlParams_.Set("officialOnly", fmt.Sprint(officialOnly))
	return c
}

// ProductionDataOnly sets the optional parameter "productionDataOnly": Whether
// to include data that has not been vetted yet. Should only be made available
// to internal IPs or trusted partners. This is a non-discoverable parameter in
// the One Platform API config.
func (c *ElectionsVoterInfoQueryCall) ProductionDataOnly(productionDataOnly bool) *ElectionsVoterInfoQueryCall {
	c.urlParams_.Set("productionDataOnly", fmt.Sprint(productionDataOnly))
	return c
}

// ReturnAllAvailableData sets the optional parameter "returnAllAvailableData":
// If set to true, the query will return the success code and include any
// partial information when it is unable to determine a matching address or
// unable to determine the election for electionId=0 queries.
func (c *ElectionsVoterInfoQueryCall) ReturnAllAvailableData(returnAllAvailableData bool) *ElectionsVoterInfoQueryCall {
	c.urlParams_.Set("returnAllAvailableData", fmt.Sprint(returnAllAvailableData))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ElectionsVoterInfoQueryCall) Fields(s ...googleapi.Field) *ElectionsVoterInfoQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ElectionsVoterInfoQueryCall) IfNoneMatch(entityTag string) *ElectionsVoterInfoQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ElectionsVoterInfoQueryCall) Context(ctx context.Context) *ElectionsVoterInfoQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ElectionsVoterInfoQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ElectionsVoterInfoQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "civicinfo/v2/voterinfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "civicinfo.elections.voterInfoQuery", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "civicinfo.elections.voterInfoQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *CivicinfoApiprotosV2VoterInfoResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ElectionsVoterInfoQueryCall) Do(opts ...googleapi.CallOption) (*CivicinfoApiprotosV2VoterInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CivicinfoApiprotosV2VoterInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "civicinfo.elections.voterInfoQuery", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
