// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package workflowexecutions provides access to the Workflow Executions API.
//
// For product documentation, see: https://cloud.google.com/workflows
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/workflowexecutions/v1"
//	...
//	ctx := context.Background()
//	workflowexecutionsService, err := workflowexecutions.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	workflowexecutionsService, err := workflowexecutions.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	workflowexecutionsService, err := workflowexecutions.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package workflowexecutions // import "google.golang.org/api/workflowexecutions/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "workflowexecutions:v1"
const apiName = "workflowexecutions"
const apiVersion = "v1"
const basePath = "https://workflowexecutions.googleapis.com/"
const mtlsBasePath = "https://workflowexecutions.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Workflows = NewProjectsLocationsWorkflowsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Workflows *ProjectsLocationsWorkflowsService
}

func NewProjectsLocationsWorkflowsService(s *Service) *ProjectsLocationsWorkflowsService {
	rs := &ProjectsLocationsWorkflowsService{s: s}
	rs.Executions = NewProjectsLocationsWorkflowsExecutionsService(s)
	return rs
}

type ProjectsLocationsWorkflowsService struct {
	s *Service

	Executions *ProjectsLocationsWorkflowsExecutionsService
}

func NewProjectsLocationsWorkflowsExecutionsService(s *Service) *ProjectsLocationsWorkflowsExecutionsService {
	rs := &ProjectsLocationsWorkflowsExecutionsService{s: s}
	rs.Callbacks = NewProjectsLocationsWorkflowsExecutionsCallbacksService(s)
	rs.StepEntries = NewProjectsLocationsWorkflowsExecutionsStepEntriesService(s)
	return rs
}

type ProjectsLocationsWorkflowsExecutionsService struct {
	s *Service

	Callbacks *ProjectsLocationsWorkflowsExecutionsCallbacksService

	StepEntries *ProjectsLocationsWorkflowsExecutionsStepEntriesService
}

func NewProjectsLocationsWorkflowsExecutionsCallbacksService(s *Service) *ProjectsLocationsWorkflowsExecutionsCallbacksService {
	rs := &ProjectsLocationsWorkflowsExecutionsCallbacksService{s: s}
	return rs
}

type ProjectsLocationsWorkflowsExecutionsCallbacksService struct {
	s *Service
}

func NewProjectsLocationsWorkflowsExecutionsStepEntriesService(s *Service) *ProjectsLocationsWorkflowsExecutionsStepEntriesService {
	rs := &ProjectsLocationsWorkflowsExecutionsStepEntriesService{s: s}
	return rs
}

type ProjectsLocationsWorkflowsExecutionsStepEntriesService struct {
	s *Service
}

// Callback: An instance of a Callback created by an execution.
type Callback struct {
	// AvailablePayloads: Output only. The payloads received by the callback
	// that have not been processed by a waiting execution step.
	AvailablePayloads []string `json:"availablePayloads,omitempty"`

	// Method: Output only. The method accepted by the callback. For
	// example: GET, POST, PUT.
	Method string `json:"method,omitempty"`

	// Name: Output only. The resource name of the callback. Format:
	// projects/{project}/locations/{location}/workflows/{workflow}/execution
	// s/{execution}/callback/{callback}
	Name string `json:"name,omitempty"`

	// Waiters: Output only. Number of execution steps waiting on this
	// callback.
	Waiters int64 `json:"waiters,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AvailablePayloads")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailablePayloads") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Callback) MarshalJSON() ([]byte, error) {
	type NoMethod Callback
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CancelExecutionRequest: Request for the CancelExecution method.
type CancelExecutionRequest struct {
}

// Error: Error describes why the execution was abnormally terminated.
type Error struct {
	// Context: Human-readable stack trace string.
	Context string `json:"context,omitempty"`

	// Payload: Error message and data returned represented as a JSON
	// string.
	Payload string `json:"payload,omitempty"`

	// StackTrace: Stack trace with detailed information of where error was
	// generated.
	StackTrace *StackTrace `json:"stackTrace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Error) MarshalJSON() ([]byte, error) {
	type NoMethod Error
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Exception: Exception describes why the step entry failed.
type Exception struct {
	// Payload: Error message represented as a JSON string.
	Payload string `json:"payload,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Payload") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Payload") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Exception) MarshalJSON() ([]byte, error) {
	type NoMethod Exception
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Execution: A running instance of a Workflow
// (/workflows/docs/reference/rest/v1/projects.locations.workflows).
type Execution struct {
	// Argument: Input parameters of the execution represented as a JSON
	// string. The size limit is 32KB. *Note*: If you are using the REST API
	// directly to run your workflow, you must escape any JSON string value
	// of `argument`. Example:
	// `'{"argument":"{\"firstName\":\"FIRST\",\"lastName\":\"LAST\"}"}'`
	Argument string `json:"argument,omitempty"`

	// CallLogLevel: The call logging level associated to this execution.
	//
	// Possible values:
	//   "CALL_LOG_LEVEL_UNSPECIFIED" - No call logging level specified.
	//   "LOG_ALL_CALLS" - Log all call steps within workflows, all call
	// returns, and all exceptions raised.
	//   "LOG_ERRORS_ONLY" - Log only exceptions that are raised from call
	// steps within workflows.
	//   "LOG_NONE" - Explicitly log nothing.
	CallLogLevel string `json:"callLogLevel,omitempty"`

	// Duration: Output only. Measures the duration of the execution.
	Duration string `json:"duration,omitempty"`

	// EndTime: Output only. Marks the end of execution, successful or not.
	EndTime string `json:"endTime,omitempty"`

	// Error: Output only. The error which caused the execution to finish
	// prematurely. The value is only present if the execution's state is
	// `FAILED` or `CANCELLED`.
	Error *Error `json:"error,omitempty"`

	// Labels: Labels associated with this execution. Labels can contain at
	// most 64 entries. Keys and values can be no longer than 63 characters
	// and can only contain lowercase letters, numeric characters,
	// underscores, and dashes. Label keys must start with a letter.
	// International characters are allowed. By default, labels are
	// inherited from the workflow but are overridden by any labels
	// associated with the execution.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The resource name of the execution. Format:
	// projects/{project}/locations/{location}/workflows/{workflow}/execution
	// s/{execution}
	Name string `json:"name,omitempty"`

	// Result: Output only. Output of the execution represented as a JSON
	// string. The value can only be present if the execution's state is
	// `SUCCEEDED`.
	Result string `json:"result,omitempty"`

	// StartTime: Output only. Marks the beginning of execution.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. Current state of the execution.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Invalid state.
	//   "ACTIVE" - The execution is in progress.
	//   "SUCCEEDED" - The execution finished successfully.
	//   "FAILED" - The execution failed with an error.
	//   "CANCELLED" - The execution was stopped intentionally.
	//   "UNAVAILABLE" - Execution data is unavailable. See the
	// `state_error` field.
	//   "QUEUED" - Request has been placed in the backlog for processing at
	// a later time.
	State string `json:"state,omitempty"`

	// StateError: Output only. Error regarding the state of the Execution
	// resource. For example, this field will have error details if the
	// execution data is unavailable due to revoked KMS key permissions.
	StateError *StateError `json:"stateError,omitempty"`

	// Status: Output only. Status tracks the current steps and progress
	// data of this execution.
	Status *Status `json:"status,omitempty"`

	// WorkflowRevisionId: Output only. Revision of the workflow this
	// execution is using.
	WorkflowRevisionId string `json:"workflowRevisionId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Argument") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Argument") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Execution) MarshalJSON() ([]byte, error) {
	type NoMethod Execution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExportDataResponse: Response for the ExportData method.
type ExportDataResponse struct {
	// Data: The JSON string with customer data and metadata for an
	// execution with the given name
	Data string `json:"data,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExportDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExportDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCallbacksResponse: RPC response object for the ListCallbacks
// method.
type ListCallbacksResponse struct {
	// Callbacks: The callbacks which match the request.
	Callbacks []*Callback `json:"callbacks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Callbacks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Callbacks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListCallbacksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCallbacksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListExecutionsResponse: Response for the ListExecutions method.
type ListExecutionsResponse struct {
	// Executions: The executions which match the request.
	Executions []*Execution `json:"executions,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Executions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Executions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListExecutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExecutionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListStepEntriesResponse: Response message for
// ExecutionHistory.ListStepEntries.
type ListStepEntriesResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass this
	// value in the ListStepEntriesRequest.page_token field in the
	// subsequent call to `ListStepEntries` method to retrieve the next page
	// of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// StepEntries: The list of entries.
	StepEntries []*StepEntry `json:"stepEntries,omitempty"`

	// TotalSize: Indicates the total number of StepEntries that matched the
	// request filter. For running executions, this number shows the number
	// of StepEntries that are executed thus far.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListStepEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListStepEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NavigationInfo: NavigationInfo describes what steps if any come
// before or after this step, or what steps are parents or children of
// this step.
type NavigationInfo struct {
	// Children: Step entries that can be reached by "stepping into" e.g. a
	// subworkflow call.
	Children googleapi.Int64s `json:"children,omitempty"`

	// Next: The index of the next step in the current workflow, if any.
	Next int64 `json:"next,omitempty,string"`

	// Parent: The step entry, if any, that can be reached by "stepping out"
	// of the current workflow being executed.
	Parent int64 `json:"parent,omitempty,string"`

	// Previous: The index of the previous step in the current workflow, if
	// any.
	Previous int64 `json:"previous,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Children") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Children") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NavigationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod NavigationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Position: Position contains source position information about the
// stack trace element such as line number, column number and length of
// the code block in bytes.
type Position struct {
	// Column: The source code column position (of the line) the current
	// instruction was generated from.
	Column int64 `json:"column,omitempty,string"`

	// Length: The number of bytes of source code making up this stack trace
	// element.
	Length int64 `json:"length,omitempty,string"`

	// Line: The source code line number the current instruction was
	// generated from.
	Line int64 `json:"line,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Column") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Column") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Position) MarshalJSON() ([]byte, error) {
	type NoMethod Position
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PubsubMessage: A message that is published by publishers and consumed
// by subscribers. The message must contain either a non-empty data
// field or at least one attribute. Note that client libraries represent
// this object differently depending on the language. See the
// corresponding client library documentation
// (https://cloud.google.com/pubsub/docs/reference/libraries) for more
// information. See [quotas and limits]
// (https://cloud.google.com/pubsub/quotas) for more information about
// message limits.
type PubsubMessage struct {
	// Attributes: Optional. Attributes for this message. If this field is
	// empty, the message must contain non-empty data. This can be used to
	// filter messages on the subscription.
	Attributes map[string]string `json:"attributes,omitempty"`

	// Data: Optional. The message data field. If this field is empty, the
	// message must contain at least one attribute.
	Data string `json:"data,omitempty"`

	// MessageId: Optional. ID of this message, assigned by the server when
	// the message is published. Guaranteed to be unique within the topic.
	// This value may be read by a subscriber that receives a
	// `PubsubMessage` via a `Pull` call or a push delivery. It must not be
	// populated by the publisher in a `Publish` call.
	MessageId string `json:"messageId,omitempty"`

	// OrderingKey: Optional. If non-empty, identifies related messages for
	// which publish order should be respected. If a `Subscription` has
	// `enable_message_ordering` set to `true`, messages published with the
	// same non-empty `ordering_key` value will be delivered to subscribers
	// in the order in which they are received by the Pub/Sub system. All
	// `PubsubMessage`s published in a given `PublishRequest` must specify
	// the same `ordering_key` value. For more information, see ordering
	// messages (https://cloud.google.com/pubsub/docs/ordering).
	OrderingKey string `json:"orderingKey,omitempty"`

	// PublishTime: Optional. The time at which the message was published,
	// populated by the server when it receives the `Publish` call. It must
	// not be populated by the publisher in a `Publish` call.
	PublishTime string `json:"publishTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PubsubMessage) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StackTrace: A collection of stack elements (frames) where an error
// occurred.
type StackTrace struct {
	// Elements: An array of stack elements.
	Elements []*StackTraceElement `json:"elements,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Elements") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Elements") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StackTrace) MarshalJSON() ([]byte, error) {
	type NoMethod StackTrace
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StackTraceElement: A single stack element (frame) where an error
// occurred.
type StackTraceElement struct {
	// Position: The source position information of the stack trace element.
	Position *Position `json:"position,omitempty"`

	// Routine: The routine where the error occurred.
	Routine string `json:"routine,omitempty"`

	// Step: The step the error occurred at.
	Step string `json:"step,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Position") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Position") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StackTraceElement) MarshalJSON() ([]byte, error) {
	type NoMethod StackTraceElement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StateError: Describes an error related to the current state of the
// Execution resource.
type StateError struct {
	// Details: Provides specifics about the error.
	Details string `json:"details,omitempty"`

	// Type: The type of this state error.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - No type specified.
	//   "KMS_ERROR" - Caused by an issue with KMS.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Details") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Details") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StateError) MarshalJSON() ([]byte, error) {
	type NoMethod StateError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: Represents the current status of this execution.
type Status struct {
	// CurrentSteps: A list of currently executing or last executed step
	// names for the workflow execution currently running. If the workflow
	// has succeeded or failed, this is the last attempted or executed step.
	// Presently, if the current step is inside a subworkflow, the list only
	// includes that step. In the future, the list will contain items for
	// each step in the call stack, starting with the outermost step in the
	// `main` subworkflow, and ending with the most deeply nested step.
	CurrentSteps []*Step `json:"currentSteps,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentSteps") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentSteps") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Step: Represents a step of the workflow this execution is running.
type Step struct {
	// Routine: Name of a routine within the workflow.
	Routine string `json:"routine,omitempty"`

	// Step: Name of a step within the routine.
	Step string `json:"step,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Routine") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Routine") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Step) MarshalJSON() ([]byte, error) {
	type NoMethod Step
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StepEntry: An StepEntry contains debugging information for a step
// transition in a workflow execution.
type StepEntry struct {
	// CreateTime: Output only. The creation time of the step entry.
	CreateTime string `json:"createTime,omitempty"`

	// EntryId: Output only. The numeric ID of this step entry, used for
	// navigation.
	EntryId int64 `json:"entryId,omitempty,string"`

	// Exception: Output only. The exception thrown by the step entry.
	Exception *Exception `json:"exception,omitempty"`

	// Name: Output only. The full resource name of the step entry. Each
	// step entry has a unique entry ID, which is a monotonically increasing
	// counter. Step entry names have the format:
	// `projects/{project}/locations/{location}/workflows/{workflow}/executio
	// ns/{execution}/stepEntries/{step_entry}`.
	Name string `json:"name,omitempty"`

	// NavigationInfo: Output only. The NavigationInfo associated to this
	// step.
	NavigationInfo *NavigationInfo `json:"navigationInfo,omitempty"`

	// Routine: Output only. The name of the routine this step entry belongs
	// to. A routine name is the subworkflow name defined in the YAML source
	// code. The top level routine name is `main`.
	Routine string `json:"routine,omitempty"`

	// State: Output only. The state of the step entry.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Invalid state.
	//   "STATE_IN_PROGRESS" - The step entry is in progress.
	//   "STATE_SUCCEEDED" - The step entry finished successfully.
	//   "STATE_FAILED" - The step entry failed with an error.
	State string `json:"state,omitempty"`

	// Step: Output only. The name of the step this step entry belongs to.
	Step string `json:"step,omitempty"`

	// StepEntryMetadata: Output only. The StepEntryMetadata associated to
	// this step.
	StepEntryMetadata *StepEntryMetadata `json:"stepEntryMetadata,omitempty"`

	// StepType: Output only. The type of the step this step entry belongs
	// to.
	//
	// Possible values:
	//   "STEP_TYPE_UNSPECIFIED" - Invalid step type.
	//   "STEP_ASSIGN" - The step entry assigns new variable(s).
	//   "STEP_STD_LIB_CALL" - The step entry calls a standard library
	// routine.
	//   "STEP_CONNECTOR_CALL" - The step entry calls a connector.
	//   "STEP_SUBWORKFLOW_CALL" - The step entry calls a subworklfow.
	//   "STEP_CALL" - The step entry calls a subworkflow/stdlib.
	//   "STEP_SWITCH" - The step entry executes a switch-case block.
	//   "STEP_CONDITION" - The step entry executes a condition inside a
	// switch.
	//   "STEP_FOR" - The step entry executes a for loop.
	//   "STEP_FOR_ITERATION" - The step entry executes a iteration of a for
	// loop.
	//   "STEP_PARALLEL_FOR" - The step entry executes a parallel for loop.
	//   "STEP_PARALLEL_BRANCH" - The step entry executes a series of
	// parallel branch(es).
	//   "STEP_PARALLEL_BRANCH_ENTRY" - The step entry executes a branch of
	// a parallel branch.
	//   "STEP_TRY_RETRY_EXCEPT" - The step entry executes a
	// try/retry/except block.
	//   "STEP_TRY" - The step entry executes the try part of a
	// try/retry/except block.
	//   "STEP_RETRY" - The step entry executes the retry part of a
	// try/retry/except block.
	//   "STEP_EXCEPT" - The step entry executes the except part of a
	// try/retry/except block.
	//   "STEP_RETURN" - The step entry returns.
	//   "STEP_RAISE" - The step entry raises an error.
	//   "STEP_GOTO" - The step entry jumps to another step.
	StepType string `json:"stepType,omitempty"`

	// UpdateTime: Output only. The most recently updated time of the step
	// entry.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StepEntry) MarshalJSON() ([]byte, error) {
	type NoMethod StepEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StepEntryMetadata: StepEntryMetadata contains metadata information
// about this step.
type StepEntryMetadata struct {
	// ProgressNumber: Progress number represents the current state of the
	// current progress. eg: A step entry represents the 4th iteration in a
	// progress of PROGRESS_TYPE_FOR.
	ProgressNumber int64 `json:"progressNumber,omitempty,string"`

	// ProgressType: Progress type of this step entry.
	//
	// Possible values:
	//   "PROGRESS_TYPE_UNSPECIFIED" - Current step entry does not have any
	// progress data.
	//   "PROGRESS_TYPE_FOR" - Current step entry is in progress of a FOR
	// step.
	//   "PROGRESS_TYPE_SWITCH" - Current step entry is in progress of a
	// SWITCH step.
	//   "PROGRESS_TYPE_RETRY" - Current step entry is in progress of a
	// RETRY step.
	//   "PROGRESS_TYPE_PARALLEL_FOR" - Current step entry is in progress of
	// a PARALLEL FOR step.
	//   "PROGRESS_TYPE_PARALLEL_BRANCH" - Current step entry is in progress
	// of a PARALLEL BRANCH step.
	ProgressType string `json:"progressType,omitempty"`

	// ThreadId: Child thread id that this step entry belongs to.
	ThreadId string `json:"threadId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProgressNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProgressNumber") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *StepEntryMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod StepEntryMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TriggerPubsubExecutionRequest: Request for the TriggerPubsubExecution
// method.
type TriggerPubsubExecutionRequest struct {
	// GCPCloudEventsMode: Required. LINT: LEGACY_NAMES The query parameter
	// value for __GCP_CloudEventsMode, set by the Eventarc service when
	// configuring triggers.
	GCPCloudEventsMode string `json:"GCPCloudEventsMode,omitempty"`

	// DeliveryAttempt: The number of attempts that have been made to
	// deliver this message. This is set by Pub/Sub for subscriptions that
	// have the "dead letter" feature enabled, and hence provided here for
	// compatibility, but is ignored by Workflows.
	DeliveryAttempt int64 `json:"deliveryAttempt,omitempty"`

	// Message: Required. The message of the Pub/Sub push notification.
	Message *PubsubMessage `json:"message,omitempty"`

	// Subscription: Required. The subscription of the Pub/Sub push
	// notification. Format: projects/{project}/subscriptions/{sub}
	Subscription string `json:"subscription,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GCPCloudEventsMode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GCPCloudEventsMode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TriggerPubsubExecutionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerPubsubExecutionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "workflowexecutions.projects.locations.workflows.triggerPubsubExecution":

type ProjectsLocationsWorkflowsTriggerPubsubExecutionCall struct {
	s                             *Service
	workflow                      string
	triggerpubsubexecutionrequest *TriggerPubsubExecutionRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// TriggerPubsubExecution: Triggers a new execution using the latest
// revision of the given workflow by a Pub/Sub push notification.
//
//   - workflow: Name of the workflow for which an execution should be
//     created. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}.
func (r *ProjectsLocationsWorkflowsService) TriggerPubsubExecution(workflow string, triggerpubsubexecutionrequest *TriggerPubsubExecutionRequest) *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall {
	c := &ProjectsLocationsWorkflowsTriggerPubsubExecutionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.workflow = workflow
	c.triggerpubsubexecutionrequest = triggerpubsubexecutionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.triggerpubsubexecutionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+workflow}:triggerPubsubExecution")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"workflow": c.workflow,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.triggerPubsubExecution" call.
// Exactly one of *Execution or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsTriggerPubsubExecutionCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Triggers a new execution using the latest revision of the given workflow by a Pub/Sub push notification.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}:triggerPubsubExecution",
	//   "httpMethod": "POST",
	//   "id": "workflowexecutions.projects.locations.workflows.triggerPubsubExecution",
	//   "parameterOrder": [
	//     "workflow"
	//   ],
	//   "parameters": {
	//     "workflow": {
	//       "description": "Required. Name of the workflow for which an execution should be created. Format: projects/{project}/locations/{location}/workflows/{workflow}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+workflow}:triggerPubsubExecution",
	//   "request": {
	//     "$ref": "TriggerPubsubExecutionRequest"
	//   },
	//   "response": {
	//     "$ref": "Execution"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "workflowexecutions.projects.locations.workflows.executions.cancel":

type ProjectsLocationsWorkflowsExecutionsCancelCall struct {
	s                      *Service
	name                   string
	cancelexecutionrequest *CancelExecutionRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Cancels an execution of the given name.
//
//   - name: Name of the execution to be cancelled. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}/executi
//     ons/{execution}.
func (r *ProjectsLocationsWorkflowsExecutionsService) Cancel(name string, cancelexecutionrequest *CancelExecutionRequest) *ProjectsLocationsWorkflowsExecutionsCancelCall {
	c := &ProjectsLocationsWorkflowsExecutionsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelexecutionrequest = cancelexecutionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsCancelCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cancelexecutionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.cancel" call.
// Exactly one of *Execution or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsCancelCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Cancels an execution of the given name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions/{executionsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the execution to be cancelled. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+/executions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:cancel",
	//   "request": {
	//     "$ref": "CancelExecutionRequest"
	//   },
	//   "response": {
	//     "$ref": "Execution"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "workflowexecutions.projects.locations.workflows.executions.create":

type ProjectsLocationsWorkflowsExecutionsCreateCall struct {
	s          *Service
	parent     string
	execution  *Execution
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new execution using the latest revision of the
// given workflow.
//
//   - parent: Name of the workflow for which an execution should be
//     created. Format:
//     projects/{project}/locations/{location}/workflows/{workflow} The
//     latest revision of the workflow will be used.
func (r *ProjectsLocationsWorkflowsExecutionsService) Create(parent string, execution *Execution) *ProjectsLocationsWorkflowsExecutionsCreateCall {
	c := &ProjectsLocationsWorkflowsExecutionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.execution = execution
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsCreateCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.execution)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/executions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.create" call.
// Exactly one of *Execution or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsCreateCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new execution using the latest revision of the given workflow.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions",
	//   "httpMethod": "POST",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the workflow for which an execution should be created. Format: projects/{project}/locations/{location}/workflows/{workflow} The latest revision of the workflow will be used.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/executions",
	//   "request": {
	//     "$ref": "Execution"
	//   },
	//   "response": {
	//     "$ref": "Execution"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "workflowexecutions.projects.locations.workflows.executions.exportData":

type ProjectsLocationsWorkflowsExecutionsExportDataCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExportData: Returns all metadata stored about an execution, excluding
// most data that is already accessible using other API methods.
//
//   - name: Name of the execution for which data is to be exported.
//     Format:
//     projects/{project}/locations/{location}/workflows/{workflow}/executi
//     ons/{execution}.
func (r *ProjectsLocationsWorkflowsExecutionsService) ExportData(name string) *ProjectsLocationsWorkflowsExecutionsExportDataCall {
	c := &ProjectsLocationsWorkflowsExecutionsExportDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsExportDataCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsExportDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsWorkflowsExecutionsExportDataCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowsExecutionsExportDataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsExportDataCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsExportDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsExportDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsExportDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:exportData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.exportData" call.
// Exactly one of *ExportDataResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExportDataResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsExportDataCall) Do(opts ...googleapi.CallOption) (*ExportDataResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExportDataResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns all metadata stored about an execution, excluding most data that is already accessible using other API methods.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions/{executionsId}:exportData",
	//   "httpMethod": "GET",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.exportData",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the execution for which data is to be exported. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+/executions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:exportData",
	//   "response": {
	//     "$ref": "ExportDataResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "workflowexecutions.projects.locations.workflows.executions.get":

type ProjectsLocationsWorkflowsExecutionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an execution of the given name.
//
//   - name: Name of the execution to be retrieved. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}/executi
//     ons/{execution}.
func (r *ProjectsLocationsWorkflowsExecutionsService) Get(name string) *ProjectsLocationsWorkflowsExecutionsGetCall {
	c := &ProjectsLocationsWorkflowsExecutionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": A view defining which fields
// should be filled in the returned execution. The API will default to
// the FULL view.
//
// Possible values:
//
//	"EXECUTION_VIEW_UNSPECIFIED" - The default / unset value.
//	"BASIC" - Includes only basic metadata about the execution. The
//
// following fields are returned: name, start_time, end_time, duration,
// state, and workflow_revision_id.
//
//	"FULL" - Includes all data.
func (c *ProjectsLocationsWorkflowsExecutionsGetCall) View(view string) *ProjectsLocationsWorkflowsExecutionsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsWorkflowsExecutionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowsExecutionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsGetCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.get" call.
// Exactly one of *Execution or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsGetCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns an execution of the given name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions/{executionsId}",
	//   "httpMethod": "GET",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the execution to be retrieved. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+/executions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. A view defining which fields should be filled in the returned execution. The API will default to the FULL view.",
	//       "enum": [
	//         "EXECUTION_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value.",
	//         "Includes only basic metadata about the execution. The following fields are returned: name, start_time, end_time, duration, state, and workflow_revision_id.",
	//         "Includes all data."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Execution"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "workflowexecutions.projects.locations.workflows.executions.list":

type ProjectsLocationsWorkflowsExecutionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of executions which belong to the workflow with
// the given name. The method returns executions of all workflow
// revisions. Returned executions are ordered by their start time
// (newest first).
//
//   - parent: Name of the workflow for which the executions should be
//     listed. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}.
func (r *ProjectsLocationsWorkflowsExecutionsService) List(parent string) *ProjectsLocationsWorkflowsExecutionsListCall {
	c := &ProjectsLocationsWorkflowsExecutionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filters applied to the
// `[Executions.ListExecutions]` results. The following fields are
// supported for filtering: `executionId`, `state`, `startTime`,
// `endTime`, `duration`, `workflowRevisionId`, `stepName`, and `label`.
// For details, see AIP-160. For example, if you are using the Google
// APIs Explorer: `state="SUCCEEDED" or `startTime>"2023-08-01" AND
// state="FAILED"
func (c *ProjectsLocationsWorkflowsExecutionsListCall) Filter(filter string) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list
// of fields that specify the ordering applied to the
// `[Executions.ListExecutions]` results. By default the ordering is
// based on descending `startTime`. The following fields are supported
// for ordering: `executionId`, `state`, `startTime`, `endTime`,
// `duration`, and `workflowRevisionId`. For details, see AIP-132.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) OrderBy(orderBy string) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// executions to return per call. Max supported value depends on the
// selected Execution view: it's 1000 for BASIC and 100 for FULL. The
// default value used if the field is not specified is 100, regardless
// of the selected view. Values greater than the max value will be
// coerced down to it.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) PageSize(pageSize int64) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListExecutions` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListExecutions` must match the call that provided the
// page token. Note that pagination is applied to dynamic data. The list
// of executions returned can change between page requests.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) PageToken(pageToken string) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": A view defining which fields
// should be filled in the returned executions. The API will default to
// the BASIC view.
//
// Possible values:
//
//	"EXECUTION_VIEW_UNSPECIFIED" - The default / unset value.
//	"BASIC" - Includes only basic metadata about the execution. The
//
// following fields are returned: name, start_time, end_time, duration,
// state, and workflow_revision_id.
//
//	"FULL" - Includes all data.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) View(view string) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/executions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.list" call.
// Exactly one of *ListExecutionsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListExecutionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) Do(opts ...googleapi.CallOption) (*ListExecutionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExecutionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of executions which belong to the workflow with the given name. The method returns executions of all workflow revisions. Returned executions are ordered by their start time (newest first).",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions",
	//   "httpMethod": "GET",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filters applied to the `[Executions.ListExecutions]` results. The following fields are supported for filtering: `executionId`, `state`, `startTime`, `endTime`, `duration`, `workflowRevisionId`, `stepName`, and `label`. For details, see AIP-160. For example, if you are using the Google APIs Explorer: `state=\"SUCCEEDED\"` or `startTime\u003e\"2023-08-01\" AND state=\"FAILED\"`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Comma-separated list of fields that specify the ordering applied to the `[Executions.ListExecutions]` results. By default the ordering is based on descending `startTime`. The following fields are supported for ordering: `executionId`, `state`, `startTime`, `endTime`, `duration`, and `workflowRevisionId`. For details, see AIP-132.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of executions to return per call. Max supported value depends on the selected Execution view: it's 1000 for BASIC and 100 for FULL. The default value used if the field is not specified is 100, regardless of the selected view. Values greater than the max value will be coerced down to it.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListExecutions` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListExecutions` must match the call that provided the page token. Note that pagination is applied to dynamic data. The list of executions returned can change between page requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the workflow for which the executions should be listed. Format: projects/{project}/locations/{location}/workflows/{workflow}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. A view defining which fields should be filled in the returned executions. The API will default to the BASIC view.",
	//       "enum": [
	//         "EXECUTION_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value.",
	//         "Includes only basic metadata about the execution. The following fields are returned: name, start_time, end_time, duration, state, and workflow_revision_id.",
	//         "Includes all data."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/executions",
	//   "response": {
	//     "$ref": "ListExecutionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWorkflowsExecutionsListCall) Pages(ctx context.Context, f func(*ListExecutionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "workflowexecutions.projects.locations.workflows.executions.callbacks.list":

type ProjectsLocationsWorkflowsExecutionsCallbacksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of active callbacks that belong to the execution
// with the given name. The returned callbacks are ordered by callback
// ID.
//
//   - parent: Name of the execution for which the callbacks should be
//     listed. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}/executi
//     ons/{execution}.
func (r *ProjectsLocationsWorkflowsExecutionsCallbacksService) List(parent string) *ProjectsLocationsWorkflowsExecutionsCallbacksListCall {
	c := &ProjectsLocationsWorkflowsExecutionsCallbacksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// callbacks to return per call. The default value is 100 and is also
// the maximum value.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) PageSize(pageSize int64) *ProjectsLocationsWorkflowsExecutionsCallbacksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListCallbacks` call. Provide this to
// retrieve the subsequent page. Note that pagination is applied to
// dynamic data. The list of callbacks returned can change between page
// requests if callbacks are created or deleted.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) PageToken(pageToken string) *ProjectsLocationsWorkflowsExecutionsCallbacksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsCallbacksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowsExecutionsCallbacksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsCallbacksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/callbacks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.callbacks.list" call.
// Exactly one of *ListCallbacksResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListCallbacksResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) Do(opts ...googleapi.CallOption) (*ListCallbacksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCallbacksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of active callbacks that belong to the execution with the given name. The returned callbacks are ordered by callback ID.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions/{executionsId}/callbacks",
	//   "httpMethod": "GET",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.callbacks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Maximum number of callbacks to return per call. The default value is 100 and is also the maximum value.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListCallbacks` call. Provide this to retrieve the subsequent page. Note that pagination is applied to dynamic data. The list of callbacks returned can change between page requests if callbacks are created or deleted.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the execution for which the callbacks should be listed. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+/executions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/callbacks",
	//   "response": {
	//     "$ref": "ListCallbacksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWorkflowsExecutionsCallbacksListCall) Pages(ctx context.Context, f func(*ListCallbacksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "workflowexecutions.projects.locations.workflows.executions.stepEntries.get":

type ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a step entry.
//
//   - name: The name of the step entry to retrieve. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}/executi
//     ons/{execution}/stepEntries/{step_entry}.
func (r *ProjectsLocationsWorkflowsExecutionsStepEntriesService) Get(name string) *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall {
	c := &ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.stepEntries.get" call.
// Exactly one of *StepEntry or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *StepEntry.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesGetCall) Do(opts ...googleapi.CallOption) (*StepEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StepEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a step entry.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions/{executionsId}/stepEntries/{stepEntriesId}",
	//   "httpMethod": "GET",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.stepEntries.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the step entry to retrieve. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}/stepEntries/{step_entry}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+/executions/[^/]+/stepEntries/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "StepEntry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "workflowexecutions.projects.locations.workflows.executions.stepEntries.list":

type ProjectsLocationsWorkflowsExecutionsStepEntriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists step entries for the corresponding workflow execution.
// Returned entries are ordered by their create_time.
//
//   - parent: Name of the workflow execution to list entries for. Format:
//     projects/{project}/locations/{location}/workflows/{workflow}/executi
//     ons/{execution}/stepEntries/.
func (r *ProjectsLocationsWorkflowsExecutionsStepEntriesService) List(parent string) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c := &ProjectsLocationsWorkflowsExecutionsStepEntriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filters applied to the
// `[StepEntries.ListStepEntries]` results. The following fields are
// supported for filtering: `entryId`, `createTime`, `updateTime`,
// `routine`, `step`, `stepType`, `state`. For details, see AIP-160. For
// example, if you are using the Google APIs Explorer:
// `state="SUCCEEDED" or `createTime>"2023-08-01" AND state="FAILED"
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Filter(filter string) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list
// of fields that specify the ordering applied to the
// `[StepEntries.ListStepEntries]` results. By default the ordering is
// based on ascending `entryId`. The following fields are supported for
// ordering: `entryId`, `createTime`, `updateTime`, `routine`, `step`,
// `stepType`, `state`. For details, see AIP-132.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) OrderBy(orderBy string) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of step
// entries to return per call. The default max is 1000.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) PageSize(pageSize int64) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListStepEntries` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListStepEntries` must match the call that provided the
// page token.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) PageToken(pageToken string) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Skip sets the optional parameter "skip": The number of step entries
// to skip. It can be used with or without a pageToken. If used with a
// pageToken, then it indicates the number of step entries to skip
// starting from the requested page.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Skip(skip int64) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.urlParams_.Set("skip", fmt.Sprint(skip))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Context(ctx context.Context) *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/stepEntries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "workflowexecutions.projects.locations.workflows.executions.stepEntries.list" call.
// Exactly one of *ListStepEntriesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListStepEntriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Do(opts ...googleapi.CallOption) (*ListStepEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListStepEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists step entries for the corresponding workflow execution. Returned entries are ordered by their create_time.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/executions/{executionsId}/stepEntries",
	//   "httpMethod": "GET",
	//   "id": "workflowexecutions.projects.locations.workflows.executions.stepEntries.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filters applied to the `[StepEntries.ListStepEntries]` results. The following fields are supported for filtering: `entryId`, `createTime`, `updateTime`, `routine`, `step`, `stepType`, `state`. For details, see AIP-160. For example, if you are using the Google APIs Explorer: `state=\"SUCCEEDED\"` or `createTime\u003e\"2023-08-01\" AND state=\"FAILED\"`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Comma-separated list of fields that specify the ordering applied to the `[StepEntries.ListStepEntries]` results. By default the ordering is based on ascending `entryId`. The following fields are supported for ordering: `entryId`, `createTime`, `updateTime`, `routine`, `step`, `stepType`, `state`. For details, see AIP-132.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Number of step entries to return per call. The default max is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A page token, received from a previous `ListStepEntries` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListStepEntries` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the workflow execution to list entries for. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}/stepEntries/",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/workflows/[^/]+/executions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "skip": {
	//       "description": "Optional. The number of step entries to skip. It can be used with or without a pageToken. If used with a pageToken, then it indicates the number of step entries to skip starting from the requested page.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     }
	//   },
	//   "path": "v1/{+parent}/stepEntries",
	//   "response": {
	//     "$ref": "ListStepEntriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWorkflowsExecutionsStepEntriesListCall) Pages(ctx context.Context, f func(*ListStepEntriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
