// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plog

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestLogs_MoveTo(t *testing.T) {
	ms := generateTestLogs()
	dest := NewLogs()
	ms.MoveTo(dest)
	assert.Equal(t, NewLogs(), ms)
	assert.Equal(t, generateTestLogs(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestLogs(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newLogs(internal.NewExportLogsServiceRequest(), sharedState)) })
	assert.Panics(t, func() { newLogs(internal.NewExportLogsServiceRequest(), sharedState).MoveTo(dest) })
}

func TestLogs_CopyTo(t *testing.T) {
	ms := NewLogs()
	orig := NewLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newLogs(internal.NewExportLogsServiceRequest(), sharedState)) })
}

func TestLogs_ResourceLogs(t *testing.T) {
	ms := NewLogs()
	assert.Equal(t, NewResourceLogsSlice(), ms.ResourceLogs())
	ms.getOrig().ResourceLogs = internal.GenTestResourceLogsPtrSlice()
	assert.Equal(t, generateTestResourceLogsSlice(), ms.ResourceLogs())
}

func generateTestLogs() Logs {
	return newLogs(internal.GenTestExportLogsServiceRequest(), internal.NewState())
}
