// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySpanEvent(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanEvent() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSpanEvent()
				CopySpanEvent(dest, src)
				assert.Equal(t, src, dest)
				CopySpanEvent(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySpanEventSlice(t *testing.T) {
	src := []SpanEvent{}
	dest := []SpanEvent{}
	// Test CopyTo empty
	dest = CopySpanEventSlice(dest, src)
	assert.Equal(t, []SpanEvent{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanEventSlice()
	dest = CopySpanEventSlice(dest, src)
	assert.Equal(t, GenTestSpanEventSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanEventSlice(dest, src)
	assert.Equal(t, GenTestSpanEventSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanEventSlice(dest, []SpanEvent{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanEventSlice(dest, src)
	assert.Equal(t, GenTestSpanEventSlice(), dest)
}

func TestCopySpanEventPtrSlice(t *testing.T) {
	src := []*SpanEvent{}
	dest := []*SpanEvent{}
	// Test CopyTo empty
	dest = CopySpanEventPtrSlice(dest, src)
	assert.Equal(t, []*SpanEvent{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanEventPtrSlice()
	dest = CopySpanEventPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanEventPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanEventPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanEventPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanEventPtrSlice(dest, []*SpanEvent{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanEventPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanEventPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSpanEventUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSpanEvent()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSpanEvent(), dest)
}

func TestMarshalAndUnmarshalJSONSpanEvent(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanEvent() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSpanEvent()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSpanEvent(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSpanEventFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSpanEvent() {
		t.Run(name, func(t *testing.T) {
			dest := NewSpanEvent()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSpanEventUnknown(t *testing.T) {
	dest := NewSpanEvent()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSpanEvent(), dest)
}

func TestMarshalAndUnmarshalProtoSpanEvent(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanEvent() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSpanEvent()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSpanEvent(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSpanEvent(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanEvent() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.Span_Event{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSpanEvent()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSpanEvent() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"TimeUnixNano/wrong_wire_type":           {0xc},
		"TimeUnixNano/missing_value":             {0x9},
		"Name/wrong_wire_type":                   {0x14},
		"Name/missing_value":                     {0x12},
		"Attributes/wrong_wire_type":             {0x1c},
		"Attributes/missing_value":               {0x1a},
		"DroppedAttributesCount/wrong_wire_type": {0x24},
		"DroppedAttributesCount/missing_value":   {0x20},
	}
}

func genTestEncodingValuesSpanEvent() map[string]*SpanEvent {
	return map[string]*SpanEvent{
		"empty":                       NewSpanEvent(),
		"TimeUnixNano/test":           {TimeUnixNano: uint64(13)},
		"Name/test":                   {Name: "test_name"},
		"Attributes/test":             {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
	}
}
