// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestExponentialHistogramDataPointBuckets_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogramDataPointBuckets()
	dest := NewExponentialHistogramDataPointBuckets()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), ms)
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		ms.MoveTo(newExponentialHistogramDataPointBuckets(internal.NewOrigExponentialHistogramDataPoint_Buckets(), sharedState))
	})
	assert.Panics(t, func() {
		newExponentialHistogramDataPointBuckets(internal.NewOrigExponentialHistogramDataPoint_Buckets(), sharedState).MoveTo(dest)
	})
}

func TestExponentialHistogramDataPointBuckets_CopyTo(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	orig := NewExponentialHistogramDataPointBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExponentialHistogramDataPointBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		ms.CopyTo(newExponentialHistogramDataPointBuckets(internal.NewOrigExponentialHistogramDataPoint_Buckets(), sharedState))
	})
}

func TestExponentialHistogramDataPointBuckets_Offset(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	assert.Equal(t, int32(0), ms.Offset())
	ms.SetOffset(int32(13))
	assert.Equal(t, int32(13), ms.Offset())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExponentialHistogramDataPointBuckets(&otlpmetrics.ExponentialHistogramDataPoint_Buckets{}, sharedState).SetOffset(int32(13))
	})
}

func TestExponentialHistogramDataPointBuckets_BucketCounts(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	assert.Equal(t, pcommon.NewUInt64Slice(), ms.BucketCounts())
	ms.orig.BucketCounts = internal.GenerateOrigTestUint64Slice()
	assert.Equal(t, pcommon.UInt64Slice(internal.GenerateTestUInt64Slice()), ms.BucketCounts())
}

func generateTestExponentialHistogramDataPointBuckets() ExponentialHistogramDataPointBuckets {
	ms := newExponentialHistogramDataPointBuckets(internal.GenTestOrigExponentialHistogramDataPoint_Buckets(), internal.NewState())
	return ms
}
