// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlplogs "go.opentelemetry.io/proto/slim/otlp/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigResourceLogs()
				CopyOrigResourceLogs(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigResourceLogs(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigResourceLogsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigResourceLogs()
	UnmarshalJSONOrigResourceLogs(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigResourceLogs(), dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigResourceLogs(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigResourceLogs()
				UnmarshalJSONOrigResourceLogs(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigResourceLogs(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceLogsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResourceLogs() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigResourceLogs()
			require.Error(t, UnmarshalProtoOrigResourceLogs(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceLogsUnknown(t *testing.T) {
	dest := NewOrigResourceLogs()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigResourceLogs(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigResourceLogs(), dest)
}

func TestMarshalAndUnmarshalProtoOrigResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigResourceLogs(src))
				gotSize := MarshalProtoOrigResourceLogs(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigResourceLogs()
				require.NoError(t, UnmarshalProtoOrigResourceLogs(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigResourceLogs(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResourceLogs(src))
			gotSize := MarshalProtoOrigResourceLogs(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlplogs.ResourceLogs{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigResourceLogs()
			require.NoError(t, UnmarshalProtoOrigResourceLogs(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResourceLogs() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Resource/wrong_wire_type":  {0xc},
		"Resource/missing_value":    {0xa},
		"ScopeLogs/wrong_wire_type": {0x14},
		"ScopeLogs/missing_value":   {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesResourceLogs() map[string]*otlplogs.ResourceLogs {
	return map[string]*otlplogs.ResourceLogs{
		"empty":                      NewOrigResourceLogs(),
		"Resource/test":              {Resource: *GenTestOrigResource()},
		"ScopeLogs/default_and_test": {ScopeLogs: []*otlplogs.ScopeLogs{{}, GenTestOrigScopeLogs()}},
		"SchemaUrl/test":             {SchemaUrl: "test_schemaurl"},
	}
}
