// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigProfileSlice(t *testing.T) {
	src := []*otlpprofiles.Profile{}
	dest := []*otlpprofiles.Profile{}
	// Test CopyTo empty
	dest = CopyOrigProfileSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Profile{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestProfileSlice()
	dest = CopyOrigProfileSlice(dest, src)
	assert.Equal(t, GenerateOrigTestProfileSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigProfileSlice(dest, src)
	assert.Equal(t, GenerateOrigTestProfileSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigProfileSlice(dest, []*otlpprofiles.Profile{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigProfileSlice(dest, src)
	assert.Equal(t, GenerateOrigTestProfileSlice(), dest)
}
