// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyNumberDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesNumberDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewNumberDataPoint()
				CopyNumberDataPoint(dest, src)
				assert.Equal(t, src, dest)
				CopyNumberDataPoint(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyNumberDataPointSlice(t *testing.T) {
	src := []NumberDataPoint{}
	dest := []NumberDataPoint{}
	// Test CopyTo empty
	dest = CopyNumberDataPointSlice(dest, src)
	assert.Equal(t, []NumberDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestNumberDataPointSlice()
	dest = CopyNumberDataPointSlice(dest, src)
	assert.Equal(t, GenTestNumberDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyNumberDataPointSlice(dest, src)
	assert.Equal(t, GenTestNumberDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyNumberDataPointSlice(dest, []NumberDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyNumberDataPointSlice(dest, src)
	assert.Equal(t, GenTestNumberDataPointSlice(), dest)
}

func TestCopyNumberDataPointPtrSlice(t *testing.T) {
	src := []*NumberDataPoint{}
	dest := []*NumberDataPoint{}
	// Test CopyTo empty
	dest = CopyNumberDataPointPtrSlice(dest, src)
	assert.Equal(t, []*NumberDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestNumberDataPointPtrSlice()
	dest = CopyNumberDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestNumberDataPointPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyNumberDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestNumberDataPointPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyNumberDataPointPtrSlice(dest, []*NumberDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyNumberDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestNumberDataPointPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONNumberDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewNumberDataPoint()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewNumberDataPoint(), dest)
}

func TestMarshalAndUnmarshalJSONNumberDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesNumberDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewNumberDataPoint()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteNumberDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoNumberDataPointFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesNumberDataPoint() {
		t.Run(name, func(t *testing.T) {
			dest := NewNumberDataPoint()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoNumberDataPointUnknown(t *testing.T) {
	dest := NewNumberDataPoint()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewNumberDataPoint(), dest)
}

func TestMarshalAndUnmarshalProtoNumberDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesNumberDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewNumberDataPoint()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteNumberDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufNumberDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesNumberDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.NumberDataPoint{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewNumberDataPoint()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesNumberDataPoint() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                     {0x02},
		"Attributes/wrong_wire_type":        {0x3c},
		"Attributes/missing_value":          {0x3a},
		"StartTimeUnixNano/wrong_wire_type": {0x14},
		"StartTimeUnixNano/missing_value":   {0x11},
		"TimeUnixNano/wrong_wire_type":      {0x1c},
		"TimeUnixNano/missing_value":        {0x19},

		"AsDouble/wrong_wire_type": {0x24},
		"AsDouble/missing_value":   {0x21},

		"AsInt/wrong_wire_type":     {0x34},
		"AsInt/missing_value":       {0x31},
		"Exemplars/wrong_wire_type": {0x2c},
		"Exemplars/missing_value":   {0x2a},
		"Flags/wrong_wire_type":     {0x44},
		"Flags/missing_value":       {0x40},
	}
}

func genTestEncodingValuesNumberDataPoint() map[string]*NumberDataPoint {
	return map[string]*NumberDataPoint{
		"empty":                  NewNumberDataPoint(),
		"Attributes/test":        {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"StartTimeUnixNano/test": {StartTimeUnixNano: uint64(13)},
		"TimeUnixNano/test":      {TimeUnixNano: uint64(13)},
		"AsDouble/default":       {Value: &NumberDataPoint_AsDouble{AsDouble: float64(0)}},
		"AsDouble/test":          {Value: &NumberDataPoint_AsDouble{AsDouble: float64(3.1415926)}},
		"AsInt/default":          {Value: &NumberDataPoint_AsInt{AsInt: int64(0)}},
		"AsInt/test":             {Value: &NumberDataPoint_AsInt{AsInt: int64(13)}},
		"Exemplars/test":         {Exemplars: []Exemplar{{}, *GenTestExemplar()}},
		"Flags/test":             {Flags: uint32(13)},
	}
}
