// © Broadcom. All Rights Reserved.
// The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
// SPDX-License-Identifier: Apache-2.0

package esx

import "github.com/vmware/govmomi/vim25/types"

// RoleList is the default template for the AuthorizationManager roleList property.
// Capture method:
// govc object.collect -s -dump AuthorizationManager:ha-authmgr roleList
var RoleList = []types.AuthorizationRole{
	{
		RoleId: -8,
		System: true,
		Name:   "NoTrustedAdmin",
		Info: &types.Description{
			Label:   "No Trusted Infrastructure administrator",
			Summary: "Full access without Trusted Infrastructure privileges",
		},
		Privilege: []string{"Alarm.Acknowledge", "Alarm.Create", "Alarm.Delete", "Alarm.DisableActions", "Alarm.Edit", "Alarm.SetStatus", "Alarm.ToggleEnableOnEntity", "Authorization.ModifyPermissions", "Authorization.ModifyPrivileges", "Authorization.ModifyRoles", "Authorization.ModifyVTContainerMappings", "Authorization.ModifyVTContainers", "Authorization.ReassignRolePermissions", "AutoDeploy.Host.AssociateMachine", "AutoDeploy.Profile.Create", "AutoDeploy.Profile.Edit", "AutoDeploy.Rule.Create", "AutoDeploy.Rule.Delete", "AutoDeploy.Rule.Edit", "AutoDeploy.RuleSet.Activate", "AutoDeploy.RuleSet.Edit", "Certificate.Manage", "CertificateAuthority.Administer", "CertificateAuthority.Manage", "CertificateManagement.Administer", "CertificateManagement.Manage", "CertificateManagementSubscriptions.Create", "CertificateManagementSubscriptions.Delete", "CertificateManagementSubscriptions.Update", "Cns.Searchable", "ComputePolicy.Manage", "ContentLibrary.AddCertToTrustStore", "ContentLibrary.AddLibraryItem", "ContentLibrary.AddSubscription", "ContentLibrary.CheckInTemplate", "ContentLibrary.CheckOutTemplate", "ContentLibrary.CreateLocalLibrary", "ContentLibrary.CreateSubscribedLibrary", "ContentLibrary.DeleteCertFromTrustStore", "ContentLibrary.DeleteLibraryItem", "ContentLibrary.DeleteLocalLibrary", "ContentLibrary.DeleteSubscribedLibrary", "ContentLibrary.DeleteSubscription", "ContentLibrary.DownloadSession", "ContentLibrary.EvictLibraryItem", "ContentLibrary.EvictSubscribedLibrary", "ContentLibrary.GetConfiguration", "ContentLibrary.ImportStorage", "ContentLibrary.ManageClusterRegistryResource", "ContentLibrary.ManageRegistry", "ContentLibrary.ManageRegistryProject", "ContentLibrary.MigrateLibrary", "ContentLibrary.ProbeSubscription", "ContentLibrary.PublishLibrary", "ContentLibrary.PublishLibraryItem", "ContentLibrary.ReadStorage", "ContentLibrary.SyncLibrary", "ContentLibrary.SyncLibraryItem", "ContentLibrary.TypeIntrospection", "ContentLibrary.UpdateConfiguration", "ContentLibrary.UpdateLibrary", "ContentLibrary.UpdateLibraryItem", "ContentLibrary.UpdateLocalLibrary", "ContentLibrary.UpdateSession", "ContentLibrary.UpdateSubscribedLibrary", "ContentLibrary.UpdateSubscription", "Cryptographer.Access", "Cryptographer.AddDisk", "Cryptographer.Clone", "Cryptographer.Decrypt", "Cryptographer.Encrypt", "Cryptographer.EncryptNew", "Cryptographer.ManageEncryptionPolicy", "Cryptographer.ManageKeyServers", "Cryptographer.ManageKeys", "Cryptographer.Migrate", "Cryptographer.ReadKeyServersInfo", "Cryptographer.Recrypt", "Cryptographer.RegisterHost", "Cryptographer.RegisterVM", "DVPortgroup.Create", "DVPortgroup.Delete", "DVPortgroup.Modify", "DVPortgroup.PolicyOp", "DVPortgroup.ScopeOp", "DVSwitch.Create", "DVSwitch.Delete", "DVSwitch.HostOp", "DVSwitch.Modify", "DVSwitch.Move", "DVSwitch.PolicyOp", "DVSwitch.PortConfig", "DVSwitch.PortSetting", "DVSwitch.ResourceManagement", "DVSwitch.Vspan", "Datacenter.Create", "Datacenter.Delete", "Datacenter.IpPoolConfig", "Datacenter.IpPoolQueryAllocations", "Datacenter.IpPoolReleaseIp", "Datacenter.Move", "Datacenter.Reconfigure", "Datacenter.Rename", "Datacenter.UpdateCarbonInfo", "Datastore.AllocateSpace", "Datastore.Browse", "Datastore.Config", "Datastore.ConfigIOManagement", "Datastore.Delete", "Datastore.DeleteFile", "Datastore.FileManagement", "Datastore.Move", "Datastore.Rename", "Datastore.UpdateVirtualMachineFiles", "Datastore.UpdateVirtualMachineMetadata", "DirectPathProfileManager.Manage", "DrProxy.Host.Configure", "DrProxy.Host.ManageService", "DrProxy.Host.View", "DrProxy.License.Update", "DrProxy.License.View", "DrProxy.Progress.Control", "DrProxy.Vm.Configure", "EAM.Config", "EAM.Modify", "EAM.View", "Extension.Register", "Extension.Unregister", "Extension.Update", "ExternalStatsProvider.Register", "ExternalStatsProvider.Unregister", "ExternalStatsProvider.Update", "Folder.Create", "Folder.Delete", "Folder.ExternalFolderManagement", "Folder.Move", "Folder.Rename", "FoundationLoadBalancers.Manage", "Global.CancelTask", "Global.CapacityPlanning", "Global.Diagnostics", "Global.DisableMethods", "Global.EnableMethods", "Global.GlobalTag", "Global.Health", "Global.Licenses", "Global.LogEvent", "Global.ManageCustomFields", "Global.Proxy", "Global.ScriptAction", "Global.ServiceManagers", "Global.SetCustomField", "Global.Settings", "Global.SystemTag", "Global.VCServer", "GuestDataPublisher.GetData", "HLM.Create", "HLM.Manage", "HealthUpdateProvider.Register", "HealthUpdateProvider.Unregister", "HealthUpdateProvider.Update", "Host.Cim.CimInteraction", "Host.Config.AdvancedConfig", "Host.Config.AuthenticationStore", "Host.Config.AutoStart", "Host.Config.Connection", "Host.Config.DateTime", "Host.Config.Firmware", "Host.Config.GuestStore", "Host.Config.HyperThreading", "Host.Config.Image", "Host.Config.Maintenance", "Host.Config.Memory", "Host.Config.NetService", "Host.Config.Network", "Host.Config.Nvdimm", "Host.Config.Patch", "Host.Config.PciPassthru", "Host.Config.Power", "Host.Config.ProductLocker", "Host.Config.Quarantine", "Host.Config.Resources", "Host.Config.Settings", "Host.Config.Snmp", "Host.Config.Storage", "Host.Config.SystemFirewallRuleSet", "Host.Config.SystemManagement", "Host.Entropy.Read", "Host.Entropy.Write", "Host.Hbr.HbrDaemonManagement", "Host.Hbr.HbrManagement", "Host.Inventory.AddHostToCluster", "Host.Inventory.AddStandaloneHost", "Host.Inventory.CreateCluster", "Host.Inventory.DeleteCluster", "Host.Inventory.EditCluster", "Host.Inventory.ManageClusterLifecyle", "Host.Inventory.MoveCluster", "Host.Inventory.MoveHost", "Host.Inventory.RemoveHostFromCluster", "Host.Inventory.RenameCluster", "Host.Local.CreateVM", "Host.Local.DeleteVM", "Host.Local.InstallAgent", "Host.Local.ManageUserGroups", "Host.Local.ReconfigVM", "Host.Sgx.Register", "Host.Stats.Query", "Infraprofile.Read", "Infraprofile.Write", "IntercomNamespace.Read", "IntercomNamespace.Write", "InventoryService.Tagging.AttachTag", "InventoryService.Tagging.CreateCategory", "InventoryService.Tagging.CreateTag", "InventoryService.Tagging.DeleteCategory", "InventoryService.Tagging.DeleteTag", "InventoryService.Tagging.EditCategory", "InventoryService.Tagging.EditTag", "InventoryService.Tagging.ModifyUsedByForCategory", "InventoryService.Tagging.ModifyUsedByForTag", "InventoryService.Tagging.ObjectAttachable", "Namespaces.Backup", "Namespaces.Configure", "Namespaces.ListAccess", "Namespaces.Manage", "Namespaces.ManageCapabilities", "Namespaces.ManageDisks", "Namespaces.SelfServiceManage", "Namespaces.Upgrade", "Network.Assign", "Network.Config", "Network.Delete", "Network.Move", "Nsx.Manage", "Nsx.ModifyAll", "Nsx.Read", "Observability.Admin", "Observability.StatsProvider.Manage", "OvfManager.OvfConsumerAccess", "PartnerRestDaemon.Read", "PartnerRestDaemon.Write", "Performance.ModifyIntervals", "Plugin.Management", "Profile.Clear", "Profile.Create", "Profile.Delete", "Profile.Edit", "Profile.Export", "Profile.View", "ReplicationService.Administer", "Resource.ApplyRecommendation", "Resource.AssignVAppToPool", "Resource.AssignVMToPool", "Resource.ColdMigrate", "Resource.CreatePool", "Resource.DeletePool", "Resource.EditPool", "Resource.HotMigrate", "Resource.MovePool", "Resource.QueryVMotion", "Resource.RenamePool", "ScheduledTask.Create", "ScheduledTask.Delete", "ScheduledTask.Edit", "ScheduledTask.Run", "ServiceAccount.Administer", "ServiceAccount.ManageAccount", "ServiceAccount.ManagePassword", "Sessions.CollectPrivilegeChecks", "Sessions.GlobalMessage", "Sessions.ImpersonateUser", "Sessions.TerminateSession", "Sessions.ValidateSession", "SettingsStore.Manage", "StoragePod.Config", "StorageProfile.Apply", "StorageProfile.Update", "StorageProfile.View", "StorageViews.ConfigureService", "StorageViews.View", "SupervisorServices.Install", "SupervisorServices.Manage", "System.Anonymous", "System.Read", "System.View", "Task.Create", "Task.Update", "Task.Update.Task.Update", "TenantManager.Query", "TenantManager.Update", "TokenService.PersistableTokenExchange", "TransferService.Manage", "TransferService.Monitor", "Trust.Administer", "Trust.Manage", "VApp.ApplicationConfig", "VApp.AssignResourcePool", "VApp.AssignVApp", "VApp.AssignVM", "VApp.Clone", "VApp.Create", "VApp.Delete", "VApp.Export", "VApp.ExtractOvfEnvironment", "VApp.Import", "VApp.InstanceConfig", "VApp.ManagedByConfig", "VApp.Move", "VApp.PowerOff", "VApp.PowerOn", "VApp.PullFromUrls", "VApp.Rename", "VApp.ResourceConfig", "VApp.Suspend", "VApp.Unregister", "VcIdentityProviders.Create", "VcIdentityProviders.Manage", "VcIdentityProviders.Read", "VcIntegrity.Baseline.com.vmware.vcIntegrity.AssignBaselines", "VcIntegrity.Baseline.com.vmware.vcIntegrity.ManageBaselines", "VcIntegrity.ClusterConfiguration.Export", "VcIntegrity.ClusterConfiguration.Modify", "VcIntegrity.ClusterConfiguration.Remediate", "VcIntegrity.ClusterConfiguration.View", "VcIntegrity.FileUpload.com.vmware.vcIntegrity.ImportFile", "VcIntegrity.General.com.vmware.vcIntegrity.Configure", "VcIntegrity.HardwareCompatibility.Read", "VcIntegrity.HardwareCompatibility.Write", "VcIntegrity.Updates.com.vmware.vcIntegrity.Remediate", "VcIntegrity.Updates.com.vmware.vcIntegrity.Scan", "VcIntegrity.Updates.com.vmware.vcIntegrity.Stage", "VcIntegrity.Updates.com.vmware.vcIntegrity.ViewStatus", "VcIntegrity.lifecycleDepots.Delete", "VcIntegrity.lifecycleGeneral.Read", "VcIntegrity.lifecycleGeneral.Write", "VcIntegrity.lifecycleHealth.Read", "VcIntegrity.lifecycleHealth.Write", "VcIntegrity.lifecycleSettings.Read", "VcIntegrity.lifecycleSettings.Write", "VcIntegrity.lifecycleSoftwareRemediation.Read", "VcIntegrity.lifecycleSoftwareRemediation.Write", "VcIntegrity.lifecycleSoftwareSpecification.Read", "VcIntegrity.lifecycleSoftwareSpecification.Write", "VcIntegrity.systemVM.Read", "VcIntegrity.systemVM.Write", "VcLifecycle.Upgrade", "VcLifecycle.View", "VirtualMachine.Config.AddExistingDisk", "VirtualMachine.Config.AddNewDisk", "VirtualMachine.Config.AddRemoveDevice", "VirtualMachine.Config.AdvancedConfig", "VirtualMachine.Config.Annotation", "VirtualMachine.Config.CPUCount", "VirtualMachine.Config.ChangeTracking", "VirtualMachine.Config.DiskExtend", "VirtualMachine.Config.DiskLease", "VirtualMachine.Config.EditDevice", "VirtualMachine.Config.HostUSBDevice", "VirtualMachine.Config.ManagedBy", "VirtualMachine.Config.Memory", "VirtualMachine.Config.MksControl", "VirtualMachine.Config.QueryFTCompatibility", "VirtualMachine.Config.QueryUnownedFiles", "VirtualMachine.Config.RawDevice", "VirtualMachine.Config.ReloadFromPath", "VirtualMachine.Config.RemoveDisk", "VirtualMachine.Config.Rename", "VirtualMachine.Config.ResetGuestInfo", "VirtualMachine.Config.Resource", "VirtualMachine.Config.Settings", "VirtualMachine.Config.SwapPlacement", "VirtualMachine.Config.ToggleForkParent", "VirtualMachine.Config.UpgradeVirtualHardware", "VirtualMachine.DataSets.DataSetCreate", "VirtualMachine.DataSets.DataSetDelete", "VirtualMachine.DataSets.DataSetEntryDelete", "VirtualMachine.DataSets.DataSetEntryGet", "VirtualMachine.DataSets.DataSetEntryList", "VirtualMachine.DataSets.DataSetEntrySet", "VirtualMachine.DataSets.DataSetGet", "VirtualMachine.DataSets.DataSetList", "VirtualMachine.DataSets.DataSetUpdate", "VirtualMachine.DataSets.Export", "VirtualMachine.GuestOperations.Execute", "VirtualMachine.GuestOperations.Modify", "VirtualMachine.GuestOperations.ModifyAliases", "VirtualMachine.GuestOperations.Query", "VirtualMachine.GuestOperations.QueryAliases", "VirtualMachine.Hbr.ConfigureReplication", "VirtualMachine.Hbr.MonitorReplication", "VirtualMachine.Hbr.ReplicaManagement", "VirtualMachine.Interact.AnswerQuestion", "VirtualMachine.Interact.Backup", "VirtualMachine.Interact.ConsoleInteract", "VirtualMachine.Interact.CreateScreenshot", "VirtualMachine.Interact.CreateSecondary", "VirtualMachine.Interact.DefragmentAllDisks", "VirtualMachine.Interact.DeviceConnection", "VirtualMachine.Interact.DisableSecondary", "VirtualMachine.Interact.DnD", "VirtualMachine.Interact.EnableSecondary", "VirtualMachine.Interact.GuestControl", "VirtualMachine.Interact.MakePrimary", "VirtualMachine.Interact.Pause", "VirtualMachine.Interact.PowerOff", "VirtualMachine.Interact.PowerOn", "VirtualMachine.Interact.PutUsbScanCodes", "VirtualMachine.Interact.Record", "VirtualMachine.Interact.Replay", "VirtualMachine.Interact.Reset", "VirtualMachine.Interact.SESparseMaintenance", "VirtualMachine.Interact.SetCDMedia", "VirtualMachine.Interact.SetFloppyMedia", "VirtualMachine.Interact.Suspend", "VirtualMachine.Interact.SuspendToMemory", "VirtualMachine.Interact.TerminateFaultTolerantVM", "VirtualMachine.Interact.ToolsInstall", "VirtualMachine.Interact.TurnOffFaultTolerance", "VirtualMachine.Inventory.Create", "VirtualMachine.Inventory.CreateFromExisting", "VirtualMachine.Inventory.Delete", "VirtualMachine.Inventory.Move", "VirtualMachine.Inventory.Register", "VirtualMachine.Inventory.Unregister", "VirtualMachine.Namespace.Event", "VirtualMachine.Namespace.EventNotify", "VirtualMachine.Namespace.Management", "VirtualMachine.Namespace.ModifyContent", "VirtualMachine.Namespace.Query", "VirtualMachine.Namespace.ReadContent", "VirtualMachine.Provisioning.Clone", "VirtualMachine.Provisioning.CloneTemplate", "VirtualMachine.Provisioning.CreateTemplateFromVM", "VirtualMachine.Provisioning.Customize", "VirtualMachine.Provisioning.DeployTemplate", "VirtualMachine.Provisioning.DiskRandomAccess", "VirtualMachine.Provisioning.DiskRandomRead", "VirtualMachine.Provisioning.FileRandomAccess", "VirtualMachine.Provisioning.GetVmFiles", "VirtualMachine.Provisioning.MarkAsTemplate", "VirtualMachine.Provisioning.MarkAsVM", "VirtualMachine.Provisioning.ModifyCustSpecs", "VirtualMachine.Provisioning.PromoteDisks", "VirtualMachine.Provisioning.PutVmFiles", "VirtualMachine.Provisioning.ReadCustSpecs", "VirtualMachine.State.CreateSnapshot", "VirtualMachine.State.RemoveSnapshot", "VirtualMachine.State.RenameSnapshot", "VirtualMachine.State.RevertToSnapshot", "VirtualMachineClasses.Manage", "VmCam.Administer", "VmResourceProfiles.Manage", "Vsan.Cluster.ShallowRekey", "Vsan.Xvc.UpdateClientInfo", "Zone.Manage", "Zone.ObjectAttachable", "vSANStats.Access", "vService.CreateDependency", "vService.DestroyDependency", "vService.ReconfigureDependency", "vService.UpdateDependency", "vSphereClient.UtilizeVerificationCode", "vSphereDataProtection.Protection", "vSphereDataProtection.Recovery", "vStats.CollectAny", "vStats.QueryAny", "vStats.Settings"},
	},
	{
		RoleId: -7,
		System: true,
		Name:   "TrustedAdmin",
		Info: &types.Description{
			Label:   "Trusted Infrastructure administrator",
			Summary: "Setup and monitoring of Trusted Infrastructure",
		},
		Privilege: []string{"Host.Tpm.Read", "Host.Tpm.Unseal", "System.Anonymous", "System.Read", "System.View", "TrustedAdmin.ConfigureHostCertificates", "TrustedAdmin.ConfigureHostMetadata", "TrustedAdmin.ConfigureTokenConversionPolicy", "TrustedAdmin.ManageAttestingSSO", "TrustedAdmin.ManageKMSTrust", "TrustedAdmin.ManageTrustedHosts", "TrustedAdmin.ReadAttestingSSO", "TrustedAdmin.ReadKMSTrust", "TrustedAdmin.ReadStsInfo", "TrustedAdmin.ReadTrustedHosts", "TrustedAdmin.RetrieveHostMetadata", "TrustedAdmin.RetrieveTPMHostCertificates"},
	},
	{
		RoleId: -6,
		System: true,
		Name:   "NoCryptoAdmin",
		Info: &types.Description{
			Label:   "No cryptography administrator",
			Summary: "Full access without Cryptographic operations and Trusted Infrastructure privileges",
		},
		Privilege: []string{"Alarm.Acknowledge", "Alarm.Create", "Alarm.Delete", "Alarm.DisableActions", "Alarm.Edit", "Alarm.SetStatus", "Alarm.ToggleEnableOnEntity", "Authorization.ModifyPermissions", "Authorization.ModifyPrivileges", "Authorization.ModifyRoles", "Authorization.ModifyVTContainerMappings", "Authorization.ModifyVTContainers", "Authorization.ReassignRolePermissions", "AutoDeploy.Host.AssociateMachine", "AutoDeploy.Profile.Create", "AutoDeploy.Profile.Edit", "AutoDeploy.Rule.Create", "AutoDeploy.Rule.Delete", "AutoDeploy.Rule.Edit", "AutoDeploy.RuleSet.Activate", "AutoDeploy.RuleSet.Edit", "Certificate.Manage", "CertificateAuthority.Administer", "CertificateAuthority.Manage", "CertificateManagement.Administer", "CertificateManagement.Manage", "CertificateManagementSubscriptions.Create", "CertificateManagementSubscriptions.Delete", "CertificateManagementSubscriptions.Update", "Cns.Searchable", "ComputePolicy.Manage", "ContentLibrary.AddCertToTrustStore", "ContentLibrary.AddLibraryItem", "ContentLibrary.AddSubscription", "ContentLibrary.CheckInTemplate", "ContentLibrary.CheckOutTemplate", "ContentLibrary.CreateLocalLibrary", "ContentLibrary.CreateSubscribedLibrary", "ContentLibrary.DeleteCertFromTrustStore", "ContentLibrary.DeleteLibraryItem", "ContentLibrary.DeleteLocalLibrary", "ContentLibrary.DeleteSubscribedLibrary", "ContentLibrary.DeleteSubscription", "ContentLibrary.DownloadSession", "ContentLibrary.EvictLibraryItem", "ContentLibrary.EvictSubscribedLibrary", "ContentLibrary.GetConfiguration", "ContentLibrary.ImportStorage", "ContentLibrary.ManageClusterRegistryResource", "ContentLibrary.ManageRegistry", "ContentLibrary.ManageRegistryProject", "ContentLibrary.MigrateLibrary", "ContentLibrary.ProbeSubscription", "ContentLibrary.PublishLibrary", "ContentLibrary.PublishLibraryItem", "ContentLibrary.ReadStorage", "ContentLibrary.SyncLibrary", "ContentLibrary.SyncLibraryItem", "ContentLibrary.TypeIntrospection", "ContentLibrary.UpdateConfiguration", "ContentLibrary.UpdateLibrary", "ContentLibrary.UpdateLibraryItem", "ContentLibrary.UpdateLocalLibrary", "ContentLibrary.UpdateSession", "ContentLibrary.UpdateSubscribedLibrary", "ContentLibrary.UpdateSubscription", "DVPortgroup.Create", "DVPortgroup.Delete", "DVPortgroup.Modify", "DVPortgroup.PolicyOp", "DVPortgroup.ScopeOp", "DVSwitch.Create", "DVSwitch.Delete", "DVSwitch.HostOp", "DVSwitch.Modify", "DVSwitch.Move", "DVSwitch.PolicyOp", "DVSwitch.PortConfig", "DVSwitch.PortSetting", "DVSwitch.ResourceManagement", "DVSwitch.Vspan", "Datacenter.Create", "Datacenter.Delete", "Datacenter.IpPoolConfig", "Datacenter.IpPoolQueryAllocations", "Datacenter.IpPoolReleaseIp", "Datacenter.Move", "Datacenter.Reconfigure", "Datacenter.Rename", "Datacenter.UpdateCarbonInfo", "Datastore.AllocateSpace", "Datastore.Browse", "Datastore.Config", "Datastore.ConfigIOManagement", "Datastore.Delete", "Datastore.DeleteFile", "Datastore.FileManagement", "Datastore.Move", "Datastore.Rename", "Datastore.UpdateVirtualMachineFiles", "Datastore.UpdateVirtualMachineMetadata", "DirectPathProfileManager.Manage", "DrProxy.Host.Configure", "DrProxy.Host.ManageService", "DrProxy.Host.View", "DrProxy.License.Update", "DrProxy.License.View", "DrProxy.Progress.Control", "DrProxy.Vm.Configure", "EAM.Config", "EAM.Modify", "EAM.View", "Extension.Register", "Extension.Unregister", "Extension.Update", "ExternalStatsProvider.Register", "ExternalStatsProvider.Unregister", "ExternalStatsProvider.Update", "Folder.Create", "Folder.Delete", "Folder.ExternalFolderManagement", "Folder.Move", "Folder.Rename", "FoundationLoadBalancers.Manage", "Global.CancelTask", "Global.CapacityPlanning", "Global.DisableMethods", "Global.EnableMethods", "Global.GlobalTag", "Global.Health", "Global.Licenses", "Global.LogEvent", "Global.ManageCustomFields", "Global.Proxy", "Global.ScriptAction", "Global.ServiceManagers", "Global.SetCustomField", "Global.Settings", "Global.SystemTag", "Global.VCServer", "GuestDataPublisher.GetData", "HLM.Create", "HLM.Manage", "HealthUpdateProvider.Register", "HealthUpdateProvider.Unregister", "HealthUpdateProvider.Update", "Host.Cim.CimInteraction", "Host.Config.AdvancedConfig", "Host.Config.AuthenticationStore", "Host.Config.AutoStart", "Host.Config.Connection", "Host.Config.DateTime", "Host.Config.Firmware", "Host.Config.GuestStore", "Host.Config.HyperThreading", "Host.Config.Image", "Host.Config.Maintenance", "Host.Config.Memory", "Host.Config.NetService", "Host.Config.Network", "Host.Config.Nvdimm", "Host.Config.Patch", "Host.Config.PciPassthru", "Host.Config.Power", "Host.Config.ProductLocker", "Host.Config.Quarantine", "Host.Config.Resources", "Host.Config.Settings", "Host.Config.Snmp", "Host.Config.Storage", "Host.Config.SystemFirewallRuleSet", "Host.Config.SystemManagement", "Host.Entropy.Read", "Host.Entropy.Write", "Host.Hbr.HbrDaemonManagement", "Host.Hbr.HbrManagement", "Host.Inventory.CreateCluster", "Host.Inventory.DeleteCluster", "Host.Inventory.EditCluster", "Host.Inventory.ManageClusterLifecyle", "Host.Inventory.MoveCluster", "Host.Inventory.MoveHost", "Host.Inventory.RemoveHostFromCluster", "Host.Inventory.RenameCluster", "Host.Local.CreateVM", "Host.Local.DeleteVM", "Host.Local.InstallAgent", "Host.Local.ReconfigVM", "Host.Sgx.Register", "Host.Stats.Query", "Infraprofile.Read", "Infraprofile.Write", "IntercomNamespace.Read", "IntercomNamespace.Write", "InventoryService.Tagging.AttachTag", "InventoryService.Tagging.CreateCategory", "InventoryService.Tagging.CreateTag", "InventoryService.Tagging.DeleteCategory", "InventoryService.Tagging.DeleteTag", "InventoryService.Tagging.EditCategory", "InventoryService.Tagging.EditTag", "InventoryService.Tagging.ModifyUsedByForCategory", "InventoryService.Tagging.ModifyUsedByForTag", "InventoryService.Tagging.ObjectAttachable", "Namespaces.Backup", "Namespaces.Configure", "Namespaces.ListAccess", "Namespaces.Manage", "Namespaces.ManageCapabilities", "Namespaces.ManageDisks", "Namespaces.SelfServiceManage", "Namespaces.Upgrade", "Network.Assign", "Network.Config", "Network.Delete", "Network.Move", "Nsx.Manage", "Nsx.ModifyAll", "Nsx.Read", "Observability.Admin", "Observability.StatsProvider.Manage", "OvfManager.OvfConsumerAccess", "PartnerRestDaemon.Read", "PartnerRestDaemon.Write", "Performance.ModifyIntervals", "Plugin.Management", "Profile.Clear", "Profile.Create", "Profile.Delete", "Profile.Edit", "Profile.Export", "Profile.View", "ReplicationService.Administer", "Resource.ApplyRecommendation", "Resource.AssignVAppToPool", "Resource.AssignVMToPool", "Resource.ColdMigrate", "Resource.CreatePool", "Resource.DeletePool", "Resource.EditPool", "Resource.HotMigrate", "Resource.MovePool", "Resource.QueryVMotion", "Resource.RenamePool", "ScheduledTask.Create", "ScheduledTask.Delete", "ScheduledTask.Edit", "ScheduledTask.Run", "ServiceAccount.Administer", "ServiceAccount.ManageAccount", "ServiceAccount.ManagePassword", "Sessions.CollectPrivilegeChecks", "Sessions.GlobalMessage", "Sessions.ImpersonateUser", "Sessions.TerminateSession", "Sessions.ValidateSession", "SettingsStore.Manage", "StoragePod.Config", "StorageProfile.Apply", "StorageProfile.Update", "StorageProfile.View", "StorageViews.ConfigureService", "StorageViews.View", "SupervisorServices.Install", "SupervisorServices.Manage", "System.Anonymous", "System.Read", "System.View", "Task.Create", "Task.Update", "Task.Update.Task.Update", "TenantManager.Query", "TenantManager.Update", "TokenService.PersistableTokenExchange", "TransferService.Manage", "TransferService.Monitor", "Trust.Administer", "Trust.Manage", "VApp.ApplicationConfig", "VApp.AssignResourcePool", "VApp.AssignVApp", "VApp.AssignVM", "VApp.Clone", "VApp.Create", "VApp.Delete", "VApp.Export", "VApp.ExtractOvfEnvironment", "VApp.Import", "VApp.InstanceConfig", "VApp.ManagedByConfig", "VApp.Move", "VApp.PowerOff", "VApp.PowerOn", "VApp.PullFromUrls", "VApp.Rename", "VApp.ResourceConfig", "VApp.Suspend", "VApp.Unregister", "VcIdentityProviders.Create", "VcIdentityProviders.Manage", "VcIdentityProviders.Read", "VcIntegrity.Baseline.com.vmware.vcIntegrity.AssignBaselines", "VcIntegrity.Baseline.com.vmware.vcIntegrity.ManageBaselines", "VcIntegrity.ClusterConfiguration.Export", "VcIntegrity.ClusterConfiguration.Modify", "VcIntegrity.ClusterConfiguration.Remediate", "VcIntegrity.ClusterConfiguration.View", "VcIntegrity.FileUpload.com.vmware.vcIntegrity.ImportFile", "VcIntegrity.General.com.vmware.vcIntegrity.Configure", "VcIntegrity.HardwareCompatibility.Read", "VcIntegrity.HardwareCompatibility.Write", "VcIntegrity.Updates.com.vmware.vcIntegrity.Remediate", "VcIntegrity.Updates.com.vmware.vcIntegrity.Scan", "VcIntegrity.Updates.com.vmware.vcIntegrity.Stage", "VcIntegrity.Updates.com.vmware.vcIntegrity.ViewStatus", "VcIntegrity.lifecycleDepots.Delete", "VcIntegrity.lifecycleGeneral.Read", "VcIntegrity.lifecycleGeneral.Write", "VcIntegrity.lifecycleHealth.Read", "VcIntegrity.lifecycleHealth.Write", "VcIntegrity.lifecycleSettings.Read", "VcIntegrity.lifecycleSettings.Write", "VcIntegrity.lifecycleSoftwareRemediation.Read", "VcIntegrity.lifecycleSoftwareRemediation.Write", "VcIntegrity.lifecycleSoftwareSpecification.Read", "VcIntegrity.lifecycleSoftwareSpecification.Write", "VcIntegrity.systemVM.Read", "VcIntegrity.systemVM.Write", "VcLifecycle.Upgrade", "VcLifecycle.View", "VirtualMachine.Config.AddExistingDisk", "VirtualMachine.Config.AddNewDisk", "VirtualMachine.Config.AddRemoveDevice", "VirtualMachine.Config.AdvancedConfig", "VirtualMachine.Config.Annotation", "VirtualMachine.Config.CPUCount", "VirtualMachine.Config.ChangeTracking", "VirtualMachine.Config.DiskExtend", "VirtualMachine.Config.DiskLease", "VirtualMachine.Config.EditDevice", "VirtualMachine.Config.HostUSBDevice", "VirtualMachine.Config.ManagedBy", "VirtualMachine.Config.Memory", "VirtualMachine.Config.MksControl", "VirtualMachine.Config.QueryFTCompatibility", "VirtualMachine.Config.QueryUnownedFiles", "VirtualMachine.Config.RawDevice", "VirtualMachine.Config.ReloadFromPath", "VirtualMachine.Config.RemoveDisk", "VirtualMachine.Config.Rename", "VirtualMachine.Config.ResetGuestInfo", "VirtualMachine.Config.Resource", "VirtualMachine.Config.Settings", "VirtualMachine.Config.SwapPlacement", "VirtualMachine.Config.ToggleForkParent", "VirtualMachine.Config.UpgradeVirtualHardware", "VirtualMachine.DataSets.DataSetCreate", "VirtualMachine.DataSets.DataSetDelete", "VirtualMachine.DataSets.DataSetEntryDelete", "VirtualMachine.DataSets.DataSetEntryGet", "VirtualMachine.DataSets.DataSetEntryList", "VirtualMachine.DataSets.DataSetEntrySet", "VirtualMachine.DataSets.DataSetGet", "VirtualMachine.DataSets.DataSetList", "VirtualMachine.DataSets.DataSetUpdate", "VirtualMachine.DataSets.Export", "VirtualMachine.GuestOperations.Execute", "VirtualMachine.GuestOperations.Modify", "VirtualMachine.GuestOperations.ModifyAliases", "VirtualMachine.GuestOperations.Query", "VirtualMachine.GuestOperations.QueryAliases", "VirtualMachine.Hbr.ConfigureReplication", "VirtualMachine.Hbr.MonitorReplication", "VirtualMachine.Hbr.ReplicaManagement", "VirtualMachine.Interact.AnswerQuestion", "VirtualMachine.Interact.Backup", "VirtualMachine.Interact.ConsoleInteract", "VirtualMachine.Interact.CreateScreenshot", "VirtualMachine.Interact.CreateSecondary", "VirtualMachine.Interact.DefragmentAllDisks", "VirtualMachine.Interact.DeviceConnection", "VirtualMachine.Interact.DisableSecondary", "VirtualMachine.Interact.DnD", "VirtualMachine.Interact.EnableSecondary", "VirtualMachine.Interact.MakePrimary", "VirtualMachine.Interact.Pause", "VirtualMachine.Interact.PowerOff", "VirtualMachine.Interact.PowerOn", "VirtualMachine.Interact.PutUsbScanCodes", "VirtualMachine.Interact.Record", "VirtualMachine.Interact.Replay", "VirtualMachine.Interact.Reset", "VirtualMachine.Interact.SESparseMaintenance", "VirtualMachine.Interact.SetCDMedia", "VirtualMachine.Interact.SetFloppyMedia", "VirtualMachine.Interact.Suspend", "VirtualMachine.Interact.SuspendToMemory", "VirtualMachine.Interact.TerminateFaultTolerantVM", "VirtualMachine.Interact.ToolsInstall", "VirtualMachine.Interact.TurnOffFaultTolerance", "VirtualMachine.Inventory.Create", "VirtualMachine.Inventory.CreateFromExisting", "VirtualMachine.Inventory.Delete", "VirtualMachine.Inventory.Move", "VirtualMachine.Inventory.Register", "VirtualMachine.Inventory.Unregister", "VirtualMachine.Namespace.Event", "VirtualMachine.Namespace.EventNotify", "VirtualMachine.Namespace.Management", "VirtualMachine.Namespace.ModifyContent", "VirtualMachine.Namespace.Query", "VirtualMachine.Namespace.ReadContent", "VirtualMachine.Provisioning.Clone", "VirtualMachine.Provisioning.CloneTemplate", "VirtualMachine.Provisioning.CreateTemplateFromVM", "VirtualMachine.Provisioning.Customize", "VirtualMachine.Provisioning.DeployTemplate", "VirtualMachine.Provisioning.DiskRandomAccess", "VirtualMachine.Provisioning.DiskRandomRead", "VirtualMachine.Provisioning.FileRandomAccess", "VirtualMachine.Provisioning.GetVmFiles", "VirtualMachine.Provisioning.MarkAsTemplate", "VirtualMachine.Provisioning.MarkAsVM", "VirtualMachine.Provisioning.ModifyCustSpecs", "VirtualMachine.Provisioning.PromoteDisks", "VirtualMachine.Provisioning.PutVmFiles", "VirtualMachine.Provisioning.ReadCustSpecs", "VirtualMachine.State.CreateSnapshot", "VirtualMachine.State.RemoveSnapshot", "VirtualMachine.State.RenameSnapshot", "VirtualMachine.State.RevertToSnapshot", "VirtualMachineClasses.Manage", "VmCam.Administer", "VmResourceProfiles.Manage", "Vsan.Cluster.ShallowRekey", "Vsan.Xvc.UpdateClientInfo", "Zone.Manage", "Zone.ObjectAttachable", "vSANStats.Access", "vService.CreateDependency", "vService.DestroyDependency", "vService.ReconfigureDependency", "vService.UpdateDependency", "vSphereClient.UtilizeVerificationCode", "vSphereDataProtection.Protection", "vSphereDataProtection.Recovery", "vStats.CollectAny", "vStats.QueryAny", "vStats.Settings"},
	},
	{
		RoleId: -5,
		System: true,
		Name:   "NoAccess",
		Info: &types.Description{
			Label:   "No access",
			Summary: "Used for restricting granted access",
		},
		Privilege: nil,
	},
	{
		RoleId: -4,
		System: true,
		Name:   "Anonymous",
		Info: &types.Description{
			Label:   "Anonymous",
			Summary: "Not logged-in user (cannot be granted)",
		},
		Privilege: []string{"System.Anonymous"},
	},
	{
		RoleId: -3,
		System: true,
		Name:   "View",
		Info: &types.Description{
			Label:   "View",
			Summary: "Visibility access (cannot be granted)",
		},
		Privilege: []string{"System.Anonymous", "System.View"},
	},
	{
		RoleId: -2,
		System: true,
		Name:   "ReadOnly",
		Info: &types.Description{
			Label:   "Read-only",
			Summary: "See details of objects, but not make changes",
		},
		Privilege: []string{"System.Anonymous", "System.Read", "System.View"},
	},
	{
		RoleId: -1,
		System: true,
		Name:   "Admin",
		Info: &types.Description{
			Label:   "Administrator",
			Summary: "Full access rights",
		},
		Privilege: []string{"Alarm.Acknowledge", "Alarm.Create", "Alarm.Delete", "Alarm.DisableActions", "Alarm.Edit", "Alarm.SetStatus", "Alarm.ToggleEnableOnEntity", "Authorization.ModifyPermissions", "Authorization.ModifyPrivileges", "Authorization.ModifyRoles", "Authorization.ModifyVTContainerMappings", "Authorization.ModifyVTContainers", "Authorization.ReassignRolePermissions", "AutoDeploy.Host.AssociateMachine", "AutoDeploy.Profile.Create", "AutoDeploy.Profile.Edit", "AutoDeploy.Rule.Create", "AutoDeploy.Rule.Delete", "AutoDeploy.Rule.Edit", "AutoDeploy.RuleSet.Activate", "AutoDeploy.RuleSet.Edit", "Certificate.Manage", "CertificateAuthority.Administer", "CertificateAuthority.Manage", "CertificateManagement.Administer", "CertificateManagement.Manage", "CertificateManagementSubscriptions.Create", "CertificateManagementSubscriptions.Delete", "CertificateManagementSubscriptions.Update", "Cns.Searchable", "ComputePolicy.Manage", "ContentLibrary.AddCertToTrustStore", "ContentLibrary.AddLibraryItem", "ContentLibrary.AddSubscription", "ContentLibrary.CheckInTemplate", "ContentLibrary.CheckOutTemplate", "ContentLibrary.CreateLocalLibrary", "ContentLibrary.CreateSubscribedLibrary", "ContentLibrary.DeleteCertFromTrustStore", "ContentLibrary.DeleteLibraryItem", "ContentLibrary.DeleteLocalLibrary", "ContentLibrary.DeleteSubscribedLibrary", "ContentLibrary.DeleteSubscription", "ContentLibrary.DownloadSession", "ContentLibrary.EvictLibraryItem", "ContentLibrary.EvictSubscribedLibrary", "ContentLibrary.GetConfiguration", "ContentLibrary.ImportStorage", "ContentLibrary.ManageClusterRegistryResource", "ContentLibrary.ManageRegistry", "ContentLibrary.ManageRegistryProject", "ContentLibrary.MigrateLibrary", "ContentLibrary.ProbeSubscription", "ContentLibrary.PublishLibrary", "ContentLibrary.PublishLibraryItem", "ContentLibrary.ReadStorage", "ContentLibrary.SyncLibrary", "ContentLibrary.SyncLibraryItem", "ContentLibrary.TypeIntrospection", "ContentLibrary.UpdateConfiguration", "ContentLibrary.UpdateLibrary", "ContentLibrary.UpdateLibraryItem", "ContentLibrary.UpdateLocalLibrary", "ContentLibrary.UpdateSession", "ContentLibrary.UpdateSubscribedLibrary", "ContentLibrary.UpdateSubscription", "Cryptographer.Access", "Cryptographer.AddDisk", "Cryptographer.Clone", "Cryptographer.Decrypt", "Cryptographer.Encrypt", "Cryptographer.EncryptNew", "Cryptographer.ManageEncryptionPolicy", "Cryptographer.ManageKeyServers", "Cryptographer.ManageKeys", "Cryptographer.Migrate", "Cryptographer.ReadKeyServersInfo", "Cryptographer.Recrypt", "Cryptographer.RegisterHost", "Cryptographer.RegisterVM", "DVPortgroup.Create", "DVPortgroup.Delete", "DVPortgroup.Modify", "DVPortgroup.PolicyOp", "DVPortgroup.ScopeOp", "DVSwitch.Create", "DVSwitch.Delete", "DVSwitch.HostOp", "DVSwitch.Modify", "DVSwitch.Move", "DVSwitch.PolicyOp", "DVSwitch.PortConfig", "DVSwitch.PortSetting", "DVSwitch.ResourceManagement", "DVSwitch.Vspan", "Datacenter.Create", "Datacenter.Delete", "Datacenter.IpPoolConfig", "Datacenter.IpPoolQueryAllocations", "Datacenter.IpPoolReleaseIp", "Datacenter.Move", "Datacenter.Reconfigure", "Datacenter.Rename", "Datacenter.UpdateCarbonInfo", "Datastore.AllocateSpace", "Datastore.Browse", "Datastore.Config", "Datastore.ConfigIOManagement", "Datastore.Delete", "Datastore.DeleteFile", "Datastore.FileManagement", "Datastore.Move", "Datastore.Rename", "Datastore.UpdateVirtualMachineFiles", "Datastore.UpdateVirtualMachineMetadata", "DirectPathProfileManager.Manage", "DrProxy.Host.Configure", "DrProxy.Host.ManageService", "DrProxy.Host.View", "DrProxy.License.Update", "DrProxy.License.View", "DrProxy.Progress.Control", "DrProxy.Vm.Configure", "EAM.Config", "EAM.Modify", "EAM.View", "Extension.Register", "Extension.Unregister", "Extension.Update", "ExternalStatsProvider.Register", "ExternalStatsProvider.Unregister", "ExternalStatsProvider.Update", "Folder.Create", "Folder.Delete", "Folder.ExternalFolderManagement", "Folder.Move", "Folder.Rename", "FoundationLoadBalancers.Manage", "Global.CancelTask", "Global.CapacityPlanning", "Global.Diagnostics", "Global.DisableMethods", "Global.EnableMethods", "Global.GlobalTag", "Global.Health", "Global.Licenses", "Global.LogEvent", "Global.ManageCustomFields", "Global.Proxy", "Global.ScriptAction", "Global.ServiceManagers", "Global.SetCustomField", "Global.Settings", "Global.SystemTag", "Global.VCServer", "GuestDataPublisher.GetData", "HLM.Create", "HLM.Manage", "HealthUpdateProvider.Register", "HealthUpdateProvider.Unregister", "HealthUpdateProvider.Update", "Host.Cim.CimInteraction", "Host.Config.AdvancedConfig", "Host.Config.AuthenticationStore", "Host.Config.AutoStart", "Host.Config.Connection", "Host.Config.DateTime", "Host.Config.Firmware", "Host.Config.GuestStore", "Host.Config.HyperThreading", "Host.Config.Image", "Host.Config.Maintenance", "Host.Config.Memory", "Host.Config.NetService", "Host.Config.Network", "Host.Config.Nvdimm", "Host.Config.Patch", "Host.Config.PciPassthru", "Host.Config.Power", "Host.Config.ProductLocker", "Host.Config.Quarantine", "Host.Config.Resources", "Host.Config.Settings", "Host.Config.Snmp", "Host.Config.Storage", "Host.Config.SystemFirewallRuleSet", "Host.Config.SystemManagement", "Host.Entropy.Read", "Host.Entropy.Write", "Host.Hbr.HbrDaemonManagement", "Host.Hbr.HbrManagement", "Host.Inventory.AddHostToCluster", "Host.Inventory.AddStandaloneHost", "Host.Inventory.CreateCluster", "Host.Inventory.DeleteCluster", "Host.Inventory.EditCluster", "Host.Inventory.ManageClusterLifecyle", "Host.Inventory.MoveCluster", "Host.Inventory.MoveHost", "Host.Inventory.RemoveHostFromCluster", "Host.Inventory.RenameCluster", "Host.Local.CreateVM", "Host.Local.DeleteVM", "Host.Local.InstallAgent", "Host.Local.ManageUserGroups", "Host.Local.ReconfigVM", "Host.Sgx.Register", "Host.Stats.Query", "Host.Tpm.Read", "Host.Tpm.Unseal", "Infraprofile.Read", "Infraprofile.Write", "IntercomNamespace.Read", "IntercomNamespace.Write", "InventoryService.Tagging.AttachTag", "InventoryService.Tagging.CreateCategory", "InventoryService.Tagging.CreateTag", "InventoryService.Tagging.DeleteCategory", "InventoryService.Tagging.DeleteTag", "InventoryService.Tagging.EditCategory", "InventoryService.Tagging.EditTag", "InventoryService.Tagging.ModifyUsedByForCategory", "InventoryService.Tagging.ModifyUsedByForTag", "InventoryService.Tagging.ObjectAttachable", "Namespaces.Backup", "Namespaces.Configure", "Namespaces.ListAccess", "Namespaces.Manage", "Namespaces.ManageCapabilities", "Namespaces.ManageDisks", "Namespaces.SelfServiceManage", "Namespaces.Upgrade", "Network.Assign", "Network.Config", "Network.Delete", "Network.Move", "Nsx.Manage", "Nsx.ModifyAll", "Nsx.Read", "Observability.Admin", "Observability.StatsProvider.Manage", "OvfManager.OvfConsumerAccess", "PartnerRestDaemon.Read", "PartnerRestDaemon.Write", "Performance.ModifyIntervals", "Plugin.Management", "Profile.Clear", "Profile.Create", "Profile.Delete", "Profile.Edit", "Profile.Export", "Profile.View", "ReplicationService.Administer", "Resource.ApplyRecommendation", "Resource.AssignVAppToPool", "Resource.AssignVMToPool", "Resource.ColdMigrate", "Resource.CreatePool", "Resource.DeletePool", "Resource.EditPool", "Resource.HotMigrate", "Resource.MovePool", "Resource.QueryVMotion", "Resource.RenamePool", "ScheduledTask.Create", "ScheduledTask.Delete", "ScheduledTask.Edit", "ScheduledTask.Run", "ServiceAccount.Administer", "ServiceAccount.ManageAccount", "ServiceAccount.ManagePassword", "Sessions.CollectPrivilegeChecks", "Sessions.GlobalMessage", "Sessions.ImpersonateUser", "Sessions.TerminateSession", "Sessions.ValidateSession", "SettingsStore.Manage", "StoragePod.Config", "StorageProfile.Apply", "StorageProfile.Update", "StorageProfile.View", "StorageViews.ConfigureService", "StorageViews.View", "SupervisorServices.Install", "SupervisorServices.Manage", "System.Anonymous", "System.Read", "System.View", "Task.Create", "Task.Update", "Task.Update.Task.Update", "TenantManager.Query", "TenantManager.Update", "TokenService.PersistableTokenExchange", "TransferService.Manage", "TransferService.Monitor", "Trust.Administer", "Trust.Manage", "TrustedAdmin.ConfigureHostCertificates", "TrustedAdmin.ConfigureHostMetadata", "TrustedAdmin.ConfigureTokenConversionPolicy", "TrustedAdmin.ManageAttestingSSO", "TrustedAdmin.ManageKMSTrust", "TrustedAdmin.ManageTrustedHosts", "TrustedAdmin.ReadAttestingSSO", "TrustedAdmin.ReadKMSTrust", "TrustedAdmin.ReadStsInfo", "TrustedAdmin.ReadTrustedHosts", "TrustedAdmin.RetrieveHostMetadata", "TrustedAdmin.RetrieveTPMHostCertificates", "VApp.ApplicationConfig", "VApp.AssignResourcePool", "VApp.AssignVApp", "VApp.AssignVM", "VApp.Clone", "VApp.Create", "VApp.Delete", "VApp.Export", "VApp.ExtractOvfEnvironment", "VApp.Import", "VApp.InstanceConfig", "VApp.ManagedByConfig", "VApp.Move", "VApp.PowerOff", "VApp.PowerOn", "VApp.PullFromUrls", "VApp.Rename", "VApp.ResourceConfig", "VApp.Suspend", "VApp.Unregister", "VcIdentityProviders.Create", "VcIdentityProviders.Manage", "VcIdentityProviders.Read", "VcIntegrity.Baseline.com.vmware.vcIntegrity.AssignBaselines", "VcIntegrity.Baseline.com.vmware.vcIntegrity.ManageBaselines", "VcIntegrity.ClusterConfiguration.Export", "VcIntegrity.ClusterConfiguration.Modify", "VcIntegrity.ClusterConfiguration.Remediate", "VcIntegrity.ClusterConfiguration.View", "VcIntegrity.FileUpload.com.vmware.vcIntegrity.ImportFile", "VcIntegrity.General.com.vmware.vcIntegrity.Configure", "VcIntegrity.HardwareCompatibility.Read", "VcIntegrity.HardwareCompatibility.Write", "VcIntegrity.Updates.com.vmware.vcIntegrity.Remediate", "VcIntegrity.Updates.com.vmware.vcIntegrity.Scan", "VcIntegrity.Updates.com.vmware.vcIntegrity.Stage", "VcIntegrity.Updates.com.vmware.vcIntegrity.ViewStatus", "VcIntegrity.lifecycleDepots.Delete", "VcIntegrity.lifecycleGeneral.Read", "VcIntegrity.lifecycleGeneral.Write", "VcIntegrity.lifecycleHealth.Read", "VcIntegrity.lifecycleHealth.Write", "VcIntegrity.lifecycleSettings.Read", "VcIntegrity.lifecycleSettings.Write", "VcIntegrity.lifecycleSoftwareRemediation.Read", "VcIntegrity.lifecycleSoftwareRemediation.Write", "VcIntegrity.lifecycleSoftwareSpecification.Read", "VcIntegrity.lifecycleSoftwareSpecification.Write", "VcIntegrity.systemVM.Read", "VcIntegrity.systemVM.Write", "VcLifecycle.Upgrade", "VcLifecycle.View", "VirtualMachine.Config.AddExistingDisk", "VirtualMachine.Config.AddNewDisk", "VirtualMachine.Config.AddRemoveDevice", "VirtualMachine.Config.AdvancedConfig", "VirtualMachine.Config.Annotation", "VirtualMachine.Config.CPUCount", "VirtualMachine.Config.ChangeTracking", "VirtualMachine.Config.DiskExtend", "VirtualMachine.Config.DiskLease", "VirtualMachine.Config.EditDevice", "VirtualMachine.Config.HostUSBDevice", "VirtualMachine.Config.ManagedBy", "VirtualMachine.Config.Memory", "VirtualMachine.Config.MksControl", "VirtualMachine.Config.QueryFTCompatibility", "VirtualMachine.Config.QueryUnownedFiles", "VirtualMachine.Config.RawDevice", "VirtualMachine.Config.ReloadFromPath", "VirtualMachine.Config.RemoveDisk", "VirtualMachine.Config.Rename", "VirtualMachine.Config.ResetGuestInfo", "VirtualMachine.Config.Resource", "VirtualMachine.Config.Settings", "VirtualMachine.Config.SwapPlacement", "VirtualMachine.Config.ToggleForkParent", "VirtualMachine.Config.UpgradeVirtualHardware", "VirtualMachine.DataSets.DataSetCreate", "VirtualMachine.DataSets.DataSetDelete", "VirtualMachine.DataSets.DataSetEntryDelete", "VirtualMachine.DataSets.DataSetEntryGet", "VirtualMachine.DataSets.DataSetEntryList", "VirtualMachine.DataSets.DataSetEntrySet", "VirtualMachine.DataSets.DataSetGet", "VirtualMachine.DataSets.DataSetList", "VirtualMachine.DataSets.DataSetUpdate", "VirtualMachine.DataSets.Export", "VirtualMachine.GuestOperations.Execute", "VirtualMachine.GuestOperations.Modify", "VirtualMachine.GuestOperations.ModifyAliases", "VirtualMachine.GuestOperations.Query", "VirtualMachine.GuestOperations.QueryAliases", "VirtualMachine.Hbr.ConfigureReplication", "VirtualMachine.Hbr.MonitorReplication", "VirtualMachine.Hbr.ReplicaManagement", "VirtualMachine.Interact.AnswerQuestion", "VirtualMachine.Interact.Backup", "VirtualMachine.Interact.ConsoleInteract", "VirtualMachine.Interact.CreateScreenshot", "VirtualMachine.Interact.CreateSecondary", "VirtualMachine.Interact.DefragmentAllDisks", "VirtualMachine.Interact.DeviceConnection", "VirtualMachine.Interact.DisableSecondary", "VirtualMachine.Interact.DnD", "VirtualMachine.Interact.EnableSecondary", "VirtualMachine.Interact.GuestControl", "VirtualMachine.Interact.MakePrimary", "VirtualMachine.Interact.Pause", "VirtualMachine.Interact.PowerOff", "VirtualMachine.Interact.PowerOn", "VirtualMachine.Interact.PutUsbScanCodes", "VirtualMachine.Interact.Record", "VirtualMachine.Interact.Replay", "VirtualMachine.Interact.Reset", "VirtualMachine.Interact.SESparseMaintenance", "VirtualMachine.Interact.SetCDMedia", "VirtualMachine.Interact.SetFloppyMedia", "VirtualMachine.Interact.Suspend", "VirtualMachine.Interact.SuspendToMemory", "VirtualMachine.Interact.TerminateFaultTolerantVM", "VirtualMachine.Interact.ToolsInstall", "VirtualMachine.Interact.TurnOffFaultTolerance", "VirtualMachine.Inventory.Create", "VirtualMachine.Inventory.CreateFromExisting", "VirtualMachine.Inventory.Delete", "VirtualMachine.Inventory.Move", "VirtualMachine.Inventory.Register", "VirtualMachine.Inventory.Unregister", "VirtualMachine.Namespace.Event", "VirtualMachine.Namespace.EventNotify", "VirtualMachine.Namespace.Management", "VirtualMachine.Namespace.ModifyContent", "VirtualMachine.Namespace.Query", "VirtualMachine.Namespace.ReadContent", "VirtualMachine.Provisioning.Clone", "VirtualMachine.Provisioning.CloneTemplate", "VirtualMachine.Provisioning.CreateTemplateFromVM", "VirtualMachine.Provisioning.Customize", "VirtualMachine.Provisioning.DeployTemplate", "VirtualMachine.Provisioning.DiskRandomAccess", "VirtualMachine.Provisioning.DiskRandomRead", "VirtualMachine.Provisioning.FileRandomAccess", "VirtualMachine.Provisioning.GetVmFiles", "VirtualMachine.Provisioning.MarkAsTemplate", "VirtualMachine.Provisioning.MarkAsVM", "VirtualMachine.Provisioning.ModifyCustSpecs", "VirtualMachine.Provisioning.PromoteDisks", "VirtualMachine.Provisioning.PutVmFiles", "VirtualMachine.Provisioning.ReadCustSpecs", "VirtualMachine.State.CreateSnapshot", "VirtualMachine.State.RemoveSnapshot", "VirtualMachine.State.RenameSnapshot", "VirtualMachine.State.RevertToSnapshot", "VirtualMachineClasses.Manage", "VmCam.Administer", "VmResourceProfiles.Manage", "Vsan.Cluster.ShallowRekey", "Vsan.Xvc.UpdateClientInfo", "Zone.Manage", "Zone.ObjectAttachable", "vSANStats.Access", "vService.CreateDependency", "vService.DestroyDependency", "vService.ReconfigureDependency", "vService.UpdateDependency", "vSphereClient.UtilizeVerificationCode", "vSphereDataProtection.Protection", "vSphereDataProtection.Recovery", "vStats.CollectAny", "vStats.QueryAny", "vStats.Settings"},
	},
}
