package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// LayoutDeleteRequestBody 删除布局请求体
type LayoutDeleteRequestBody struct {

	// 布局ID列表
	Ids []string `json:"ids"`

	// 是否删除，为true时直接删除；如有引用关系，则删除失败
	IsDelete *bool `json:"is_delete,omitempty"`
}

func (o LayoutDeleteRequestBody) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "LayoutDeleteRequestBody struct{}"
	}

	return strings.Join([]string{"LayoutDeleteRequestBody", string(data)}, " ")
}
