// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudWebhookWebhook hashicorp cloud webhook webhook
//
// swagger:model hashicorp.cloud.webhook.Webhook
type HashicorpCloudWebhookWebhook struct {

	// The information for delivering event payloads.
	Config *HashicorpCloudWebhookWebhookConfig `json:"config,omitempty"`

	// The time the webhook was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// The description of this webhook.
	Description string `json:"description,omitempty"`

	// When `true`, this parameter indicates that the webhook is enabled and is able to receive payloads for the subscribed events.
	Enabled bool `json:"enabled,omitempty"`

	// The latest delivery to the webhook.
	LastDelivery *HashicorpCloudWebhookWebhookDelivery `json:"last_delivery,omitempty"`

	// Unique identifier for the platform.
	ResourceID string `json:"resource_id,omitempty"`

	// The human-readable identifier for the platform. For example, `webhooks/project/<project-id>/geo/<geography>/webhook/<webhook-name>`.
	ResourceName string `json:"resource_name,omitempty"`

	// The resource events this webhook is subscribed to.
	Subscriptions []*HashicorpCloudWebhookWebhookSubscription `json:"subscriptions"`

	// The time the webhook was last updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud webhook webhook
func (m *HashicorpCloudWebhookWebhook) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastDelivery(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubscriptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookWebhook) validateConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.Config) { // not required
		return nil
	}

	if m.Config != nil {
		if err := m.Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookWebhook) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudWebhookWebhook) validateLastDelivery(formats strfmt.Registry) error {
	if swag.IsZero(m.LastDelivery) { // not required
		return nil
	}

	if m.LastDelivery != nil {
		if err := m.LastDelivery.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_delivery")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("last_delivery")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookWebhook) validateSubscriptions(formats strfmt.Registry) error {
	if swag.IsZero(m.Subscriptions) { // not required
		return nil
	}

	for i := 0; i < len(m.Subscriptions); i++ {
		if swag.IsZero(m.Subscriptions[i]) { // not required
			continue
		}

		if m.Subscriptions[i] != nil {
			if err := m.Subscriptions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWebhookWebhook) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud webhook webhook based on the context it is used
func (m *HashicorpCloudWebhookWebhook) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastDelivery(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubscriptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookWebhook) contextValidateConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.Config != nil {

		if swag.IsZero(m.Config) { // not required
			return nil
		}

		if err := m.Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookWebhook) contextValidateLastDelivery(ctx context.Context, formats strfmt.Registry) error {

	if m.LastDelivery != nil {

		if swag.IsZero(m.LastDelivery) { // not required
			return nil
		}

		if err := m.LastDelivery.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_delivery")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("last_delivery")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookWebhook) contextValidateSubscriptions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Subscriptions); i++ {

		if m.Subscriptions[i] != nil {

			if swag.IsZero(m.Subscriptions[i]) { // not required
				return nil
			}

			if err := m.Subscriptions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWebhookWebhook) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWebhookWebhook) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWebhookWebhook
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
