// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceListApplicationTemplatesReader is a Reader for the WaypointServiceListApplicationTemplates structure.
type WaypointServiceListApplicationTemplatesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListApplicationTemplatesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListApplicationTemplatesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListApplicationTemplatesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListApplicationTemplatesOK creates a WaypointServiceListApplicationTemplatesOK with default headers values
func NewWaypointServiceListApplicationTemplatesOK() *WaypointServiceListApplicationTemplatesOK {
	return &WaypointServiceListApplicationTemplatesOK{}
}

/*
WaypointServiceListApplicationTemplatesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListApplicationTemplatesOK struct {
	Payload *models.HashicorpCloudWaypointListApplicationTemplatesResponse
}

// IsSuccess returns true when this waypoint service list application templates o k response has a 2xx status code
func (o *WaypointServiceListApplicationTemplatesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list application templates o k response has a 3xx status code
func (o *WaypointServiceListApplicationTemplatesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list application templates o k response has a 4xx status code
func (o *WaypointServiceListApplicationTemplatesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list application templates o k response has a 5xx status code
func (o *WaypointServiceListApplicationTemplatesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list application templates o k response a status code equal to that given
func (o *WaypointServiceListApplicationTemplatesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list application templates o k response
func (o *WaypointServiceListApplicationTemplatesOK) Code() int {
	return 200
}

func (o *WaypointServiceListApplicationTemplatesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] waypointServiceListApplicationTemplatesOK %s", 200, payload)
}

func (o *WaypointServiceListApplicationTemplatesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] waypointServiceListApplicationTemplatesOK %s", 200, payload)
}

func (o *WaypointServiceListApplicationTemplatesOK) GetPayload() *models.HashicorpCloudWaypointListApplicationTemplatesResponse {
	return o.Payload
}

func (o *WaypointServiceListApplicationTemplatesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListApplicationTemplatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListApplicationTemplatesDefault creates a WaypointServiceListApplicationTemplatesDefault with default headers values
func NewWaypointServiceListApplicationTemplatesDefault(code int) *WaypointServiceListApplicationTemplatesDefault {
	return &WaypointServiceListApplicationTemplatesDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListApplicationTemplatesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListApplicationTemplatesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list application templates default response has a 2xx status code
func (o *WaypointServiceListApplicationTemplatesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list application templates default response has a 3xx status code
func (o *WaypointServiceListApplicationTemplatesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list application templates default response has a 4xx status code
func (o *WaypointServiceListApplicationTemplatesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list application templates default response has a 5xx status code
func (o *WaypointServiceListApplicationTemplatesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list application templates default response a status code equal to that given
func (o *WaypointServiceListApplicationTemplatesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list application templates default response
func (o *WaypointServiceListApplicationTemplatesDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListApplicationTemplatesDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] WaypointService_ListApplicationTemplates default %s", o._statusCode, payload)
}

func (o *WaypointServiceListApplicationTemplatesDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] WaypointService_ListApplicationTemplates default %s", o._statusCode, payload)
}

func (o *WaypointServiceListApplicationTemplatesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListApplicationTemplatesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
