// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceListApplicationTemplates2Reader is a Reader for the WaypointServiceListApplicationTemplates2 structure.
type WaypointServiceListApplicationTemplates2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListApplicationTemplates2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListApplicationTemplates2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListApplicationTemplates2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListApplicationTemplates2OK creates a WaypointServiceListApplicationTemplates2OK with default headers values
func NewWaypointServiceListApplicationTemplates2OK() *WaypointServiceListApplicationTemplates2OK {
	return &WaypointServiceListApplicationTemplates2OK{}
}

/*
WaypointServiceListApplicationTemplates2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListApplicationTemplates2OK struct {
	Payload *models.HashicorpCloudWaypointListApplicationTemplatesResponse
}

// IsSuccess returns true when this waypoint service list application templates2 o k response has a 2xx status code
func (o *WaypointServiceListApplicationTemplates2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list application templates2 o k response has a 3xx status code
func (o *WaypointServiceListApplicationTemplates2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list application templates2 o k response has a 4xx status code
func (o *WaypointServiceListApplicationTemplates2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list application templates2 o k response has a 5xx status code
func (o *WaypointServiceListApplicationTemplates2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list application templates2 o k response a status code equal to that given
func (o *WaypointServiceListApplicationTemplates2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list application templates2 o k response
func (o *WaypointServiceListApplicationTemplates2OK) Code() int {
	return 200
}

func (o *WaypointServiceListApplicationTemplates2OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates][%d] waypointServiceListApplicationTemplates2OK %s", 200, payload)
}

func (o *WaypointServiceListApplicationTemplates2OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates][%d] waypointServiceListApplicationTemplates2OK %s", 200, payload)
}

func (o *WaypointServiceListApplicationTemplates2OK) GetPayload() *models.HashicorpCloudWaypointListApplicationTemplatesResponse {
	return o.Payload
}

func (o *WaypointServiceListApplicationTemplates2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListApplicationTemplatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListApplicationTemplates2Default creates a WaypointServiceListApplicationTemplates2Default with default headers values
func NewWaypointServiceListApplicationTemplates2Default(code int) *WaypointServiceListApplicationTemplates2Default {
	return &WaypointServiceListApplicationTemplates2Default{
		_statusCode: code,
	}
}

/*
WaypointServiceListApplicationTemplates2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListApplicationTemplates2Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list application templates2 default response has a 2xx status code
func (o *WaypointServiceListApplicationTemplates2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list application templates2 default response has a 3xx status code
func (o *WaypointServiceListApplicationTemplates2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list application templates2 default response has a 4xx status code
func (o *WaypointServiceListApplicationTemplates2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list application templates2 default response has a 5xx status code
func (o *WaypointServiceListApplicationTemplates2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list application templates2 default response a status code equal to that given
func (o *WaypointServiceListApplicationTemplates2Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list application templates2 default response
func (o *WaypointServiceListApplicationTemplates2Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListApplicationTemplates2Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates][%d] WaypointService_ListApplicationTemplates2 default %s", o._statusCode, payload)
}

func (o *WaypointServiceListApplicationTemplates2Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates][%d] WaypointService_ListApplicationTemplates2 default %s", o._statusCode, payload)
}

func (o *WaypointServiceListApplicationTemplates2Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListApplicationTemplates2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
