// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceCheckNamespaceActivationReader is a Reader for the WaypointServiceCheckNamespaceActivation structure.
type WaypointServiceCheckNamespaceActivationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCheckNamespaceActivationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCheckNamespaceActivationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCheckNamespaceActivationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCheckNamespaceActivationOK creates a WaypointServiceCheckNamespaceActivationOK with default headers values
func NewWaypointServiceCheckNamespaceActivationOK() *WaypointServiceCheckNamespaceActivationOK {
	return &WaypointServiceCheckNamespaceActivationOK{}
}

/*
WaypointServiceCheckNamespaceActivationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCheckNamespaceActivationOK struct {
	Payload *models.HashicorpCloudWaypointCheckNamespaceActivationResponse
}

// IsSuccess returns true when this waypoint service check namespace activation o k response has a 2xx status code
func (o *WaypointServiceCheckNamespaceActivationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service check namespace activation o k response has a 3xx status code
func (o *WaypointServiceCheckNamespaceActivationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service check namespace activation o k response has a 4xx status code
func (o *WaypointServiceCheckNamespaceActivationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service check namespace activation o k response has a 5xx status code
func (o *WaypointServiceCheckNamespaceActivationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service check namespace activation o k response a status code equal to that given
func (o *WaypointServiceCheckNamespaceActivationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service check namespace activation o k response
func (o *WaypointServiceCheckNamespaceActivationOK) Code() int {
	return 200
}

func (o *WaypointServiceCheckNamespaceActivationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/check-activation][%d] waypointServiceCheckNamespaceActivationOK %s", 200, payload)
}

func (o *WaypointServiceCheckNamespaceActivationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/check-activation][%d] waypointServiceCheckNamespaceActivationOK %s", 200, payload)
}

func (o *WaypointServiceCheckNamespaceActivationOK) GetPayload() *models.HashicorpCloudWaypointCheckNamespaceActivationResponse {
	return o.Payload
}

func (o *WaypointServiceCheckNamespaceActivationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCheckNamespaceActivationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCheckNamespaceActivationDefault creates a WaypointServiceCheckNamespaceActivationDefault with default headers values
func NewWaypointServiceCheckNamespaceActivationDefault(code int) *WaypointServiceCheckNamespaceActivationDefault {
	return &WaypointServiceCheckNamespaceActivationDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCheckNamespaceActivationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCheckNamespaceActivationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service check namespace activation default response has a 2xx status code
func (o *WaypointServiceCheckNamespaceActivationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service check namespace activation default response has a 3xx status code
func (o *WaypointServiceCheckNamespaceActivationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service check namespace activation default response has a 4xx status code
func (o *WaypointServiceCheckNamespaceActivationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service check namespace activation default response has a 5xx status code
func (o *WaypointServiceCheckNamespaceActivationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service check namespace activation default response a status code equal to that given
func (o *WaypointServiceCheckNamespaceActivationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service check namespace activation default response
func (o *WaypointServiceCheckNamespaceActivationDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCheckNamespaceActivationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/check-activation][%d] WaypointService_CheckNamespaceActivation default %s", o._statusCode, payload)
}

func (o *WaypointServiceCheckNamespaceActivationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/check-activation][%d] WaypointService_CheckNamespaceActivation default %s", o._statusCode, payload)
}

func (o *WaypointServiceCheckNamespaceActivationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCheckNamespaceActivationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
