// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointWaypointServiceUpdateAddOnBody UpdateAddOnRequest is the request used to update an existing Add-on.
//
// swagger:model hashicorp.cloud.waypoint.WaypointService.UpdateAddOnBody
type HashicorpCloudWaypointWaypointServiceUpdateAddOnBody struct {

	// existing add on
	ExistingAddOn *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn `json:"existing_add_on,omitempty"`

	// The new name of the Add-on.
	Name string `json:"name,omitempty"`

	// namespace
	Namespace *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace `json:"namespace,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update add on body
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExistingAddOn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) validateExistingAddOn(formats strfmt.Registry) error {
	if swag.IsZero(m.ExistingAddOn) { // not required
		return nil
	}

	if m.ExistingAddOn != nil {
		if err := m.ExistingAddOn.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("existing_add_on")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("existing_add_on")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update add on body based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExistingAddOn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) contextValidateExistingAddOn(ctx context.Context, formats strfmt.Registry) error {

	if m.ExistingAddOn != nil {

		if swag.IsZero(m.ExistingAddOn) { // not required
			return nil
		}

		if err := m.ExistingAddOn.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("existing_add_on")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("existing_add_on")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {

		if swag.IsZero(m.Namespace) { // not required
			return nil
		}

		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateAddOnBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn Add-on ref without ID
//
// # The add-on to be updated
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn
type HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn struct {

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update add on body existing add on
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this hashicorp cloud waypoint waypoint service update add on body existing add on based on context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyExistingAddOn
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace Global references the entire server. This is used in some APIs
// as a way to read/write values that are server-global.
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace
type HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace struct {

	// When used via an API request, this is populated and used to populate id.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update add on body namespace
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update add on body namespace based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateAddOnBodyNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
