// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// NewWaypointServiceRunActionParams creates a new WaypointServiceRunActionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceRunActionParams() *WaypointServiceRunActionParams {
	return &WaypointServiceRunActionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceRunActionParamsWithTimeout creates a new WaypointServiceRunActionParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceRunActionParamsWithTimeout(timeout time.Duration) *WaypointServiceRunActionParams {
	return &WaypointServiceRunActionParams{
		timeout: timeout,
	}
}

// NewWaypointServiceRunActionParamsWithContext creates a new WaypointServiceRunActionParams object
// with the ability to set a context for a request.
func NewWaypointServiceRunActionParamsWithContext(ctx context.Context) *WaypointServiceRunActionParams {
	return &WaypointServiceRunActionParams{
		Context: ctx,
	}
}

// NewWaypointServiceRunActionParamsWithHTTPClient creates a new WaypointServiceRunActionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceRunActionParamsWithHTTPClient(client *http.Client) *WaypointServiceRunActionParams {
	return &WaypointServiceRunActionParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceRunActionParams contains all the parameters to send to the API endpoint

	for the waypoint service run action operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceRunActionParams struct {

	// Body.
	Body *models.HashicorpCloudWaypointWaypointServiceRunActionBody

	// NamespaceID.
	NamespaceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service run action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceRunActionParams) WithDefaults() *WaypointServiceRunActionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service run action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceRunActionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service run action params
func (o *WaypointServiceRunActionParams) WithTimeout(timeout time.Duration) *WaypointServiceRunActionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service run action params
func (o *WaypointServiceRunActionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service run action params
func (o *WaypointServiceRunActionParams) WithContext(ctx context.Context) *WaypointServiceRunActionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service run action params
func (o *WaypointServiceRunActionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service run action params
func (o *WaypointServiceRunActionParams) WithHTTPClient(client *http.Client) *WaypointServiceRunActionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service run action params
func (o *WaypointServiceRunActionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint service run action params
func (o *WaypointServiceRunActionParams) WithBody(body *models.HashicorpCloudWaypointWaypointServiceRunActionBody) *WaypointServiceRunActionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint service run action params
func (o *WaypointServiceRunActionParams) SetBody(body *models.HashicorpCloudWaypointWaypointServiceRunActionBody) {
	o.Body = body
}

// WithNamespaceID adds the namespaceID to the waypoint service run action params
func (o *WaypointServiceRunActionParams) WithNamespaceID(namespaceID string) *WaypointServiceRunActionParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service run action params
func (o *WaypointServiceRunActionParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceRunActionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
