// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointServiceListVariablesParams creates a new WaypointServiceListVariablesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceListVariablesParams() *WaypointServiceListVariablesParams {
	return &WaypointServiceListVariablesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceListVariablesParamsWithTimeout creates a new WaypointServiceListVariablesParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceListVariablesParamsWithTimeout(timeout time.Duration) *WaypointServiceListVariablesParams {
	return &WaypointServiceListVariablesParams{
		timeout: timeout,
	}
}

// NewWaypointServiceListVariablesParamsWithContext creates a new WaypointServiceListVariablesParams object
// with the ability to set a context for a request.
func NewWaypointServiceListVariablesParamsWithContext(ctx context.Context) *WaypointServiceListVariablesParams {
	return &WaypointServiceListVariablesParams{
		Context: ctx,
	}
}

// NewWaypointServiceListVariablesParamsWithHTTPClient creates a new WaypointServiceListVariablesParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceListVariablesParamsWithHTTPClient(client *http.Client) *WaypointServiceListVariablesParams {
	return &WaypointServiceListVariablesParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceListVariablesParams contains all the parameters to send to the API endpoint

	for the waypoint service list variables operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceListVariablesParams struct {

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	// ScopeActionID.
	ScopeActionID *string

	// ScopeActionName.
	ScopeActionName *string

	// ScopeApplicationID.
	ScopeApplicationID *string

	// ScopeApplicationName.
	ScopeApplicationName *string

	/* ScopeApplicationTemplateID.

	   ID of the ApplicationTemplate
	*/
	ScopeApplicationTemplateID *string

	/* ScopeApplicationTemplateName.

	   Name of the ApplicationTemplate
	*/
	ScopeApplicationTemplateName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service list variables params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListVariablesParams) WithDefaults() *WaypointServiceListVariablesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service list variables params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListVariablesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithTimeout(timeout time.Duration) *WaypointServiceListVariablesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithContext(ctx context.Context) *WaypointServiceListVariablesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithHTTPClient(client *http.Client) *WaypointServiceListVariablesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithNamespaceID adds the namespaceID to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithNamespaceID(namespaceID string) *WaypointServiceListVariablesParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceListVariablesParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceListVariablesParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceListVariablesParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceListVariablesParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *WaypointServiceListVariablesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithPaginationPageSize(paginationPageSize *int64) *WaypointServiceListVariablesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *WaypointServiceListVariablesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithScopeActionID adds the scopeActionID to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithScopeActionID(scopeActionID *string) *WaypointServiceListVariablesParams {
	o.SetScopeActionID(scopeActionID)
	return o
}

// SetScopeActionID adds the scopeActionId to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetScopeActionID(scopeActionID *string) {
	o.ScopeActionID = scopeActionID
}

// WithScopeActionName adds the scopeActionName to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithScopeActionName(scopeActionName *string) *WaypointServiceListVariablesParams {
	o.SetScopeActionName(scopeActionName)
	return o
}

// SetScopeActionName adds the scopeActionName to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetScopeActionName(scopeActionName *string) {
	o.ScopeActionName = scopeActionName
}

// WithScopeApplicationID adds the scopeApplicationID to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithScopeApplicationID(scopeApplicationID *string) *WaypointServiceListVariablesParams {
	o.SetScopeApplicationID(scopeApplicationID)
	return o
}

// SetScopeApplicationID adds the scopeApplicationId to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetScopeApplicationID(scopeApplicationID *string) {
	o.ScopeApplicationID = scopeApplicationID
}

// WithScopeApplicationName adds the scopeApplicationName to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithScopeApplicationName(scopeApplicationName *string) *WaypointServiceListVariablesParams {
	o.SetScopeApplicationName(scopeApplicationName)
	return o
}

// SetScopeApplicationName adds the scopeApplicationName to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetScopeApplicationName(scopeApplicationName *string) {
	o.ScopeApplicationName = scopeApplicationName
}

// WithScopeApplicationTemplateID adds the scopeApplicationTemplateID to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithScopeApplicationTemplateID(scopeApplicationTemplateID *string) *WaypointServiceListVariablesParams {
	o.SetScopeApplicationTemplateID(scopeApplicationTemplateID)
	return o
}

// SetScopeApplicationTemplateID adds the scopeApplicationTemplateId to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetScopeApplicationTemplateID(scopeApplicationTemplateID *string) {
	o.ScopeApplicationTemplateID = scopeApplicationTemplateID
}

// WithScopeApplicationTemplateName adds the scopeApplicationTemplateName to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) WithScopeApplicationTemplateName(scopeApplicationTemplateName *string) *WaypointServiceListVariablesParams {
	o.SetScopeApplicationTemplateName(scopeApplicationTemplateName)
	return o
}

// SetScopeApplicationTemplateName adds the scopeApplicationTemplateName to the waypoint service list variables params
func (o *WaypointServiceListVariablesParams) SetScopeApplicationTemplateName(scopeApplicationTemplateName *string) {
	o.ScopeApplicationTemplateName = scopeApplicationTemplateName
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceListVariablesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.ScopeActionID != nil {

		// query param scope.action.id
		var qrScopeActionID string

		if o.ScopeActionID != nil {
			qrScopeActionID = *o.ScopeActionID
		}
		qScopeActionID := qrScopeActionID
		if qScopeActionID != "" {

			if err := r.SetQueryParam("scope.action.id", qScopeActionID); err != nil {
				return err
			}
		}
	}

	if o.ScopeActionName != nil {

		// query param scope.action.name
		var qrScopeActionName string

		if o.ScopeActionName != nil {
			qrScopeActionName = *o.ScopeActionName
		}
		qScopeActionName := qrScopeActionName
		if qScopeActionName != "" {

			if err := r.SetQueryParam("scope.action.name", qScopeActionName); err != nil {
				return err
			}
		}
	}

	if o.ScopeApplicationID != nil {

		// query param scope.application.id
		var qrScopeApplicationID string

		if o.ScopeApplicationID != nil {
			qrScopeApplicationID = *o.ScopeApplicationID
		}
		qScopeApplicationID := qrScopeApplicationID
		if qScopeApplicationID != "" {

			if err := r.SetQueryParam("scope.application.id", qScopeApplicationID); err != nil {
				return err
			}
		}
	}

	if o.ScopeApplicationName != nil {

		// query param scope.application.name
		var qrScopeApplicationName string

		if o.ScopeApplicationName != nil {
			qrScopeApplicationName = *o.ScopeApplicationName
		}
		qScopeApplicationName := qrScopeApplicationName
		if qScopeApplicationName != "" {

			if err := r.SetQueryParam("scope.application.name", qScopeApplicationName); err != nil {
				return err
			}
		}
	}

	if o.ScopeApplicationTemplateID != nil {

		// query param scope.application_template.id
		var qrScopeApplicationTemplateID string

		if o.ScopeApplicationTemplateID != nil {
			qrScopeApplicationTemplateID = *o.ScopeApplicationTemplateID
		}
		qScopeApplicationTemplateID := qrScopeApplicationTemplateID
		if qScopeApplicationTemplateID != "" {

			if err := r.SetQueryParam("scope.application_template.id", qScopeApplicationTemplateID); err != nil {
				return err
			}
		}
	}

	if o.ScopeApplicationTemplateName != nil {

		// query param scope.application_template.name
		var qrScopeApplicationTemplateName string

		if o.ScopeApplicationTemplateName != nil {
			qrScopeApplicationTemplateName = *o.ScopeApplicationTemplateName
		}
		qScopeApplicationTemplateName := qrScopeApplicationTemplateName
		if qScopeApplicationTemplateName != "" {

			if err := r.SetQueryParam("scope.application_template.name", qScopeApplicationTemplateName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
