// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceListAgentGroupsParams creates a new WaypointServiceListAgentGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceListAgentGroupsParams() *WaypointServiceListAgentGroupsParams {
	return &WaypointServiceListAgentGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceListAgentGroupsParamsWithTimeout creates a new WaypointServiceListAgentGroupsParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceListAgentGroupsParamsWithTimeout(timeout time.Duration) *WaypointServiceListAgentGroupsParams {
	return &WaypointServiceListAgentGroupsParams{
		timeout: timeout,
	}
}

// NewWaypointServiceListAgentGroupsParamsWithContext creates a new WaypointServiceListAgentGroupsParams object
// with the ability to set a context for a request.
func NewWaypointServiceListAgentGroupsParamsWithContext(ctx context.Context) *WaypointServiceListAgentGroupsParams {
	return &WaypointServiceListAgentGroupsParams{
		Context: ctx,
	}
}

// NewWaypointServiceListAgentGroupsParamsWithHTTPClient creates a new WaypointServiceListAgentGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceListAgentGroupsParamsWithHTTPClient(client *http.Client) *WaypointServiceListAgentGroupsParams {
	return &WaypointServiceListAgentGroupsParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceListAgentGroupsParams contains all the parameters to send to the API endpoint

	for the waypoint service list agent groups operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceListAgentGroupsParams struct {

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service list agent groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListAgentGroupsParams) WithDefaults() *WaypointServiceListAgentGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service list agent groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListAgentGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithTimeout(timeout time.Duration) *WaypointServiceListAgentGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithContext(ctx context.Context) *WaypointServiceListAgentGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithHTTPClient(client *http.Client) *WaypointServiceListAgentGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithNamespaceID adds the namespaceID to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithNamespaceID(namespaceID string) *WaypointServiceListAgentGroupsParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceListAgentGroupsParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceListAgentGroupsParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceListAgentGroupsParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceListAgentGroupsParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list agent groups params
func (o *WaypointServiceListAgentGroupsParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceListAgentGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
