// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceEndingActionReader is a Reader for the WaypointServiceEndingAction structure.
type WaypointServiceEndingActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceEndingActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceEndingActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceEndingActionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceEndingActionOK creates a WaypointServiceEndingActionOK with default headers values
func NewWaypointServiceEndingActionOK() *WaypointServiceEndingActionOK {
	return &WaypointServiceEndingActionOK{}
}

/*
WaypointServiceEndingActionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceEndingActionOK struct {
	Payload models.HashicorpCloudWaypointEndingActionResponse
}

// IsSuccess returns true when this waypoint service ending action o k response has a 2xx status code
func (o *WaypointServiceEndingActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service ending action o k response has a 3xx status code
func (o *WaypointServiceEndingActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service ending action o k response has a 4xx status code
func (o *WaypointServiceEndingActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service ending action o k response has a 5xx status code
func (o *WaypointServiceEndingActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service ending action o k response a status code equal to that given
func (o *WaypointServiceEndingActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service ending action o k response
func (o *WaypointServiceEndingActionOK) Code() int {
	return 200
}

func (o *WaypointServiceEndingActionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:endAction][%d] waypointServiceEndingActionOK %s", 200, payload)
}

func (o *WaypointServiceEndingActionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:endAction][%d] waypointServiceEndingActionOK %s", 200, payload)
}

func (o *WaypointServiceEndingActionOK) GetPayload() models.HashicorpCloudWaypointEndingActionResponse {
	return o.Payload
}

func (o *WaypointServiceEndingActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceEndingActionDefault creates a WaypointServiceEndingActionDefault with default headers values
func NewWaypointServiceEndingActionDefault(code int) *WaypointServiceEndingActionDefault {
	return &WaypointServiceEndingActionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceEndingActionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceEndingActionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service ending action default response has a 2xx status code
func (o *WaypointServiceEndingActionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service ending action default response has a 3xx status code
func (o *WaypointServiceEndingActionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service ending action default response has a 4xx status code
func (o *WaypointServiceEndingActionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service ending action default response has a 5xx status code
func (o *WaypointServiceEndingActionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service ending action default response a status code equal to that given
func (o *WaypointServiceEndingActionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service ending action default response
func (o *WaypointServiceEndingActionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceEndingActionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:endAction][%d] WaypointService_EndingAction default %s", o._statusCode, payload)
}

func (o *WaypointServiceEndingActionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:endAction][%d] WaypointService_EndingAction default %s", o._statusCode, payload)
}

func (o *WaypointServiceEndingActionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceEndingActionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
