// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceDestroyApplication2Params creates a new WaypointServiceDestroyApplication2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceDestroyApplication2Params() *WaypointServiceDestroyApplication2Params {
	return &WaypointServiceDestroyApplication2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceDestroyApplication2ParamsWithTimeout creates a new WaypointServiceDestroyApplication2Params object
// with the ability to set a timeout on a request.
func NewWaypointServiceDestroyApplication2ParamsWithTimeout(timeout time.Duration) *WaypointServiceDestroyApplication2Params {
	return &WaypointServiceDestroyApplication2Params{
		timeout: timeout,
	}
}

// NewWaypointServiceDestroyApplication2ParamsWithContext creates a new WaypointServiceDestroyApplication2Params object
// with the ability to set a context for a request.
func NewWaypointServiceDestroyApplication2ParamsWithContext(ctx context.Context) *WaypointServiceDestroyApplication2Params {
	return &WaypointServiceDestroyApplication2Params{
		Context: ctx,
	}
}

// NewWaypointServiceDestroyApplication2ParamsWithHTTPClient creates a new WaypointServiceDestroyApplication2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceDestroyApplication2ParamsWithHTTPClient(client *http.Client) *WaypointServiceDestroyApplication2Params {
	return &WaypointServiceDestroyApplication2Params{
		HTTPClient: client,
	}
}

/*
WaypointServiceDestroyApplication2Params contains all the parameters to send to the API endpoint

	for the waypoint service destroy application2 operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceDestroyApplication2Params struct {

	// ApplicationID.
	ApplicationID *string

	// ApplicationName.
	ApplicationName string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service destroy application2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDestroyApplication2Params) WithDefaults() *WaypointServiceDestroyApplication2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service destroy application2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDestroyApplication2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithTimeout(timeout time.Duration) *WaypointServiceDestroyApplication2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithContext(ctx context.Context) *WaypointServiceDestroyApplication2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithHTTPClient(client *http.Client) *WaypointServiceDestroyApplication2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationID adds the applicationID to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithApplicationID(applicationID *string) *WaypointServiceDestroyApplication2Params {
	o.SetApplicationID(applicationID)
	return o
}

// SetApplicationID adds the applicationId to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetApplicationID(applicationID *string) {
	o.ApplicationID = applicationID
}

// WithApplicationName adds the applicationName to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithApplicationName(applicationName string) *WaypointServiceDestroyApplication2Params {
	o.SetApplicationName(applicationName)
	return o
}

// SetApplicationName adds the applicationName to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetApplicationName(applicationName string) {
	o.ApplicationName = applicationName
}

// WithNamespaceID adds the namespaceID to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithNamespaceID(namespaceID string) *WaypointServiceDestroyApplication2Params {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceDestroyApplication2Params {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceDestroyApplication2Params {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceDestroyApplication2Params {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceDestroyApplication2Params {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service destroy application2 params
func (o *WaypointServiceDestroyApplication2Params) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceDestroyApplication2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationID != nil {

		// query param application.id
		var qrApplicationID string

		if o.ApplicationID != nil {
			qrApplicationID = *o.ApplicationID
		}
		qApplicationID := qrApplicationID
		if qApplicationID != "" {

			if err := r.SetQueryParam("application.id", qApplicationID); err != nil {
				return err
			}
		}
	}

	// path param application.name
	if err := r.SetPathParam("application.name", o.ApplicationName); err != nil {
		return err
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
