// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new waypoint service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new waypoint service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new waypoint service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for waypoint service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	WaypointServiceCheckNamespaceActivation(params *WaypointServiceCheckNamespaceActivationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCheckNamespaceActivationOK, error)

	WaypointServiceCheckTFCOrganization(params *WaypointServiceCheckTFCOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCheckTFCOrganizationOK, error)

	WaypointServiceCreateActionConfig(params *WaypointServiceCreateActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateActionConfigOK, error)

	WaypointServiceCreateAddOn(params *WaypointServiceCreateAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateAddOnOK, error)

	WaypointServiceCreateAddOnDefinition(params *WaypointServiceCreateAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateAddOnDefinitionOK, error)

	WaypointServiceCreateAgentGroup(params *WaypointServiceCreateAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateAgentGroupOK, error)

	WaypointServiceCreateApplicationFromTemplate(params *WaypointServiceCreateApplicationFromTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateApplicationFromTemplateOK, error)

	WaypointServiceCreateApplicationTemplate(params *WaypointServiceCreateApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateApplicationTemplateOK, error)

	WaypointServiceCreateApplicationTemplate2(params *WaypointServiceCreateApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateApplicationTemplate2OK, error)

	WaypointServiceCreateNamespace(params *WaypointServiceCreateNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateNamespaceOK, error)

	WaypointServiceCreateTFCConfig(params *WaypointServiceCreateTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateTFCConfigOK, error)

	WaypointServiceCreateVariable(params *WaypointServiceCreateVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateVariableOK, error)

	WaypointServiceDeleteActionConfig(params *WaypointServiceDeleteActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteActionConfigOK, error)

	WaypointServiceDeleteAddOnDefinition(params *WaypointServiceDeleteAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteAddOnDefinitionOK, error)

	WaypointServiceDeleteAddOnDefinition2(params *WaypointServiceDeleteAddOnDefinition2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteAddOnDefinition2OK, error)

	WaypointServiceDeleteAgentGroup(params *WaypointServiceDeleteAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteAgentGroupOK, error)

	WaypointServiceDeleteApplicationTemplate(params *WaypointServiceDeleteApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplateOK, error)

	WaypointServiceDeleteApplicationTemplate2(params *WaypointServiceDeleteApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplate2OK, error)

	WaypointServiceDeleteApplicationTemplate3(params *WaypointServiceDeleteApplicationTemplate3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplate3OK, error)

	WaypointServiceDeleteApplicationTemplate4(params *WaypointServiceDeleteApplicationTemplate4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplate4OK, error)

	WaypointServiceDeleteNamespace(params *WaypointServiceDeleteNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteNamespaceOK, error)

	WaypointServiceDeleteTFCConfig(params *WaypointServiceDeleteTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteTFCConfigOK, error)

	WaypointServiceDeleteVariable(params *WaypointServiceDeleteVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteVariableOK, error)

	WaypointServiceDestroyAddOn(params *WaypointServiceDestroyAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyAddOnOK, error)

	WaypointServiceDestroyAddOn2(params *WaypointServiceDestroyAddOn2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyAddOn2OK, error)

	WaypointServiceDestroyApplication(params *WaypointServiceDestroyApplicationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyApplicationOK, error)

	WaypointServiceDestroyApplication2(params *WaypointServiceDestroyApplication2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyApplication2OK, error)

	WaypointServiceEndingAction(params *WaypointServiceEndingActionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceEndingActionOK, error)

	WaypointServiceGetActionConfig(params *WaypointServiceGetActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetActionConfigOK, error)

	WaypointServiceGetActionRun(params *WaypointServiceGetActionRunParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetActionRunOK, error)

	WaypointServiceGetAddOn(params *WaypointServiceGetAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOnOK, error)

	WaypointServiceGetAddOn2(params *WaypointServiceGetAddOn2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOn2OK, error)

	WaypointServiceGetAddOnDefinition(params *WaypointServiceGetAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOnDefinitionOK, error)

	WaypointServiceGetAddOnDefinition2(params *WaypointServiceGetAddOnDefinition2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOnDefinition2OK, error)

	WaypointServiceGetAgentGroup(params *WaypointServiceGetAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAgentGroupOK, error)

	WaypointServiceGetApplication(params *WaypointServiceGetApplicationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationOK, error)

	WaypointServiceGetApplication2(params *WaypointServiceGetApplication2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplication2OK, error)

	WaypointServiceGetApplicationTemplate(params *WaypointServiceGetApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplateOK, error)

	WaypointServiceGetApplicationTemplate2(params *WaypointServiceGetApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplate2OK, error)

	WaypointServiceGetApplicationTemplate3(params *WaypointServiceGetApplicationTemplate3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplate3OK, error)

	WaypointServiceGetApplicationTemplate4(params *WaypointServiceGetApplicationTemplate4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplate4OK, error)

	WaypointServiceGetNamespace(params *WaypointServiceGetNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetNamespaceOK, error)

	WaypointServiceGetTFCConfig(params *WaypointServiceGetTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFCConfigOK, error)

	WaypointServiceGetTFModuleDetails(params *WaypointServiceGetTFModuleDetailsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFModuleDetailsOK, error)

	WaypointServiceGetTFModuleDetails2(params *WaypointServiceGetTFModuleDetails2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFModuleDetails2OK, error)

	WaypointServiceGetTFModuleDetails3(params *WaypointServiceGetTFModuleDetails3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFModuleDetails3OK, error)

	WaypointServiceGetTFRunStatus(params *WaypointServiceGetTFRunStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFRunStatusOK, error)

	WaypointServiceGetTFWorkspaceInfo(params *WaypointServiceGetTFWorkspaceInfoParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfoOK, error)

	WaypointServiceGetTFWorkspaceInfo2(params *WaypointServiceGetTFWorkspaceInfo2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfo2OK, error)

	WaypointServiceGetTFWorkspaceInfo3(params *WaypointServiceGetTFWorkspaceInfo3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfo3OK, error)

	WaypointServiceGetTFWorkspaceInfo4(params *WaypointServiceGetTFWorkspaceInfo4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfo4OK, error)

	WaypointServiceGetVariable(params *WaypointServiceGetVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetVariableOK, error)

	WaypointServiceListActionConfigs(params *WaypointServiceListActionConfigsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionConfigsOK, error)

	WaypointServiceListActionRuns(params *WaypointServiceListActionRunsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionRunsOK, error)

	WaypointServiceListActionRuns2(params *WaypointServiceListActionRuns2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionRuns2OK, error)

	WaypointServiceListActionRunsByNamespace(params *WaypointServiceListActionRunsByNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionRunsByNamespaceOK, error)

	WaypointServiceListAddOnDefinitions(params *WaypointServiceListAddOnDefinitionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListAddOnDefinitionsOK, error)

	WaypointServiceListAddOns(params *WaypointServiceListAddOnsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListAddOnsOK, error)

	WaypointServiceListAgentGroups(params *WaypointServiceListAgentGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListAgentGroupsOK, error)

	WaypointServiceListApplicationTemplates(params *WaypointServiceListApplicationTemplatesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListApplicationTemplatesOK, error)

	WaypointServiceListApplicationTemplates2(params *WaypointServiceListApplicationTemplates2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListApplicationTemplates2OK, error)

	WaypointServiceListApplications(params *WaypointServiceListApplicationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListApplicationsOK, error)

	WaypointServiceListNoCodeModules(params *WaypointServiceListNoCodeModulesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListNoCodeModulesOK, error)

	WaypointServiceListNoCodeModules2(params *WaypointServiceListNoCodeModules2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListNoCodeModules2OK, error)

	WaypointServiceListTFAgentPools(params *WaypointServiceListTFAgentPoolsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListTFAgentPoolsOK, error)

	WaypointServiceListTFCOrganizations(params *WaypointServiceListTFCOrganizationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListTFCOrganizationsOK, error)

	WaypointServiceListTFCProjects(params *WaypointServiceListTFCProjectsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListTFCProjectsOK, error)

	WaypointServiceListVariables(params *WaypointServiceListVariablesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListVariablesOK, error)

	WaypointServiceQueueAgentOperation(params *WaypointServiceQueueAgentOperationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceQueueAgentOperationOK, error)

	WaypointServiceRetrieveAgentOperation(params *WaypointServiceRetrieveAgentOperationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceRetrieveAgentOperationOK, error)

	WaypointServiceRunAction(params *WaypointServiceRunActionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceRunActionOK, error)

	WaypointServiceSendStatusLog(params *WaypointServiceSendStatusLogParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceSendStatusLogOK, error)

	WaypointServiceStartingAction(params *WaypointServiceStartingActionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceStartingActionOK, error)

	WaypointServiceUIListActionConfigBundles(params *WaypointServiceUIListActionConfigBundlesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIListActionConfigBundlesOK, error)

	WaypointServiceUIBulkUpdateActionAssignForApp(params *WaypointServiceUIBulkUpdateActionAssignForAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIBulkUpdateActionAssignForAppOK, error)

	WaypointServiceUICreateActionConfigWithVars(params *WaypointServiceUICreateActionConfigWithVarsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUICreateActionConfigWithVarsOK, error)

	WaypointServiceUIGetActionConfigBundle(params *WaypointServiceUIGetActionConfigBundleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetActionConfigBundleOK, error)

	WaypointServiceUIGetActionConfigBundle2(params *WaypointServiceUIGetActionConfigBundle2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetActionConfigBundle2OK, error)

	WaypointServiceUIGetApplicationBundle(params *WaypointServiceUIGetApplicationBundleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationBundleOK, error)

	WaypointServiceUIGetApplicationBundle2(params *WaypointServiceUIGetApplicationBundle2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationBundle2OK, error)

	WaypointServiceUIGetApplicationTemplateBundle(params *WaypointServiceUIGetApplicationTemplateBundleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationTemplateBundleOK, error)

	WaypointServiceUIGetApplicationTemplateBundle2(params *WaypointServiceUIGetApplicationTemplateBundle2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationTemplateBundle2OK, error)

	WaypointServiceUIListAddOnDefinitions(params *WaypointServiceUIListAddOnDefinitionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIListAddOnDefinitionsOK, error)

	WaypointServiceUILoadProductBanner(params *WaypointServiceUILoadProductBannerParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUILoadProductBannerOK, error)

	WaypointServiceUpdateActionConfig(params *WaypointServiceUpdateActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateActionConfigOK, error)

	WaypointServiceUpdateAddOn(params *WaypointServiceUpdateAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAddOnOK, error)

	WaypointServiceUpdateAddOnDefinition(params *WaypointServiceUpdateAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAddOnDefinitionOK, error)

	WaypointServiceUpdateAddOnDefinition2(params *WaypointServiceUpdateAddOnDefinition2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAddOnDefinition2OK, error)

	WaypointServiceUpdateAgentGroup(params *WaypointServiceUpdateAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAgentGroupOK, error)

	WaypointServiceUpdateApplication(params *WaypointServiceUpdateApplicationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationOK, error)

	WaypointServiceUpdateApplication2(params *WaypointServiceUpdateApplication2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplication2OK, error)

	WaypointServiceUpdateApplicationTemplate(params *WaypointServiceUpdateApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplateOK, error)

	WaypointServiceUpdateApplicationTemplate2(params *WaypointServiceUpdateApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate2OK, error)

	WaypointServiceUpdateApplicationTemplate3(params *WaypointServiceUpdateApplicationTemplate3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate3OK, error)

	WaypointServiceUpdateApplicationTemplate4(params *WaypointServiceUpdateApplicationTemplate4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate4OK, error)

	WaypointServiceUpdateApplicationTemplate5(params *WaypointServiceUpdateApplicationTemplate5Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate5OK, error)

	WaypointServiceUpdateApplicationTemplate6(params *WaypointServiceUpdateApplicationTemplate6Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate6OK, error)

	WaypointServiceUpdateTFCConfig(params *WaypointServiceUpdateTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateTFCConfigOK, error)

	WaypointServiceUpdateVariable(params *WaypointServiceUpdateVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateVariableOK, error)

	WaypointServiceUpgradeApplicationTFWorkspace(params *WaypointServiceUpgradeApplicationTFWorkspaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpgradeApplicationTFWorkspaceOK, error)

	WaypointServiceValidateAgentGroups(params *WaypointServiceValidateAgentGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceValidateAgentGroupsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
WaypointServiceCheckNamespaceActivation checks namespace activation checks the activation status of a namespace based on the t f c token stored in the namespaces database
*/
func (a *Client) WaypointServiceCheckNamespaceActivation(params *WaypointServiceCheckNamespaceActivationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCheckNamespaceActivationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCheckNamespaceActivationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CheckNamespaceActivation",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/check-activation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCheckNamespaceActivationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCheckNamespaceActivationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCheckNamespaceActivationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCheckTFCOrganization checks t f c organization will use the stored t f c config to look up the t f c org and look at what permissions it has
*/
func (a *Client) WaypointServiceCheckTFCOrganization(params *WaypointServiceCheckTFCOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCheckTFCOrganizationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCheckTFCOrganizationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CheckTFCOrganization",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig/check-organization",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCheckTFCOrganizationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCheckTFCOrganizationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCheckTFCOrganizationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateActionConfig waypoint service create action config API
*/
func (a *Client) WaypointServiceCreateActionConfig(params *WaypointServiceCreateActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateActionConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateActionConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateActionConfig",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/actionconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateActionConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateActionConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateActionConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateAddOn creates add on adds an add on to a project from an add on definition
*/
func (a *Client) WaypointServiceCreateAddOn(params *WaypointServiceCreateAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateAddOnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateAddOnParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateAddOn",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateAddOnReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateAddOnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateAddOnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateAddOnDefinition creates add on definition creates a new add on definition
*/
func (a *Client) WaypointServiceCreateAddOnDefinition(params *WaypointServiceCreateAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateAddOnDefinitionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateAddOnDefinitionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateAddOnDefinition",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateAddOnDefinitionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateAddOnDefinitionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateAddOnDefinitionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateAgentGroup creates agent group creates a new agent group
*/
func (a *Client) WaypointServiceCreateAgentGroup(params *WaypointServiceCreateAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateAgentGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateAgentGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateAgentGroup",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/group",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateAgentGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateAgentGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateAgentGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateApplicationFromTemplate creates application from template creates a new waypoint application from an application template provisioning infrastructure before upserting the waypoint application to the database
*/
func (a *Client) WaypointServiceCreateApplicationFromTemplate(params *WaypointServiceCreateApplicationFromTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateApplicationFromTemplateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateApplicationFromTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateApplicationFromTemplate",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/from-template",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateApplicationFromTemplateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateApplicationFromTemplateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateApplicationFromTemplateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateApplicationTemplate creates application template creates a new application template
*/
func (a *Client) WaypointServiceCreateApplicationTemplate(params *WaypointServiceCreateApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateApplicationTemplateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateApplicationTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateApplicationTemplate",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateApplicationTemplateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateApplicationTemplateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateApplicationTemplateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateApplicationTemplate2 creates application template creates a new application template
*/
func (a *Client) WaypointServiceCreateApplicationTemplate2(params *WaypointServiceCreateApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateApplicationTemplate2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateApplicationTemplate2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateApplicationTemplate2",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateApplicationTemplate2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateApplicationTemplate2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateApplicationTemplate2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateNamespace creates namespaces creates an h c p waypoint namespaces
*/
func (a *Client) WaypointServiceCreateNamespace(params *WaypointServiceCreateNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateNamespaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateNamespaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateNamespace",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateNamespaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateNamespaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateNamespaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateTFCConfig creates t f c config creates a terraform cloud configuration
*/
func (a *Client) WaypointServiceCreateTFCConfig(params *WaypointServiceCreateTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateTFCConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateTFCConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateTFCConfig",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateTFCConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateTFCConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateTFCConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceCreateVariable waypoint service create variable API
*/
func (a *Client) WaypointServiceCreateVariable(params *WaypointServiceCreateVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceCreateVariableOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceCreateVariableParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_CreateVariable",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/variable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceCreateVariableReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceCreateVariableOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceCreateVariableDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteActionConfig waypoint service delete action config API
*/
func (a *Client) WaypointServiceDeleteActionConfig(params *WaypointServiceDeleteActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteActionConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteActionConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteActionConfig",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/actionconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteActionConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteActionConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteActionConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteAddOnDefinition deletes add on definition deletes an existing add on definition
*/
func (a *Client) WaypointServiceDeleteAddOnDefinition(params *WaypointServiceDeleteAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteAddOnDefinitionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteAddOnDefinitionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteAddOnDefinition",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{add_on_definition.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteAddOnDefinitionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteAddOnDefinitionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteAddOnDefinitionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteAddOnDefinition2 deletes add on definition deletes an existing add on definition
*/
func (a *Client) WaypointServiceDeleteAddOnDefinition2(params *WaypointServiceDeleteAddOnDefinition2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteAddOnDefinition2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteAddOnDefinition2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteAddOnDefinition2",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/by-name/{add_on_definition.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteAddOnDefinition2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteAddOnDefinition2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteAddOnDefinition2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteAgentGroup deletes agent group deletes an agent group
*/
func (a *Client) WaypointServiceDeleteAgentGroup(params *WaypointServiceDeleteAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteAgentGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteAgentGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteAgentGroup",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/group/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteAgentGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteAgentGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteAgentGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteApplicationTemplate deletes application template deletes a application template by the application template name or id
*/
func (a *Client) WaypointServiceDeleteApplicationTemplate(params *WaypointServiceDeleteApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteApplicationTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteApplicationTemplate",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates/{application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteApplicationTemplateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteApplicationTemplateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteApplicationTemplateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteApplicationTemplate2 deletes application template deletes a application template by the application template name or id
*/
func (a *Client) WaypointServiceDeleteApplicationTemplate2(params *WaypointServiceDeleteApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplate2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteApplicationTemplate2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteApplicationTemplate2",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates/by-name/{application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteApplicationTemplate2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteApplicationTemplate2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteApplicationTemplate2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteApplicationTemplate3 deletes application template deletes a application template by the application template name or id
*/
func (a *Client) WaypointServiceDeleteApplicationTemplate3(params *WaypointServiceDeleteApplicationTemplate3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplate3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteApplicationTemplate3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteApplicationTemplate3",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteApplicationTemplate3Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteApplicationTemplate3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteApplicationTemplate3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteApplicationTemplate4 deletes application template deletes a application template by the application template name or id
*/
func (a *Client) WaypointServiceDeleteApplicationTemplate4(params *WaypointServiceDeleteApplicationTemplate4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteApplicationTemplate4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteApplicationTemplate4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteApplicationTemplate4",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteApplicationTemplate4Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteApplicationTemplate4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteApplicationTemplate4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteNamespace deletes namespace deletes an h c p waypoint namespace
*/
func (a *Client) WaypointServiceDeleteNamespace(params *WaypointServiceDeleteNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteNamespaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteNamespaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteNamespace",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces/{namespace.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteNamespaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteNamespaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteNamespaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteTFCConfig deletes t f c config deletes a terraform configuration
*/
func (a *Client) WaypointServiceDeleteTFCConfig(params *WaypointServiceDeleteTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteTFCConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteTFCConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteTFCConfig",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteTFCConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteTFCConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteTFCConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDeleteVariable waypoint service delete variable API
*/
func (a *Client) WaypointServiceDeleteVariable(params *WaypointServiceDeleteVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDeleteVariableOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDeleteVariableParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DeleteVariable",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/variable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDeleteVariableReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDeleteVariableOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDeleteVariableDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDestroyAddOn destroys add on destroys an existing add on
*/
func (a *Client) WaypointServiceDestroyAddOn(params *WaypointServiceDestroyAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyAddOnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDestroyAddOnParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DestroyAddOn",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDestroyAddOnReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDestroyAddOnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDestroyAddOnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDestroyAddOn2 destroys add on destroys an existing add on
*/
func (a *Client) WaypointServiceDestroyAddOn2(params *WaypointServiceDestroyAddOn2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyAddOn2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDestroyAddOn2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DestroyAddOn2",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDestroyAddOn2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDestroyAddOn2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDestroyAddOn2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDestroyApplication destroys application destroys an existing application a destroy operation is queued for the application s terraform workspace and the application is deleted from h c p waypoint
*/
func (a *Client) WaypointServiceDestroyApplication(params *WaypointServiceDestroyApplicationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyApplicationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDestroyApplicationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DestroyApplication",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDestroyApplicationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDestroyApplicationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDestroyApplicationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceDestroyApplication2 destroys application destroys an existing application a destroy operation is queued for the application s terraform workspace and the application is deleted from h c p waypoint
*/
func (a *Client) WaypointServiceDestroyApplication2(params *WaypointServiceDestroyApplication2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceDestroyApplication2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceDestroyApplication2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_DestroyApplication2",
		Method:             "DELETE",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/by-name/{application.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceDestroyApplication2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceDestroyApplication2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceDestroyApplication2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceEndingAction endings action is run by the agent after it s operation finishes and it called starting action before running the operation it includes the action run id that was retrieved from starting action this also includes the ability to send a final status log message that will be included for the action run
*/
func (a *Client) WaypointServiceEndingAction(params *WaypointServiceEndingActionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceEndingActionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceEndingActionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_EndingAction",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:endAction",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceEndingActionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceEndingActionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceEndingActionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetActionConfig configs endpoints
*/
func (a *Client) WaypointServiceGetActionConfig(params *WaypointServiceGetActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetActionConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetActionConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetActionConfig",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/actionconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetActionConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetActionConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetActionConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetActionRun waypoint service get action run API
*/
func (a *Client) WaypointServiceGetActionRun(params *WaypointServiceGetActionRunParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetActionRunOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetActionRunParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetActionRun",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/action",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetActionRunReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetActionRunOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetActionRunDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetAddOn gets add on returns an existing add on
*/
func (a *Client) WaypointServiceGetAddOn(params *WaypointServiceGetAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetAddOnParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetAddOn",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetAddOnReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetAddOnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetAddOnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetAddOn2 gets add on returns an existing add on
*/
func (a *Client) WaypointServiceGetAddOn2(params *WaypointServiceGetAddOn2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOn2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetAddOn2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetAddOn2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetAddOn2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetAddOn2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetAddOn2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetAddOnDefinition gets add on definition returns an add on definition referenced by name or ID
*/
func (a *Client) WaypointServiceGetAddOnDefinition(params *WaypointServiceGetAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOnDefinitionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetAddOnDefinitionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetAddOnDefinition",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{add_on_definition.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetAddOnDefinitionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetAddOnDefinitionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetAddOnDefinitionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetAddOnDefinition2 gets add on definition returns an add on definition referenced by name or ID
*/
func (a *Client) WaypointServiceGetAddOnDefinition2(params *WaypointServiceGetAddOnDefinition2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAddOnDefinition2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetAddOnDefinition2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetAddOnDefinition2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/by-name/{add_on_definition.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetAddOnDefinition2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetAddOnDefinition2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetAddOnDefinition2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetAgentGroup gets agent group returns the information about the specified group
*/
func (a *Client) WaypointServiceGetAgentGroup(params *WaypointServiceGetAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetAgentGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetAgentGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetAgentGroup",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/group/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetAgentGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetAgentGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetAgentGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetApplication gets application returns an application by ID or name
*/
func (a *Client) WaypointServiceGetApplication(params *WaypointServiceGetApplicationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetApplicationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetApplication",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetApplicationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetApplicationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetApplicationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetApplication2 gets application returns an application by ID or name
*/
func (a *Client) WaypointServiceGetApplication2(params *WaypointServiceGetApplication2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplication2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetApplication2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetApplication2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/by-name/{application.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetApplication2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetApplication2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetApplication2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetApplicationTemplate gets application template returns a application template by the application template name or id
*/
func (a *Client) WaypointServiceGetApplicationTemplate(params *WaypointServiceGetApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetApplicationTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetApplicationTemplate",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates/{application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetApplicationTemplateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetApplicationTemplateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetApplicationTemplateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetApplicationTemplate2 gets application template returns a application template by the application template name or id
*/
func (a *Client) WaypointServiceGetApplicationTemplate2(params *WaypointServiceGetApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplate2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetApplicationTemplate2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetApplicationTemplate2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates/by-name/{application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetApplicationTemplate2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetApplicationTemplate2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetApplicationTemplate2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetApplicationTemplate3 gets application template returns a application template by the application template name or id
*/
func (a *Client) WaypointServiceGetApplicationTemplate3(params *WaypointServiceGetApplicationTemplate3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplate3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetApplicationTemplate3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetApplicationTemplate3",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetApplicationTemplate3Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetApplicationTemplate3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetApplicationTemplate3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetApplicationTemplate4 gets application template returns a application template by the application template name or id
*/
func (a *Client) WaypointServiceGetApplicationTemplate4(params *WaypointServiceGetApplicationTemplate4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetApplicationTemplate4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetApplicationTemplate4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetApplicationTemplate4",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetApplicationTemplate4Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetApplicationTemplate4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetApplicationTemplate4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetNamespace gets namespace gets a namespace based on either the namespace ID or an h c p location returns not found if the namespace doesn t exist
*/
func (a *Client) WaypointServiceGetNamespace(params *WaypointServiceGetNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetNamespaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetNamespaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetNamespace",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetNamespaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetNamespaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetNamespaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFCConfig gets t f c config gets the server stored terraform cloud config
*/
func (a *Client) WaypointServiceGetTFCConfig(params *WaypointServiceGetTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFCConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFCConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFCConfig",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFCConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFCConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFCConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFModuleDetails gets t f module details returns the details of a specific no code module
*/
func (a *Client) WaypointServiceGetTFModuleDetails(params *WaypointServiceGetTFModuleDetailsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFModuleDetailsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFModuleDetailsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFModuleDetails",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}/{version}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFModuleDetailsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFModuleDetailsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFModuleDetailsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFModuleDetails2 gets t f module details returns the details of a specific no code module
*/
func (a *Client) WaypointServiceGetTFModuleDetails2(params *WaypointServiceGetTFModuleDetails2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFModuleDetails2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFModuleDetails2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFModuleDetails2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFModuleDetails2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFModuleDetails2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFModuleDetails2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFModuleDetails3 gets t f module details returns the details of a specific no code module
*/
func (a *Client) WaypointServiceGetTFModuleDetails3(params *WaypointServiceGetTFModuleDetails3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFModuleDetails3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFModuleDetails3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFModuleDetails3",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}/{module_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFModuleDetails3Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFModuleDetails3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFModuleDetails3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFRunStatus gets t f run status returns the status of the latest run of a terraform workspace
*/
func (a *Client) WaypointServiceGetTFRunStatus(params *WaypointServiceGetTFRunStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFRunStatusOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFRunStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFRunStatus",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tf-run-status/{workspace_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFRunStatusReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFRunStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFRunStatusDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFWorkspaceInfo useds to retrieve the upgrade status of a workspace given the workspace id or workspace name
*/
func (a *Client) WaypointServiceGetTFWorkspaceInfo(params *WaypointServiceGetTFWorkspaceInfoParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfoOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFWorkspaceInfoParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFWorkspaceInfo",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application/{application.id}/workspace",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFWorkspaceInfoReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFWorkspaceInfoOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFWorkspaceInfoDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFWorkspaceInfo2 useds to retrieve the upgrade status of a workspace given the workspace id or workspace name
*/
func (a *Client) WaypointServiceGetTFWorkspaceInfo2(params *WaypointServiceGetTFWorkspaceInfo2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfo2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFWorkspaceInfo2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFWorkspaceInfo2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application/by-name/{application.name}/workspace",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFWorkspaceInfo2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFWorkspaceInfo2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFWorkspaceInfo2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFWorkspaceInfo3 useds to retrieve the upgrade status of a workspace given the workspace id or workspace name
*/
func (a *Client) WaypointServiceGetTFWorkspaceInfo3(params *WaypointServiceGetTFWorkspaceInfo3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfo3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFWorkspaceInfo3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFWorkspaceInfo3",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}/workspace",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFWorkspaceInfo3Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFWorkspaceInfo3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFWorkspaceInfo3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetTFWorkspaceInfo4 useds to retrieve the upgrade status of a workspace given the workspace id or workspace name
*/
func (a *Client) WaypointServiceGetTFWorkspaceInfo4(params *WaypointServiceGetTFWorkspaceInfo4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetTFWorkspaceInfo4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetTFWorkspaceInfo4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetTFWorkspaceInfo4",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}/workspace",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetTFWorkspaceInfo4Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetTFWorkspaceInfo4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetTFWorkspaceInfo4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceGetVariable waypoint service get variable API
*/
func (a *Client) WaypointServiceGetVariable(params *WaypointServiceGetVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceGetVariableOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceGetVariableParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_GetVariable",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/variable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceGetVariableReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceGetVariableOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceGetVariableDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListActionConfigs waypoint service list action configs API
*/
func (a *Client) WaypointServiceListActionConfigs(params *WaypointServiceListActionConfigsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionConfigsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListActionConfigsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListActionConfigs",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/actionconfigs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListActionConfigsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListActionConfigsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListActionConfigsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListActionRuns lists all action runs for a given config
*/
func (a *Client) WaypointServiceListActionRuns(params *WaypointServiceListActionRunsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionRunsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListActionRunsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListActionRuns",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/action/{action_id}/runs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListActionRunsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListActionRunsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListActionRunsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListActionRuns2 lists all action runs for a given config
*/
func (a *Client) WaypointServiceListActionRuns2(params *WaypointServiceListActionRuns2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionRuns2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListActionRuns2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListActionRuns2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/action/by-name/{action_name}/runs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListActionRuns2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListActionRuns2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListActionRuns2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListActionRunsByNamespace lists all action runs for the entire namespace for all configs
*/
func (a *Client) WaypointServiceListActionRunsByNamespace(params *WaypointServiceListActionRunsByNamespaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListActionRunsByNamespaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListActionRunsByNamespaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListActionRunsByNamespace",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/action-runs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListActionRunsByNamespaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListActionRunsByNamespaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListActionRunsByNamespaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListAddOnDefinitions lists add on definitions returns all existing add on definitions
*/
func (a *Client) WaypointServiceListAddOnDefinitions(params *WaypointServiceListAddOnDefinitionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListAddOnDefinitionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListAddOnDefinitionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListAddOnDefinitions",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definitions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListAddOnDefinitionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListAddOnDefinitionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListAddOnDefinitionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListAddOns lists add ons returns all existing add ons
*/
func (a *Client) WaypointServiceListAddOns(params *WaypointServiceListAddOnsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListAddOnsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListAddOnsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListAddOns",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-ons",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListAddOnsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListAddOnsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListAddOnsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListAgentGroups lists agent groups returns the agent groups defined on the h c p project
*/
func (a *Client) WaypointServiceListAgentGroups(params *WaypointServiceListAgentGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListAgentGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListAgentGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListAgentGroups",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/group",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListAgentGroupsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListAgentGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListAgentGroupsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListApplicationTemplates lists application templates returns a list of all application templates known
*/
func (a *Client) WaypointServiceListApplicationTemplates(params *WaypointServiceListApplicationTemplatesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListApplicationTemplatesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListApplicationTemplatesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListApplicationTemplates",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListApplicationTemplatesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListApplicationTemplatesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListApplicationTemplatesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListApplicationTemplates2 lists application templates returns a list of all application templates known
*/
func (a *Client) WaypointServiceListApplicationTemplates2(params *WaypointServiceListApplicationTemplates2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListApplicationTemplates2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListApplicationTemplates2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListApplicationTemplates2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListApplicationTemplates2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListApplicationTemplates2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListApplicationTemplates2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListApplications lists applications returns a list of all applications
*/
func (a *Client) WaypointServiceListApplications(params *WaypointServiceListApplicationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListApplicationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListApplicationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListApplications",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListApplicationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListApplicationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListApplicationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListNoCodeModules lists no code modules returns a list of available no code module for the configured t f c organization
*/
func (a *Client) WaypointServiceListNoCodeModules(params *WaypointServiceListNoCodeModulesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListNoCodeModulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListNoCodeModulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListNoCodeModules",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfcmodules",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListNoCodeModulesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListNoCodeModulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListNoCodeModulesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListNoCodeModules2 lists no code modules returns a list of available no code module for the configured t f c organization
*/
func (a *Client) WaypointServiceListNoCodeModules2(params *WaypointServiceListNoCodeModules2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListNoCodeModules2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListNoCodeModules2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListNoCodeModules2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfmodules",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListNoCodeModules2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListNoCodeModules2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListNoCodeModules2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListTFAgentPools lists t f agent pools returns a list of h c p terraform agent pools
*/
func (a *Client) WaypointServiceListTFAgentPools(params *WaypointServiceListTFAgentPoolsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListTFAgentPoolsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListTFAgentPoolsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListTFAgentPools",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tf-agent-pools",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListTFAgentPoolsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListTFAgentPoolsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListTFAgentPoolsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListTFCOrganizations lists t f c organizations returns a list of available h c p terraform organizations which can be used by the currently set token
*/
func (a *Client) WaypointServiceListTFCOrganizations(params *WaypointServiceListTFCOrganizationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListTFCOrganizationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListTFCOrganizationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListTFCOrganizations",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfc-organizations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListTFCOrganizationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListTFCOrganizationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListTFCOrganizationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListTFCProjects lists t f c projects returns a list of available t f c projects for the configured t f c organization
*/
func (a *Client) WaypointServiceListTFCProjects(params *WaypointServiceListTFCProjectsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListTFCProjectsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListTFCProjectsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListTFCProjects",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfc-projects",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListTFCProjectsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListTFCProjectsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListTFCProjectsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceListVariables waypoint service list variables API
*/
func (a *Client) WaypointServiceListVariables(params *WaypointServiceListVariablesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceListVariablesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceListVariablesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ListVariables",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/variables",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceListVariablesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceListVariablesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceListVariablesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceQueueAgentOperation useds by any code that wishes to have an agent execute an operation this places a new operation into the queue for a specific group a future caller of retrieve agent operation will then return that operation
*/
func (a *Client) WaypointServiceQueueAgentOperation(params *WaypointServiceQueueAgentOperationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceQueueAgentOperationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceQueueAgentOperationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_QueueAgentOperation",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:queue",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceQueueAgentOperationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceQueueAgentOperationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceQueueAgentOperationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceRetrieveAgentOperation useds by the agent itself retrieve agent operation returns any available operations from the specified groups the agent polls on this endpoint every 60 seconds by default
*/
func (a *Client) WaypointServiceRetrieveAgentOperation(params *WaypointServiceRetrieveAgentOperationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceRetrieveAgentOperationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceRetrieveAgentOperationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_RetrieveAgentOperation",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:retrieve",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceRetrieveAgentOperationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceRetrieveAgentOperationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceRetrieveAgentOperationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceRunAction runnings actions
*/
func (a *Client) WaypointServiceRunAction(params *WaypointServiceRunActionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceRunActionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceRunActionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_RunAction",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/action",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceRunActionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceRunActionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceRunActionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceSendStatusLog statuses logs for action runs
*/
func (a *Client) WaypointServiceSendStatusLog(params *WaypointServiceSendStatusLogParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceSendStatusLogOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceSendStatusLogParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_SendStatusLog",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/action/{action_config.id}/action-runs/{action_run_seq}/status-log",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceSendStatusLogReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceSendStatusLogOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceSendStatusLogDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceStartingAction startings action is run by the agent after retrieving an operation and seeing an action config id specified on the operation this allows for agents to integrate with actions closely
*/
func (a *Client) WaypointServiceStartingAction(params *WaypointServiceStartingActionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceStartingActionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceStartingActionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_StartingAction",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:startAction",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceStartingActionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceStartingActionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceStartingActionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIListActionConfigBundles waypoint service UI list action config bundles API
*/
func (a *Client) WaypointServiceUIListActionConfigBundles(params *WaypointServiceUIListActionConfigBundlesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIListActionConfigBundlesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIListActionConfigBundlesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UIListActionConfigBundles",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfigs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIListActionConfigBundlesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIListActionConfigBundlesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIListActionConfigBundlesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIBulkUpdateActionAssignForApp waypoint service UI bulk update action assign for app API
*/
func (a *Client) WaypointServiceUIBulkUpdateActionAssignForApp(params *WaypointServiceUIBulkUpdateActionAssignForAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIBulkUpdateActionAssignForAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIBulkUpdateActionAssignForAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_BulkUpdateActionAssignForApp",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/applications/action-assignments",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIBulkUpdateActionAssignForAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIBulkUpdateActionAssignForAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIBulkUpdateActionAssignForAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUICreateActionConfigWithVars waypoint service UI create action config with vars API
*/
func (a *Client) WaypointServiceUICreateActionConfigWithVars(params *WaypointServiceUICreateActionConfigWithVarsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUICreateActionConfigWithVarsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUICreateActionConfigWithVarsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_CreateActionConfigWithVars",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfigwithvars",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUICreateActionConfigWithVarsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUICreateActionConfigWithVarsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUICreateActionConfigWithVarsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIGetActionConfigBundle waypoint service UI get action config bundle API
*/
func (a *Client) WaypointServiceUIGetActionConfigBundle(params *WaypointServiceUIGetActionConfigBundleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetActionConfigBundleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIGetActionConfigBundleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_GetActionConfigBundle",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfig/{action_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIGetActionConfigBundleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIGetActionConfigBundleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIGetActionConfigBundleDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIGetActionConfigBundle2 waypoint service UI get action config bundle2 API
*/
func (a *Client) WaypointServiceUIGetActionConfigBundle2(params *WaypointServiceUIGetActionConfigBundle2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetActionConfigBundle2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIGetActionConfigBundle2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_GetActionConfigBundle2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfig/by-name/{action_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIGetActionConfigBundle2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIGetActionConfigBundle2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIGetActionConfigBundle2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIGetApplicationBundle UIs get application bundle returns an application and any associated action configs it may have
*/
func (a *Client) WaypointServiceUIGetApplicationBundle(params *WaypointServiceUIGetApplicationBundleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationBundleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIGetApplicationBundleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_GetApplicationBundle",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/applications/{application.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIGetApplicationBundleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIGetApplicationBundleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIGetApplicationBundleDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIGetApplicationBundle2 UIs get application bundle returns an application and any associated action configs it may have
*/
func (a *Client) WaypointServiceUIGetApplicationBundle2(params *WaypointServiceUIGetApplicationBundle2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationBundle2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIGetApplicationBundle2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_GetApplicationBundle2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/applications/by-name/{application.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIGetApplicationBundle2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIGetApplicationBundle2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIGetApplicationBundle2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIGetApplicationTemplateBundle UIs get application template bundle returns a template using a name or id to look it up this RPC is used by the h c p waypoint UI
*/
func (a *Client) WaypointServiceUIGetApplicationTemplateBundle(params *WaypointServiceUIGetApplicationTemplateBundleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationTemplateBundleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIGetApplicationTemplateBundleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_GetApplicationTemplateBundle",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/application-templates/{application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIGetApplicationTemplateBundleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIGetApplicationTemplateBundleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIGetApplicationTemplateBundleDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIGetApplicationTemplateBundle2 UIs get application template bundle returns a template using a name or id to look it up this RPC is used by the h c p waypoint UI
*/
func (a *Client) WaypointServiceUIGetApplicationTemplateBundle2(params *WaypointServiceUIGetApplicationTemplateBundle2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIGetApplicationTemplateBundle2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIGetApplicationTemplateBundle2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_GetApplicationTemplateBundle2",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/application-templates/by-name/{application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIGetApplicationTemplateBundle2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIGetApplicationTemplateBundle2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIGetApplicationTemplateBundle2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUIListAddOnDefinitions lists add on definitions within the context of a project
*/
func (a *Client) WaypointServiceUIListAddOnDefinitions(params *WaypointServiceUIListAddOnDefinitionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUIListAddOnDefinitionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUIListAddOnDefinitionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_ListAddOnDefinitions",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/add-on-definitions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUIListAddOnDefinitionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUIListAddOnDefinitionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUIListAddOnDefinitionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUILoadProductBanner UIs load product banner will call two functions for checking the stored t f c tokens expiration against t f c as well as the stored t f c orgs permisions as set by t f c the UI uses this function to show product activation or deactivation banners
*/
func (a *Client) WaypointServiceUILoadProductBanner(params *WaypointServiceUILoadProductBannerParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUILoadProductBannerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUILoadProductBannerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UI_LoadProductBanner",
		Method:             "GET",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/ui/product-banner",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUILoadProductBannerReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUILoadProductBannerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUILoadProductBannerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateActionConfig waypoint service update action config API
*/
func (a *Client) WaypointServiceUpdateActionConfig(params *WaypointServiceUpdateActionConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateActionConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateActionConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateActionConfig",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/actionconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateActionConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateActionConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateActionConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateAddOn updates add on updates an existing add on
*/
func (a *Client) WaypointServiceUpdateAddOn(params *WaypointServiceUpdateAddOnParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAddOnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateAddOnParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateAddOn",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on/{existing_add_on.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateAddOnReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateAddOnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateAddOnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateAddOnDefinition updates add on definition updates an existing add on definition
*/
func (a *Client) WaypointServiceUpdateAddOnDefinition(params *WaypointServiceUpdateAddOnDefinitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAddOnDefinitionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateAddOnDefinitionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateAddOnDefinition",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{existing_add_on_definition.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateAddOnDefinitionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateAddOnDefinitionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateAddOnDefinitionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateAddOnDefinition2 updates add on definition updates an existing add on definition
*/
func (a *Client) WaypointServiceUpdateAddOnDefinition2(params *WaypointServiceUpdateAddOnDefinition2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAddOnDefinition2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateAddOnDefinition2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateAddOnDefinition2",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/by-name/{existing_add_on_definition.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateAddOnDefinition2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateAddOnDefinition2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateAddOnDefinition2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateAgentGroup updates agent group updates an agent group
*/
func (a *Client) WaypointServiceUpdateAgentGroup(params *WaypointServiceUpdateAgentGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateAgentGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateAgentGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateAgentGroup",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/group/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateAgentGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateAgentGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateAgentGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplication updates application updates an existing application
*/
func (a *Client) WaypointServiceUpdateApplication(params *WaypointServiceUpdateApplicationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplication",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplication2 updates application updates an existing application
*/
func (a *Client) WaypointServiceUpdateApplication2(params *WaypointServiceUpdateApplication2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplication2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplication2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplication2",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/by-name/{application.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplication2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplication2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplication2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplicationTemplate updates application template updates an existing application template
*/
func (a *Client) WaypointServiceUpdateApplicationTemplate(params *WaypointServiceUpdateApplicationTemplateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplicationTemplate",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates/{existing_application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationTemplateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationTemplateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationTemplateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplicationTemplate2 updates application template updates an existing application template
*/
func (a *Client) WaypointServiceUpdateApplicationTemplate2(params *WaypointServiceUpdateApplicationTemplate2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationTemplate2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplicationTemplate2",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/application-templates/by-name/{existing_application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationTemplate2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationTemplate2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationTemplate2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplicationTemplate3 updates application template updates an existing application template
*/
func (a *Client) WaypointServiceUpdateApplicationTemplate3(params *WaypointServiceUpdateApplicationTemplate3Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationTemplate3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplicationTemplate3",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/{existing_application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationTemplate3Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationTemplate3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationTemplate3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplicationTemplate4 updates application template updates an existing application template
*/
func (a *Client) WaypointServiceUpdateApplicationTemplate4(params *WaypointServiceUpdateApplicationTemplate4Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationTemplate4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplicationTemplate4",
		Method:             "PUT",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{existing_application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationTemplate4Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationTemplate4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationTemplate4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplicationTemplate5 updates application template updates an existing application template
*/
func (a *Client) WaypointServiceUpdateApplicationTemplate5(params *WaypointServiceUpdateApplicationTemplate5Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate5OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationTemplate5Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplicationTemplate5",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/{existing_application_template.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationTemplate5Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationTemplate5OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationTemplate5Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateApplicationTemplate6 updates application template updates an existing application template
*/
func (a *Client) WaypointServiceUpdateApplicationTemplate6(params *WaypointServiceUpdateApplicationTemplate6Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateApplicationTemplate6OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateApplicationTemplate6Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateApplicationTemplate6",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{existing_application_template.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateApplicationTemplate6Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateApplicationTemplate6OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateApplicationTemplate6Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateTFCConfig updates t f c config updates a terraform cloud configuration
*/
func (a *Client) WaypointServiceUpdateTFCConfig(params *WaypointServiceUpdateTFCConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateTFCConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateTFCConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateTFCConfig",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateTFCConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateTFCConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateTFCConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpdateVariable waypoint service update variable API
*/
func (a *Client) WaypointServiceUpdateVariable(params *WaypointServiceUpdateVariableParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpdateVariableOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpdateVariableParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpdateVariable",
		Method:             "PATCH",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/variable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpdateVariableReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpdateVariableOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpdateVariableDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceUpgradeApplicationTFWorkspace upgrades application t f workspace upgrades the application s terraform workspace to the pinned version of the no code module used to provision the application infrastructure
*/
func (a *Client) WaypointServiceUpgradeApplicationTFWorkspace(params *WaypointServiceUpgradeApplicationTFWorkspaceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceUpgradeApplicationTFWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceUpgradeApplicationTFWorkspaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_UpgradeApplicationTFWorkspace",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.name}/upgrade-tf-workspace",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceUpgradeApplicationTFWorkspaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceUpgradeApplicationTFWorkspaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceUpgradeApplicationTFWorkspaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointServiceValidateAgentGroups validates agent groups is called by the agent on startup to check that the groups it is listening on are valid groups
*/
func (a *Client) WaypointServiceValidateAgentGroups(params *WaypointServiceValidateAgentGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WaypointServiceValidateAgentGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointServiceValidateAgentGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "WaypointService_ValidateAgentGroups",
		Method:             "POST",
		PathPattern:        "/waypoint/2023-08-18/namespace/{namespace.id}/agent/group:validate",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &WaypointServiceValidateAgentGroupsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointServiceValidateAgentGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointServiceValidateAgentGroupsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
