// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// OpenAppSecretByResourceNameReader is a Reader for the OpenAppSecretByResourceName structure.
type OpenAppSecretByResourceNameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OpenAppSecretByResourceNameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOpenAppSecretByResourceNameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOpenAppSecretByResourceNameDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOpenAppSecretByResourceNameOK creates a OpenAppSecretByResourceNameOK with default headers values
func NewOpenAppSecretByResourceNameOK() *OpenAppSecretByResourceNameOK {
	return &OpenAppSecretByResourceNameOK{}
}

/*
OpenAppSecretByResourceNameOK describes a response with status code 200, with default header values.

A successful response.
*/
type OpenAppSecretByResourceNameOK struct {
	Payload *models.Secrets20231128OpenAppSecretResponse
}

// IsSuccess returns true when this open app secret by resource name o k response has a 2xx status code
func (o *OpenAppSecretByResourceNameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this open app secret by resource name o k response has a 3xx status code
func (o *OpenAppSecretByResourceNameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this open app secret by resource name o k response has a 4xx status code
func (o *OpenAppSecretByResourceNameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this open app secret by resource name o k response has a 5xx status code
func (o *OpenAppSecretByResourceNameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this open app secret by resource name o k response a status code equal to that given
func (o *OpenAppSecretByResourceNameOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the open app secret by resource name o k response
func (o *OpenAppSecretByResourceNameOK) Code() int {
	return 200
}

func (o *OpenAppSecretByResourceNameOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2023-11-28/{resource_name}:open][%d] openAppSecretByResourceNameOK %s", 200, payload)
}

func (o *OpenAppSecretByResourceNameOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2023-11-28/{resource_name}:open][%d] openAppSecretByResourceNameOK %s", 200, payload)
}

func (o *OpenAppSecretByResourceNameOK) GetPayload() *models.Secrets20231128OpenAppSecretResponse {
	return o.Payload
}

func (o *OpenAppSecretByResourceNameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128OpenAppSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOpenAppSecretByResourceNameDefault creates a OpenAppSecretByResourceNameDefault with default headers values
func NewOpenAppSecretByResourceNameDefault(code int) *OpenAppSecretByResourceNameDefault {
	return &OpenAppSecretByResourceNameDefault{
		_statusCode: code,
	}
}

/*
OpenAppSecretByResourceNameDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OpenAppSecretByResourceNameDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this open app secret by resource name default response has a 2xx status code
func (o *OpenAppSecretByResourceNameDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this open app secret by resource name default response has a 3xx status code
func (o *OpenAppSecretByResourceNameDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this open app secret by resource name default response has a 4xx status code
func (o *OpenAppSecretByResourceNameDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this open app secret by resource name default response has a 5xx status code
func (o *OpenAppSecretByResourceNameDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this open app secret by resource name default response a status code equal to that given
func (o *OpenAppSecretByResourceNameDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the open app secret by resource name default response
func (o *OpenAppSecretByResourceNameDefault) Code() int {
	return o._statusCode
}

func (o *OpenAppSecretByResourceNameDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2023-11-28/{resource_name}:open][%d] OpenAppSecretByResourceName default %s", o._statusCode, payload)
}

func (o *OpenAppSecretByResourceNameDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2023-11-28/{resource_name}:open][%d] OpenAppSecretByResourceName default %s", o._statusCode, payload)
}

func (o *OpenAppSecretByResourceNameDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *OpenAppSecretByResourceNameDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
