// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewLockOrganizationParams creates a new LockOrganizationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLockOrganizationParams() *LockOrganizationParams {
	return &LockOrganizationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLockOrganizationParamsWithTimeout creates a new LockOrganizationParams object
// with the ability to set a timeout on a request.
func NewLockOrganizationParamsWithTimeout(timeout time.Duration) *LockOrganizationParams {
	return &LockOrganizationParams{
		timeout: timeout,
	}
}

// NewLockOrganizationParamsWithContext creates a new LockOrganizationParams object
// with the ability to set a context for a request.
func NewLockOrganizationParamsWithContext(ctx context.Context) *LockOrganizationParams {
	return &LockOrganizationParams{
		Context: ctx,
	}
}

// NewLockOrganizationParamsWithHTTPClient creates a new LockOrganizationParams object
// with the ability to set a custom HTTPClient for a request.
func NewLockOrganizationParamsWithHTTPClient(client *http.Client) *LockOrganizationParams {
	return &LockOrganizationParams{
		HTTPClient: client,
	}
}

/*
LockOrganizationParams contains all the parameters to send to the API endpoint

	for the lock organization operation.

	Typically these are written to a http.Request.
*/
type LockOrganizationParams struct {

	// Body.
	Body *models.SecretServiceLockOrganizationBody

	// OrganizationID.
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lock organization params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LockOrganizationParams) WithDefaults() *LockOrganizationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lock organization params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LockOrganizationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the lock organization params
func (o *LockOrganizationParams) WithTimeout(timeout time.Duration) *LockOrganizationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lock organization params
func (o *LockOrganizationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lock organization params
func (o *LockOrganizationParams) WithContext(ctx context.Context) *LockOrganizationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lock organization params
func (o *LockOrganizationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lock organization params
func (o *LockOrganizationParams) WithHTTPClient(client *http.Client) *LockOrganizationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lock organization params
func (o *LockOrganizationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the lock organization params
func (o *LockOrganizationParams) WithBody(body *models.SecretServiceLockOrganizationBody) *LockOrganizationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the lock organization params
func (o *LockOrganizationParams) SetBody(body *models.SecretServiceLockOrganizationBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the lock organization params
func (o *LockOrganizationParams) WithOrganizationID(organizationID string) *LockOrganizationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the lock organization params
func (o *LockOrganizationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *LockOrganizationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
