// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetIntegrationReader is a Reader for the GetIntegration structure.
type GetIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetIntegrationOK creates a GetIntegrationOK with default headers values
func NewGetIntegrationOK() *GetIntegrationOK {
	return &GetIntegrationOK{}
}

/*
GetIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetIntegrationOK struct {
	Payload *models.Secrets20231128GetIntegrationResponse
}

// IsSuccess returns true when this get integration o k response has a 2xx status code
func (o *GetIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get integration o k response has a 3xx status code
func (o *GetIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get integration o k response has a 4xx status code
func (o *GetIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get integration o k response has a 5xx status code
func (o *GetIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get integration o k response a status code equal to that given
func (o *GetIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get integration o k response
func (o *GetIntegrationOK) Code() int {
	return 200
}

func (o *GetIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] getIntegrationOK %s", 200, payload)
}

func (o *GetIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] getIntegrationOK %s", 200, payload)
}

func (o *GetIntegrationOK) GetPayload() *models.Secrets20231128GetIntegrationResponse {
	return o.Payload
}

func (o *GetIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntegrationDefault creates a GetIntegrationDefault with default headers values
func NewGetIntegrationDefault(code int) *GetIntegrationDefault {
	return &GetIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get integration default response has a 2xx status code
func (o *GetIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get integration default response has a 3xx status code
func (o *GetIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get integration default response has a 4xx status code
func (o *GetIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get integration default response has a 5xx status code
func (o *GetIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get integration default response a status code equal to that given
func (o *GetIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get integration default response
func (o *GetIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] GetIntegration default %s", o._statusCode, payload)
}

func (o *GetIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] GetIntegration default %s", o._statusCode, payload)
}

func (o *GetIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
