// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateIntegrationParams creates a new CreateIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateIntegrationParams() *CreateIntegrationParams {
	return &CreateIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateIntegrationParamsWithTimeout creates a new CreateIntegrationParams object
// with the ability to set a timeout on a request.
func NewCreateIntegrationParamsWithTimeout(timeout time.Duration) *CreateIntegrationParams {
	return &CreateIntegrationParams{
		timeout: timeout,
	}
}

// NewCreateIntegrationParamsWithContext creates a new CreateIntegrationParams object
// with the ability to set a context for a request.
func NewCreateIntegrationParamsWithContext(ctx context.Context) *CreateIntegrationParams {
	return &CreateIntegrationParams{
		Context: ctx,
	}
}

// NewCreateIntegrationParamsWithHTTPClient creates a new CreateIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateIntegrationParamsWithHTTPClient(client *http.Client) *CreateIntegrationParams {
	return &CreateIntegrationParams{
		HTTPClient: client,
	}
}

/*
CreateIntegrationParams contains all the parameters to send to the API endpoint

	for the create integration operation.

	Typically these are written to a http.Request.
*/
type CreateIntegrationParams struct {

	// Body.
	Body *models.SecretServiceCreateIntegrationBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateIntegrationParams) WithDefaults() *CreateIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create integration params
func (o *CreateIntegrationParams) WithTimeout(timeout time.Duration) *CreateIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create integration params
func (o *CreateIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create integration params
func (o *CreateIntegrationParams) WithContext(ctx context.Context) *CreateIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create integration params
func (o *CreateIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create integration params
func (o *CreateIntegrationParams) WithHTTPClient(client *http.Client) *CreateIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create integration params
func (o *CreateIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create integration params
func (o *CreateIntegrationParams) WithBody(body *models.SecretServiceCreateIntegrationBody) *CreateIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create integration params
func (o *CreateIntegrationParams) SetBody(body *models.SecretServiceCreateIntegrationBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create integration params
func (o *CreateIntegrationParams) WithOrganizationID(organizationID string) *CreateIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create integration params
func (o *CreateIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create integration params
func (o *CreateIntegrationParams) WithProjectID(projectID string) *CreateIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create integration params
func (o *CreateIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
