// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// APIHTTPBody Message that represents an arbitrary HTTP body. It should only be used for
// payload formats that can't be represented as JSON, such as raw binary or
// an HTML page.
//
// This message can be used both in streaming and non-streaming API methods in
// the request as well as the response.
//
// It can be used as a top-level request field, which is convenient if one
// wants to extract parameters from either the URL or HTTP template into the
// request fields and also want access to the raw HTTP body.
//
// Example:
//
//	message GetResourceRequest {
//	  // A unique request id.
//	  string request_id = 1;
//
//	  // The raw HTTP body is bound to this field.
//	  google.api.HttpBody http_body = 2;
//
//	}
//
//	service ResourceService {
//	  rpc GetResource(GetResourceRequest)
//	    returns (google.api.HttpBody);
//	  rpc UpdateResource(google.api.HttpBody)
//	    returns (google.protobuf.Empty);
//
//	}
//
// Example with streaming methods:
//
//	service CaldavService {
//	  rpc GetCalendar(stream google.api.HttpBody)
//	    returns (stream google.api.HttpBody);
//	  rpc UpdateCalendar(stream google.api.HttpBody)
//	    returns (stream google.api.HttpBody);
//
//	}
//
// Use of this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
//
// swagger:model apiHttpBody
type APIHTTPBody struct {

	// The HTTP Content-Type header value specifying the content type of the body.
	ContentType string `json:"content_type,omitempty"`

	// The HTTP request/response body as raw binary.
	// Format: byte
	Data strfmt.Base64 `json:"data,omitempty"`

	// Application specific response metadata. Must be set in the first response
	// for streaming APIs.
	Extensions []*ProtobufAny `json:"extensions"`
}

// Validate validates this api Http body
func (m *APIHTTPBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExtensions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIHTTPBody) validateExtensions(formats strfmt.Registry) error {
	if swag.IsZero(m.Extensions) { // not required
		return nil
	}

	for i := 0; i < len(m.Extensions); i++ {
		if swag.IsZero(m.Extensions[i]) { // not required
			continue
		}

		if m.Extensions[i] != nil {
			if err := m.Extensions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("extensions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("extensions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this api Http body based on the context it is used
func (m *APIHTTPBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExtensions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIHTTPBody) contextValidateExtensions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Extensions); i++ {

		if m.Extensions[i] != nil {

			if swag.IsZero(m.Extensions[i]) { // not required
				return nil
			}

			if err := m.Extensions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("extensions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("extensions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *APIHTTPBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIHTTPBody) UnmarshalBinary(b []byte) error {
	var res APIHTTPBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
