// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// UpdateAppReader is a Reader for the UpdateApp structure.
type UpdateAppReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateAppReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateAppOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateAppDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateAppOK creates a UpdateAppOK with default headers values
func NewUpdateAppOK() *UpdateAppOK {
	return &UpdateAppOK{}
}

/*
UpdateAppOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateAppOK struct {
	Payload *models.Secrets20230613UpdateAppResponse
}

// IsSuccess returns true when this update app o k response has a 2xx status code
func (o *UpdateAppOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update app o k response has a 3xx status code
func (o *UpdateAppOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update app o k response has a 4xx status code
func (o *UpdateAppOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update app o k response has a 5xx status code
func (o *UpdateAppOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update app o k response a status code equal to that given
func (o *UpdateAppOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update app o k response
func (o *UpdateAppOK) Code() int {
	return 200
}

func (o *UpdateAppOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] updateAppOK %s", 200, payload)
}

func (o *UpdateAppOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] updateAppOK %s", 200, payload)
}

func (o *UpdateAppOK) GetPayload() *models.Secrets20230613UpdateAppResponse {
	return o.Payload
}

func (o *UpdateAppOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613UpdateAppResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAppDefault creates a UpdateAppDefault with default headers values
func NewUpdateAppDefault(code int) *UpdateAppDefault {
	return &UpdateAppDefault{
		_statusCode: code,
	}
}

/*
UpdateAppDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateAppDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this update app default response has a 2xx status code
func (o *UpdateAppDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update app default response has a 3xx status code
func (o *UpdateAppDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update app default response has a 4xx status code
func (o *UpdateAppDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update app default response has a 5xx status code
func (o *UpdateAppDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update app default response a status code equal to that given
func (o *UpdateAppDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update app default response
func (o *UpdateAppDefault) Code() int {
	return o._statusCode
}

func (o *UpdateAppDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] UpdateApp default %s", o._statusCode, payload)
}

func (o *UpdateAppDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] UpdateApp default %s", o._statusCode, payload)
}

func (o *UpdateAppDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *UpdateAppDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UpdateAppBody update app body
swagger:model UpdateAppBody
*/
type UpdateAppBody struct {

	// description
	Description string `json:"description,omitempty"`

	// location
	Location *UpdateAppParamsBodyLocation `json:"location,omitempty"`

	// sync integrations
	SyncIntegrations []string `json:"sync_integrations"`
}

// Validate validates this update app body
func (o *UpdateAppBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateAppBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update app body based on the context it is used
func (o *UpdateAppBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateAppBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateAppBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateAppBody) UnmarshalBinary(b []byte) error {
	var res UpdateAppBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UpdateAppParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model UpdateAppParamsBodyLocation
*/
type UpdateAppParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this update app params body location
func (o *UpdateAppParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateAppParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update app params body location based on the context it is used
func (o *UpdateAppParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateAppParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateAppParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateAppParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res UpdateAppParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
