// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVagrant20220930Provider Provider describes a Provider with its list of architectures and box data.
//
// swagger:model hashicorp.cloud.vagrant_20220930.Provider
type HashicorpCloudVagrant20220930Provider struct {

	// Architectures of provider (if expanded).
	// Read Only: true
	Architectures []*HashicorpCloudVagrant20220930Architecture `json:"architectures"`

	// The date the record was created.
	// Read Only: true
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// The name of the Provider, should be unique within the version.
	Name string `json:"name,omitempty"`

	// The ProviderSummary provides quick facts about provider child objects
	// Read Only: true
	Summary *HashicorpCloudVagrant20220930ProviderSummary `json:"summary,omitempty"`

	// The date that the record was last updated.
	// Read Only: true
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud vagrant 20220930 provider
func (m *HashicorpCloudVagrant20220930Provider) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchitectures(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) validateArchitectures(formats strfmt.Registry) error {
	if swag.IsZero(m.Architectures) { // not required
		return nil
	}

	for i := 0; i < len(m.Architectures); i++ {
		if swag.IsZero(m.Architectures[i]) { // not required
			continue
		}

		if m.Architectures[i] != nil {
			if err := m.Architectures[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("architectures" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("architectures" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant 20220930 provider based on the context it is used
func (m *HashicorpCloudVagrant20220930Provider) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArchitectures(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) contextValidateArchitectures(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "architectures", "body", []*HashicorpCloudVagrant20220930Architecture(m.Architectures)); err != nil {
		return err
	}

	for i := 0; i < len(m.Architectures); i++ {

		if m.Architectures[i] != nil {

			if swag.IsZero(m.Architectures[i]) { // not required
				return nil
			}

			if err := m.Architectures[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("architectures" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("architectures" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", strfmt.DateTime(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {

		if swag.IsZero(m.Summary) { // not required
			return nil
		}

		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Provider) contextValidateUpdatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "updated_at", "body", strfmt.DateTime(m.UpdatedAt)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Provider) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Provider) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrant20220930Provider
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
