// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVagrant20220930Box hashicorp cloud vagrant 20220930 box
//
// swagger:model hashicorp.cloud.vagrant_20220930.Box
type HashicorpCloudVagrant20220930Box struct {

	// The date the record was created.
	// Read Only: true
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// A long-form description of the box.
	Description string `json:"description,omitempty"`

	// The HTML rendered description.
	// Read Only: true
	DescriptionHTML string `json:"description_html,omitempty"`

	// The number of times this box has been downloaded.
	// Read Only: true
	Downloads string `json:"downloads,omitempty"`

	// Whether or not the Box is private.
	IsPrivate bool `json:"is_private,omitempty"`

	// The name segment of the Box. As an example, this field would represent the
	// "vagrant" in "hashicorp/vagrant". Should be unique within the Registry.
	// This field should only be set when creating the box.
	Name string `json:"name,omitempty"`

	// A short-form description of the box. Limited to 100 characters.
	ShortDescription string `json:"short_description,omitempty"`

	// The state of the box.
	// Read Only: true
	State *HashicorpCloudVagrant20220930BoxState `json:"state,omitempty"`

	// Summary details about this box.
	// Read Only: true
	Summary *HashicorpCloudVagrant20220930BoxSummary `json:"summary,omitempty"`

	// The date that the record was last updated.
	// Read Only: true
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`

	// Versions of box (if expanded).
	// Read Only: true
	Versions []*HashicorpCloudVagrant20220930Version `json:"versions"`
}

// Validate validates this hashicorp cloud vagrant 20220930 box
func (m *HashicorpCloudVagrant20220930Box) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Box) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) validateVersions(formats strfmt.Registry) error {
	if swag.IsZero(m.Versions) { // not required
		return nil
	}

	for i := 0; i < len(m.Versions); i++ {
		if swag.IsZero(m.Versions[i]) { // not required
			continue
		}

		if m.Versions[i] != nil {
			if err := m.Versions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("versions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("versions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant 20220930 box based on the context it is used
func (m *HashicorpCloudVagrant20220930Box) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescriptionHTML(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDownloads(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", strfmt.DateTime(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateDescriptionHTML(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description_html", "body", string(m.DescriptionHTML)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateDownloads(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "downloads", "body", string(m.Downloads)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {

		if swag.IsZero(m.State) { // not required
			return nil
		}

		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {

		if swag.IsZero(m.Summary) { // not required
			return nil
		}

		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateUpdatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "updated_at", "body", strfmt.DateTime(m.UpdatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Box) contextValidateVersions(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "versions", "body", []*HashicorpCloudVagrant20220930Version(m.Versions)); err != nil {
		return err
	}

	for i := 0; i < len(m.Versions); i++ {

		if m.Versions[i] != nil {

			if swag.IsZero(m.Versions[i]) { // not required
				return nil
			}

			if err := m.Versions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("versions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("versions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Box) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Box) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrant20220930Box
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
