// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// UploadBoxReader is a Reader for the UploadBox structure.
type UploadBoxReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UploadBoxReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUploadBoxOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUploadBoxDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUploadBoxOK creates a UploadBoxOK with default headers values
func NewUploadBoxOK() *UploadBoxOK {
	return &UploadBoxOK{}
}

/*
UploadBoxOK describes a response with status code 200, with default header values.

A successful response.
*/
type UploadBoxOK struct {
	Payload *models.HashicorpCloudVagrant20220930UploadBoxResponse
}

// IsSuccess returns true when this upload box o k response has a 2xx status code
func (o *UploadBoxOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this upload box o k response has a 3xx status code
func (o *UploadBoxOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload box o k response has a 4xx status code
func (o *UploadBoxOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this upload box o k response has a 5xx status code
func (o *UploadBoxOK) IsServerError() bool {
	return false
}

// IsCode returns true when this upload box o k response a status code equal to that given
func (o *UploadBoxOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the upload box o k response
func (o *UploadBoxOK) Code() int {
	return 200
}

func (o *UploadBoxOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/upload][%d] uploadBoxOK  %+v", 200, o.Payload)
}

func (o *UploadBoxOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/upload][%d] uploadBoxOK  %+v", 200, o.Payload)
}

func (o *UploadBoxOK) GetPayload() *models.HashicorpCloudVagrant20220930UploadBoxResponse {
	return o.Payload
}

func (o *UploadBoxOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930UploadBoxResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadBoxDefault creates a UploadBoxDefault with default headers values
func NewUploadBoxDefault(code int) *UploadBoxDefault {
	return &UploadBoxDefault{
		_statusCode: code,
	}
}

/*
UploadBoxDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UploadBoxDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this upload box default response has a 2xx status code
func (o *UploadBoxDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this upload box default response has a 3xx status code
func (o *UploadBoxDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this upload box default response has a 4xx status code
func (o *UploadBoxDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this upload box default response has a 5xx status code
func (o *UploadBoxDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this upload box default response a status code equal to that given
func (o *UploadBoxDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the upload box default response
func (o *UploadBoxDefault) Code() int {
	return o._statusCode
}

func (o *UploadBoxDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/upload][%d] UploadBox default  %+v", o._statusCode, o.Payload)
}

func (o *UploadBoxDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/upload][%d] UploadBox default  %+v", o._statusCode, o.Payload)
}

func (o *UploadBoxDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *UploadBoxDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
